/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4A\u0001G\r\u0001U!)\u0011\u0007\u0001C\u0001e!9Q\u0007\u0001b\u0001\n\u00131\u0004B\u0002\u001e\u0001A\u0003%q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003O\u0001\u0011\u0005A\bC\u0003Q\u0001\u0011\u0005A\bC\u0003S\u0001\u0011\u0005A\bC\u0003U\u0001\u0011\u0005A\bC\u0003W\u0001\u0011\u0005A\bC\u0003Y\u0001\u0011\u0005A\bC\u0003[\u0001\u0011\u0005A\bC\u0003]\u0001\u0011\u0005A\bC\u0003_\u0001\u0011\u0005A\bC\u0003a\u0001\u0011\u0005A\bC\u0003c\u0001\u0011%1\rC\u0003j\u0001\u0011\u0005A\bC\u0003l\u0001\u0011%A\u000eC\u0003r\u0001\u0011\u0005A\bC\u0003t\u0001\u0011\u0005A\bC\u0003v\u0001\u0011\u0005A\bC\u0003x\u0001\u0011\u0005A\bC\u0003z\u0001\u0011\u0005A\bC\u0003|\u0001\u0011\u0005AHA\bUC\ndWmU8ve\u000e,G+Z:u\u0015\tQ2$A\u0002tc2T!\u0001H\u000f\u0002\rM$(/Z1n\u0015\tqr$\u0001\u0003qY\u0006t'B\u0001\u0011\"\u0003\u001d\u0001H.\u00198oKJT!AI\u0012\u0002\u000bQ\f'\r\\3\u000b\u0005\u0011*\u0013!\u00024mS:\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001WA\u0011AfL\u0007\u0002[)\u0011afH\u0001\u0006kRLGn]\u0005\u0003a5\u0012Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u00014!\t!\u0004!D\u0001\u001a\u0003\u0011)H/\u001b7\u0016\u0003]\u0002\"\u0001\f\u001d\n\u0005ej#aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0017!B;uS2\u0004\u0013\u0001\u000b;fgR$\u0016M\u00197f'>,(oY3XSRDG+[7fgR\fW\u000e\u001d*poRKW.\u001a$jK2$G#A\u001f\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\tUs\u0017\u000e\u001e\u0015\u0003\t\u0011\u0003\"!\u0012'\u000e\u0003\u0019S!a\u0012%\u0002\u0007\u0005\u0004\u0018N\u0003\u0002J\u0015\u00069!.\u001e9ji\u0016\u0014(BA&(\u0003\u0015QWO\\5u\u0013\tieI\u0001\u0003UKN$\u0018a\t;fgR$\u0016M\u00197f'>,(oY3XSRD7k\\;sG\u0016<\u0016\r^3s[\u0006\u00148n\u001d\u0015\u0003\u000b\u0011\u000b\u0011\u0005^3tiJ{w\u000fV5nKR\u000b'\r\\3T_V\u00148-Z$s_V\u0004x+\u001b8e_^D#A\u0002#\u00027Q,7\u000f\u001e)s_\u000e$\u0018.\\3P]^\u000bG/\u001a:nCJ\\7\u000b]3dQ\t9A)A\ruKN$\bK]8kK\u000e$x+\u001b;i_V$(k\\<uS6,\u0007F\u0001\u0005E\u0003i!Xm\u001d;Qe>TWm\u0019;XSRDw.\u001e;Qe>\u001cG/[7fQ\tIA)\u0001\fuKN$\bK]8kK\u000e$xJ\u001c7z%><H/[7fQ\tQA)A\tuKN$h*Z:uK\u0012\u0004&o\u001c6fGRD#a\u0003#\u00025Q,7\u000f\u001e)s_*,7\r^,ji\"|W\u000f^%oaV$(+\u001a4)\u00051!\u0015!\b;fgRtUm\u001d;fIB\u0013xN[3di^KG\u000f['fi\u0006$\u0017\r^1)\u00055!\u0015a\b;fgRtuNT3ti\u0016$\u0007K]8kK\u000e$x+\u001b;i\u001b\u0016$\u0018\rZ1uC\"\u0012a\u0002R\u0001\"i\u0016\u001cHOT3ti\u0016$\u0007K]8kK\u000e$x+\u001b;i\u001b\u0016$\u0018\rZ1uC\n\u000b7/\u001a\u000b\u0003{\u0011DQ!Z\bA\u0002\u0019\f\u0001e];qa>\u0014Ho\u001d(fgR,G\r\u0015:pU\u0016\u001cG/[8o!V\u001c\b\u000eR8x]B\u0011ahZ\u0005\u0003Q~\u0012qAQ8pY\u0016\fg.A\ruKN$h*Z:uK\u0012\u0004&o\u001c6fGR<\u0016\u000e\u001e5Ji\u0016l\u0007F\u0001\tE\u0003\u0011\u0002(/\u001a9be\u0016$E\r\\,ji\"\u0004Vo\u001d5Qe>TWm\u0019;B]\u0012lU\r^1ECR\fGcA\u001fn_\")a.\u0005a\u0001M\u0006\u0011\u0002O]8kK\u000e$\u0018n\u001c8QkNDGi\\<o\u0011\u0015\u0001\u0018\u00031\u0001g\u0003%\u0011X-\u00193t\u001b\u0016$\u0018-A\u0012uKN$(+Z1eg6+G/\u0019#bi\u0006<\u0016\u000e\u001e5ES\u001a4WM]3oi>\u0013H-\u001a:)\u0005I!\u0015A\u000b;fgR\u0014V-\u00193t\u001b\u0016$\u0018\rR1uC^KG\u000f[8viB\u0013xN[3di&|g\u000eU;tQ\u0012{wO\u001c\u0015\u0003'\u0011\u000b\u0001\u0007^3tiJ+\u0017\rZ:D_6\u0004X\u000f^3e\u0007>dW/\u001c8XSRDw.\u001e;Qe>TWm\u0019;j_:\u0004Vo\u001d5E_^t\u0007F\u0001\u000bE\u00035\"Xm\u001d;SK\u0006$7oQ8naV$X\rZ\"pYVlgnV5uQB\u0013xN[3di&|g\u000eU;tQ\u0012{wO\u001c\u0015\u0003+\u0011\u000bq\u0005^3tiJ+\u0017\rZ:NKR\fG)\u0019;b/&$\b\u000e\u0015:pU\u0016\u001cG/[8o!V\u001c\b\u000eR8x]\"\u0012a\u0003R\u0001\u001bi\u0016\u001cH\u000f\u0015:pU\u0016\u001cG/[8o!V\u001c\b\u000eR8x]>sG.\u001f\u0015\u0003/\u0011\u0003")
public class TableSourceTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testTableSourceWithTimestampRowTimeField() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id int,\n         |  rowtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  watermark for rowtime as rowtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT rowtime, id, name, val FROM rowTimeT");
    }

    @Test
    public void testTableSourceWithSourceWatermarks() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id INT,\n         |  rowtime TIMESTAMP(3),\n         |  val BIGINT,\n         |  name VARCHAR(32),\n         |  WATERMARK FOR rowtime AS SOURCE_WATERMARK()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false',\n         |  'disable-lookup' = 'true',\n         |  'enable-watermark-push-down' = 'true'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT rowtime, id, name, val FROM rowTimeT");
    }

    @Test
    public void testRowTimeTableSourceGroupWindow() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id int,\n         |  rowtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  watermark for rowtime as rowtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT name,\n        |    TUMBLE_END(rowtime, INTERVAL '10' MINUTE),\n        |    AVG(val)\n        |FROM rowTimeT WHERE val > 100\n        |   GROUP BY name, TUMBLE(rowtime, INTERVAL '10' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProctimeOnWatermarkSpec() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE procTimeT (\n         |  id int,\n         |  val bigint,\n         |  name varchar(32),\n         |  pTime as PROCTIME(),\n         |  watermark for pTime as pTime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> {
            this.util().tableEnv().executeSql(ddl);
            this.util().verifyExecPlan("SELECT pTime, id, name, val FROM procTimeT");
        }).hasMessageContaining("A watermark can not be defined for a processing-time attribute.") instanceof ValidationException;
    }

    @Test
    public void testProjectWithoutRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT ptime, name, val, id FROM T");
    }

    @Test
    public void testProjectWithoutProctime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("select name, val, rtime, id from T");
    }

    @Test
    public void testProjectOnlyRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT rtime FROM T");
    }

    @Test
    public void testNestedProject() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |                 nested2 row<num int, flag boolean>>,\n         |  nested row<name string, `value` int>,\n         |  name string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'true',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |FROM T\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProjectWithoutInputRef() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  name varchar(32)\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT COUNT(1) FROM T");
    }

    @Test
    public void testNestedProjectWithMetadata() {
        this.testNestedProjectWithMetadataBase(true);
    }

    @Test
    public void testNoNestedProjectWithMetadata() {
        this.testNestedProjectWithMetadataBase(false);
    }

    private void testNestedProjectWithMetadataBase(boolean supportsNestedProjectionPushDown) {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(487).append("\n         |CREATE TABLE T (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |    nested2 row<num int, flag boolean>>,\n         |  metadata_1 int metadata,\n         |  metadata_2 string metadata\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = '").append(supportsNestedProjectionPushDown).append("',\n         |  'bounded' = 'true',\n         |  'readable-metadata' = 'metadata_1:INT, metadata_2:STRING, metadata_3:BIGINT'\n         |)\n         |").toString())).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |       deepNested.nested1 AS nested1,\n        |       deepNested.nested1.`value` + deepNested.nested2.num + metadata_1 as results\n        |FROM T\n        |")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNestedProjectWithItem() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE NestedItemTable (\n         |  `id` INT,\n         |  `name` STRING,\n         |  `result` ROW<\n         |     `data_arr` ROW<`value` BIGINT> ARRAY,\n         |     `data_map` MAP<STRING, ROW<`value` BIGINT>>>,\n         |  `extra` STRING\n         |  ) WITH (\n         |    'connector' = 'values',\n         |    'nested-projection-supported' = 'true',\n         |    'bounded' = 'true'\n         |)\n         |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  `result`.`data_arr`[`id`].`value`,\n         |  `result`.`data_map`['item'].`value`\n         |FROM NestedItemTable\n         |")).stripMargin());
    }

    private void prepareDdlWithPushProjectAndMetaData(boolean projectionPushDown, boolean readsMeta) {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(329).append("\n         |CREATE TABLE src (\n         |  id int,\n         |  name varchar,\n         |  tags varchar ").append((Object)(readsMeta ? "METADATA VIRTUAL" : "")).append(",\n         |  op varchar ").append((Object)(readsMeta ? "METADATA VIRTUAL" : "")).append(",\n         |  ts timestamp(3) ").append((Object)(readsMeta ? "METADATA VIRTUAL" : "")).append(",\n         |  ts1 as ts + interval '10' second\n         |) WITH (\n         |  'connector' = 'values',\n         |  ").append((Object)(readsMeta ? "'readable-metadata'='tags:varchar,op:varchar,ts:timestamp(3)'," : "")).append("\n         |  'enable-projection-push-down' = '").append(projectionPushDown).append("'\n         |)").toString())).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testReadsMetaDataWithDifferentOrder() {
        this.prepareDdlWithPushProjectAndMetaData(false, true);
        this.util().verifyExecPlan("SELECT ts, id, name, tags, op FROM src");
    }

    @Test
    public void testReadsMetaDataWithoutProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(false, true);
        this.util().verifyExecPlan("SELECT id, ts, tags FROM src");
    }

    @Test
    public void testReadsComputedColumnWithoutProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(false, true);
        this.util().verifyExecPlan("SELECT id, ts1, op FROM src");
    }

    @Test
    public void testReadsComputedColumnWithProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(true, true);
        this.util().verifyExecPlan("SELECT id, ts1, op FROM src");
    }

    @Test
    public void testReadsMetaDataWithProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(true, true);
        this.util().verifyExecPlan("SELECT id, ts, tags FROM src");
    }

    @Test
    public void testProjectionPushDownOnly() {
        this.prepareDdlWithPushProjectAndMetaData(true, false);
        this.util().verifyExecPlan("SELECT id, ts1, tags FROM src");
    }
}

