/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e3AAD\b\u0001A!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0013a\u0003B\u0002\u0019\u0001A\u0003%Q\u0006C\u00032\u0001\u0011\u0005!\u0007C\u0003E\u0001\u0011\u0005!\u0007C\u0003J\u0001\u0011\u0005!\u0007C\u0003L\u0001\u0011\u0005!\u0007C\u0003N\u0001\u0011\u0005!\u0007C\u0003P\u0001\u0011\u0005!\u0007C\u0003R\u0001\u0011\u0005!\u0007C\u0003T\u0001\u0011\u0005!\u0007C\u0003V\u0001\u0011\u0005!\u0007C\u0003X\u0001\u0011\u0005!GA\nT_V\u00148-Z,bi\u0016\u0014X.\u0019:l)\u0016\u001cHO\u0003\u0002\u0011#\u0005\u00191/\u001d7\u000b\u0005I\u0019\u0012AB:ue\u0016\fWN\u0003\u0002\u0015+\u0005!\u0001\u000f\\1o\u0015\t1r#A\u0004qY\u0006tg.\u001a:\u000b\u0005aI\u0012!\u0002;bE2,'B\u0001\u000e\u001c\u0003\u00151G.\u001b8l\u0015\taR$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\t\t\u0003E\u0015j\u0011a\t\u0006\u0003IU\tQ!\u001e;jYNL!AJ\u0012\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\tq\"\u0001\u0003vi&dW#A\u0017\u0011\u0005\tr\u0013BA\u0018$\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0003\u0015)H/\u001b7!\u0003\u0015\u0019X\r^;q)\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$\u0001B+oSRD#\u0001\u0002\u001e\u0011\u0005m\u0012U\"\u0001\u001f\u000b\u0005ur\u0014aA1qS*\u0011q\bQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\tU$A\u0003kk:LG/\u0003\u0002Dy\tQ!)\u001a4pe\u0016,\u0015m\u00195\u00027Q,7\u000f^*j[BdWmV1uKJl\u0017M]6QkNDGi\\<oQ\t)a\t\u0005\u0002<\u000f&\u0011\u0001\n\u0010\u0002\u0005)\u0016\u001cH/A\u0017uKN$x+\u0019;fe6\f'o[(o\u0007>l\u0007/\u001e;fI\u000e{G.^7o\u000bb\u001cG.\u001e3fIJ{w\u000fV5nKJB#A\u0002$\u0002YQ,7\u000f^,bi\u0016\u0014X.\u0019:l\u001f:\u001cu.\u001c9vi\u0016$7i\u001c7v[:,\u0005p\u00197vK\u0012\u0014vn\u001e+j[\u0016\f\u0004FA\u0004G\u00031\"Xm\u001d;XCR,'/\\1sW>sg*Z:uK\u0012\u0014vn^,ji\"tUm\u001d;fIB\u0013xN[3di&|g\u000e\u000b\u0002\t\r\u0006!B/Z:u/\u0006$XM]7be.<\u0016\u000e\u001e5VI\u001aD#!\u0003$\u00023Q,7\u000f^,bi\u0016\u0014X.\u0019:l/&$\b.T3uC\u0012\fG/\u0019\u0015\u0003\u0015\u0019\u000ba\u0004^3ti^\u000bG/\u001a:nCJ\\wJ\u001c+j[\u0016\u001cH/Y7q\u0019RT8i\u001c7)\u0005-1\u0015A\u000b;fgR<\u0016\r^3s[\u0006\u00148n\u00148DkJ\u0014XM\u001c;S_^$\u0016.\\3ti\u0006l\u0007OR;oGRLwN\u001c\u0015\u0003\u0019\u0019\u000bQ\u0005^3tiB\u0013xN[3diR\u0013\u0018M\\:q_N,w+\u0019;fe6\f'o[!tg&<g.\u001a:)\u000551\u0005")
public class SourceWatermarkTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                | CREATE TABLE VirtualTable (\n                                |   a INT,\n                                |   b BIGINT,\n                                |   c TIMESTAMP(3),\n                                |   d AS c + INTERVAL '5' SECOND,\n                                |   WATERMARK FOR d AS d - INTERVAL '5' SECOND\n                                | ) WITH (\n                                |   'connector' = 'values',\n                                |   'enable-watermark-push-down' = 'true',\n                                |   'bounded' = 'false',\n                                |   'disable-lookup' = 'true'\n                                | )\n         ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                | CREATE TABLE NestedTable (\n                                |   a INT,\n                                |   b BIGINT,\n                                |   c ROW<name STRING, d ROW<e STRING, f TIMESTAMP(3)>>,\n                                |   g AS c.d.f,\n                                |   WATERMARK FOR g AS g - INTERVAL '5' SECOND\n                                | ) WITH (\n                                |   'connector' = 'values',\n                                |   'enable-watermark-push-down' = 'true',\n                                |   'nested-projection-supported' = 'true',\n                                |   'bounded' = 'false',\n                                |   'disable-lookup' = 'true'\n                                | )\n         ")).stripMargin());
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        this.util().addTemporarySystemFunction("func", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                | CREATE Table UdfTable (\n                                |   a INT,\n                                |   b BIGINT,\n                                |   c timestamp(3),\n                                |   d as func(c, a),\n                                |   WATERMARK FOR c as func(func(d, a), a)\n                                | ) with (\n                                |   'connector' = 'values',\n                                |   'bounded' = 'false',\n                                |   'enable-watermark-push-down' = 'true',\n                                |   'disable-lookup' = 'true'\n                                | )\n         ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE MyTable(\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP(3),\n         |   originTime BIGINT METADATA,\n         |   rowtime AS TO_TIMESTAMP(FROM_UNIXTIME(originTime/1000), 'yyyy-MM-dd HH:mm:ss'),\n         |   WATERMARK FOR rowtime AS rowtime\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true',\n         |   'readable-metadata' = 'originTime:BIGINT'\n         | )\n         ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                | CREATE TABLE MyLtzTable(\n                                |   a INT,\n                                |   b BIGINT,\n                                |   c TIMESTAMP(3),\n                                |   originTime BIGINT METADATA,\n                                |   rowtime AS TO_TIMESTAMP_LTZ(originTime, 3),\n                                |   WATERMARK FOR rowtime AS rowtime\n                                | ) WITH (\n                                |   'connector' = 'values',\n                                |   'enable-watermark-push-down' = 'true',\n                                |   'bounded' = 'false',\n                                |   'disable-lookup' = 'true',\n                                |   'readable-metadata' = 'originTime:BIGINT'\n                                | )\n         ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                | CREATE TABLE timeTestTable(\n                                |   a INT,\n                                |   b BIGINT,\n                                |   rowtime AS TO_TIMESTAMP_LTZ(b, 0),\n                                |   WATERMARK FOR rowtime AS rowtime\n                                | ) WITH (\n                                |   'connector' = 'values',\n                                |   'enable-watermark-push-down' = 'true',\n                                |   'bounded' = 'false',\n                                |   'disable-lookup' = 'true'\n                                | )\n         ")).stripMargin());
    }

    @Test
    public void testSimpleWatermarkPushDown() {
        this.util().verifyExecPlan("SELECT a, b, c FROM VirtualTable");
    }

    @Test
    public void testWatermarkOnComputedColumnExcludedRowTime2() {
        this.util().verifyExecPlan("SELECT a, b, SECOND(d) FROM VirtualTable");
    }

    @Test
    public void testWatermarkOnComputedColumnExcluedRowTime1() {
        this.util().verifyExecPlan("SELECT a, b FROM VirtualTable WHERE b > 10");
    }

    @Test
    public void testWatermarkOnNestedRowWithNestedProjection() {
        this.util().verifyExecPlan("select c.e, c.d from NestedTable");
    }

    @Test
    public void testWatermarkWithUdf() {
        this.util().verifyExecPlan("SELECT a - b FROM UdfTable");
    }

    @Test
    public void testWatermarkWithMetadata() {
        this.util().verifyExecPlan("SELECT a, b FROM MyTable");
    }

    @Test
    public void testWatermarkOnTimestampLtzCol() {
        this.util().verifyExecPlan("SELECT a, b FROM MyLtzTable");
    }

    @Test
    public void testWatermarkOnCurrentRowTimestampFunction() {
        this.util().verifyExecPlan("SELECT * FROM timeTestTable");
    }

    @Test
    public void testProjectTransposeWatermarkAssigner() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TEMPORARY TABLE `t1` (\n         |  `a`  VARCHAR,\n         |  `b`  VARCHAR,\n         |  `c`  VARCHAR,\n         |  `d`  INT,\n         |  `t`  TIMESTAMP(3),\n         |  `ts` AS `t`,\n         |  WATERMARK FOR `ts` AS `ts`  - INTERVAL '10' SECOND\n         |) WITH (\n         |  'connector' = 'values',\n         |  'enable-watermark-push-down' = 'true',\n         |  'bounded' = 'false',\n         |  'disable-lookup' = 'true'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(sourceDDL);
        this.util().verifyExecPlan("SELECT a, b, ts FROM t1");
    }
}

