/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.utils.JavaStreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NullTypeTest
extends TableTestBase {
    private final JavaStreamTableTestUtil util = this.javaStreamTestUtil();

    NullTypeTest() {
    }

    @Test
    void testValues() {
        Assertions.assertThatThrownBy(() -> this.util.verifyExecPlan("SELECT * FROM (VALUES (1, NULL), (2, NULL)) AS T(a, b)")).hasMessageContaining("Illegal use of 'NULL'").isInstanceOf(ValidationException.class);
    }

    @Test
    void testValuesWithoutTypeCoercion() {
        Assertions.assertThatThrownBy(() -> this.util.verifyExecPlan("SELECT * FROM (VALUES (1, NULL), (2, 1)) AS T(a, b)")).hasMessageContaining("Illegal use of 'NULL'").isInstanceOf(ValidationException.class);
    }

    @Test
    void testSetOperationWithoutTypeCoercion() {
        Assertions.assertThatThrownBy(() -> this.util.verifyExecPlan("SELECT ARRAY[1,2] IN (ARRAY[1], ARRAY[1,2], ARRAY[NULL, NULL, NULL])")).hasMessageContaining("Parameters must be of the same type").isInstanceOf(ValidationException.class);
    }

    @Test
    void testBuiltInFunction() {
        Assertions.assertThatThrownBy(() -> this.util.verifyExecPlan("SELECT ABS(NULL)")).hasMessageContaining("Illegal use of 'NULL'").isInstanceOf(ValidationException.class);
    }

    @Test
    void testArrayConstructor() {
        Assertions.assertThatThrownBy(() -> this.util.verifyExecPlan("SELECT ARRAY[NULL]")).hasMessageContaining("Parameters must be of the same type").isInstanceOf(ValidationException.class);
    }

    @Test
    void testMapConstructor() {
        Assertions.assertThatThrownBy(() -> this.util.verifyExecPlan("SELECT MAP[NULL, NULL]")).hasMessageContaining("Parameters must be of the same type").isInstanceOf(ValidationException.class);
    }

    @Test
    void testFunctionReturningNull() {
        this.util.addTemporarySystemFunction("NullTypeFunction", NullTypeFunction.class);
        Assertions.assertThatThrownBy(() -> this.util.verifyExecPlan("SELECT NullTypeFunction(12)")).hasMessageContaining("SQL validation failed. Invalid function call").isInstanceOf(ValidationException.class);
    }

    @Test
    void testNestedNull() {
        this.util.addTemporarySystemFunction("NestedNullTypeFunction", NestedNullTypeFunction.class);
        Assertions.assertThatThrownBy(() -> this.util.verifyExecPlan("SELECT NestedNullTypeFunction(12)")).hasMessageContaining("SQL validation failed. Invalid function call").isInstanceOf(ValidationException.class);
    }

    public static class NullTypeFunction
    extends ScalarFunction {
        @DataTypeHint(value="NULL")
        public Object eval(Integer i) {
            return null;
        }
    }

    public static class NestedNullTypeFunction
    extends ScalarFunction {
        @DataTypeHint(value="ARRAY<NULL>")
        public Object eval(Integer i) {
            return null;
        }
    }
}

