/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ColumnExpansionTest {
    private TableEnvironment tableEnv;

    ColumnExpansionTest() {
    }

    @BeforeEach
    void before() {
        this.tableEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        this.tableEnv.executeSql("CREATE TABLE t1 (\n  t1_i INT,\n  t1_s STRING,\n  t1_m_virtual INT METADATA VIRTUAL,\n  t1_m_aliased_virtual STRING METADATA FROM 'k1' VIRTUAL,\n  t1_m_default INT METADATA,\n  t1_m_aliased STRING METADATA FROM 'k2'\n) WITH (\n 'connector' = 'values',\n 'readable-metadata' = 't1_m_virtual:INT,k1:STRING,t1_m_default:INT,k2:STRING'\n)");
        this.tableEnv.executeSql("CREATE TABLE t2 (\n  t2_i INT,\n  t2_s STRING,\n  t2_m_virtual INT METADATA VIRTUAL,\n  t2_m_aliased_virtual STRING METADATA FROM 'k1' VIRTUAL,\n  t2_m_default INT METADATA,\n  t2_m_aliased STRING METADATA FROM 'k2'\n) WITH (\n 'connector' = 'values',\n 'readable-metadata' = 't2_m_virtual:INT,k1:STRING,t2_m_default:INT,k2:STRING'\n)");
        this.tableEnv.executeSql("CREATE TABLE t3 (\n  t3_s STRING,\n  t3_i INT,\n  t3_m_virtual TIMESTAMP_LTZ(3) METADATA VIRTUAL,\n  WATERMARK FOR t3_m_virtual AS t3_m_virtual - INTERVAL '1' SECOND\n) WITH (\n 'connector' = 'values',\n 'readable-metadata' = 't3_m_virtual:TIMESTAMP_LTZ(3)'\n)");
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.emptyList());
    }

    @Test
    void testExcludeDefaultVirtualMetadataColumns() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.singletonList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS));
        this.assertColumnNames("SELECT * FROM t1", "t1_i", "t1_s", "t1_m_aliased_virtual", "t1_m_default", "t1_m_aliased");
        this.assertColumnNames("SELECT t1_m_virtual, * FROM t1", "t1_m_virtual", "t1_i", "t1_s", "t1_m_aliased_virtual", "t1_m_default", "t1_m_aliased");
        this.assertColumnNames("SELECT * FROM t1, t2", "t1_i", "t1_s", "t1_m_aliased_virtual", "t1_m_default", "t1_m_aliased", "t2_i", "t2_s", "t2_m_aliased_virtual", "t2_m_default", "t2_m_aliased");
        this.assertColumnNames("SELECT t1.*, t2.* FROM t1, t2", "t1_i", "t1_s", "t1_m_aliased_virtual", "t1_m_default", "t1_m_aliased", "t2_i", "t2_s", "t2_m_aliased_virtual", "t2_m_default", "t2_m_aliased");
        this.assertColumnNames("SELECT * FROM (SELECT t1_m_virtual, t2_m_virtual, * FROM t1, t2)", "t1_m_virtual", "t2_m_virtual", "t1_i", "t1_s", "t1_m_aliased_virtual", "t1_m_default", "t1_m_aliased", "t2_i", "t2_s", "t2_m_aliased_virtual", "t2_m_default", "t2_m_aliased");
    }

    @Test
    void testExcludeAliasedVirtualMetadataColumns() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.singletonList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_ALIASED_VIRTUAL_METADATA_COLUMNS));
        this.assertColumnNames("SELECT * FROM t1", "t1_i", "t1_s", "t1_m_virtual", "t1_m_default", "t1_m_aliased");
        this.assertColumnNames("SELECT t1_m_aliased_virtual, * FROM t1", "t1_m_aliased_virtual", "t1_i", "t1_s", "t1_m_virtual", "t1_m_default", "t1_m_aliased");
        this.assertColumnNames("SELECT * FROM t1, t2", "t1_i", "t1_s", "t1_m_virtual", "t1_m_default", "t1_m_aliased", "t2_i", "t2_s", "t2_m_virtual", "t2_m_default", "t2_m_aliased");
        this.assertColumnNames("SELECT t1.*, t2.* FROM t1, t2", "t1_i", "t1_s", "t1_m_virtual", "t1_m_default", "t1_m_aliased", "t2_i", "t2_s", "t2_m_virtual", "t2_m_default", "t2_m_aliased");
        this.assertColumnNames("SELECT * FROM (SELECT t1_m_aliased_virtual, t2_m_aliased_virtual, * FROM t1, t2)", "t1_m_aliased_virtual", "t2_m_aliased_virtual", "t1_i", "t1_s", "t1_m_virtual", "t1_m_default", "t1_m_aliased", "t2_i", "t2_s", "t2_m_virtual", "t2_m_default", "t2_m_aliased");
    }

    @Test
    void testExcludeViaView() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Arrays.asList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS, TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_ALIASED_VIRTUAL_METADATA_COLUMNS));
        this.tableEnv.executeSql("CREATE VIEW v1 AS SELECT * FROM t1");
        this.assertColumnNames("SELECT * FROM v1", "t1_i", "t1_s", "t1_m_default", "t1_m_aliased");
    }

    @Test
    void testExplicitTableWithinTableFunction() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.singletonList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS));
        this.assertColumnNames("SELECT * FROM TABLE(TUMBLE(TABLE t3, DESCRIPTOR(t3_m_virtual), INTERVAL '1' MINUTE))", "t3_s", "t3_i", "t3_m_virtual", "window_start", "window_end", "window_time");
        this.assertColumnNames("SELECT t3_s, SUM(t3_i) AS agg FROM TABLE(TUMBLE(TABLE t3, DESCRIPTOR(t3_m_virtual), INTERVAL '1' MINUTE)) GROUP BY t3_s, window_start, window_end", "t3_s", "agg");
    }

    @Test
    void testSetSemanticsTableWithinTableFunction() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.singletonList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS));
        this.assertColumnNames("SELECT * FROM TABLE(SESSION(TABLE t3 PARTITION BY t3_s, DESCRIPTOR(t3_m_virtual), INTERVAL '1' MINUTE))", "t3_s", "t3_i", "t3_m_virtual", "window_start", "window_end", "window_time");
        this.assertColumnNames("SELECT t3_s, SUM(t3_i) AS agg FROM TABLE(SESSION(TABLE t3 PARTITION BY t3_s, DESCRIPTOR(t3_m_virtual), INTERVAL '1' MINUTE))GROUP BY t3_s, window_start, window_end", "t3_s", "agg");
    }

    @Test
    void testExplicitTableWithinTableFunctionWithInsertIntoNamedColumns() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.singletonList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS));
        this.tableEnv.executeSql("CREATE TABLE sink (\n  a STRING,\n  c BIGINT\n) WITH (\n 'connector' = 'values', 'sink-insert-only' = 'false')");
        this.tableEnv.explainSql("INSERT INTO sink(a, c) SELECT t3_s, COUNT(t3_i) FROM  TABLE(TUMBLE(TABLE t3, DESCRIPTOR(t3_m_virtual), INTERVAL '1' MINUTE)) GROUP BY t3_s;", new ExplainDetail[0]);
    }

    @Test
    void testSetSemanticsTableWithinTableFunctionWithInsertIntoNamedColumns() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.singletonList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS));
        this.tableEnv.executeSql("CREATE TABLE sink (\n  a STRING,\n  c BIGINT\n) WITH (\n 'connector' = 'values', 'sink-insert-only' = 'false')");
        this.tableEnv.explainSql("INSERT INTO sink(a, c) SELECT t3_s, COUNT(t3_i) FROM  TABLE(SESSION(TABLE t3 PARTITION BY t3_s, DESCRIPTOR(t3_m_virtual), INTERVAL '1' MINUTE)) GROUP BY t3_s;", new ExplainDetail[0]);
    }

    private void assertColumnNames(String sql, String ... columnNames) {
        Assertions.assertThat((List)this.tableEnv.sqlQuery(sql).getResolvedSchema().getColumnNames()).containsExactly((Object[])columnNames);
    }

    @Test
    void testExplicitTableWithinTableFunctionWithNamedArgs() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.singletonList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS));
        this.assertColumnNames("SELECT * FROM TABLE(TUMBLE(DATA => TABLE t3, TIMECOL => DESCRIPTOR(t3_m_virtual), SIZE => INTERVAL '1' MINUTE))", "t3_s", "t3_i", "t3_m_virtual", "window_start", "window_end", "window_time");
        this.assertColumnNames("SELECT t3_s, SUM(t3_i) AS agg FROM TABLE(TUMBLE(DATA => TABLE t3, TIMECOL => DESCRIPTOR(t3_m_virtual), SIZE => INTERVAL '1' MINUTE)) GROUP BY t3_s, window_start, window_end", "t3_s", "agg");
    }

    @Test
    void testSetSemanticsTableFunctionWithNamedArgs() {
        this.tableEnv.getConfig().set(TableConfigOptions.TABLE_COLUMN_EXPANSION_STRATEGY, Collections.singletonList(TableConfigOptions.ColumnExpansionStrategy.EXCLUDE_DEFAULT_VIRTUAL_METADATA_COLUMNS));
        this.assertColumnNames("SELECT * FROM TABLE(SESSION(DATA => TABLE t3 PARTITION BY t3_s, TIMECOL => DESCRIPTOR(t3_m_virtual), GAP => INTERVAL '1' MINUTE))", "t3_s", "t3_i", "t3_m_virtual", "window_start", "window_end", "window_time");
        this.assertColumnNames("SELECT t3_s, SUM(t3_i) AS agg FROM TABLE(SESSION(DATA => TABLE t3 PARTITION BY t3_s, TIMECOL => DESCRIPTOR(t3_m_virtual), GAP => INTERVAL '1' MINUTE))GROUP BY t3_s, window_start, window_end", "t3_s", "agg");
    }
}

