/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.CalcRankTransposeRule;
import org.apache.flink.table.planner.plan.rules.logical.CalcSnapshotTransposeRule;
import org.apache.flink.table.planner.plan.rules.logical.ConstantRankNumberColumnRemoveRule;
import org.apache.flink.table.planner.plan.rules.logical.FlinkLogicalRankRule$;
import org.apache.flink.table.planner.plan.rules.logical.TemporalJoinRewriteWithUniqueKeyRule;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3Aa\u0003\u0007\u0001;!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001b\u0001\n#I\u0003BB\u0017\u0001A\u0003%!\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u0003B\u0001\u0011\u0005q\u0006C\u0003G\u0001\u0011\u0005q\u0006C\u0003I\u0001\u0011\u0005q\u0006C\u0003K\u0001\u0011\u0005q\u0006C\u0003M\u0001\u0011\u0005q\u0006C\u0003O\u0001\u0011\u0005qF\u0001\u0015UK6\u0004xN]1m\u0015>LgNU3xe&$XmV5uQVs\u0017.];f\u0017\u0016L(+\u001e7f)\u0016\u001cHO\u0003\u0002\u000e\u001d\u00059An\\4jG\u0006d'BA\b\u0011\u0003\u0015\u0011X\u000f\\3t\u0015\t\t\"#\u0001\u0003qY\u0006t'BA\n\u0015\u0003\u001d\u0001H.\u00198oKJT!!\u0006\f\u0002\u000bQ\f'\r\\3\u000b\u0005]A\u0012!\u00024mS:\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\u0011\u0011EE\u0001\u0006kRLGn]\u0005\u0003G\u0001\u0012Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001'!\t9\u0003!D\u0001\r\u0003\u0011)H/\u001b7\u0016\u0003)\u0002\"aH\u0016\n\u00051\u0002#aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0017!B;uS2\u0004\u0013!B:fiV\u0004H#\u0001\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t]\u0002\"\u0001O \u000e\u0003eR!AO\u001e\u0002\u0007\u0005\u0004\u0018N\u0003\u0002={\u00059!.\u001e9ji\u0016\u0014(B\u0001 \u001b\u0003\u0015QWO\\5u\u0013\t\u0001\u0015H\u0001\u0006CK\u001a|'/Z#bG\"\fA\u0004^3tiB\u0013\u0018.\\1ss.+\u00170\u00138UK6\u0004xN]1m\u0015>Lg\u000e\u000b\u0002\u0006\u0007B\u0011\u0001\bR\u0005\u0003\u000bf\u0012A\u0001V3ti\u0006!C/Z:u\u0013:4WM\u001d:fIB\u0013\u0018.\\1ss.+\u00170\u00138UK6\u0004xN]1m\u0015>Lg\u000e\u000b\u0002\u0007\u0007\u0006\u0011C/Z:u!JLW.\u0019:z\u0017\u0016L\u0018J\u001c+f[B|'/\u00197K_&twJ\u001c+sk\u0016D#aB\"\u0002GQ,7\u000f^%om\u0006d\u0017\u000e\u001a)sS6\f'/_&fs&sG+Z7q_J\fGNS8j]\"\u0012\u0001bQ\u0001,i\u0016\u001cH/\u00138wC2LG-\u00138gKJ\u0014X\r\u001a)sS6\f'/_&fs&sG+Z7q_J\fGNS8j]\"\u0012\u0011bQ\u0001+i\u0016\u001cH/\u00138gKJ\u0014X\r\u001a)sS6\f'/_&fs&sG+Z7q_J\fGNS8j]>sGK];fQ\tQ1\t")
public class TemporalJoinRewriteWithUniqueKeyRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
        FlinkChainedProgram<StreamOptimizeContext> chainedProgram = this.util().getStreamProgram();
        chainedProgram.addLast("test_rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FlinkLogicalRankRule$.MODULE$.INSTANCE(), CalcRankTransposeRule.INSTANCE, ConstantRankNumberColumnRemoveRule.INSTANCE, CalcSnapshotTransposeRule.INSTANCE, TemporalJoinRewriteWithUniqueKeyRule.INSTANCE})).build());
        this.util().replaceStreamProgram(chainedProgram);
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T1 (\n                    | id STRING,\n                    | mount INT,\n                    | proctime as PROCTIME(),\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T2 (\n                    | id STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime,\n                    | PRIMARY KEY(id) NOT ENFORCED\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T3 (\n                    | id STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTable(" CREATE VIEW DeduplicatedView as SELECT id, rate, rowtime FROM   (SELECT *,           ROW_NUMBER() OVER (PARTITION BY id ORDER BY rowtime DESC) AS rowNum    FROM T3   ) T   WHERE rowNum = 1");
    }

    @Test
    public void testPrimaryKeyInTemporalJoin() {
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T2 FOR SYSTEM_TIME AS OF T1.rowtime AS T ON T1.id = T.id");
    }

    @Test
    public void testInferredPrimaryKeyInTemporalJoin() {
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN DeduplicatedView FOR SYSTEM_TIME AS OF T1.rowtime AS T ON T1.id = T.id");
    }

    @Test
    public void testPrimaryKeyInTemporalJoinOnTrue() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 JOIN T2 FOR SYSTEM_TIME AS OF T1.rowtime AS T ON TRUE")).hasMessageContaining("Currently the join key in Temporal Table Join can not be empty.") instanceof ValidationException;
    }

    @Test
    public void testInvalidPrimaryKeyInTemporalJoin() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE noPkTable (\n                    | id STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 LEFT JOIN noPkTable FOR SYSTEM_TIME AS OF T1.rowtime AS T ON T1.id = T.id")).hasMessageContaining("Temporal Table Join requires primary key in versioned table, but no primary key can be found. The physical plan is:\nFlinkLogicalJoin(condition=[AND(=($0, $4), __INITIAL_TEMPORAL_JOIN_CONDITION($3, $6, __TEMPORAL_JOIN_LEFT_KEY($0), __TEMPORAL_JOIN_RIGHT_KEY($4)))], joinType=[left])") instanceof ValidationException;
    }

    @Test
    public void testInvalidInferredPrimaryKeyInTemporalJoin() {
        this.util().addTable(" CREATE VIEW noPkView as SELECT id, rate, rowtime FROM   (SELECT *,           ROW_NUMBER() OVER (PARTITION BY id ORDER BY rowtime DESC) AS rowNum    FROM T3   ) T   WHERE rowNum = 2");
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 JOIN noPkView FOR SYSTEM_TIME AS OF T1.rowtime AS T ON T1.id = T.id")).hasMessageContaining("Temporal Table Join requires primary key in versioned table, but no primary key can be found. The physical plan is:\nFlinkLogicalJoin(condition=[AND(=($0, $4), __INITIAL_TEMPORAL_JOIN_CONDITION($3, $6, __TEMPORAL_JOIN_LEFT_KEY($0), __TEMPORAL_JOIN_RIGHT_KEY($4)))], joinType=[inner])") instanceof ValidationException;
    }

    @Test
    public void testInferredPrimaryKeyInTemporalJoinOnTrue() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 JOIN DeduplicatedView FOR SYSTEM_TIME AS OF T1.rowtime AS T ON TRUE")).hasMessageContaining("Currently the join key in Temporal Table Join can not be empty.") instanceof ValidationException;
    }
}

