/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.rules.logical.SplitAggregateRuleTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000194AAF\f\u0001Q!)q\u0006\u0001C\u0001a!91\u0007\u0001b\u0001\n\u0013!\u0004B\u0002\u001d\u0001A\u0003%Q\u0007C\u0003:\u0001\u0011\u0005!\bC\u0003M\u0001\u0011\u0005!\bC\u0003O\u0001\u0011\u0005!\bC\u0003Q\u0001\u0011\u0005!\bC\u0003S\u0001\u0011\u0005!\bC\u0003U\u0001\u0011\u0005!\bC\u0003W\u0001\u0011\u0005!\bC\u0003Y\u0001\u0011\u0005!\bC\u0003[\u0001\u0011\u0005!\bC\u0003]\u0001\u0011\u0005!\bC\u0003_\u0001\u0011\u0005!\bC\u0003a\u0001\u0011\u0005!\bC\u0003c\u0001\u0011\u0005!\bC\u0003e\u0001\u0011\u0005!\bC\u0003g\u0001\u0011\u0005!\bC\u0003i\u0001\u0011\u0005!\bC\u0003k\u0001\u0011\u0005!\bC\u0003m\u0001\u0011\u0005!H\u0001\fTa2LG/Q4he\u0016<\u0017\r^3Sk2,G+Z:u\u0015\tA\u0012$A\u0004m_\u001eL7-\u00197\u000b\u0005iY\u0012!\u0002:vY\u0016\u001c(B\u0001\u000f\u001e\u0003\u0011\u0001H.\u00198\u000b\u0005yy\u0012a\u00029mC:tWM\u001d\u0006\u0003A\u0005\nQ\u0001^1cY\u0016T!AI\u0012\u0002\u000b\u0019d\u0017N\\6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-;\u0005)Q\u000f^5mg&\u0011af\u000b\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005\t\u0004C\u0001\u001a\u0001\u001b\u00059\u0012\u0001B;uS2,\u0012!\u000e\t\u0003UYJ!aN\u0016\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u0002+Q,7\u000f^*j]\u001edW\rR5ti&t7\r^!hOR\t1\b\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0003V]&$\bF\u0001\u0003C!\t\u0019%*D\u0001E\u0015\t)e)A\u0002ba&T!a\u0012%\u0002\u000f),\b/\u001b;fe*\u0011\u0011*J\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0017\u0012\u0013A\u0001V3ti\u0006\u0001B/Z:u'&tw\r\\3NS:\fum\u001a\u0015\u0003\u000b\t\u000bq\u0003^3tiNKgn\u001a7f\r&\u00148\u000f\u001e,bYV,\u0017iZ4)\u0005\u0019\u0011\u0015!\u0006;fgRlU\u000f\u001c;j\t&\u001cH/\u001b8di\u0006;wm\u001d\u0015\u0003\u000f\t\u000bA\u0004^3tiNKgn\u001a7f\u001b\u0006Dx+\u001b;i\t&\u001cH/\u001b8di\u0006;w\r\u000b\u0002\t\u0005\u0006\u0019C/Z:u'&tw\r\\3GSJ\u001cHOV1mk\u0016<\u0016\u000e\u001e5ESN$\u0018N\\2u\u0003\u001e<\u0007FA\u0005C\u0003\t\"Xm\u001d;TS:<G.\u001a'bgR4\u0016\r\\;f/&$\b\u000eR5ti&t7\r^!hO\"\u0012!BQ\u0001!i\u0016\u001cHoU5oO2,G*[:u\u0003\u001e<w+\u001b;i\t&\u001cH/\u001b8di\u0006;w\r\u000b\u0002\f\u0005\u0006QC/Z:u'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<w+\u001b;i\u00032dgj\u001c8ESN$\u0018N\\2u\u0003\u001e<\u0007F\u0001\u0007C\u0003\u0001\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e<\u0016\u000e\u001e5He>,\bOQ=)\u00055\u0011\u0015A\u000e;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ,ji\"\fe\u000e\u001a(p]\u0012K7\u000f^5oGR\fumZ(o'\u0006lWmQ8mk6t\u0007F\u0001\bC\u0003)\"Xm\u001d;T_6,7i\u001c7v[:\u001c(i\u001c;i\u0013:$\u0015n\u001d;j]\u000e$\u0018iZ4B]\u0012<%o\\;q\u0005fD#a\u0004\"\u0002/Q,7\u000f^!hO^KG\u000f\u001b$jYR,'o\u00117bkN,\u0007F\u0001\tC\u0003E!Xm\u001d;Nk2$\u0018n\u0012:pkB\u0014\u0015p\u001d\u0015\u0003#\t\u000bq\u0002^3ti\u0006;wmV5uQ*{\u0017N\u001c\u0015\u0003%\t\u000b\u0001\u0004^3ti\n+8m[3ug\u000e{gNZ5hkJ\fG/[8oQ\t\u0019\")A\u0012uKN$X*\u001e7uSBdW\rR5ti&t7\r^!hO>s7+Y7f\u0007>dW/\u001c8)\u0005Q\u0011\u0015A\n;fgR\fum\u001a$jYR,'o\u00117bkN,'i\u001c;i/&$\b.\u0011<h\u0003:$7i\\;oi\"\u0012QC\u0011")
public class SplitAggregateRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testSingleDistinctAgg() {
        this.util().verifyRelPlan("SELECT COUNT(DISTINCT c) FROM MyTable");
    }

    @Test
    public void testSingleMinAgg() {
        this.util().verifyRelPlan("SELECT MIN(c) FROM MyTable");
    }

    @Test
    public void testSingleFirstValueAgg() {
        this.util().verifyRelPlan("SELECT FIRST_VALUE(c) FROM MyTable GROUP BY a");
    }

    @Test
    public void testMultiDistinctAggs() {
        this.util().verifyRelPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT b) FROM MyTable");
    }

    @Test
    public void testSingleMaxWithDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT b), MAX(c)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSingleFirstValueWithDistinctAgg() {
        this.util().verifyRelPlan("SELECT a, FIRST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleLastValueWithDistinctAgg() {
        this.util().verifyRelPlan("SELECT a, LAST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleListAggWithDistinctAgg() {
        this.util().verifyRelPlan("SELECT a, LISTAGG(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleDistinctAggWithAllNonDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT c), SUM(b), AVG(b), MAX(b), MIN(b), COUNT(b), COUNT(*)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSingleDistinctAggWithGroupBy() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleDistinctAggWithAndNonDistinctAggOnSameColumn() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT b), SUM(b), AVG(b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSomeColumnsBothInDistinctAggAndGroupBy() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT a), COUNT(b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testAggWithFilterClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n         |  SUM(b) FILTER (WHERE NOT b = 5),\n         |  SUM(b) FILTER (WHERE NOT b = 2)\n         |FROM MyTable\n         |GROUP BY a\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiGroupBys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  c, MIN(b), MAX(b), SUM(b), COUNT(*), COUNT(DISTINCT a)\n         |FROM(\n         |  SELECT\n         |    a, AVG(b) as b, MAX(c) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY c\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggWithJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM(\n         |  SELECT\n         |    c, SUM(b) as b, SUM(b) as d, COUNT(DISTINCT a) as a\n         |  FROM(\n         |    SELECT\n         |      a, COUNT(DISTINCT b) as b, SUM(b) as c, SUM(b) as d\n         |    FROM MyTable\n         |    GROUP BY a)\n         |  GROUP BY c\n         |) as MyTable1 JOIN MyTable ON MyTable1.b = MyTable.a\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testBucketsConfiguration() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_BUCKET_NUM, (Object)100);
        String sqlQuery = "SELECT COUNT(DISTINCT c) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultipleDistinctAggOnSameColumn() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b),\n         |  COUNT(DISTINCT b) FILTER(WHERE b <> 5),\n         |  SUM(b),\n         |  AVG(b)\n         |FROM MyTable\n         |GROUP BY a\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggFilterClauseBothWithAvgAndCount() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n         |  SUM(b) FILTER (WHERE NOT b = 5),\n         |  COUNT(b),\n         |  AVG(b),\n         |  SUM(b)\n         |FROM MyTable\n         |GROUP BY a\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    public SplitAggregateRuleTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.SplitAggregateRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

