/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.SimplifyJoinConditionRule;
import org.apache.flink.table.planner.plan.rules.logical.SimplifyJoinConditionRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0003\u0006\u00017!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003BB\u0016\u0001A\u0003%\u0001\u0006C\u0003-\u0001\u0011\u0005Q\u0006C\u0003@\u0001\u0011\u0005Q\u0006C\u0003E\u0001\u0011\u0005Q\u0006C\u0003G\u0001\u0011\u0005Q\u0006C\u0003I\u0001\u0011\u0005QFA\u000fTS6\u0004H.\u001b4z\u0015>LgnQ8oI&$\u0018n\u001c8Sk2,G+Z:u\u0015\tYA\"A\u0004m_\u001eL7-\u00197\u000b\u00055q\u0011!\u0002:vY\u0016\u001c(BA\b\u0011\u0003\u0011\u0001H.\u00198\u000b\u0005E\u0011\u0012a\u00029mC:tWM\u001d\u0006\u0003'Q\tQ\u0001^1cY\u0016T!!\u0006\f\u0002\u000b\u0019d\u0017N\\6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0004\u0005\u0002\u001eA5\taD\u0003\u0002 !\u0005)Q\u000f^5mg&\u0011\u0011E\b\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u0005Q\u0011\u0001B;uS2,\u0012\u0001\u000b\t\u0003;%J!A\u000b\u0010\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\\\u0001\u0006kRLG\u000eI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002]A\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t!QK\\5uQ\t!Q\u0007\u0005\u00027{5\tqG\u0003\u00029s\u0005\u0019\u0011\r]5\u000b\u0005iZ\u0014a\u00026va&$XM\u001d\u0006\u0003ya\tQA[;oSRL!AP\u001c\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\ruKN$8+[7qY&4\u0017PS8j]\u000e{g\u000eZ5uS>t\u0007FA\u0003B!\t1$)\u0003\u0002Do\t!A+Z:u\u0003\u0015\"Xm\u001d;TS6\u0004H.\u001b4z\u0015>LgnQ8oI&$\u0018n\u001c8Ge>l7+\u001e2Rk\u0016\u0014\u0018\u0010\u000b\u0002\u0007\u0003\u00069C/Z:u'&l\u0007\u000f\\5gs*{\u0017N\\\"p]\u0012LG/[8o/&$\bnQ1tiR{GK];fQ\t9\u0011)\u0001\u0015uKN$8+[7qY&4\u0017PS8j]\u000e{g\u000eZ5uS>tw+\u001b;i\u0007\u0006\u001cH\u000fV8GC2\u001cX\r\u000b\u0002\t\u0003\u0002")
public class SimplifyJoinConditionRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("SimplifyJoinConditionRule", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{SimplifyJoinConditionRule.INSTANCE})).build());
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.SimplifyJoinConditionRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.SimplifyJoinConditionRuleTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testSimplifyJoinCondition() {
        String sqlQuery = "SELECT d FROM MyTable1 JOIN MyTable2 ON (d = a AND a > 2) OR (d = a AND b = 1)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSimplifyJoinConditionFromSubQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a FROM MyTable1 WHERE b = (\n        |    SELECT COUNT(*) FROM MyTable2 WHERE (d = a AND d < 2) OR (d = a AND b = 5))\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSimplifyJoinConditionWithCastToTrue() {
        String sqlQuery = "SELECT d FROM MyTable1 JOIN MyTable2 ON CAST(1 AS BOOLEAN)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSimplifyJoinConditionWithCastToFalse() {
        String sqlQuery = "SELECT d FROM MyTable1 JOIN MyTable2 ON CAST(0 AS BOOLEAN)";
        this.util().verifyRelPlan(sqlQuery);
    }
}

