/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSort;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE;
import org.apache.flink.table.planner.plan.rules.logical.PushLimitIntoTableSourceScanRule;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PushLimitIntoTableSourceScanRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(TableConfig.getDefault());

    PushLimitIntoTableSourceScanRuleTest() {
    }

    @BeforeEach
    public void setup() {
        this.util.buildBatchProgram(FlinkBatchProgram.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util.tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{PushLimitIntoTableSourceScanRule.INSTANCE, CoreRules.SORT_PROJECT_TRANSPOSE, FlinkLogicalSort.BATCH_CONVERTER(), FlinkLogicalTableSourceScan.CONVERTER()})).build());
        String ddl = "CREATE TABLE LimitTable (\n  a int,\n  b bigint,\n  c string\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
    }

    @Test
    void testLimitWithNegativeOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util.verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 10 OFFSET -1"));
    }

    @Test
    void testNegativeLimitWithoutOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util.verifyRelPlan("SELECT a, c FROM LimitTable LIMIT -1"));
    }

    @Test
    void testMysqlLimit() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util.verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 1, 10"));
    }

    @Test
    void testCanPushdownLimitWithoutOffset() {
        this.util.verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 5");
    }

    @Test
    void testCanPushdownLimitWithOffset() {
        this.util.verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 10 OFFSET 1");
    }

    @Test
    void testCanPushdownFetchWithOffset() {
        this.util.verifyRelPlan("SELECT a, c FROM LimitTable OFFSET 10 ROWS FETCH NEXT 10 ROWS ONLY");
    }

    @Test
    void testCanPushdownFetchWithoutOffset() {
        this.util.verifyRelPlan("SELECT a, c FROM LimitTable FETCH FIRST 10 ROWS ONLY");
    }

    @Test
    void testCannotPushDownWithoutLimit() {
        this.util.verifyRelPlan("SELECT a, c FROM LimitTable OFFSET 10");
    }

    @Test
    void testCannotPushDownWithoutFetch() {
        this.util.verifyRelPlan("SELECT a, c FROM LimitTable OFFSET 10 ROWS");
    }

    @Test
    void testCannotPushDownWithOrderBy() {
        this.util.verifyRelPlan("SELECT a, c FROM LimitTable ORDER BY c LIMIT 10");
    }
}

