/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRule$;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRuleTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!4A\u0001E\t\u0001E!)\u0011\u0006\u0001C\u0001U!9Q\u0006\u0001b\u0001\n#q\u0003B\u0002\u001a\u0001A\u0003%q\u0006C\u00034\u0001\u0011\u0005A\u0007C\u0003G\u0001\u0011\u0005A\u0007C\u0003L\u0001\u0011\u0005A\u0007C\u0003N\u0001\u0011\u0005A\u0007C\u0003P\u0001\u0011\u0005A\u0007C\u0003R\u0001\u0011\u0005A\u0007C\u0003T\u0001\u0011\u0005A\u0007C\u0003V\u0001\u0011\u0005A\u0007C\u0003X\u0001\u0011\u0005A\u0007C\u0003Z\u0001\u0011\u0005A\u0007C\u0003\\\u0001\u0011\u0005A\u0007C\u0003^\u0001\u0011\u0005aLA\u0018M_\u001eL7-\u00197D_J\u0014X\r\\1uKR{'j\\5o\rJ|W\u000eV3na>\u0014\u0018\r\u001c+bE2,'+\u001e7f)\u0016\u001cHO\u0003\u0002\u0013'\u00059An\\4jG\u0006d'B\u0001\u000b\u0016\u0003\u0015\u0011X\u000f\\3t\u0015\t1r#\u0001\u0003qY\u0006t'B\u0001\r\u001a\u0003\u001d\u0001H.\u00198oKJT!AG\u000e\u0002\u000bQ\f'\r\\3\u000b\u0005qi\u0012!\u00024mS:\\'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001GA\u0011AeJ\u0007\u0002K)\u0011aeF\u0001\u0006kRLGn]\u0005\u0003Q\u0015\u0012Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u0012\u0003\u0011)H/\u001b7\u0016\u0003=\u0002\"\u0001\n\u0019\n\u0005E*#aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0017!B;uS2\u0004\u0013!B:fiV\u0004H#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\tUs\u0017\u000e\u001e\u0015\u0003\tq\u0002\"!\u0010#\u000e\u0003yR!a\u0010!\u0002\u0007\u0005\u0004\u0018N\u0003\u0002B\u0005\u00069!.\u001e9ji\u0016\u0014(BA\" \u0003\u0015QWO\\5u\u0013\t)eH\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0004^3ti2{wn[;q\u0015>LgnV5uQ\u001aKG\u000e^3sQ\t)\u0001\n\u0005\u0002>\u0013&\u0011!J\u0010\u0002\u0005)\u0016\u001cH/\u0001\ruKN$H*\u001a4u\u0019>|7.\u001e9K_&twJ\u001c+sk\u0016D#A\u0002%\u0002EQ,7\u000f\u001e)s_\u000e$\u0016.\\3UK6\u0004xN]1m\u0015>LgnV5uQ\u001aKG\u000e^3sQ\t9\u0001*A\u0011uKN$(k\\<US6,G+Z7q_J\fGNS8j]^KG\u000f\u001b$jYR,'\u000f\u000b\u0002\t\u0011\u0006)C/Z:u%><H+[7f\u0019\u00164G\u000fV3na>\u0014\u0018\r\u001c&pS:<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003\u0013!\u000bA\u0003^3ti2{wn[;q\u0015>Lgn\u00148UeV,\u0007F\u0001\u0006I\u0003y!Xm\u001d;Qe>\u001cG+[7f)\u0016l\u0007o\u001c:bY*{\u0017N\\(o)J,X\r\u000b\u0002\f\u0011\u0006iB/Z:u%><H+[7f)\u0016l\u0007o\u001c:bY*{\u0017N\\(o)J,X\r\u000b\u0002\r\u0011\u0006)B/Z:u%&<\u0007\u000e\u001e+f[B|'/\u00197K_&t\u0007FA\u0007I\u0003Q!Xm\u001d;Gk2dG+Z7q_J\fGNS8j]\"\u0012a\u0002S\u0001\u0011g\u0016$X\u000b]\"veJ,g\u000e\u001e*vY\u0016$\"!N0\t\u000b\u0001|\u0001\u0019A1\u0002\tI,H.\u001a\t\u0003E\u001al\u0011a\u0019\u0006\u0003-\u0011T!!Z\u000f\u0002\u000f\r\fGnY5uK&\u0011qm\u0019\u0002\u000b%\u0016dw\n\u001d;Sk2,\u0007")
public class LogicalCorrelateToJoinFromTemporalTableRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T1 (\n                    | id STRING,\n                    | mount INT,\n                    | proctime as PROCTIME(),\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T2 (\n                    | id STRING,\n                    | rate INT,\n                    | PRIMARY KEY(id) NOT ENFORCED\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTableSource("T3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testLookupJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.LOOKUP_JOIN_WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T2 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testLeftLookupJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.LOOKUP_JOIN_WITHOUT_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 LEFT JOIN T2 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON TRUE");
    }

    @Test
    public void testProcTimeTemporalJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testRowTimeTemporalJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.rowtime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testRowTimeLeftTemporalJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 LEFT JOIN T3 FOR SYSTEM_TIME AS OF T1.rowtime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testLookupJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.LOOKUP_JOIN_WITHOUT_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T2 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON TRUE");
    }

    @Test
    public void testProcTimeTemporalJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITHOUT_FILTER());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.rowtime AS dimTable ON TRUE")).hasMessageContaining("Currently the join key in Temporal Table Join can not be empty.") instanceof ValidationException;
    }

    @Test
    public void testRowTimeTemporalJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITHOUT_FILTER());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON TRUE")).hasMessageContaining("Currently the join key in Temporal Table Join can not be empty.") instanceof ValidationException;
    }

    @Test
    public void testRightTemporalJoin() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 RIGHT JOIN T3 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10")).hasMessageContaining("Correlate has invalid join type RIGHT") instanceof AssertionError;
    }

    @Test
    public void testFullTemporalJoin() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 FULL JOIN T3 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10")).hasMessageContaining("Correlate has invalid join type FULL") instanceof AssertionError;
    }

    public void setUpCurrentRule(RelOptRule rule) {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{rule})).build());
        this.util().replaceStreamProgram((FlinkChainedProgram<StreamOptimizeContext>)programs);
    }
}

