/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.JoinDeriveNullFilterRule;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e3AAD\b\u0001A!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0013a\u0003B\u0002\u0019\u0001A\u0003%Q\u0006C\u00032\u0001\u0011\u0005!\u0007C\u0003E\u0001\u0011\u0005!\u0007C\u0003J\u0001\u0011\u0005!\u0007C\u0003L\u0001\u0011\u0005!\u0007C\u0003N\u0001\u0011\u0005!\u0007C\u0003P\u0001\u0011\u0005!\u0007C\u0003R\u0001\u0011\u0005!\u0007C\u0003T\u0001\u0011\u0005!\u0007C\u0003V\u0001\u0011\u0005!\u0007C\u0003X\u0001\u0011\u0005!G\u0001\u000fK_&tG)\u001a:jm\u0016tU\u000f\u001c7GS2$XM\u001d*vY\u0016$Vm\u001d;\u000b\u0005A\t\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003%M\tQA];mKNT!\u0001F\u000b\u0002\tAd\u0017M\u001c\u0006\u0003-]\tq\u0001\u001d7b]:,'O\u0003\u0002\u00193\u0005)A/\u00192mK*\u0011!dG\u0001\u0006M2Lgn\u001b\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0016\u0003\u0015)H/\u001b7t\u0013\t13EA\u0007UC\ndW\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"A\u000b\u0001\u000e\u0003=\tA!\u001e;jYV\tQ\u0006\u0005\u0002#]%\u0011qf\t\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%A\u0003tKR,\b\u000fF\u00014!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0011)f.\u001b;)\u0005\u0011Q\u0004CA\u001eC\u001b\u0005a$BA\u001f?\u0003\r\t\u0007/\u001b\u0006\u0003\u007f\u0001\u000bqA[;qSR,'O\u0003\u0002B;\u0005)!.\u001e8ji&\u00111\t\u0010\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017A\b;fgRLeN\\3s\u0015>Lgn\u0018(p]\u0016,\u0015/^5K_&t7*Z=tQ\t)a\t\u0005\u0002<\u000f&\u0011\u0001\n\u0010\u0002\u0005)\u0016\u001cH/A\u0013uKN$\u0018J\u001c8fe*{\u0017N\\0Ok2d7i\\;oi>sG*\u001a4u\u0015>LgnS3zg\"\u0012aAR\u0001'i\u0016\u001cH/\u00138oKJTu.\u001b8`\u001dVdGnQ8v]R|eNU5hQRTu.\u001b8LKf\u001c\bFA\u0004G\u0003)\"Xm\u001d;J]:,'OS8j]~sU\u000f\u001c7D_VtGo\u00148MK\u001a$(+[4ii*{\u0017N\\&fsND#\u0001\u0003$\u00023Q,7\u000f^%o]\u0016\u0014(j\\5o?:{g*\u001e7m\u0007>,h\u000e\u001e\u0015\u0003\u0013\u0019\u000b\u0001\u0006^3ti&sg.\u001a:K_&twLT;mY\u000e{WO\u001c;MKN\u001cH\u000b[1o)\"\u0014Xm\u001d5pY\u0012D#A\u0003$\u0002\u0019Q,7\u000f\u001e'fMRTu.\u001b8)\u0005-1\u0015!\u0004;fgR\u0014\u0016n\u001a5u\u0015>Lg\u000e\u000b\u0002\r\r\u0006aA/Z:u\rVdGNS8j]\"\u0012QB\u0012")
public class JoinDeriveNullFilterRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{JoinDeriveNullFilterRule.INSTANCE})).build());
        this.util().addTableSource("MyTable1", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING(), Types.INT(), Types.LONG()}), (String[])((Object[])new String[]{"a1", "b1", "c1", "d1", "e1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(1000000000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a1"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(10000000L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(5000000L), Predef$.MODULE$.double2Double(10.2), Predef$.MODULE$.int2Integer(16), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e1"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(500000L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("MyTable2", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING(), Types.INT(), Types.LONG()}), (String[])((Object[])new String[]{"a2", "b2", "c2", "d2", "e2"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(2000000000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b2"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(10000000L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c2"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(3000000L), Predef$.MODULE$.double2Double(18.6), Predef$.MODULE$.int2Integer(32), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e2"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(1500000L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
    }

    @Test
    public void testInnerJoin_NoneEquiJoinKeys() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a1 > a2");
    }

    @Test
    public void testInnerJoin_NullCountOnLeftJoinKeys() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a1 = a2");
    }

    @Test
    public void testInnerJoin_NullCountOnRightJoinKeys() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON b1 = b2");
    }

    @Test
    public void testInnerJoin_NullCountOnLeftRightJoinKeys() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON c1 = c2");
    }

    @Test
    public void testInnerJoin_NoNullCount() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON d1 = d2");
    }

    @Test
    public void testInnerJoin_NullCountLessThanThreshold() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON e1 = e2");
    }

    @Test
    public void testLeftJoin() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON c1 = c2");
    }

    @Test
    public void testRightJoin() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 RIGHT JOIN MyTable2 ON c1 = c2");
    }

    @Test
    public void testFullJoin() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 FULL JOIN MyTable2 ON c1 = c2");
    }
}

