/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.JoinDependentConditionDerivationRule$;
import org.apache.flink.table.planner.plan.rules.logical.JoinDependentConditionDerivationRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0004\b\u0001?!)a\u0005\u0001C\u0001O!9!\u0006\u0001b\u0001\n\u0013Y\u0003BB\u0018\u0001A\u0003%A\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003D\u0001\u0011\u0005\u0011\u0007C\u0003I\u0001\u0011\u0005\u0011\u0007C\u0003K\u0001\u0011\u0005\u0011\u0007C\u0003M\u0001\u0011\u0005\u0011\u0007C\u0003O\u0001\u0011\u0005\u0011\u0007C\u0003Q\u0001\u0011\u0005\u0011\u0007C\u0003S\u0001\u0011\u0005\u0011\u0007C\u0003U\u0001\u0011\u0005\u0011G\u0001\u0015K_&tG)\u001a9f]\u0012,g\u000e^\"p]\u0012LG/[8o\t\u0016\u0014\u0018N^1uS>t'+\u001e7f)\u0016\u001cHO\u0003\u0002\u0010!\u00059An\\4jG\u0006d'BA\t\u0013\u0003\u0015\u0011X\u000f\\3t\u0015\t\u0019B#\u0001\u0003qY\u0006t'BA\u000b\u0017\u0003\u001d\u0001H.\u00198oKJT!a\u0006\r\u0002\u000bQ\f'\r\\3\u000b\u0005eQ\u0012!\u00024mS:\\'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001AA\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005F\u0001\u0006kRLGn]\u0005\u0003K\t\u0012Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u000f\u0003\u0011)H/\u001b7\u0016\u00031\u0002\"!I\u0017\n\u00059\u0012#A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\nQa]3ukB$\u0012A\r\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\u0005+:LG\u000f\u000b\u0002\u0005sA\u0011!(Q\u0007\u0002w)\u0011A(P\u0001\u0004CBL'B\u0001 @\u0003\u001dQW\u000f]5uKJT!\u0001\u0011\u000f\u0002\u000b),h.\u001b;\n\u0005\t[$A\u0003\"fM>\u0014X-R1dQ\u0006QA/Z:u'&l\u0007\u000f\\3)\u0005\u0015)\u0005C\u0001\u001eG\u0013\t95H\u0001\u0003UKN$\u0018a\u0002;fgR\fe\u000e\u001a\u0015\u0003\r\u0015\u000bq\u0003^3ti\u000e\u000bgNT8u\u001b\u0006$8\r\u001b+iSN\u0014V\u000f\\3)\u0005\u001d)\u0015a\u0003;fgR$\u0006N]3f\u001fJD#\u0001C#\u0002\u0013Q,7\u000f^!oI>\u0013\bFA\u0005F\u0003=!Xm\u001d;Nk2$\u0018NR5fY\u0012\u001c\bF\u0001\u0006F\u0003e!Xm\u001d;Nk2$\u0018nU5oO2,7+\u001b3f\r&,G\u000eZ:)\u0005-)\u0015A\u0004;fgRlU\u000f\u001c;j\u0015>Lgn\u001d\u0015\u0003\u0019\u0015\u0003")
public class JoinDependentConditionDerivationRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_INTO_JOIN, CoreRules.JOIN_CONDITION_PUSH, JoinDependentConditionDerivationRule$.MODULE$.INSTANCE()})).build());
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.JoinDependentConditionDerivationRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}), new CaseClassTypeInfo<Tuple5<Object, Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.JoinDependentConditionDerivationRuleTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testSimple() {
        String sqlQuery = "SELECT a, d FROM MyTable1, MyTable2 WHERE (a = 1 AND d = 2) OR (a = 2 AND d = 1)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAnd() {
        String sqlQuery = "SELECT a, d FROM MyTable1, MyTable2 WHERE b = e AND ((a = 1 AND d = 2) OR (a = 2 AND d = 1))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCanNotMatchThisRule() {
        String sqlQuery = "SELECT a, d FROM MyTable1, MyTable2 WHERE b = e OR ((a = 1 AND d = 2) OR (a = 2 AND d = 1))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testThreeOr() {
        String sqlQuery = "SELECT a, d FROM MyTable1, MyTable2 WHERE (b = e AND a = 0) OR ((a = 1 AND d = 2) OR (a = 2 AND d = 1))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAndOr() {
        String sqlQuery = "SELECT a, d FROM MyTable1, MyTable2 WHERE ((a = 1 AND d = 2) OR (a = 2 AND d = 1))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiFields() {
        String sqlQuery = "SELECT a, d FROM MyTable1, MyTable2 WHERE (a = 1 AND b = 1 AND d = 2 AND e = 2) OR (a = 2 AND b = 2 AND d = 1 AND e = 1)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiSingleSideFields() {
        String sqlQuery = "SELECT a, d FROM MyTable1, MyTable2 WHERE (a = 1 AND b = 1 AND d = 2 AND e = 2) OR (d = 1 AND e = 1)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiJoins() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T1.a, T2.d FROM MyTable1 T1,\n        |  (SELECT * FROM MyTable1, MyTable2 WHERE a = d) T2 WHERE\n        |(T1.a = 1 AND T1.b = 1 AND T2.a = 2 AND T2.e = 2)\n        |OR\n        |(T1.a = 2 AND T2.b = 2 AND T2.d = 1 AND T2.e = 1)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

