/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE;
import org.apache.flink.table.planner.plan.rules.logical.FlinkFilterJoinRule;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FlinkFilterJoinRuleTest
extends TableTestBase {
    private BatchTableTestUtil util;

    FlinkFilterJoinRuleTest() {
    }

    @BeforeEach
    void setup() {
        this.util = this.batchTestUtil(TableConfig.getDefault());
        this.util.buildBatchProgram(FlinkBatchProgram.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util.tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_PROJECT_TRANSPOSE, FlinkFilterJoinRule.FILTER_INTO_JOIN, FlinkFilterJoinRule.JOIN_CONDITION_PUSH})).build());
        this.util.tableEnv().executeSql("CREATE TABLE leftT (\n  a INT,\n  b BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE rightT (\n  c INT,\n  d BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE MyTable1 (\n  a1 INT,\n  b1 BIGINT,\n  c1 VARCHAR\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE MyTable2 (\n  b2 BIGINT,\n  c2 VARCHAR,\n  a2 INT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
    }

    @Test
    void testFilterPushDownLeftSemi1() {
        this.util.verifyRelPlan("SELECT * FROM (SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT)) T WHERE T.b > 2");
    }

    @Test
    void testFilterPushDownLeftSemi2() {
        this.util.verifyRelPlan("SELECT * FROM (SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT)) T WHERE T.b > 2");
    }

    @Test
    void testFilterPushDownLeftSemi3() {
        this.util.verifyRelPlan("SELECT * FROM (SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT WHERE a = c)) T WHERE T.b > 2");
    }

    @Test
    void testJoinConditionPushDownLeftSemi1() {
        this.util.verifyRelPlan("SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT WHERE b > 2)");
    }

    @Test
    void testJoinConditionPushDownLeftSemi2() {
        this.util.verifyRelPlan("SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT WHERE b > 2)");
    }

    @Test
    void testJoinConditionPushDownLeftSemi3() {
        this.util.verifyRelPlan("SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT WHERE a = c AND b > 2)");
    }

    @Test
    void testFilterPushDownLeftAnti1() {
        this.util.verifyRelPlan("SELECT * FROM (SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE c < 3)) T WHERE T.b > 2");
    }

    @Test
    void testFilterPushDownLeftAnti2() {
        this.util.verifyRelPlan("SELECT * FROM (SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT where c > 10)) T WHERE T.b > 2");
    }

    @Test
    void testFilterPushDownLeftAnti3() {
        this.util.verifyRelPlan("SELECT * FROM (SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE b = d AND c < 3)) T WHERE T.b > 2");
    }

    @Test
    void testFilterPushDownLeftAnti4() {
        this.util.verifyRelPlan("SELECT * FROM (SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE a = c)) T WHERE T.b > 2");
    }

    @Test
    void testJoinConditionPushDownLeftAnti1() {
        this.util.verifyRelPlan("SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE b > 2)");
    }

    @Test
    void testJoinConditionPushDownLeftAnti2() {
        this.util.verifyRelPlan("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE b > 2)");
    }

    @Test
    void testJoinConditionPushDownLeftAnti3() {
        this.util.verifyRelPlan("SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE b = d AND b > 1)");
    }

    @Test
    void testJoinConditionPushDownLeftAnti4() {
        this.util.verifyRelPlan("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE a = c AND b > 2)");
    }

    @Test
    void testInnerJoinWithAllFilterFromBothSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a1 = a2 WHERE a1 = a2 + 2");
    }

    @Test
    void testInnerJoinWithAllFilterInONClause() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a1 = a2 AND b1 = b2 AND a1 = 2 AND b2 > 10");
    }

    @Test
    void testInnerJoinWithSomeFiltersFromLeftSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a1 = a2 WHERE a1 = 2");
    }

    @Test
    void testInnerJoinWithSomeFiltersFromRightSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a1 = a2 WHERE a2 = 2");
    }

    @Test
    void testInnerJoinWithSomeFiltersFromLeftRightSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a1 = a2 AND b1 = b2 AND c1 = c2 WHERE a2 = 2 AND b2 > 10 AND c1 IS NOT NULL");
    }

    @Test
    void testInnerJoinWithAllFiltersFromWhere() {
        this.util.verifyRelPlan("SELECT * FROM MyTable2, MyTable1 WHERE b1 = b2 AND c1 = c2 AND a2 = 2 AND b2 > 10 AND COALESCE(c1, c2) <> '' ");
    }

    @Test
    void testInnerJoinWithNullFilter() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 INNER JOIN MyTable2 ON a1 = a2 WHERE a2 IS NULL");
    }

    @Test
    void testInnerJoinWithNullFilter2() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 INNER JOIN MyTable2 ON a1 = a2 WHERE a2 IS NULL AND a1 < 10");
    }

    @Test
    void testInnerJoinWithFilter1() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 INNER JOIN MyTable2 ON a1 = a2 WHERE a2 < 1");
    }

    @Test
    void testInnerJoinWithFilter2() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 INNER JOIN MyTable2 ON a1 = a2 WHERE a2 <> 1");
    }

    @Test
    void testInnerJoinWithFilter3() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 INNER JOIN MyTable2 ON a1 = a2 WHERE a2 > 1");
    }

    @Test
    void testInnerJoinWithFilter4() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 INNER JOIN MyTable2 ON a1 = a2 WHERE a2 >= 1");
    }

    @Test
    void testInnerJoinWithFilter5() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 INNER JOIN MyTable2 ON a1 = a2 WHERE a2 <= 1");
    }

    @Test
    void testInnerJoinWithFilter6() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 INNER JOIN MyTable2 ON a1 = a2 WHERE a2 = null");
    }

    @Test
    void testLeftJoinWithSomeFiltersFromLeftSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON a1 = a2 WHERE a1 = 2");
    }

    @Test
    void testLeftJoinWithAllFilterInONClause() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON a1 = a2 AND a2 = 2");
    }

    @Test
    void testLeftJoinWithSomeFiltersFromLeftRightSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON a1 = a2 AND b1 = b2 AND c1 = c2 WHERE a2 = 2 AND b2 > 10 AND c1 IS NOT NULL");
    }

    @Test
    void testLeftJoinWithAllFiltersFromWhere() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON true WHERE b1 = b2 AND c1 = c2 AND a2 = 2 AND b2 > 10 AND COALESCE(c1, c2) <> '' ");
    }

    @Test
    void testLeftJoinWithNullFilterInRightSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON a1 = a2 WHERE a2 IS NULL");
    }

    @Test
    void testLeftJoinWithNullFilterInRightSide2() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON a1 = a2 WHERE a2 IS NULL AND a1 < 10");
    }

    @Test
    void testLeftJoinWithFilter1() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON a1 = a2 WHERE a2 < 1");
    }

    @Test
    void testLeftJoinWithFilter2() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON a1 = a2 WHERE a2 <> 1");
    }

    @Test
    void testLeftJoinWithFilter3() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON a1 = a2 WHERE a2 > 1");
    }

    @Test
    void testLeftJoinWithFilter4() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON a1 = a2 WHERE a2 >= 1");
    }

    @Test
    void testLeftJoinWithFilter5() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON a1 = a2 WHERE a2 <= 1");
    }

    @Test
    void testLeftJoinWithFilter6() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON a1 = a2 WHERE a2 = null");
    }

    @Test
    void testRightJoinWithAllFilterInONClause() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 RIGHT JOIN MyTable2 ON a1 = a2 AND a1 = 2");
    }

    @Test
    void testRightJoinWithSomeFiltersFromRightSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 RIGHT JOIN MyTable2 ON a1 = a2 WHERE a2 = 2");
    }

    @Test
    void testRightJoinWithSomeFiltersFromLeftRightSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 RIGHT JOIN MyTable2 ON a1 = a2 AND b1 = b2 AND c1 = c2 WHERE a2 = 2 AND b2 > 10 AND c1 IS NOT NULL");
    }

    @Test
    void testRightJoinWithAllFiltersFromWhere() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 RIGHT JOIN MyTable2 ON true WHERE b1 = b2 AND c1 = c2 AND a2 = 2 AND b2 > 10 AND COALESCE(c1, c2) <> '' ");
    }

    @Test
    void testRightJoinWithNullFilterInLeftSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 RIGHT JOIN MyTable2 ON a1 = a2 WHERE a1 IS NULL");
    }

    @Test
    void testRightJoinWithNullFilterInRightSide2() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 RIGHT JOIN MyTable2 ON a1 = a2 WHERE a1 IS NULL AND a2 < 10");
    }

    @Test
    void testFullJoinWithAllFilterInONClause() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 FULL JOIN MyTable2 ON a1 = a2 AND a1 = 2");
    }

    @Test
    void testFullJoinWithSomeFiltersFromLeftSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 FULL JOIN MyTable2 ON a1 = a2 AND b1 = b2 WHERE a1 = 2");
    }

    @Test
    void testFullJoinWithSomeFiltersFromRightSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 FULL JOIN MyTable2 ON a1 = a2 AND b1 = b2 WHERE a2 = 2");
    }

    @Test
    void testFullJoinWithSomeFiltersFromLeftRightSide() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 FULL JOIN MyTable2 ON a1 = a2 AND b1 = b2 AND c1 = c2 WHERE a2 = 2 AND b2 > 10 AND c1 IS NOT NULL");
    }

    @Test
    void testFullJoinWithAllFiltersFromWhere() {
        this.util.verifyRelPlan("SELECT * FROM MyTable2, MyTable1 WHERE b1 = b2 AND c1 = c2 AND a2 = 2 AND b2 > 10 AND COALESCE(c1, c2) <> '' ");
    }

    @Test
    void testSemiJoin() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 WHERE (a1, b1, c1) IN (SELECT a2, b2, c2 FROM MyTable2 WHERE a2 = 2 AND b2 > 10) AND c1 IS NOT NULL");
    }

    @Test
    void testAntiJoin() {
        this.util.verifyRelPlan("SELECT * FROM MyTable1 WHERE (a1, b1, c1) NOT IN (select a2, b2, c2 FROM MyTable2 WHERE a2 = 2 AND b2 > 10) AND c1 IS NOT NULL");
    }
}

