/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkGroupProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.AggregateReduceGroupingRule;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateJoinTransposeRule;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateJoinTransposeRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0004\b\u0001?!)a\u0005\u0001C\u0001O!9!\u0006\u0001b\u0001\n\u0013Y\u0003BB\u0018\u0001A\u0003%A\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003D\u0001\u0011\u0005\u0011\u0007C\u0003I\u0001\u0011\u0005\u0011\u0007C\u0003K\u0001\u0011\u0005\u0011\u0007C\u0003M\u0001\u0011\u0005\u0011\u0007C\u0003O\u0001\u0011\u0005\u0011\u0007C\u0003Q\u0001\u0011\u0005\u0011\u0007C\u0003S\u0001\u0011\u0005\u0011\u0007C\u0003U\u0001\u0011\u0005\u0011GA\u0012GY&t7.Q4he\u0016<\u0017\r^3K_&tGK]1ogB|7/\u001a*vY\u0016$Vm\u001d;\u000b\u0005=\u0001\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003#I\tQA];mKNT!a\u0005\u000b\u0002\tAd\u0017M\u001c\u0006\u0003+Y\tq\u0001\u001d7b]:,'O\u0003\u0002\u00181\u0005)A/\u00192mK*\u0011\u0011DG\u0001\u0006M2Lgn\u001b\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u0015\u0003\u0015)H/\u001b7t\u0013\t)#EA\u0007UC\ndW\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u00039\tA!\u001e;jYV\tA\u0006\u0005\u0002\"[%\u0011aF\t\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%A\u0003tKR,\b\u000fF\u00013!\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u0011)f.\u001b;)\u0005\u0011I\u0004C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u0003\r\t\u0007/\u001b\u0006\u0003}}\nqA[;qSR,'O\u0003\u0002A9\u0005)!.\u001e8ji&\u0011!i\u000f\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017a\u000b;fgR\u0004Vo\u001d5D_VtG/Q4h)\"\u0014x.^4i\u0015>Lgn\u0014<feVs\u0017.];f\u0007>dW/\u001c8)\u0005\u0015)\u0005C\u0001\u001eG\u0013\t95H\u0001\u0003UKN$\u0018!\u000b;fgR\u0004Vo\u001d5Tk6\fum\u001a+ie>,x\r\u001b&pS:|e/\u001a:V]&\fX/Z\"pYVlg\u000e\u000b\u0002\u0007\u000b\u00069C/Z:u!V\u001c\b.Q4h)\"\u0014x.^4i\u0015>LgnV5uQVs\u0017.];f\u0015>LgnS3zQ\t9Q)A\u001auKN$8k\\7f\u0003\u001e<7)\u00197m\u0007>dW/\u001c8t\u0003:$'j\\5o\u0007>tG-\u001b;j_:\u001cu\u000e\\;n]NL5oU1nK\"\u0012\u0001\"R\u0001+i\u0016\u001cH/Q4he\u0016<\u0017\r^3XSRD\u0017)\u001e=He>,\bo\u0018&pS:\\U-_%t+:L\u0017/^32Q\tIQ)\u0001\u0016uKN$\u0018iZ4sK\u001e\fG/Z,ji\"\fU\u000f_$s_V\u0004xLS8j].+\u00170S:V]&\fX/\u001a\u001a)\u0005))\u0015!\f;fgR\fum\u001a:fO\u0006$XmV5uQ\u0006+\bp\u0012:pkB|&j\\5o\u0017\u0016L\u0018j\u001d(piVs\u0017.];fc!\u00121\"R\u0001.i\u0016\u001cH/Q4he\u0016<\u0017\r^3XSRD\u0017)\u001e=He>,\bo\u0018&pS:\\U-_%t\u001d>$XK\\5rk\u0016\u0014\u0004F\u0001\u0007F\u0001")
public class FlinkAggregateJoinTransposeRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        FlinkChainedProgram program = new FlinkChainedProgram();
        program.addLast("rules", (FlinkOptimizeProgram)FlinkGroupProgramBuilder$.MODULE$.newBuilder().addProgram((FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{AggregateReduceGroupingRule.INSTANCE})).build(), "reduce useless grouping").addProgram((FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{AggregateReduceGroupingRule.INSTANCE, CoreRules.FILTER_INTO_JOIN, CoreRules.JOIN_CONDITION_PUSH, CoreRules.FILTER_AGGREGATE_TRANSPOSE, CoreRules.FILTER_PROJECT_TRANSPOSE, CoreRules.FILTER_MERGE, CoreRules.AGGREGATE_PROJECT_MERGE, FlinkAggregateJoinTransposeRule.EXTENDED})).build(), "aggregate join transpose").build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)program);
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateJoinTransposeRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE T2 (\n                                |  a2 INT,\n                                |  b2 INT PRIMARY KEY NOT ENFORCED,\n                                |  c2 STRING\n                                |) WITH (\n                                |  'connector' = 'values',\n                                |  'bounded' = 'true',\n                                |  'enable-projection-push-down' = 'false'\n                                |)\n                                |")).stripMargin());
    }

    @Test
    public void testPushCountAggThroughJoinOverUniqueColumn() {
        this.util().verifyRelPlan("SELECT COUNT(A.a) FROM (SELECT DISTINCT a FROM T) AS A JOIN T AS B ON A.a=B.a");
    }

    @Test
    public void testPushSumAggThroughJoinOverUniqueColumn() {
        this.util().verifyRelPlan("SELECT SUM(A.a) FROM (SELECT DISTINCT a FROM T) AS A JOIN T AS B ON A.a=B.a");
    }

    @Test
    public void testPushAggThroughJoinWithUniqueJoinKey() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (SELECT a AS a1, COUNT(b) AS b1 FROM T GROUP BY a),\n        |     T2 AS (SELECT COUNT(a) AS a2, b AS b2 FROM T GROUP BY b)\n        |SELECT MIN(a1), MIN(b1), MIN(a2), MIN(b2), a, b, COUNT(c) FROM\n        |  (SELECT * FROM T1, T2, T WHERE a1 = b2 AND a1 = a) t GROUP BY a, b\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSomeAggCallColumnsAndJoinConditionColumnsIsSame() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MIN(a2), MIN(b2), a, b, COUNT(c2) FROM\n        |    (SELECT * FROM T2, T WHERE b2 = a) t GROUP BY a, b\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsUnique1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a2, b2, c2, SUM(a) FROM (SELECT * FROM T2, T WHERE b2 = b) GROUP BY a2, b2, c2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsUnique2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a2, b2, c, SUM(a) FROM (SELECT * FROM T2, T WHERE b2 = b) GROUP BY a2, b2, c\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsNotUnique1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a2, b2, c2, SUM(a) FROM (SELECT * FROM T2, T WHERE a2 = a) GROUP BY a2, b2, c2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsNotUnique2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a2, b2, c, SUM(a) FROM (SELECT * FROM T2, T WHERE a2 = a) GROUP BY a2, b2, c\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

