/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.rules.logical.DecomposeGroupingSetsRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001A3A\u0001D\u0007\u0001=!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003B\u0002\u0018\u0001A\u0003%1\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u0003C\u0001\u0011\u0005\u0001\u0007C\u0003E\u0001\u0011\u0005\u0001\u0007C\u0003G\u0001\u0011\u0005\u0001\u0007C\u0003I\u0001\u0011\u0005\u0001\u0007C\u0003K\u0001\u0011\u0005\u0001\u0007C\u0003M\u0001\u0011\u0005\u0001\u0007C\u0003O\u0001\u0011\u0005\u0001GA\u000fEK\u000e|W\u000e]8tK\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:Sk2,G+Z:u\u0015\tqq\"A\u0004m_\u001eL7-\u00197\u000b\u0005A\t\u0012!\u0002:vY\u0016\u001c(B\u0001\n\u0014\u0003\u0011\u0001H.\u00198\u000b\u0005Q)\u0012a\u00029mC:tWM\u001d\u0006\u0003-]\tQ\u0001^1cY\u0016T!\u0001G\r\u0002\u000b\u0019d\u0017N\\6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011E\u0003\u0002#'\u0005)Q\u000f^5mg&\u0011A%\t\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005i\u0011\u0001B;uS2,\u0012a\u000b\t\u0003A1J!!L\u0011\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\\\u0001\u0006kRLG\u000eI\u0001\u0011i\u0016\u001cHo\u0012:pkBLgnZ*fiN$\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0005+:LG\u000f\u000b\u0002\u0005qA\u0011\u0011\bQ\u0007\u0002u)\u00111\bP\u0001\u0004CBL'BA\u001f?\u0003\u001dQW\u000f]5uKJT!aP\u000e\u0002\u000b),h.\u001b;\n\u0005\u0005S$\u0001\u0002+fgR\f\u0001\u0002^3ti\u000e+(-\u001a\u0015\u0003\u000ba\n!\u0002^3tiJ{G\u000e\\;qQ\t1\u0001(A\u0010uKN$xI]8va&twmU3ug^KG\u000f[(oK\u001e\u0013x.\u001e9j]\u001eD#a\u0002\u001d\u0002IQ,7\u000f^$s_V\u0004\u0018N\\4TKR\u001cx+\u001b;i\tV\u0004H.[2bi\u00164\u0015.\u001a7egFB#\u0001\u0003\u001d\u0002IQ,7\u000f^$s_V\u0004\u0018N\\4TKR\u001cx+\u001b;i\tV\u0004H.[2bi\u00164\u0015.\u001a7egJB#!\u0003\u001d\u0002\u001fQ,7\u000f^\"B\u0019\u000eKE+R\u00199eQB#A\u0003\u001d\u00023Q,7\u000f\u001e+p_6\u000bg._$s_V\u0004\u0018N\\4GS\u0016dGm\u001d\u0015\u0003\u0017a\u0002")
public class DecomposeGroupingSetsRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testGroupingSets() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c, avg(a) AS a, GROUP_ID() AS g FROM MyTable\n        |GROUP BY GROUPING SETS (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCube() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRollup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) as gid\n        |FROM MyTable\n        |     GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithOneGrouping() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b,\n        |    AVG(a) AS a,\n        |    GROUP_ID() as g,\n        |    GROUPING(b) as gb,\n        |    GROUPING_ID(b) as gib\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS (b)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithDuplicateFields1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT count(b) as b, count(c) as c FROM MyTable GROUP BY GROUPING SETS (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithDuplicateFields2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT count(a) as a, count(b) as b, count(c) as c FROM MyTable\n        |GROUP BY GROUPING SETS ((a, b), (a, c))\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCALCITE1824() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, GROUP_ID() AS g, COUNT(*) as c FROM MyTable GROUP BY GROUPING SETS (a, (), ())\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testTooManyGroupingFields() {
        String[] fieldNames = (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 64).map((Function1 & Serializable & scala.Serializable)i -> DecomposeGroupingSetsRuleTest.$anonfun$testTooManyGroupingFields$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        AbstractDataType[] fieldTypes = (AbstractDataType[])Array$.MODULE$.fill(fieldNames.length, (Function0 & Serializable & scala.Serializable)() -> DataTypes.INT(), ClassTag$.MODULE$.apply(AbstractDataType.class));
        this.util().addTableSource("MyTable64", fieldTypes, fieldNames);
        String fields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).mkString(",");
        String sqlQuery = new StringBuilder(48).append("SELECT ").append(fields).append(" FROM MyTable64 GROUP BY GROUPING SETS (").append(fields).append(")").toString();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.util().verifyRelPlan(sqlQuery));
    }

    public static final /* synthetic */ String $anonfun$testTooManyGroupingFields$1(int i) {
        return new StringBuilder(1).append("f").append(i).toString();
    }

    public DecomposeGroupingSetsRuleTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.DecomposeGroupingSetsRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.PHYSICAL());
    }
}

