/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.rules.logical.CalcRankTransposeRuleTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e3AAD\b\u0001A!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0013a\u0003B\u0002\u0019\u0001A\u0003%Q\u0006C\u00032\u0001\u0011\u0005!\u0007C\u0003E\u0001\u0011\u0005!\u0007C\u0003J\u0001\u0011\u0005!\u0007C\u0003L\u0001\u0011\u0005!\u0007C\u0003N\u0001\u0011\u0005!\u0007C\u0003P\u0001\u0011\u0005!\u0007C\u0003R\u0001\u0011\u0005!\u0007C\u0003T\u0001\u0011\u0005!\u0007C\u0003V\u0001\u0011\u0005!\u0007C\u0003X\u0001\u0011\u0005!GA\rDC2\u001c'+\u00198l)J\fgn\u001d9pg\u0016\u0014V\u000f\\3UKN$(B\u0001\t\u0012\u0003\u001dawnZ5dC2T!AE\n\u0002\u000bI,H.Z:\u000b\u0005Q)\u0012\u0001\u00029mC:T!AF\f\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0001$G\u0001\u0006i\u0006\u0014G.\u001a\u0006\u00035m\tQA\u001a7j].T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011C\u0001\u0001\"!\t\u0011S%D\u0001$\u0015\t!S#A\u0003vi&d7/\u0003\u0002'G\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"A\b\u0002\tU$\u0018\u000e\\\u000b\u0002[A\u0011!EL\u0005\u0003_\r\u00121c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\nQa]3ukB$\u0012a\r\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0005+:LG\u000f\u000b\u0002\u0005uA\u00111HQ\u0007\u0002y)\u0011QHP\u0001\u0004CBL'BA A\u0003\u001dQW\u000f]5uKJT!!Q\u000f\u0002\u000b),h.\u001b;\n\u0005\rc$A\u0003\"fM>\u0014X-R1dQ\u0006\u0011B/Z:u!J,h.Z(sI\u0016\u00148*Z=tQ\t)a\t\u0005\u0002<\u000f&\u0011\u0001\n\u0010\u0002\u0005)\u0016\u001cH/\u0001\fuKN$\bK];oKB\u000b'\u000f^5uS>t7*Z=tQ\t1a)A\nuKN$\bK];oKVs\u0017.];f\u0017\u0016L8\u000f\u000b\u0002\b\r\u0006\u0001B/Z:u\u001d>$HK]1ogB|7/\u001a\u0015\u0003\u0011\u0019\u000b1\u0003^3tiB\u0013XO\\3SC:\\g*^7cKJD#!\u0003$\u0002+Q,7\u000f\u001e)s_*,7\r\u001e*b].tU/\u001c2fe\"\u0012!BR\u0001\u0019i\u0016\u001cH\u000f\u0016:jm&\fGnQ1mG&\u001b(+Z7pm\u0016$\u0007FA\u0006G\u0003\u0005\"Xm\u001d;QkND7)\u00197d/&$\bnQ8oI&$\u0018n\u001c8J]R|'+\u00198lQ\taa)\u0001\fuKN$\bK];oKVsWo]3e!J|'.Z2uQ\tia\t")
public class CalcRankTransposeRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.CalcRankTransposeRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "category")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "shopId")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price"))}), new CaseClassTypeInfo<Tuple3<String, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, String>>(this, fieldSerializers){

                    public Tuple3<String, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.CalcRankTransposeRuleTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testPruneOrderKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPrunePartitionKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneUniqueKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT category, max_price, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY category ORDER BY max_price ASC) as rank_num\n        |  FROM (\n        |     SELECT category, shopId, max(price) as max_price, min(price) as min_price\n        |     FROM T\n        |     GROUP BY category, shopId\n        |  ))\n        |WHERE rank_num <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testNotTranspose() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT category, max_price, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY category ORDER BY max_price ASC) as rank_num\n        |  FROM (\n        |     SELECT category, shopId, max(price) as max_price\n        |     FROM T\n        |     GROUP BY category, shopId\n        |  ))\n        |WHERE rank_num <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneRankNumber() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, rowtime FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num <= 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testProjectRankNumber() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rank_num, rowtime, a, rank_num, a, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE  rank_num <= 2\n    ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTrivialCalcIsRemoved() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, rowtime, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE  rank_num <= 2\n    ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPushCalcWithConditionIntoRank() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, c FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE  rank_num <= 2 AND a > 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneUnusedProject() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT category, shopId, max_price, rank_num\n        |FROM (\n        |  SELECT category, shopId, max_price,\n        |      ROW_NUMBER() OVER (PARTITION BY category ORDER BY max_price ASC) as rank_num\n        |  FROM (\n        |     SELECT category, shopId, max(price) as max_price, min(price) as min_price\n        |     FROM T\n        |     GROUP BY category, shopId\n        |  ))\n        |WHERE rank_num <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }
}

