/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.testutils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.flink.table.api.CompiledPlan;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.PlanReference;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtil;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.SqlTestStep;
import org.apache.flink.table.test.program.StatementSetTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.table.test.program.TableTestProgramRunner;
import org.apache.flink.table.test.program.TestStep;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@ExtendWith(value={MiniClusterExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public abstract class BatchRestoreTestBase
implements TableTestProgramRunner {
    private final Class<? extends ExecNode<?>> execNodeUnderTest;
    private final List<Class<? extends ExecNode<?>>> childExecNodesUnderTest;

    protected BatchRestoreTestBase(Class<? extends ExecNode<?>> execNodeUnderTest) {
        this(execNodeUnderTest, new ArrayList());
    }

    protected BatchRestoreTestBase(Class<? extends ExecNode<?>> execNodeUnderTest, List<Class<? extends ExecNode<?>>> childExecNodesUnderTest) {
        this.execNodeUnderTest = execNodeUnderTest;
        this.childExecNodesUnderTest = childExecNodesUnderTest;
    }

    public Class<? extends ExecNode<?>> getExecNode() {
        return this.execNodeUnderTest;
    }

    public List<Class<? extends ExecNode<?>>> getChildExecNodes() {
        return this.childExecNodesUnderTest;
    }

    public EnumSet<TestStep.TestKind> supportedSetupSteps() {
        return EnumSet.of(TestStep.TestKind.CONFIG, new TestStep.TestKind[]{TestStep.TestKind.FUNCTION, TestStep.TestKind.SOURCE_WITH_RESTORE_DATA, TestStep.TestKind.SOURCE_WITH_DATA, TestStep.TestKind.SINK_WITH_RESTORE_DATA, TestStep.TestKind.SINK_WITH_DATA});
    }

    public EnumSet<TestStep.TestKind> supportedRunSteps() {
        return EnumSet.of(TestStep.TestKind.SQL, TestStep.TestKind.STATEMENT_SET);
    }

    @AfterEach
    public void clearData() {
        TestValuesTableFactory.clearAllData();
    }

    private List<ExecNodeMetadata> getAllMetadata() {
        return ExecNodeMetadataUtil.extractMetadataFromAnnotation(this.execNodeUnderTest);
    }

    private ExecNodeMetadata getLatestMetadata() {
        return ExecNodeMetadataUtil.latestAnnotation(this.execNodeUnderTest);
    }

    private Stream<Arguments> createSpecs() {
        return this.getAllMetadata().stream().flatMap(metadata -> this.supportedPrograms().stream().map(p -> Arguments.of((Object[])new Object[]{p, metadata})));
    }

    @ParameterizedTest
    @MethodSource(value={"supportedPrograms"})
    @Order(value=0)
    public void generateCompiledPlans(TableTestProgram program) {
        CompiledPlan compiledPlan;
        Path path = this.getPlanPath(program, this.getLatestMetadata());
        if (path.toFile().exists()) {
            return;
        }
        EnvironmentSettings settings = EnvironmentSettings.inBatchMode();
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)settings);
        program.getSetupConfigOptionTestSteps().forEach(s -> s.apply(tEnv));
        tEnv.getConfig().set(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanCompilation.SCHEMA);
        for (SourceTestStep sourceTestStep : program.getSetupSourceTestSteps()) {
            String id = TestValuesTableFactory.registerData(sourceTestStep.dataBeforeRestore);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("connector", "values");
            options.put("data-id", id);
            options.put("bounded", "true");
            options.put("terminating", "true");
            options.put("runtime-source", "NewSource");
            sourceTestStep.apply(tEnv, options);
        }
        for (SinkTestStep sinkTestStep : program.getSetupSinkTestSteps()) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("connector", "values");
            options.put("sink-insert-only", "false");
            sinkTestStep.apply(tEnv, options);
        }
        program.getSetupFunctionTestSteps().forEach(s -> s.apply(tEnv));
        if (((TestStep)program.runSteps.get(0)).getKind() == TestStep.TestKind.STATEMENT_SET) {
            StatementSetTestStep statementSetTestStep = program.getRunStatementSetTestStep();
            compiledPlan = statementSetTestStep.compiledPlan(tEnv);
        } else {
            SqlTestStep sqlTestStep = program.getRunSqlTestStep();
            compiledPlan = tEnv.compilePlanSql(sqlTestStep.sql);
        }
        compiledPlan.writeToFile(path);
    }

    @ParameterizedTest
    @MethodSource(value={"createSpecs"})
    @Order(value=1)
    void loadAndRunCompiledPlan(TableTestProgram program, ExecNodeMetadata metadata) throws Exception {
        EnvironmentSettings settings = EnvironmentSettings.inBatchMode();
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)settings);
        tEnv.getConfig().set(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanRestore.IDENTIFIER);
        program.getSetupConfigOptionTestSteps().forEach(s -> s.apply(tEnv));
        for (SourceTestStep sourceTestStep : program.getSetupSourceTestSteps()) {
            ArrayList<Row> data = new ArrayList<Row>();
            data.addAll(sourceTestStep.dataBeforeRestore);
            data.addAll(sourceTestStep.dataAfterRestore);
            String id = TestValuesTableFactory.registerData(data);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("connector", "values");
            options.put("data-id", id);
            options.put("runtime-source", "NewSource");
            options.put("terminating", "true");
            options.put("bounded", "true");
            sourceTestStep.apply(tEnv, options);
        }
        for (SinkTestStep sinkTestStep : program.getSetupSinkTestSteps()) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("connector", "values");
            options.put("disable-lookup", "true");
            options.put("sink-insert-only", "false");
            sinkTestStep.apply(tEnv, options);
        }
        program.getSetupFunctionTestSteps().forEach(s -> s.apply(tEnv));
        CompiledPlan compiledPlan = tEnv.loadPlan(PlanReference.fromFile((Path)this.getPlanPath(program, metadata)));
        compiledPlan.execute().await();
        for (SinkTestStep sinkTestStep : program.getSetupSinkTestSteps()) {
            List<String> actualResults = BatchRestoreTestBase.getActualResults(sinkTestStep, sinkTestStep.name);
            List expectResults = sinkTestStep.getExpectedMaterializedResultsAsStrings();
            Assertions.assertThat(actualResults).containsExactlyInAnyOrderElementsOf((Iterable)expectResults);
        }
    }

    private Path getPlanPath(TableTestProgram program, ExecNodeMetadata metadata) {
        return Paths.get(this.getTestResourceDirectory(program, metadata) + "/plan/" + program.id + ".json", new String[0]);
    }

    private String getTestResourceDirectory(TableTestProgram program, ExecNodeMetadata metadata) {
        return String.format("%s/src/test/resources/restore-tests/%s_%d/%s", System.getProperty("user.dir"), metadata.name(), metadata.version(), program.id);
    }

    private static List<String> getActualResults(SinkTestStep sinkTestStep, String tableName) {
        if (sinkTestStep.shouldTestChangelogData()) {
            return TestValuesTableFactory.getRawResultsAsStrings(tableName);
        }
        return TestValuesTableFactory.getResultsAsStrings(tableName);
    }
}

