/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PythonGroupAggregateJsonPlanTest
extends TableTestBase {
    private StreamTableTestUtil util;
    private TableEnvironment tEnv;

    PythonGroupAggregateJsonPlanTest() {
    }

    @BeforeEach
    void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
        String srcTableDdl = "CREATE TABLE MyTable (\n  a int not null,\n  b int not null,\n  c int not null,\n  d bigint\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
        this.tEnv.createTemporarySystemFunction("pyFunc", (UserDefinedFunction)new JavaUserDefinedAggFunctions.TestPythonAggregateFunction());
    }

    @Test
    void tesPythonAggCallsWithGroupBy() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b bigint\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into MySink select b, pyFunc(a, c) filter (where b > 1) from MyTable group by b");
    }
}

