/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.nodes.exec.stream.WindowRankTestPrograms;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.table.test.program.TableTestProgramRunner;
import org.apache.flink.table.test.program.TestStep;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@ExtendWith(value={MiniClusterExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class MiscTests
implements TableTestProgramRunner {
    MiscTests() {
    }

    public List<TableTestProgram> programs() {
        return Collections.singletonList(WindowRankTestPrograms.WINDOW_RANK_HOP_TVF_NAMED_MIN_TOP_1);
    }

    public EnumSet<TestStep.TestKind> supportedSetupSteps() {
        return EnumSet.of(TestStep.TestKind.CONFIG, TestStep.TestKind.SOURCE_WITH_DATA, TestStep.TestKind.SINK_WITH_DATA);
    }

    public EnumSet<TestStep.TestKind> supportedRunSteps() {
        return EnumSet.of(TestStep.TestKind.SQL);
    }

    @AfterEach
    public void clearData() {
        TestValuesTableFactory.clearAllData();
    }

    @ParameterizedTest
    @MethodSource(value={"supportedPrograms"})
    void runTests(TableTestProgram program) throws Exception {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        program.getSetupConfigOptionTestSteps().forEach(s -> s.apply(tEnv));
        for (SourceTestStep sourceTestStep : program.getSetupSourceTestSteps()) {
            String id = TestValuesTableFactory.registerData(sourceTestStep.dataBeforeRestore);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("connector", "values");
            options.put("data-id", id);
            options.put("runtime-source", "NewSource");
            sourceTestStep.apply(tEnv, options);
        }
        for (SinkTestStep sinkTestStep : program.getSetupSinkTestSteps()) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("connector", "values");
            options.put("sink-insert-only", "false");
            sinkTestStep.apply(tEnv, options);
        }
        program.getRunSqlTestStep().apply(tEnv).await();
        for (SinkTestStep sinkTestStep : program.getSetupSinkTestSteps()) {
            List<String> expectedResults = MiscTests.getExpectedResults(sinkTestStep, sinkTestStep.name);
            Assertions.assertThat(expectedResults).containsExactlyInAnyOrder((Object[])sinkTestStep.getExpectedAsStrings().toArray(new String[0]));
        }
    }

    private static List<String> getExpectedResults(SinkTestStep sinkTestStep, String tableName) {
        if (sinkTestStep.shouldTestChangelogData()) {
            return TestValuesTableFactory.getRawResultsAsStrings(tableName);
        }
        return TestValuesTableFactory.getResultsAsStrings(tableName);
    }
}

