/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.Duration;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class IncrementalGroupAggregateTestPrograms {
    static final Row[] BEFORE_DATA = new Row[]{Row.of((Object[])new Object[]{1, 1L, "hi"}), Row.of((Object[])new Object[]{2, 2L, "hello"}), Row.of((Object[])new Object[]{3, 2L, "hello world"})};
    static final Row[] AFTER_DATA = new Row[]{Row.of((Object[])new Object[]{3, 2L, "foo"}), Row.of((Object[])new Object[]{4, 4L, "bar"}), Row.of((Object[])new Object[]{5, 2L, "foo bar"})};
    static final String[] SOURCE_SCHEMA = new String[]{"a INT", "b BIGINT", "c VARCHAR"};
    static final TableTestProgram INCREMENTAL_GROUP_AGGREGATE_SIMPLE = TableTestProgram.of((String)"incremental-group-aggregate-simple", (String)"validates incremental group aggregation").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)true).setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(10L)).setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)1L).setupConfig(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)true).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"b BIGINT", "a BIGINT"})).consumedBeforeRestore(new String[]{"+I[1, 1]", "+I[2, 1]", "-U[2, 1]", "+U[2, 2]"}).consumedAfterRestore(new String[]{"-U[2, 2]", "+U[2, 3]", "+I[4, 1]"}).build()).runSql("INSERT INTO sink_t\n     SELECT\n         b,\n         COUNT(DISTINCT a) AS a\n     FROM source_t\n     GROUP BY b").build();
    static final TableTestProgram INCREMENTAL_GROUP_AGGREGATE_COMPLEX = TableTestProgram.of((String)"incremental-group-aggregate-complex", (String)"validates incremental group aggregation with multiple aggregations").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)true).setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(10L)).setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)1L).setupConfig(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)true).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"b BIGINT", "sum_b BIGINT", "cnt_distinct_b BIGINT", "cnt_1 BIGINT"})).consumedBeforeRestore(new String[]{"+I[1, 1, 1, 1]", "-U[1, 1, 1, 1]", "+U[1, 3, 2, 2]", "-U[1, 3, 2, 2]", "+U[1, 5, 2, 3]"}).consumedAfterRestore(new String[]{"-U[1, 5, 2, 3]", "+U[1, 3, 2, 2]", "+I[2, 2, 1, 1]", "-U[1, 3, 2, 2]", "+U[1, 7, 3, 3]", "-U[1, 7, 3, 3]", "+U[1, 9, 3, 4]"}).build()).runSql("INSERT INTO sink_t SELECT\n         b,\n         SUM(b1) AS sum_b,\n         COUNT(DISTINCT b1) AS cnt_distinct_b,\n         COUNT(1) AS cnt_1\n     FROM\n         (\n             SELECT\n                     a,\n                     COUNT(b) AS b,\n                     MAX(b) AS b1\n             FROM source_t GROUP BY a\n         )\n     GROUP BY b").build();
}

