/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.math.BigDecimal;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class GroupWindowAggregateTestPrograms {
    static final Row[] BEFORE_DATA = new Row[]{Row.of((Object[])new Object[]{"2020-10-10 00:00:01", 1, 1.0, Float.valueOf(1.0f), new BigDecimal("1.11"), "Hi", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:02", 2, 2.0, Float.valueOf(2.0f), new BigDecimal("2.22"), "Comment#1", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:03", 2, 2.0, Float.valueOf(2.0f), new BigDecimal("2.22"), "Comment#1", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:04", 5, 5.0, Float.valueOf(5.0f), new BigDecimal("5.55"), null, "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:07", 3, 3.0, Float.valueOf(3.0f), null, "Hello", "b"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:06", 6, 6.0, Float.valueOf(6.0f), new BigDecimal("6.66"), "Hi", "b"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:08", 3, null, Float.valueOf(3.0f), new BigDecimal("3.33"), "Comment#2", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:04", 5, 5.0, null, new BigDecimal("5.55"), "Hi", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:16", 4, 4.0, Float.valueOf(4.0f), new BigDecimal("4.44"), "Hi", "b"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:32", 7, 7.0, Float.valueOf(7.0f), new BigDecimal("7.77"), null, null}), Row.of((Object[])new Object[]{"2020-10-10 00:00:34", 1, 3.0, Float.valueOf(3.0f), new BigDecimal("3.33"), "Comment#3", "b"})};
    static final Row[] AFTER_DATA = new Row[]{Row.of((Object[])new Object[]{"2020-10-10 00:00:41", 10, 3.0, Float.valueOf(3.0f), new BigDecimal("4.44"), "Comment#4", "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:42", 11, 4.0, Float.valueOf(4.0f), new BigDecimal("5.44"), "Comment#5", "d"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:43", 12, 5.0, Float.valueOf(5.0f), new BigDecimal("6.44"), "Comment#6", "c"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:44", 13, 6.0, Float.valueOf(6.0f), new BigDecimal("7.44"), "Comment#7", "d"})};
    static final SourceTestStep SOURCE = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"ts STRING", "a_int INT", "b_double DOUBLE", "c_float FLOAT", "d_bigdec DECIMAL(10, 2)", "`comment` STRING", "name STRING", "`rowtime` AS TO_TIMESTAMP(`ts`)", "`proctime` AS PROCTIME()", "WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND"})).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build();
    static final TableTestProgram GROUP_TUMBLE_WINDOW_EVENT_TIME = TableTestProgram.of((String)"group-window-aggregate-tumble-event-time", (String)"validates group by using tumbling window with event time").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"name STRING", "window_start TIMESTAMP(3)", "window_end TIMESTAMP(3)", "cnt BIGINT", "sum_int INT", "distinct_cnt BIGINT"})).consumedBeforeRestore(new String[]{"+I[a, 2020-10-10T00:00, 2020-10-10T00:00:05, 4, 10, 2]", "+I[a, 2020-10-10T00:00:05, 2020-10-10T00:00:10, 1, 3, 1]", "+I[b, 2020-10-10T00:00:05, 2020-10-10T00:00:10, 2, 9, 2]", "+I[b, 2020-10-10T00:00:15, 2020-10-10T00:00:20, 1, 4, 1]"}).consumedAfterRestore(new String[]{"+I[b, 2020-10-10T00:00:30, 2020-10-10T00:00:35, 1, 1, 1]", "+I[null, 2020-10-10T00:00:30, 2020-10-10T00:00:35, 1, 7, 0]", "+I[a, 2020-10-10T00:00:40, 2020-10-10T00:00:45, 1, 10, 1]", "+I[c, 2020-10-10T00:00:40, 2020-10-10T00:00:45, 1, 12, 1]", "+I[d, 2020-10-10T00:00:40, 2020-10-10T00:00:45, 2, 24, 2]"}).build()).runSql("INSERT INTO sink_t SELECT name, TUMBLE_START(rowtime, INTERVAL '5' SECOND) AS window_start, TUMBLE_END(rowtime, INTERVAL '5' SECOND) AS window_end, COUNT(*), SUM(a_int), COUNT(DISTINCT `comment`) FROM source_t GROUP BY name, TUMBLE(rowtime, INTERVAL '5' SECOND)").build();
    static final TableTestProgram GROUP_TUMBLE_WINDOW_PROC_TIME = TableTestProgram.of((String)"group-window-aggregate-tumble-proc-time", (String)"validates group by using tumbling window with processing time").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"name STRING", "cnt BIGINT", "sum_int INT", "distinct_cnt BIGINT"})).consumedBeforeRestore(new String[]{"+I[a, 6, 18, 3]", "+I[null, 1, 7, 0]", "+I[b, 4, 14, 3]"}).consumedAfterRestore(new String[]{"+I[a, 1, 10, 1]", "+I[c, 1, 12, 1]", "+I[d, 2, 24, 2]"}).build()).runSql("INSERT INTO sink_t SELECT name, COUNT(*), SUM(a_int), COUNT(DISTINCT `comment`) FROM source_t GROUP BY name, TUMBLE(proctime, INTERVAL '5' SECOND)").build();
    static final TableTestProgram GROUP_HOP_WINDOW_EVENT_TIME = TableTestProgram.of((String)"group-window-aggregate-hop-event-time", (String)"validates group by using hopping window with event time").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"name STRING", "cnt BIGINT"})).consumedBeforeRestore(new String[]{"+I[a, 4]", "+I[b, 2]", "+I[a, 6]", "+I[a, 1]", "+I[b, 2]", "+I[b, 1]", "+I[b, 1]"}).consumedAfterRestore(new String[]{"+I[b, 1]", "+I[null, 1]", "+I[b, 1]", "+I[null, 1]", "+I[a, 1]", "+I[d, 2]", "+I[c, 1]", "+I[a, 1]", "+I[c, 1]", "+I[d, 2]"}).build()).runSql("INSERT INTO sink_t SELECT name, COUNT(*) FROM source_t GROUP BY name, HOP(rowtime, INTERVAL '5' SECOND, INTERVAL '10' SECOND)").build();
    static final TableTestProgram GROUP_HOP_WINDOW_PROC_TIME = TableTestProgram.of((String)"group-window-aggregate-hop-proc-time", (String)"validates group by using hopping window with processing time").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"name STRING", "cnt BIGINT"})).consumedBeforeRestore(new String[]{"+I[a, 6]", "+I[b, 4]", "+I[null, 1]", "+I[a, 6]", "+I[null, 1]", "+I[b, 4]"}).consumedAfterRestore(new String[]{"+I[a, 1]", "+I[d, 2]", "+I[c, 1]", "+I[a, 1]", "+I[c, 1]", "+I[d, 2]"}).build()).runSql("INSERT INTO sink_t SELECT name, COUNT(*) FROM source_t GROUP BY name, HOP(proctime, INTERVAL '5' SECOND, INTERVAL '10' SECOND)").build();
    static final TableTestProgram GROUP_SESSION_WINDOW_EVENT_TIME = TableTestProgram.of((String)"group-window-aggregate-session-event-time", (String)"validates group by using session window with event time").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"name STRING", "cnt BIGINT"})).consumedBeforeRestore(new String[]{"+I[a, 4]", "+I[b, 2]", "+I[a, 1]", "+I[b, 1]"}).consumedAfterRestore(new String[]{"+I[null, 1]", "+I[b, 1]", "+I[a, 1]", "+I[c, 1]", "+I[d, 2]"}).build()).runSql("INSERT INTO sink_t SELECT name, COUNT(*) FROM source_t GROUP BY name, SESSION(rowtime, INTERVAL '3' SECOND)").build();
    static final TableTestProgram GROUP_SESSION_WINDOW_PROC_TIME = TableTestProgram.of((String)"group-window-aggregate-session-proc-time", (String)"validates group by using session window with processing time").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"name STRING", "cnt BIGINT"})).consumedBeforeRestore(new String[]{"+I[a, 6]", "+I[null, 1]", "+I[b, 4]"}).consumedAfterRestore(new String[]{"+I[a, 1]", "+I[c, 1]", "+I[d, 2]"}).build()).runSql("INSERT INTO sink_t SELECT name, COUNT(*) FROM source_t GROUP BY name, SESSION(proctime, INTERVAL '3' SECOND)").build();
}

