/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TestDynamicTableFactory;
import org.apache.flink.table.factories.TestFormatFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.plan.abilities.source.FilterPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.LimitPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.PartitionPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.ProjectPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.ReadingMetadataSpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceWatermarkSpec;
import org.apache.flink.table.planner.plan.abilities.source.WatermarkPushDownSpec;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.watermark.WatermarkEmitStrategy;
import org.apache.flink.table.watermark.WatermarkParams;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
public class DynamicTableSourceSpecSerdeTest {
    public static Stream<DynamicTableSourceSpec> testDynamicTableSinkSpecSerde() {
        HashMap<String, String> options1 = new HashMap<String, String>();
        options1.put("connector", "filesystem");
        options1.put("format", "testcsv");
        options1.put("path", "/tmp");
        ResolvedSchema resolvedSchema1 = new ResolvedSchema(Collections.singletonList(Column.physical((String)"a", (DataType)DataTypes.BIGINT())), Collections.emptyList(), null);
        CatalogTable catalogTable1 = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema1).build()).options(options1).build();
        DynamicTableSourceSpec spec1 = new DynamicTableSourceSpec(ContextResolvedTable.temporary((ObjectIdentifier)ObjectIdentifier.of((String)((String)TableConfigOptions.TABLE_CATALOG_NAME.defaultValue()), (String)((String)TableConfigOptions.TABLE_DATABASE_NAME.defaultValue()), (String)"MyTable"), (ResolvedCatalogBaseTable)new ResolvedCatalogTable(catalogTable1, resolvedSchema1)), null);
        HashMap<String, String> options2 = new HashMap<String, String>();
        options2.put("connector", "values");
        options2.put("disable-lookup", "true");
        options2.put("enable-watermark-push-down", "true");
        options2.put("filterable-fields", "b");
        options2.put("bounded", "false");
        options2.put("readable-metadata", "m1:INT, m2:STRING");
        ResolvedSchema resolvedSchema2 = new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.BIGINT()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"c", (DataType)DataTypes.STRING()), Column.physical((String)"p", (DataType)DataTypes.STRING()), Column.metadata((String)"m1", (DataType)DataTypes.INT(), null, (boolean)false), Column.metadata((String)"m2", (DataType)DataTypes.STRING(), null, (boolean)false), Column.physical((String)"ts", (DataType)DataTypes.TIMESTAMP((int)3))), Collections.emptyList(), null);
        CatalogTable catalogTable2 = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema2).build()).options(options2).build();
        FlinkTypeFactory factory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)factory);
        DynamicTableSourceSpec spec2 = new DynamicTableSourceSpec(ContextResolvedTable.temporary((ObjectIdentifier)ObjectIdentifier.of((String)((String)TableConfigOptions.TABLE_CATALOG_NAME.defaultValue()), (String)((String)TableConfigOptions.TABLE_DATABASE_NAME.defaultValue()), (String)"MyTable"), (ResolvedCatalogBaseTable)new ResolvedCatalogTable(catalogTable2, resolvedSchema2)), Arrays.asList(new ProjectPushDownSpec((int[][])new int[][]{{0}, {1}, {4}, {6}}, RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new IntType(), new TimestampType(3)}, (String[])new String[]{"a", "b", "m1", "ts"})), new ReadingMetadataSpec(Arrays.asList("m1", "m2"), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new IntType(), new TimestampType(3)}, (String[])new String[]{"a", "b", "m1", "ts"})), new FilterPushDownSpec(Collections.singletonList(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{rexBuilder.makeInputRef(factory.createSqlType(SqlTypeName.INTEGER), 1), rexBuilder.makeExactLiteral(new BigDecimal(10))}))), new WatermarkPushDownSpec(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{rexBuilder.makeInputRef(factory.createSqlType(SqlTypeName.TIMESTAMP, 3), 3), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(1000L), new SqlIntervalQualifier(TimeUnit.SECOND, 2, TimeUnit.SECOND, 6, SqlParserPos.ZERO))}), 5000L, RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new IntType(), new TimestampType(false, TimestampKind.ROWTIME, 3)}), WatermarkParams.builder().emitStrategy(WatermarkEmitStrategy.ON_PERIODIC).alignGroupName("align-group-1").alignMaxDrift(Duration.ofMinutes(1L)).alignUpdateInterval(Duration.ofSeconds(1L)).sourceIdleTimeout(60000L).build()), new SourceWatermarkSpec(true, RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new IntType(), new TimestampType(false, TimestampKind.ROWTIME, 3)})), new LimitPushDownSpec(100L), new PartitionPushDownSpec(Arrays.asList(new HashMap<String, String>(){
            {
                this.put("p", "A");
            }
        }, new HashMap<String, String>(){
            {
                this.put("p", "B");
            }
        }))));
        return Stream.of(spec1, spec2);
    }

    @ParameterizedTest
    @MethodSource(value={"testDynamicTableSinkSpecSerde"})
    void testDynamicTableSourceSpecSerde(DynamicTableSourceSpec spec) throws IOException {
        PlannerMocks plannerMocks = PlannerMocks.create();
        CatalogManager catalogManager = plannerMocks.getCatalogManager();
        catalogManager.createTable((CatalogBaseTable)spec.getContextResolvedTable().getResolvedTable(), spec.getContextResolvedTable().getIdentifier(), false);
        SerdeContext serdeCtx = JsonSerdeTestUtil.configuredSerdeContext(catalogManager, plannerMocks.getTableConfig());
        spec = new DynamicTableSourceSpec(ContextResolvedTable.permanent((ObjectIdentifier)spec.getContextResolvedTable().getIdentifier(), (Catalog)((Catalog)catalogManager.getCatalog(catalogManager.getCurrentCatalog()).get()), (ResolvedCatalogBaseTable)spec.getContextResolvedTable().getResolvedTable()), spec.getSourceAbilities());
        String actualJson = JsonSerdeTestUtil.toJson(serdeCtx, spec);
        DynamicTableSourceSpec actual = JsonSerdeTestUtil.toObject(serdeCtx, actualJson, DynamicTableSourceSpec.class);
        Assertions.assertThat((Object)actual.getContextResolvedTable()).isEqualTo((Object)spec.getContextResolvedTable());
        Assertions.assertThat((List)actual.getSourceAbilities()).isEqualTo((Object)spec.getSourceAbilities());
        Assertions.assertThat((Object)actual.getScanTableSource(plannerMocks.getPlannerContext().getFlinkContext(), serdeCtx.getTypeFactory())).isNotNull();
    }

    @Test
    void testDynamicTableSourceSpecSerdeWithEnrichmentOptions() throws Exception {
        ObjectIdentifier identifier = ObjectIdentifier.of((String)((String)TableConfigOptions.TABLE_CATALOG_NAME.defaultValue()), (String)((String)TableConfigOptions.TABLE_DATABASE_NAME.defaultValue()), (String)"my_table");
        String formatPrefix = FactoryUtil.getFormatPrefix((ConfigOption)FactoryUtil.FORMAT, (String)"test-format");
        HashMap<String, String> planOptions = new HashMap<String, String>();
        planOptions.put(FactoryUtil.CONNECTOR.key(), "test-connector");
        planOptions.put(TestDynamicTableFactory.TARGET.key(), "abc");
        planOptions.put(TestDynamicTableFactory.PASSWORD.key(), "abc");
        planOptions.put(FactoryUtil.FORMAT.key(), "test-format");
        planOptions.put(formatPrefix + TestFormatFactory.DELIMITER.key(), "|");
        HashMap<String, String> catalogOptions = new HashMap<String, String>();
        catalogOptions.put(FactoryUtil.CONNECTOR.key(), "test-connector");
        catalogOptions.put(TestDynamicTableFactory.TARGET.key(), "abc");
        catalogOptions.put(TestDynamicTableFactory.PASSWORD.key(), "xyz");
        catalogOptions.put(FactoryUtil.FORMAT.key(), "test-format");
        catalogOptions.put(formatPrefix + TestFormatFactory.DELIMITER.key(), ",");
        ResolvedCatalogTable planResolvedCatalogTable = DynamicTableSourceSpecSerdeTest.tableWithOnlyPhysicalColumns(planOptions);
        ResolvedCatalogTable catalogResolvedCatalogTable = DynamicTableSourceSpecSerdeTest.tableWithOnlyPhysicalColumns(catalogOptions);
        PlannerMocks plannerMocks = PlannerMocks.create(new Configuration().set(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanRestore.ALL).set(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanCompilation.ALL));
        CatalogManager catalogManager = plannerMocks.getCatalogManager();
        catalogManager.createTable((CatalogBaseTable)catalogResolvedCatalogTable, identifier, false);
        SerdeContext serdeCtx = JsonSerdeTestUtil.configuredSerdeContext(catalogManager, plannerMocks.getTableConfig());
        DynamicTableSourceSpec planSpec = new DynamicTableSourceSpec(ContextResolvedTable.permanent((ObjectIdentifier)identifier, (Catalog)((Catalog)catalogManager.getCatalog(catalogManager.getCurrentCatalog()).get()), (ResolvedCatalogBaseTable)planResolvedCatalogTable), Collections.emptyList());
        String actualJson = JsonSerdeTestUtil.toJson(serdeCtx, planSpec);
        DynamicTableSourceSpec actual = JsonSerdeTestUtil.toObject(serdeCtx, actualJson, DynamicTableSourceSpec.class);
        Assertions.assertThat((Object)actual.getContextResolvedTable()).isEqualTo((Object)planSpec.getContextResolvedTable());
        Assertions.assertThat((List)actual.getSourceAbilities()).isNull();
        TestDynamicTableFactory.DynamicTableSourceMock dynamicTableSource = (TestDynamicTableFactory.DynamicTableSourceMock)actual.getScanTableSource(plannerMocks.getPlannerContext().getFlinkContext(), serdeCtx.getTypeFactory());
        Assertions.assertThat((String)dynamicTableSource.password).isEqualTo("xyz");
        Assertions.assertThat((String)((TestFormatFactory.DecodingFormatMock)dynamicTableSource.valueFormat).delimiter).isEqualTo(",");
    }

    static ResolvedCatalogTable tableWithOnlyPhysicalColumns(Map<String, String> options) {
        ResolvedSchema resolvedSchema = new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"c", (DataType)DataTypes.BOOLEAN())), Collections.emptyList(), null);
        return new ResolvedCatalogTable(CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).options(options).build(), resolvedSchema);
    }
}

