/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.functions.utils.AggSqlFunction;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.utils.Top3;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
public class AggregateCallSerdeTest {
    private static final FlinkTypeFactory FACTORY = new FlinkTypeFactory(AggregateCallSerdeTest.class.getClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);

    @MethodSource(value={"aggregateCallSpecs"})
    @ParameterizedTest
    void testAggregateCallSerde(AggregateCall aggCall) throws IOException {
        JsonSerdeTestUtil.testJsonRoundTrip(aggCall, AggregateCall.class);
    }

    @Test
    void testUnsupportedLegacyAggFunc() {
        Assertions.assertThatThrownBy(() -> JsonSerdeTestUtil.testJsonRoundTrip(AggregateCallSerdeTest.getLegacyAggCall(), AggregateCall.class)).hasRootCauseInstanceOf(TableException.class).hasRootCauseMessage("Functions of the deprecated function stack are not supported. Please update 'top3' to the new interfaces.");
    }

    public static Stream<Arguments> aggregateCallSpecs() {
        return Stream.of(Arguments.of((Object[])new Object[]{AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.RANK, (boolean)false, (boolean)false, (boolean)false, (List)ImmutableList.of(), (int)-1, null, (RelCollation)RelCollations.EMPTY, (RelDataType)AggregateCallSerdeTest.fromLogicalType((LogicalType)new BigIntType(false)), (String)"rk")}), Arguments.of((Object[])new Object[]{AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.MAX, (boolean)false, (boolean)false, (boolean)false, (List)ImmutableList.of((Object)3), (int)-1, null, (RelCollation)RelCollations.EMPTY, (RelDataType)AggregateCallSerdeTest.fromLogicalType((LogicalType)new DoubleType(false)), (String)"max_d")}), Arguments.of((Object[])new Object[]{AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.COUNT, (boolean)false, (boolean)false, (boolean)false, (List)ImmutableList.of(), (int)-1, null, (RelCollation)RelCollations.EMPTY, (RelDataType)AggregateCallSerdeTest.fromLogicalType((LogicalType)new BigIntType(false)), null)}));
    }

    private static RelDataType fromLogicalType(LogicalType type) {
        return FACTORY.createFieldTypeFromLogicalType(type);
    }

    private static AggregateCall getLegacyAggCall() {
        Top3 top3 = new Top3();
        DataType externalResultType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction((ImperativeAggregateFunction)top3));
        DataType externalAccType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction((ImperativeAggregateFunction)top3));
        AggSqlFunction aggFunction = AggSqlFunction.apply((FunctionIdentifier)FunctionIdentifier.of((String)"top3"), (String)"top3", (ImperativeAggregateFunction)top3, (DataType)externalResultType, (DataType)externalAccType, (FlinkTypeFactory)FACTORY, (boolean)false);
        return AggregateCall.create((SqlAggFunction)aggFunction, (boolean)false, (boolean)false, (boolean)false, (List)ImmutableList.of((Object)3), (int)-1, null, (RelCollation)RelCollations.of((RelFieldCollation[])new RelFieldCollation[0]), (RelDataType)FACTORY.builder().add("f0", (RelDataType)new BasicSqlType(FACTORY.getTypeSystem(), SqlTypeName.INTEGER)).add("f1", (RelDataType)new BasicSqlType(FACTORY.getTypeSystem(), SqlTypeName.INTEGER)).build(), (String)"top3");
    }
}

