/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.processor.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.TestingBatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.processor.utils.InputOrderCalculator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InputOrderCalculatorTest {
    InputOrderCalculatorTest() {
    }

    @Test
    void testCheckPipelinedPath() {
        TestingBatchExecNode[] nodes = new TestingBatchExecNode[7];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new TestingBatchExecNode("TestingBatchExecNode" + i);
        }
        nodes[1].addInput((ExecNode<?>)nodes[0]);
        nodes[3].addInput((ExecNode<?>)nodes[1]);
        nodes[3].addInput((ExecNode<?>)nodes[2], InputProperty.builder().damBehavior(InputProperty.DamBehavior.END_INPUT).build());
        nodes[3].addInput((ExecNode<?>)nodes[6], InputProperty.builder().damBehavior(InputProperty.DamBehavior.BLOCKING).build());
        nodes[4].addInput((ExecNode<?>)nodes[1], InputProperty.builder().damBehavior(InputProperty.DamBehavior.END_INPUT).build());
        nodes[4].addInput((ExecNode<?>)nodes[3]);
        nodes[6].addInput((ExecNode<?>)nodes[5]);
        Assertions.assertThat((boolean)InputOrderCalculator.checkPipelinedPath((ExecNode)nodes[4], new HashSet<TestingBatchExecNode>(Arrays.asList(nodes[2], nodes[5], nodes[6])))).isFalse();
        Assertions.assertThat((boolean)InputOrderCalculator.checkPipelinedPath((ExecNode)nodes[4], new HashSet<TestingBatchExecNode>(Arrays.asList(nodes[0], nodes[2])))).isTrue();
    }

    @Test
    void testCalculateInputOrder() {
        TestingBatchExecNode[] nodes = new TestingBatchExecNode[9];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new TestingBatchExecNode("TestingBatchExecNode" + i);
        }
        nodes[3].addInput((ExecNode<?>)nodes[0], InputProperty.builder().priority(1).build());
        nodes[4].addInput((ExecNode<?>)nodes[1], InputProperty.builder().priority(1).build());
        nodes[5].addInput((ExecNode<?>)nodes[2], InputProperty.builder().priority(1).build());
        nodes[6].addInput((ExecNode<?>)nodes[3], InputProperty.builder().damBehavior(InputProperty.DamBehavior.BLOCKING).priority(0).build());
        nodes[6].addInput((ExecNode<?>)nodes[4], InputProperty.builder().priority(1).build());
        nodes[7].addInput((ExecNode<?>)nodes[4], InputProperty.builder().damBehavior(InputProperty.DamBehavior.BLOCKING).priority(0).build());
        nodes[7].addInput((ExecNode<?>)nodes[5], InputProperty.builder().priority(1).build());
        nodes[8].addInput((ExecNode<?>)nodes[6], InputProperty.builder().damBehavior(InputProperty.DamBehavior.BLOCKING).priority(0).build());
        nodes[8].addInput((ExecNode<?>)nodes[7], InputProperty.builder().priority(1).build());
        InputOrderCalculator calculator = new InputOrderCalculator((ExecNode)nodes[8], new HashSet<TestingBatchExecNode>(Arrays.asList(nodes[1], nodes[3], nodes[5])), InputProperty.DamBehavior.BLOCKING);
        Map result = calculator.calculate();
        Assertions.assertThat((Map)result).hasSize(3);
        Assertions.assertThat((int)((Integer)result.get(nodes[3]))).isEqualTo(0);
        Assertions.assertThat((int)((Integer)result.get(nodes[1]))).isEqualTo(1);
        Assertions.assertThat((int)((Integer)result.get(nodes[5]))).isEqualTo(2);
    }

    @Test
    void testCalculateInputOrderWithRelatedBoundaries() {
        TestingBatchExecNode[] nodes = new TestingBatchExecNode[7];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new TestingBatchExecNode("TestingBatchExecNode" + i);
        }
        nodes[1].addInput((ExecNode<?>)nodes[0]);
        nodes[2].addInput((ExecNode<?>)nodes[1], InputProperty.builder().damBehavior(InputProperty.DamBehavior.BLOCKING).build());
        nodes[2].addInput((ExecNode<?>)nodes[3], InputProperty.builder().priority(1).build());
        nodes[4].addInput((ExecNode<?>)nodes[0]);
        nodes[4].addInput((ExecNode<?>)nodes[2]);
        nodes[5].addInput((ExecNode<?>)nodes[4], InputProperty.builder().priority(1).build());
        nodes[5].addInput((ExecNode<?>)nodes[6], InputProperty.builder().damBehavior(InputProperty.DamBehavior.BLOCKING).build());
        InputOrderCalculator calculator = new InputOrderCalculator((ExecNode)nodes[5], new HashSet<TestingBatchExecNode>(Arrays.asList(nodes[0], nodes[1], nodes[3], nodes[6])), InputProperty.DamBehavior.BLOCKING);
        Map result = calculator.calculate();
        Assertions.assertThat((Map)result).hasSize(4);
        Assertions.assertThat((int)((Integer)result.get(nodes[0]))).isEqualTo(1);
        Assertions.assertThat((int)((Integer)result.get(nodes[1]))).isEqualTo(1);
        Assertions.assertThat((int)((Integer)result.get(nodes[3]))).isEqualTo(2);
        Assertions.assertThat((int)((Integer)result.get(nodes[6]))).isEqualTo(0);
    }

    @Test
    void testCalculateInputOrderWithUnaffectedRelatedBoundaries() {
        TestingBatchExecNode[] nodes = new TestingBatchExecNode[8];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new TestingBatchExecNode("TestingBatchExecNode" + i);
        }
        nodes[1].addInput((ExecNode<?>)nodes[0]);
        nodes[2].addInput((ExecNode<?>)nodes[1], InputProperty.builder().damBehavior(InputProperty.DamBehavior.BLOCKING).build());
        nodes[2].addInput((ExecNode<?>)nodes[3], InputProperty.builder().priority(1).build());
        nodes[3].addInput((ExecNode<?>)nodes[1], InputProperty.builder().damBehavior(InputProperty.DamBehavior.BLOCKING).build());
        nodes[4].addInput((ExecNode<?>)nodes[2]);
        nodes[4].addInput((ExecNode<?>)nodes[6]);
        nodes[5].addInput((ExecNode<?>)nodes[0], InputProperty.builder().damBehavior(InputProperty.DamBehavior.BLOCKING).build());
        nodes[6].addInput((ExecNode<?>)nodes[5], InputProperty.builder().priority(1).build());
        nodes[6].addInput((ExecNode<?>)nodes[7], InputProperty.builder().damBehavior(InputProperty.DamBehavior.BLOCKING).build());
        InputOrderCalculator calculator = new InputOrderCalculator((ExecNode)nodes[4], new HashSet<TestingBatchExecNode>(Arrays.asList(nodes[1], nodes[3], nodes[5], nodes[7])), InputProperty.DamBehavior.BLOCKING);
        Map result = calculator.calculate();
        Assertions.assertThat((Map)result).hasSize(4);
        Assertions.assertThat((int)((Integer)result.get(nodes[1]))).isEqualTo(0);
        Assertions.assertThat((int)((Integer)result.get(nodes[3]))).isEqualTo(1);
        Assertions.assertThat((int)((Integer)result.get(nodes[5]))).isEqualTo(1);
        Assertions.assertThat((int)((Integer)result.get(nodes[7]))).isEqualTo(0);
    }

    @Test
    void testCalculateInputOrderWithLoop() {
        TestingBatchExecNode a = new TestingBatchExecNode("TestingBatchExecNode0");
        TestingBatchExecNode b = new TestingBatchExecNode("TestingBatchExecNode1");
        for (int i = 0; i < 2; ++i) {
            b.addInput((ExecNode<?>)a, InputProperty.builder().priority(i).build());
        }
        InputOrderCalculator calculator = new InputOrderCalculator((ExecNode)b, Collections.emptySet(), InputProperty.DamBehavior.BLOCKING);
        Assertions.assertThatThrownBy(() -> ((InputOrderCalculator)calculator).calculate()).isInstanceOf(IllegalStateException.class);
    }
}

