/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.calcite;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalExpand;
import org.apache.flink.table.planner.plan.nodes.calcite.RelNodeTestBase;
import org.apache.flink.table.types.logical.LogicalType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}3AAC\u0006\u00019!)\u0011\u0005\u0001C\u0001E!9A\u0005\u0001b\u0001\n\u0013)\u0003B\u0002\u001b\u0001A\u0003%a\u0005C\u00046\u0001\t\u0007I\u0011\u0002\u001c\t\r\u0001\u0003\u0001\u0015!\u00038\u0011!\t\u0005\u0001#b\u0001\n\u0013\u0011\u0005\"B&\u0001\t\u0003a\u0005\"B.\u0001\t\u0003a\u0005\"B/\u0001\t\u0003a%AC#ya\u0006tG\rV3ti*\u0011A\"D\u0001\bG\u0006d7-\u001b;f\u0015\tqq\"A\u0003o_\u0012,7O\u0003\u0002\u0011#\u0005!\u0001\u000f\\1o\u0015\t\u00112#A\u0004qY\u0006tg.\u001a:\u000b\u0005Q)\u0012!\u0002;bE2,'B\u0001\f\u0018\u0003\u00151G.\u001b8l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\b\t\u0003=}i\u0011aC\u0005\u0003A-\u0011qBU3m\u001d>$W\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"A\b\u0001\u0002\u0015\u0019LW\r\u001c3OC6,7/F\u0001'!\r9#\u0006L\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t)\u0011I\u001d:bsB\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0005Y\u0006twMC\u00012\u0003\u0011Q\u0017M^1\n\u0005Mr#AB*ue&tw-A\u0006gS\u0016dGMT1nKN\u0004\u0013A\u00034jK2$G+\u001f9fgV\tq\u0007E\u0002(Ua\u0002\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\u000f1|w-[2bY*\u0011QhE\u0001\u0006if\u0004Xm]\u0005\u0003\u007fi\u00121\u0002T8hS\u000e\fG\u000eV=qK\u0006Ya-[3mIRK\b/Z:!\u0003AawnZ5dC2$\u0016M\u00197f'\u000e\fg.F\u0001D!\t!\u0015*D\u0001F\u0015\tYdI\u0003\u0002H\u0011\u0006\u0019!/\u001a7\u000b\u000519\u0012B\u0001&F\u0005AaunZ5dC2$\u0016M\u00197f'\u000e\fg.\u0001\u0019uKN$XK\\:vaB|'\u000f^3e\u000bb\u0004\u0018M\u001c3Qe>TWm\u0019;t/&$\b\u000eR5gM\u0016\u0014XM\u001c;MK:<G\u000f\u001b\u000b\u0002\u001bB\u0011qET\u0005\u0003\u001f\"\u0012A!\u00168ji\"\u0012q!\u0015\t\u0003%fk\u0011a\u0015\u0006\u0003)V\u000b1!\u00199j\u0015\t1v+A\u0004kkBLG/\u001a:\u000b\u0005aK\u0012!\u00026v]&$\u0018B\u0001.T\u0005\u0011!Vm\u001d;\u0002QQ,7\u000f^+ogV\u0004\bo\u001c:uK\u0012,\u0005\u0010]1oIB\u0013xN[3diN<\u0016\u000e\u001e5SKb\u001c\u0015\r\u001c7)\u0005!\t\u0016A\f;fgR,fn];qa>\u0014H/\u001a3FqB\fg\u000e\u001a)s_*,7\r^:XSRDgj\\\"p[6|g\u000eV=qKND#!C)")
public class ExpandTest
extends RelNodeTestBase {
    private LogicalTableScan logicalTableScan;
    private String[] fieldNames = (String[])((Object[])new String[]{"string", "double", "long"});
    private LogicalType[] fieldTypes = (LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.BIGINT().getLogicalType()});
    private volatile boolean bitmap$0;

    private String[] fieldNames() {
        return this.fieldNames;
    }

    private LogicalType[] fieldTypes() {
        return this.fieldTypes;
    }

    private LogicalTableScan logicalTableScan$lzycompute() {
        ExpandTest expandTest = this;
        synchronized (expandTest) {
            if (!this.bitmap$0) {
                this.logicalTableScan = this.buildLogicalTableScan(this.fieldNames(), this.fieldTypes());
                this.bitmap$0 = true;
            }
        }
        this.fieldNames = null;
        this.fieldTypes = null;
        return this.logicalTableScan;
    }

    private LogicalTableScan logicalTableScan() {
        if (!this.bitmap$0) {
            return this.logicalTableScan$lzycompute();
        }
        return this.logicalTableScan;
    }

    @Test
    public void testUnsupportedExpandProjectsWithDifferentLength() {
        List inputFields = this.logicalTableScan().getRowType().getFieldList();
        ArrayList expandProjects = new ArrayList();
        RexBuilder rexBuilder = this.logicalTableScan().getCluster().getRexBuilder();
        ArrayList<Object> project = new ArrayList<Object>();
        project.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(1)).getType(), 1));
        project.add(rexBuilder.makeNullLiteral(((RelDataTypeField)inputFields.get(2)).getType()));
        expandProjects.add(project);
        ArrayList<Object> project2 = new ArrayList<Object>();
        project2.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project2.add(rexBuilder.makeBigintLiteral(new BigDecimal(1)));
        expandProjects.add(project2);
        Assertions.assertThatThrownBy(() -> new LogicalExpand(this.cluster(), this.logicalTableScan().getTraitSet(), (RelNode)this.logicalTableScan(), expandProjects, 2)).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testUnsupportedExpandProjectsWithRexCall() {
        List inputFields = this.logicalTableScan().getRowType().getFieldList();
        ArrayList expandProjects = new ArrayList();
        RexBuilder rexBuilder = this.logicalTableScan().getCluster().getRexBuilder();
        ArrayList<Object> project = new ArrayList<Object>();
        project.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(1)).getType(), 1));
        project.add(rexBuilder.makeNullLiteral(((RelDataTypeField)inputFields.get(2)).getType()));
        expandProjects.add(project);
        ArrayList<Object> project2 = new ArrayList<Object>();
        project2.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project2.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{new RexInputRef(0, this.logicalTableScan().getRowType()), new RexInputRef(1, this.logicalTableScan().getRowType())}));
        project2.add(rexBuilder.makeBigintLiteral(new BigDecimal(1)));
        expandProjects.add(project2);
        Assertions.assertThatThrownBy(() -> new LogicalExpand(this.cluster(), this.logicalTableScan().getTraitSet(), (RelNode)this.logicalTableScan(), expandProjects, 2)).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testUnsupportedExpandProjectsWithNoCommonTypes() {
        List inputFields = this.logicalTableScan().getRowType().getFieldList();
        ArrayList expandProjects = new ArrayList();
        RexBuilder rexBuilder = this.logicalTableScan().getCluster().getRexBuilder();
        ArrayList<Object> project = new ArrayList<Object>();
        project.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project.add(rexBuilder.makeBinaryLiteral(ByteString.of((String)"10001", (int)2)));
        project.add(rexBuilder.makeNullLiteral(((RelDataTypeField)inputFields.get(2)).getType()));
        expandProjects.add(project);
        ArrayList<Object> project2 = new ArrayList<Object>();
        project2.add(rexBuilder.makeInputRef(((RelDataTypeField)inputFields.get(0)).getType(), 0));
        project2.add(rexBuilder.makeTimestampLiteral(new TimestampString("2021-03-23 23:11:17.123"), 3));
        project2.add(rexBuilder.makeBigintLiteral(new BigDecimal(1)));
        expandProjects.add(project2);
        Assertions.assertThatThrownBy(() -> new LogicalExpand(this.cluster(), this.logicalTableScan().getTraitSet(), (RelNode)this.logicalTableScan(), expandProjects, 2)).isInstanceOf(AssertionError.class);
    }
}

