/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.metadata.MockMetaTable;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimator;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimatorTest$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001da\u0001B.]\u0001-DQA\u001d\u0001\u0005\u0002MDqA\u001e\u0001C\u0002\u0013%q\u000fC\u0004\u0002\u000e\u0001\u0001\u000b\u0011\u0002=\t\u0013\u0005=\u0001A1A\u0005\n\u0005E\u0001\u0002CA\u0015\u0001\u0001\u0006I!a\u0005\t\u0019\u0005-\u0002\u0001%A\u0001\u0004\u0003\u0006I!!\f\t\u0013\u0005e\u0002A1A\u0005\u0002\u0005m\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\r\t\u0013\u0005}\u0002A1A\u0005\u0002\u0005m\u0002\u0002CA!\u0001\u0001\u0006I!a\r\t\u0013\u0005\r\u0003A1A\u0005\u0002\u0005m\u0002\u0002CA#\u0001\u0001\u0006I!a\r\t\u0013\u0005\u001d\u0003A1A\u0005\u0002\u0005m\u0002\u0002CA%\u0001\u0001\u0006I!a\r\t\u0013\u0005-\u0003A1A\u0005\u0002\u0005m\u0002\u0002CA'\u0001\u0001\u0006I!a\r\t\u0013\u0005=\u0003A1A\u0005\u0002\u0005m\u0002\u0002CA)\u0001\u0001\u0006I!a\r\t\u0013\u0005M\u0003A1A\u0005\u0002\u0005m\u0002\u0002CA+\u0001\u0001\u0006I!a\r\t\u0013\u0005]\u0003A1A\u0005\u0002\u0005m\u0002\u0002CA-\u0001\u0001\u0006I!a\r\t\u0013\u0005m\u0003A1A\u0005\u0002\u0005u\u0003\u0002CA5\u0001\u0001\u0006I!a\u0018\t\u0013\u0005-\u0004\u00011A\u0005\u0002\u00055\u0004\"CA;\u0001\u0001\u0007I\u0011AA<\u0011!\t\t\t\u0001Q!\n\u0005=\u0004\"CAB\u0001\t\u0007I\u0011AAC\u0011!\t)\n\u0001Q\u0001\n\u0005\u001d\u0005\"CAL\u0001\t\u0007I\u0011AAM\u0011!\t\t\u000b\u0001Q\u0001\n\u0005m\u0005bCAR\u0001\u0001\u0007\t\u0019!C\u0001\u0003KC1\"a-\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00026\"Y\u0011\u0011\u0018\u0001A\u0002\u0003\u0005\u000b\u0015BAT\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!!6\u0001\t\u0013\t9\u000eC\u0005\u0002j\u0002\t\n\u0011\"\u0003\u0002l\"9!\u0011\u0001\u0001\u0005\n\t\r\u0001b\u0002B\u0001\u0001\u0011%!1\u0004\u0005\b\u0005K\u0001A\u0011\u0002B\u0014\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqAa\u0014\u0001\t\u0013\u0011\t\u0006C\u0004\u0003V\u0001!IAa\u0016\t\u000f\tm\u0003\u0001\"\u0003\u0003^!9!1\r\u0001\u0005\n\t\u0015\u0004b\u0002B9\u0001\u0011%!1\u000f\u0005\b\u0005w\u0002A\u0011\u0002B?\u0011\u001d\u0011Y\n\u0001C\u0005\u0005;CqAa)\u0001\t\u0013\u0011)\u000bC\u0005\u00040\u0001\t\n\u0011\"\u0003\u00042!I1Q\u0007\u0001\u0012\u0002\u0013%1\u0011\u0007\u0005\n\u0007o\u0001\u0011\u0013!C\u0005\u0007sA\u0011b!\u0010\u0001#\u0003%Iaa\u0010\t\u0013\r\r\u0003!%A\u0005\n\r\u0015\u0003\"CB*\u0001E\u0005I\u0011BB+\u0011\u001d\u0019\u0019\u0007\u0001C\u0005\u0007KB\u0011ba\u001e\u0001#\u0003%Ia!\r\t\u0013\re\u0004!%A\u0005\n\rm\u0004bBB@\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0007\u0013\u0003A\u0011AA_\u0011\u001d\u0019i\t\u0001C\u0001\u0003{Cqa!%\u0001\t\u0003\ti\fC\u0004\u0004\u0016\u0002!\t!!0\t\u000f\re\u0005\u0001\"\u0001\u0002>\"91Q\u0014\u0001\u0005\u0002\u0005u\u0006bBBQ\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0007K\u0003A\u0011AA_\u0011\u001d\u0019I\u000b\u0001C\u0001\u0003{Cqa!,\u0001\t\u0003\ti\fC\u0004\u00042\u0002!\t!!0\t\u000f\rU\u0006\u0001\"\u0001\u0002>\"91\u0011\u0018\u0001\u0005\u0002\u0005u\u0006bBB_\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0007\u0003\u0004A\u0011AA_\u0011\u001d\u0019)\r\u0001C\u0001\u0003{Cqa!3\u0001\t\u0003\ti\fC\u0004\u0004N\u0002!\t!!0\t\u000f\rE\u0007\u0001\"\u0001\u0002>\"91Q\u001b\u0001\u0005\u0002\u0005u\u0006bBBm\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0007;\u0004A\u0011AA_\u0011\u001d\u0019\t\u000f\u0001C\u0001\u0003{Cqa!:\u0001\t\u0003\ti\fC\u0004\u0004j\u0002!\t!!0\t\u000f\r5\b\u0001\"\u0001\u0002>\"91\u0011\u001f\u0001\u0005\u0002\u0005uvaBB{9\"\u00051q\u001f\u0004\u00077rC\ta!?\t\rIDF\u0011AB~\u0011\u001d\u0019i\u0010\u0017C\u0001\u0003{\u0013\u0001dU3mK\u000e$\u0018N^5us\u0016\u001bH/[7bi>\u0014H+Z:u\u0015\tif,\u0001\u0005nKR\fG-\u0019;b\u0015\ty\u0006-\u0001\u0003qY\u0006t'BA1c\u0003\u001d\u0001H.\u00198oKJT!a\u00193\u0002\u000bQ\f'\r\\3\u000b\u0005\u00154\u0017!\u00024mS:\\'BA4i\u0003\u0019\t\u0007/Y2iK*\t\u0011.A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001YB\u0011Q\u000e]\u0007\u0002]*\tq.A\u0003tG\u0006d\u0017-\u0003\u0002r]\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001;\u0011\u0005U\u0004Q\"\u0001/\u0002\u001b\u0005dGNR5fY\u0012t\u0015-\\3t+\u0005A\bcA=}}6\t!P\u0003\u0002|]\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uT(aA*fcB\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tA\u0001\\1oO*\u0011\u0011qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005\u0005!AB*ue&tw-\u0001\bbY24\u0015.\u001a7e\u001d\u0006lWm\u001d\u0011\u0002\u001b\u0005dGNR5fY\u0012$\u0016\u0010]3t+\t\t\u0019\u0002\u0005\u0003zy\u0006U\u0001\u0003BA\f\u0003Ki!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0005if\u0004XM\u0003\u0003\u0002 \u0005\u0005\u0012aA:rY*\u0019\u00111\u00054\u0002\u000f\r\fGnY5uK&!\u0011qEA\r\u0005-\u0019\u0016\u000f\u001c+za\u0016t\u0015-\\3\u0002\u001d\u0005dGNR5fY\u0012$\u0016\u0010]3tA\u0005\u0019\u0001\u0010J\u0019\u0011'5\fy#a\r\u00024\u0005M\u00121GA\u001a\u0003g\t\u0019$a\r\n\u0007\u0005EbN\u0001\u0004UkBdW\r\u000f\t\u0004[\u0006U\u0012bAA\u001c]\n\u0019\u0011J\u001c;\u0002\u00119\fW.Z0jIb,\"!a\r\u0002\u00139\fW.Z0jIb\u0004\u0013AC1n_VtGoX5eq\u0006Y\u0011-\\8v]R|\u0016\u000e\u001a=!\u0003%\u0001(/[2f?&$\u00070\u0001\u0006qe&\u001cWmX5eq\u0002\n\u0001B\u001a7bO~KG\r_\u0001\nM2\fwmX5eq\u0002\nQ\u0002]1si&$\u0018n\u001c8`S\u0012D\u0018A\u00049beRLG/[8o?&$\u0007\u0010I\u0001\tI\u0006$XmX5eq\u0006IA-\u0019;f?&$\u0007\u0010I\u0001\ti&lWmX5eq\u0006IA/[7f?&$\u0007\u0010I\u0001\u000ei&lWm\u001d;b[B|\u0016\u000e\u001a=\u0002\u001dQLW.Z:uC6\u0004x,\u001b3yA\u0005YA/\u001f9f\r\u0006\u001cGo\u001c:z+\t\ty\u0006\u0005\u0003\u0002b\u0005\u0015TBAA2\u0015\r\t\u0019\u0003Y\u0005\u0005\u0003O\n\u0019G\u0001\tGY&t7\u000eV=qK\u001a\u000b7\r^8ss\u0006aA/\u001f9f\r\u0006\u001cGo\u001c:zA\u0005Q!/\u001a=Ck&dG-\u001a:\u0016\u0005\u0005=\u0004\u0003BA1\u0003cJA!a\u001d\u0002d\tya\t\\5oWJ+\u0007PQ;jY\u0012,'/\u0001\bsKb\u0014U/\u001b7eKJ|F%Z9\u0015\t\u0005e\u0014q\u0010\t\u0004[\u0006m\u0014bAA?]\n!QK\\5u\u0011%\tYCGA\u0001\u0002\u0004\ty'A\u0006sKb\u0014U/\u001b7eKJ\u0004\u0013a\u0003:fY\u0012\u000bG/\u0019+za\u0016,\"!a\"\u0011\t\u0005%\u0015\u0011S\u0007\u0003\u0003\u0017SA!a\u0007\u0002\u000e*!\u0011qRA\u0011\u0003\r\u0011X\r\\\u0005\u0005\u0003'\u000bYIA\u0006SK2$\u0015\r^1UsB,\u0017\u0001\u0004:fY\u0012\u000bG/\u0019+za\u0016\u0004\u0013AA7r+\t\tY\nE\u0002v\u0003;K1!a(]\u0005U1E.\u001b8l%\u0016dW*\u001a;bI\u0006$\u0018-U;fef\f1!\\9!\u0003\u0011\u00198-\u00198\u0016\u0005\u0005\u001d\u0006\u0003BAU\u0003_k!!a+\u000b\t\u00055\u0016QR\u0001\u0005G>\u0014X-\u0003\u0003\u00022\u0006-&!\u0003+bE2,7kY1o\u0003!\u00198-\u00198`I\u0015\fH\u0003BA=\u0003oC\u0011\"a\u000b\"\u0003\u0003\u0005\r!a*\u0002\u000bM\u001c\u0017M\u001c\u0011\u0002\u000bM,G/\u001e9\u0015\u0005\u0005e\u0004fA\u0012\u0002BB!\u00111YAi\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017aA1qS*!\u00111ZAg\u0003\u001dQW\u000f]5uKJT1!a4i\u0003\u0015QWO\\5u\u0013\u0011\t\u0019.!2\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005n_\u000e\\7kY1o)\u0011\t9+!7\t\u0013\u0005mG\u0005%AA\u0002\u0005u\u0017!C:uCRL7\u000f^5d!\u0011\ty.!:\u000e\u0005\u0005\u0005(bAAr=\u0006)1\u000f^1ug&!\u0011q]Aq\u000591E.\u001b8l'R\fG/[:uS\u000e\f!#\\8dWN\u001b\u0017M\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u001e\u0016\u0005\u0003;\fyo\u000b\u0002\u0002rB!\u00111_A\u007f\u001b\t\t)P\u0003\u0003\u0002x\u0006e\u0018!C;oG\",7m[3e\u0015\r\tYP\\\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0000\u0003k\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Q\u0019'/Z1uK:+X.\u001a:jG2KG/\u001a:bYR!!Q\u0001B\t!\u0011\u00119A!\u0004\u000e\u0005\t%!\u0002\u0002B\u0006\u0003C\t1A]3y\u0013\u0011\u0011yA!\u0003\u0003\u0015I+\u0007\u0010T5uKJ\fG\u000eC\u0004\u0003\u0014\u0019\u0002\rA!\u0006\u0002\u00079,X\u000eE\u0002n\u0005/I1A!\u0007o\u0005\u0011auN\\4\u0015\t\t\u0015!Q\u0004\u0005\b\u0005'9\u0003\u0019\u0001B\u0010!\ri'\u0011E\u0005\u0004\u0005Gq'A\u0002#pk\ndW-\u0001\u000bde\u0016\fG/\u001a\"p_2,\u0017M\u001c'ji\u0016\u0014\u0018\r\u001c\u000b\u0005\u0005\u000b\u0011I\u0003C\u0004\u0003,!\u0002\rA!\f\u0002\u0003\t\u00042!\u001cB\u0018\u0013\r\u0011\tD\u001c\u0002\b\u0005>|G.Z1o\u0003M\u0019'/Z1uKN#(/\u001b8h\u0019&$XM]1m)\u0011\u0011)Aa\u000e\t\u000f\te\u0012\u00061\u0001\u0003<\u0005\u00191\u000f\u001e:\u0011\t\tu\"1\n\b\u0005\u0005\u007f\u00119\u0005E\u0002\u0003B9l!Aa\u0011\u000b\u0007\t\u0015#.\u0001\u0004=e>|GOP\u0005\u0004\u0005\u0013r\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\t5#b\u0001B%]\u0006\t2M]3bi\u0016$\u0015\r^3MSR,'/\u00197\u0015\t\t\u0015!1\u000b\u0005\b\u0005sQ\u0003\u0019\u0001B\u001e\u0003E\u0019'/Z1uKRKW.\u001a'ji\u0016\u0014\u0018\r\u001c\u000b\u0005\u0005\u000b\u0011I\u0006C\u0004\u0003:-\u0002\rAa\u000f\u0002-\r\u0014X-\u0019;f)&lWm\u0015;b[Bd\u0015\u000e^3sC2$BA!\u0002\u0003`!9!\u0011\r\u0017A\u0002\tU\u0011AB7jY2L7/\u0001\bde\u0016\fG/Z%oaV$(+\u001a4\u0015\t\t\u001d$Q\u000e\t\u0005\u0005\u000f\u0011I'\u0003\u0003\u0003l\t%!a\u0003*fq&s\u0007/\u001e;SK\u001aDqAa\u001c.\u0001\u0004\t\u0019$A\u0003j]\u0012,\u00070A\u000fde\u0016\fG/Z%oaV$(+\u001a4XSRDg*\u001e7mC\nLG.\u001b;z)\u0019\u00119G!\u001e\u0003x!9!q\u000e\u0018A\u0002\u0005M\u0002b\u0002B=]\u0001\u0007!QF\u0001\u000bSNtU\u000f\u001c7bE2,\u0017AC2sK\u0006$XmQ1mYR1!q\u0010BC\u0005#\u0003BAa\u0002\u0003\u0002&!!1\u0011B\u0005\u0005\u001d\u0011V\r\u001f(pI\u0016DqAa\"0\u0001\u0004\u0011I)\u0001\u0005pa\u0016\u0014\u0018\r^8s!\u0011\u0011YI!$\u000e\u0005\u0005u\u0011\u0002\u0002BH\u0003;\u00111bU9m\u001fB,'/\u0019;pe\"9!1S\u0018A\u0002\tU\u0015!B3yaJ\u001c\b#B7\u0003\u0018\n}\u0014b\u0001BM]\nQAH]3qK\u0006$X\r\u001a \u0002\u0015\r\u0014X-\u0019;f\u0007\u0006\u001cH\u000f\u0006\u0003\u0003\u0000\t}\u0005b\u0002BQa\u0001\u0007!qP\u0001\u0005Kb\u0004(/A\tde\u0016\fG/Z\"pYVlgn\u0015;biN$bBa*\u00034\n}'1\u001dBx\u0005w\u001cy\u0002\u0005\u0003\u0003*\n=VB\u0001BV\u0015\u0011\t\u0019O!,\u000b\u0005}\u0013\u0017\u0002\u0002BY\u0005W\u00131bQ8mk6t7\u000b^1ug\"I!QW\u0019\u0011\u0002\u0003\u0007!qW\u0001\u0004]\u00124\b#B7\u0003:\nu\u0016b\u0001B^]\n1q\n\u001d;j_:\u0004BAa0\u0003Z:!!\u0011\u0019Bk\u001d\u0011\u0011\u0019Ma5\u000f\t\t\u0015'\u0011\u001b\b\u0005\u0005\u000f\u0014yM\u0004\u0003\u0003J\n5g\u0002\u0002B!\u0005\u0017L\u0011![\u0005\u0003O\"L!!\u001a4\n\u0005\r$\u0017BA1c\u0013\r\u00119\u000eY\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YN!8\u0003\u000b)cuN\\4\u000b\u0007\t]\u0007\rC\u0005\u0003bF\u0002\n\u00111\u0001\u00038\u0006Ia.\u001e7m\u0007>,h\u000e\u001e\u0005\n\u0005K\f\u0004\u0013!a\u0001\u0005O\fa!\u0019<h\u0019\u0016t\u0007#B7\u0003:\n%\b\u0003\u0002B`\u0005WLAA!<\u0003^\n9!\nR8vE2,\u0007\"\u0003BycA\u0005\t\u0019\u0001Bz\u0003\u0019i\u0017\r\u001f'f]B)QN!/\u0003vB\u0019qPa>\n\t\te\u0018\u0011\u0001\u0002\b\u0013:$XmZ3s\u0011%\u0011i0\rI\u0001\u0002\u0004\u0011y0A\u0002nS:\u0004R!\u001cB]\u0007\u0003\u0001Daa\u0001\u0004\u000eA)qp!\u0002\u0004\n%!1qAA\u0001\u0005)\u0019u.\u001c9be\u0006\u0014G.\u001a\t\u0005\u0007\u0017\u0019i\u0001\u0004\u0001\u0005\u0019\r=!1`A\u0001\u0002\u0003\u0015\ta!\u0005\u0003\u0007}#\u0013'\u0005\u0003\u0004\u0014\re\u0001cA7\u0004\u0016%\u00191q\u00038\u0003\u000f9{G\u000f[5oOB\u0019Qna\u0007\n\u0007\ruaNA\u0002B]fD\u0011b!\t2!\u0003\u0005\raa\t\u0002\u00075\f\u0007\u0010E\u0003n\u0005s\u001b)\u0003\r\u0003\u0004(\r-\u0002#B@\u0004\u0006\r%\u0002\u0003BB\u0006\u0007W!Ab!\f\u0004 \u0005\u0005\t\u0011!B\u0001\u0007#\u00111a\u0018\u00133\u0003m\u0019'/Z1uK\u000e{G.^7o'R\fGo\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u001111\u0007\u0016\u0005\u0005o\u000by/A\u000ede\u0016\fG/Z\"pYVlgn\u0015;biN$C-\u001a4bk2$HEM\u0001\u001cGJ,\u0017\r^3D_2,XN\\*uCR\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\rm\"\u0006\u0002Bt\u0003_\f1d\u0019:fCR,7i\u001c7v[:\u001cF/\u0019;tI\u0011,g-Y;mi\u0012\"TCAB!U\u0011\u0011\u00190a<\u00027\r\u0014X-\u0019;f\u0007>dW/\u001c8Ti\u0006$8\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u00199E\u000b\u0003\u0004J\u0005=\b#B7\u0003:\u000e-\u0003\u0007BB'\u0007#\u0002Ra`B\u0003\u0007\u001f\u0002Baa\u0003\u0004R\u0011Y1q\u0002\u001c\u0002\u0002\u0003\u0005)\u0011AB\t\u0003m\u0019'/Z1uK\u000e{G.^7o'R\fGo\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u00111q\u000b\u0016\u0005\u00073\ny\u000fE\u0003n\u0005s\u001bY\u0006\r\u0003\u0004^\r\u0005\u0004#B@\u0004\u0006\r}\u0003\u0003BB\u0006\u0007C\"1b!\f8\u0003\u0003\u0005\tQ!\u0001\u0004\u0012\u0005!2M]3bi\u00164E.\u001b8l'R\fG/[:uS\u000e$b!!8\u0004h\r-\u0004\"CB5qA\u0005\t\u0019\u0001B\\\u0003!\u0011xn^\"pk:$\b\"CB7qA\u0005\t\u0019AB8\u0003!\u0019w\u000e\\*uCR\u001c\b#B7\u0003:\u000eE\u0004\u0003\u0003B\u001f\u0007g\u0012YDa*\n\t\rU$Q\n\u0002\u0004\u001b\u0006\u0004\u0018AH2sK\u0006$XM\u00127j].\u001cF/\u0019;jgRL7\r\n3fM\u0006,H\u000e\u001e\u00132\u0003y\u0019'/Z1uK\u001ac\u0017N\\6Ti\u0006$\u0018n\u001d;jG\u0012\"WMZ1vYR$#'\u0006\u0002\u0004~)\"1qNAx\u0003\t\"Xm\u001d;FcV\fGn],ji\"d\u0015\u000e^3sC2|eMT;nKJL7\rV=qK\"\u001a1ha!\u0011\t\u0005\r7QQ\u0005\u0005\u0007\u000f\u000b)M\u0001\u0003UKN$\u0018!\t;fgR,\u0015/^1mg^KG\u000f\u001b'ji\u0016\u0014\u0018\r\\(g'R\u0014\u0018N\\4UsB,\u0007f\u0001\u001f\u0004\u0004\u0006\u0011C/Z:u\u000bF,\u0018\r\\:XSRDG*\u001b;fe\u0006dwJ\u001a\"p_2,\u0017M\u001c+za\u0016D3!PBB\u0003}!Xm\u001d;FcV\fGn],ji\"d\u0015\u000e^3sC2|e\rR1uKRK\b/\u001a\u0015\u0004}\r\r\u0015a\b;fgR,\u0015/^1mg^KG\u000f\u001b'ji\u0016\u0014\u0018\r\\(g)&lW\rV=qK\"\u001aqha!\u0002IQ,7\u000f^#rk\u0006d7oV5uQ2KG/\u001a:bY>3G+[7fgR\fW\u000e\u001d+za\u0016D3\u0001QBB\u0003a!Xm\u001d;FcV\fGn],ji\"|W\u000f\u001e'ji\u0016\u0014\u0018\r\u001c\u0015\u0004\u0003\u000e\r\u0015\u0001\u0007;fgRtu\u000e^#rk\u0006d7oV5uQ2KG/\u001a:bY\"\u001a!ia!\u0002KQ,7\u000f^\"p[B\f'/[:p]^KG\u000f\u001b'ji\u0016\u0014\u0018\r\\(g'R\u0014\u0018N\\4UsB,\u0007fA\"\u0004\u0004\u0006QB/Z:u\u000fJ,\u0017\r^3s)\"\fgnV5uQ2KG/\u001a:bY\"\u001aAia!\u0002;Q,7\u000f^$sK\u0006$XM\u001d+iC:<\u0016\u000e\u001e5pkRd\u0015\u000e^3sC2D3!RBB\u0003\u0011\"Xm\u001d;He\u0016\fG/\u001a:UQ\u0006twJ]#rk\u0006d7\u000fV8XSRDG*\u001b;fe\u0006d\u0007f\u0001$\u0004\u0004\u00069C/Z:u\u000fJ,\u0017\r^3s)\"\fgn\u0014:FcV\fGn\u001d+p/&$\bn\\;u\u0019&$XM]1mQ\r951Q\u0001\u0018i\u0016\u001cH\u000fT3tgRC\u0017M\\,ji\"d\u0015\u000e^3sC2D3\u0001SBB\u0003i!Xm\u001d;MKN\u001cH\u000b[1o/&$\bn\\;u\u0019&$XM]1mQ\rI51Q\u0001\"i\u0016\u001cH\u000fT3tgRC\u0017M\\(s\u000bF,\u0018\r\\:U_^KG\u000f\u001b'ji\u0016\u0014\u0018\r\u001c\u0015\u0004\u0015\u000e\r\u0015\u0001\n;fgRdUm]:UQ\u0006twJ]#rk\u0006d7\u000fV8XSRDw.\u001e;MSR,'/\u00197)\u0007-\u001b\u0019)\u0001\u0005uKN$H*[6fQ\ra51Q\u0001\u000bi\u0016\u001cH/S:Ok2d\u0007fA'\u0004\u0004\u0006iA/Z:u\u0013Ntu\u000e\u001e(vY2D3ATBB\u0003\u0019!Xm\u001d;J]\"\u001aqja!\u0002\u000fQ,7\u000f^!oI\"\u001a\u0001ka!\u0002\rQ,7\u000f^(sQ\r\t61Q\u0001\bi\u0016\u001cHOT8uQ\r\u001161Q\u0001\ri\u0016\u001cH/\u00118e\u001fJtu\u000e\u001e\u0015\u0004'\u000e\r\u0015\u0001\u0006;fgR\u0004&/\u001a3jG\u0006$XmV5uQV#g\rK\u0002U\u0007\u0007\u000b1\u0005^3tiN+G.Z2uSZLG/_,ji\"\u001c\u0016-\\3SKbLe\u000e];u%\u001647\u000fK\u0002V\u0007\u0007\u000b\u0001\u0007^3tiN+G.Z2uSZLG/_,ji\"\u001c\u0016-\\3SKbLe\u000e];u%\u001647/\u00118e'R\u0014\u0018N\\4UsB,\u0007f\u0001,\u0004\u0004\u0006A2+\u001a7fGRLg/\u001b;z\u000bN$\u0018.\\1u_J$Vm\u001d;\u0011\u0005UD6C\u0001-m)\t\u001990A\u0005cK\u001a|'/Z!mY\"\u001a!\f\"\u0001\u0011\t\u0005\rG1A\u0005\u0005\t\u000b\t)MA\u0005CK\u001a|'/Z!mY\u0002")
public class SelectivityEstimatorTest {
    private final Seq<String> allFieldNames = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "amount", "price", "flag", "partition", "date_col", "time_col", "timestamp_col"}));
    private final Seq<SqlTypeName> allFieldTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.VARCHAR, SqlTypeName.INTEGER, SqlTypeName.DOUBLE, SqlTypeName.BOOLEAN, SqlTypeName.VARCHAR, SqlTypeName.DATE, SqlTypeName.TIME, SqlTypeName.TIMESTAMP}));
    private final /* synthetic */ Tuple8 x$1;
    private final int name_idx;
    private final int amount_idx;
    private final int price_idx;
    private final int flag_idx;
    private final int partition_idx;
    private final int date_idx;
    private final int time_idx;
    private final int timestamp_idx;
    private final FlinkTypeFactory typeFactory;
    private FlinkRexBuilder rexBuilder;
    private final RelDataType relDataType;
    private final FlinkRelMetadataQuery mq;
    private TableScan scan;

    @BeforeAll
    public static void beforeAll() {
        SelectivityEstimatorTest$.MODULE$.beforeAll();
    }

    private Seq<String> allFieldNames() {
        return this.allFieldNames;
    }

    private Seq<SqlTypeName> allFieldTypes() {
        return this.allFieldTypes;
    }

    public int name_idx() {
        return this.name_idx;
    }

    public int amount_idx() {
        return this.amount_idx;
    }

    public int price_idx() {
        return this.price_idx;
    }

    public int flag_idx() {
        return this.flag_idx;
    }

    public int partition_idx() {
        return this.partition_idx;
    }

    public int date_idx() {
        return this.date_idx;
    }

    public int time_idx() {
        return this.time_idx;
    }

    public int timestamp_idx() {
        return this.timestamp_idx;
    }

    public FlinkTypeFactory typeFactory() {
        return this.typeFactory;
    }

    public FlinkRexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    public void rexBuilder_$eq(FlinkRexBuilder x$1) {
        this.rexBuilder = x$1;
    }

    public RelDataType relDataType() {
        return this.relDataType;
    }

    public FlinkRelMetadataQuery mq() {
        return this.mq;
    }

    public TableScan scan() {
        return this.scan;
    }

    public void scan_$eq(TableScan x$1) {
        this.scan = x$1;
    }

    @BeforeEach
    public void setup() {
        this.scan_$eq(this.mockScan(this.mockScan$default$1()));
    }

    private TableScan mockScan(FlinkStatistic statistic) {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        MockMetaTable table = new MockMetaTable(this.relDataType(), statistic);
        rootSchema.add("test", (Table)table);
        PlannerContext plannerContext = PlannerMocks.newBuilder().withRootSchema(CalciteSchema.from((SchemaPlus)rootSchema)).build().getPlannerContext();
        FlinkRelBuilder relBuilder = plannerContext.createRelBuilder();
        relBuilder.clear();
        return (TableScan)relBuilder.scan(Arrays.asList((Object[])new String[]{"test"})).build();
    }

    private FlinkStatistic mockScan$default$1() {
        return FlinkStatistic$.MODULE$.UNKNOWN();
    }

    private RexLiteral createNumericLiteral(long num) {
        return this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(num));
    }

    private RexLiteral createNumericLiteral(double num) {
        return this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(num));
    }

    private RexLiteral createBooleanLiteral(boolean b) {
        return this.rexBuilder().makeLiteral(b);
    }

    private RexLiteral createStringLiteral(String str) {
        return this.rexBuilder().makeLiteral(str);
    }

    private RexLiteral createDateLiteral(String str) {
        return this.rexBuilder().makeDateLiteral(new DateString(str));
    }

    private RexLiteral createTimeLiteral(String str) {
        return this.rexBuilder().makeTimeLiteral(new TimeString(str), 0);
    }

    private RexLiteral createTimeStampLiteral(long millis) {
        return this.rexBuilder().makeTimestampLiteral(TimestampString.fromMillisSinceEpoch((long)millis), 0);
    }

    private RexInputRef createInputRef(int index) {
        return this.createInputRefWithNullability(index, false);
    }

    private RexInputRef createInputRefWithNullability(int index, boolean isNullable) {
        RelDataType relDataType = this.typeFactory().createSqlType((SqlTypeName)this.allFieldTypes().apply(index));
        RelDataType relDataTypeWithNullability = this.typeFactory().createTypeWithNullability(relDataType, isNullable);
        return this.rexBuilder().makeInputRef(relDataTypeWithNullability, index);
    }

    private RexNode createCall(SqlOperator operator, Seq<RexNode> exprs) {
        Preconditions.checkArgument((boolean)exprs.nonEmpty());
        return this.rexBuilder().makeCall(operator, (RexNode[])exprs.toArray(ClassTag$.MODULE$.apply(RexNode.class)));
    }

    private RexNode createCast(RexNode expr) {
        RelDataType relDataType = this.typeFactory().createSqlType((SqlTypeName)this.allFieldTypes().apply(1));
        return this.rexBuilder().makeCast(relDataType, expr);
    }

    private ColumnStats createColumnStats(Option<Long> ndv, Option<Long> nullCount, Option<Double> avgLen, Option<Integer> maxLen, Option<Comparable<?>> min, Option<Comparable<?>> max) {
        return ColumnStats.Builder.builder().setNdv((Long)ndv.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setNullCount((Long)nullCount.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setAvgLen((Double)avgLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMaxLen((Integer)maxLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMax((Comparable)max.orNull(Predef$.MODULE$.$conforms())).setMin((Comparable)min.orNull(Predef$.MODULE$.$conforms())).build();
    }

    private Option<Long> createColumnStats$default$1() {
        return None$.MODULE$;
    }

    private Option<Long> createColumnStats$default$2() {
        return None$.MODULE$;
    }

    private Option<Double> createColumnStats$default$3() {
        return None$.MODULE$;
    }

    private Option<Integer> createColumnStats$default$4() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$5() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$6() {
        return None$.MODULE$;
    }

    private FlinkStatistic createFlinkStatistic(Option<Long> rowCount, Option<scala.collection.immutable.Map<String, ColumnStats>> colStats) {
        Predef$.MODULE$.require(rowCount.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "rowCount requires not null now");
        TableStats tableStats = colStats.isDefined() ? new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)colStats.get()).asJava()) : new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), null);
        return FlinkStatistic$.MODULE$.builder().tableStats(tableStats).build();
    }

    private Option<Long> createFlinkStatistic$default$1() {
        return None$.MODULE$;
    }

    private Option<scala.collection.immutable.Map<String, ColumnStats>> createFlinkStatistic$default$2() {
        return None$.MODULE$;
    }

    @Test
    public void testEqualsWithLiteralOfNumericType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator3 = new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq());
        Assertions.assertEquals((Object)estimator3.defaultEqualsSelectivity(), (Object)estimator3.evaluate(predicate1));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        SelectivityEstimator estimator4 = new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator4.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator5 = new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq());
        Assertions.assertEquals((Object)estimator5.defaultEqualsSelectivity(), (Object)estimator5.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator5.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfStringType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(800L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)new Some((Object)"aaa"), (Option<Comparable<?>>)new Some((Object)"max")))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.00125)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("xyz")}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfBooleanType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(true)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(true)}));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(false)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(false)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get())))), (Object)estimator1.evaluate(predicate2));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get())))), (Object)estimator1.evaluate(predicate3));
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate4));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flag"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(2L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.boolean2Boolean(false)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.boolean2Boolean(true))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(false)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testEqualsWithLiteralOfDateType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.date_idx()), this.createDateLiteral("2017-10-11")}));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date_col"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)None$.MODULE$, (Option<Integer>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Date.valueOf("2017-10-01")), (Option<Comparable<?>>)new Some((Object)Date.valueOf("2018-10-01"))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.date_idx()), this.createDateLiteral("2018-10-02")}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfTimeType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.time_idx()), this.createTimeLiteral("11:00:00")}));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"time_col"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)None$.MODULE$, (Option<Integer>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Time.valueOf("10:00:00")), (Option<Comparable<?>>)new Some((Object)Time.valueOf("12:00:00"))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.time_idx()), this.createTimeLiteral("13:00:00")}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfTimestampType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.timestamp_idx()), this.createTimeStampLiteral(1000L)}));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp_col"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)None$.MODULE$, (Option<Integer>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)new Timestamp(0L)), (Option<Comparable<?>>)new Some((Object)new Timestamp(2000L))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.timestamp_idx()), this.createTimeStampLiteral(3000L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate));
        FlinkStatistic statistic5 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic5), this.mq()).evaluate(predicate));
    }

    @Test
    public void testNotEqualsWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get())))), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9875)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate2));
    }

    @Test
    public void testComparisonWithLiteralOfStringType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(800L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)new Some((Object)"aaa"), (Option<Comparable<?>>)new Some((Object)"max")))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)estimator2.defaultComparisonSelectivity(), (Object)estimator2.evaluate(predicate));
    }

    @Test
    public void testGreaterThanWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.99)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate5));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator3 = new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator3.evaluate(predicate2));
        Assertions.assertEquals((Object)estimator3.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate3));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator4 = new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator4.evaluate(predicate2));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator4.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator4.evaluate(predicate1));
    }

    @Test
    public void testGreaterThanWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate));
        FlinkStatistic statistic5 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(11)), (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic5), this.mq()).evaluate(predicate));
        FlinkStatistic statistic6 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic6), this.mq()).evaluate(predicate));
    }

    @Test
    public void testGreaterThanOrEqualsToWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(201L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.01)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testGreaterThanOrEqualsToWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
    }

    @Test
    public void testLessThanWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(201L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.99)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testLessThanWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate));
    }

    @Test
    public void testLessThanOrEqualsToWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(9L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.01)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testLessThanOrEqualsToWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(9))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
    }

    @Test
    public void testLike() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.LIKE, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("ross")}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator.defaultLikeSelectivity(), (Object)estimator.evaluate(predicate));
    }

    @Test
    public void testIsNull() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.IS_NULL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRefWithNullability(this.name_idx(), true)}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator.defaultIsNullSelectivity(), (Object)estimator.evaluate(predicate));
        ColumnStats colStats = this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$);
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)colStats)}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
    }

    @Test
    public void testIsNotNull() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRefWithNullability(this.name_idx(), true)}));
        Assertions.assertEquals((Object)estimator.defaultIsNotNullSelectivity(), (Object)estimator.evaluate(predicate2));
        ColumnStats colStats = this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$);
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)colStats)}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate2));
    }

    @Test
    public void testIn() {
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        RexNode predicate1 = this.rexBuilder().makeIn((RexNode)this.createInputRef(this.name_idx()), Arrays.asList((Object[])new RexLiteral[]{this.createStringLiteral("abc"), this.createStringLiteral("def")}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)estimator.defaultEqualsSelectivity().get()) * (double)2))), (Object)estimator.evaluate(predicate1));
        RexNode predicate2 = this.rexBuilder().makeIn((RexNode)this.createInputRef(this.amount_idx()), Arrays.asList((Object[])new RexLiteral[]{this.createNumericLiteral(10.0), this.createNumericLiteral(20.0), this.createNumericLiteral(30.0), this.createNumericLiteral(40.0)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)estimator.defaultEqualsSelectivity().get()) * (double)4))), (Object)estimator.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(50)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(15)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0375)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(50)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic5 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)estimator.defaultEqualsSelectivity().get()) * (double)4))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic5), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic6 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(40L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic6), this.mq()).evaluate(predicate2));
    }

    @Test
    public void testAnd() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(6.5)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.05263157894736842)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate));
    }

    @Test
    public void testOr() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(6.5)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * (double)2 - selectivity * selectivity))), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        double leftSelectivity = 0.21052631578947367;
        double rightSelectivity = 0.25;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(leftSelectivity + rightSelectivity - leftSelectivity * rightSelectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate));
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(60L)}))}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.025)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(60L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(70L)}))}));
        double inSelectivity = 0.025;
        double greaterThan70Selectivity = 0.6842105263157895;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(inSelectivity + greaterThan70Selectivity - inSelectivity * greaterThan70Selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(80L)}))}));
        double lessThan50Selectivity = 0.21052631578947367;
        double greaterThan80Selectivity = 0.631578947368421;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(lessThan50Selectivity + greaterThan80Selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate3));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(60L)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(70L), this.createInputRef(this.amount_idx())})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(5L)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(3L)}))}));
        double inSelectivity1 = 0.025;
        double lessThan70Selectivity = 0.6842105263157895;
        double priceSelectivity = 0.18666666666666665;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(inSelectivity1 + lessThan70Selectivity + priceSelectivity - inSelectivity1 * lessThan70Selectivity * priceSelectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate4));
    }

    @Test
    public void testNot() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.NOT, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get())))), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate));
    }

    @Test
    public void testAndOrNot() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")})), this.createCall((SqlOperator)SqlStdOperatorTable.NOT, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(4.5)}))}))}))}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double accountSelectivity1 = BoxesRunTime.unboxToDouble((Object)estimator1.defaultComparisonSelectivity().get());
        double nameSelectivity1 = BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get());
        double notPriceSelectivity1 = 1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultComparisonSelectivity().get());
        double selectivity1 = accountSelectivity1 * (nameSelectivity1 + notPriceSelectivity1 - nameSelectivity1 * notPriceSelectivity1);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)selectivity1)), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        double accountSelectivity2 = 0.21052631578947367;
        double nameSelectivity2 = BoxesRunTime.unboxToDouble((Object)estimator2.defaultEqualsSelectivity().get());
        double notPriceSelectivity2 = 0.5833333333333334;
        double selectivity2 = accountSelectivity2 * (nameSelectivity2 + notPriceSelectivity2 - nameSelectivity2 * notPriceSelectivity2);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)selectivity2)), (Object)estimator2.evaluate(predicate));
    }

    @Test
    public void testPredicateWithUdf() {
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.ABS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx())})), this.createNumericLiteral(50L)}));
        Assertions.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate1));
    }

    @Test
    public void testSelectivityWithSameRexInputRefs() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(45L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(40L)}))}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(45L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(40L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(4.5)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(5L)}))}));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(45L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(40L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(4.5)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCast((RexNode)this.createInputRef(this.price_idx())), this.createNumericLiteral(5L)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)estimator.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity * selectivity * selectivity))), (Object)estimator.evaluate(predicate2));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(100)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.05)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.004166666666666667)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate2));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(0.02916666666666667 * selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate3));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(120L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(80L)}))}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate4));
    }

    @Test
    public void testSelectivityWithSameRexInputRefsAndStringType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("test")}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)estimator.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(800L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)new Some((Object)"aaa"), (Option<Comparable<?>>)new Some((Object)"max")))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate1));
    }

    public SelectivityEstimatorTest() {
        Tuple8 tuple8 = new Tuple8((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)7));
        if (tuple8 == null) {
            throw new MatchError((Object)tuple8);
        }
        int name_idx = BoxesRunTime.unboxToInt((Object)tuple8._1());
        int amount_idx = BoxesRunTime.unboxToInt((Object)tuple8._2());
        int price_idx = BoxesRunTime.unboxToInt((Object)tuple8._3());
        int flag_idx = BoxesRunTime.unboxToInt((Object)tuple8._4());
        int partition_idx = BoxesRunTime.unboxToInt((Object)tuple8._5());
        int date_idx = BoxesRunTime.unboxToInt((Object)tuple8._6());
        int time_idx = BoxesRunTime.unboxToInt((Object)tuple8._7());
        int timestamp_idx = BoxesRunTime.unboxToInt((Object)tuple8._8());
        this.x$1 = new Tuple8((Object)BoxesRunTime.boxToInteger((int)name_idx), (Object)BoxesRunTime.boxToInteger((int)amount_idx), (Object)BoxesRunTime.boxToInteger((int)price_idx), (Object)BoxesRunTime.boxToInteger((int)flag_idx), (Object)BoxesRunTime.boxToInteger((int)partition_idx), (Object)BoxesRunTime.boxToInteger((int)date_idx), (Object)BoxesRunTime.boxToInteger((int)time_idx), (Object)BoxesRunTime.boxToInteger((int)timestamp_idx));
        this.name_idx = BoxesRunTime.unboxToInt((Object)this.x$1._1());
        this.amount_idx = BoxesRunTime.unboxToInt((Object)this.x$1._2());
        this.price_idx = BoxesRunTime.unboxToInt((Object)this.x$1._3());
        this.flag_idx = BoxesRunTime.unboxToInt((Object)this.x$1._4());
        this.partition_idx = BoxesRunTime.unboxToInt((Object)this.x$1._5());
        this.date_idx = BoxesRunTime.unboxToInt((Object)this.x$1._6());
        this.time_idx = BoxesRunTime.unboxToInt((Object)this.x$1._7());
        this.timestamp_idx = BoxesRunTime.unboxToInt((Object)this.x$1._8());
        this.typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), FlinkTypeFactory$.MODULE$.$lessinit$greater$default$2());
        this.rexBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        this.relDataType = this.typeFactory().createStructType((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.allFieldTypes().map((Function1 & Serializable & scala.Serializable)typeName -> this.typeFactory().createSqlType(typeName), Seq$.MODULE$.canBuildFrom())).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.allFieldNames()).asJava());
        this.mq = FlinkRelMetadataQuery.instance();
    }
}

