/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.io.Serializable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.apache.flink.table.planner.plan.nodes.common.CommonCalc;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRank;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001m3AAE\n\u0001E!)q\u0005\u0001C\u0001Q!)!\u0006\u0001C\u0001W!)Q\b\u0001C\u0001W!)q\b\u0001C\u0001W!)\u0011\t\u0001C\u0001W!)1\t\u0001C\u0001W!)Q\t\u0001C\u0001W!)q\t\u0001C\u0001W!)\u0011\n\u0001C\u0001W!)1\n\u0001C\u0001W!)Q\n\u0001C\u0001W!)q\n\u0001C\u0001W!)\u0011\u000b\u0001C\u0001W!)1\u000b\u0001C\u0001W!)Q\u000b\u0001C\u0001W!)q\u000b\u0001C\u0001W!)\u0011\f\u0001C\u0001W\tab\t\\5oWJ+G.\u00143Q_B,H.\u0019;j_:\u001c\u0016N_3UKN$(B\u0001\u000b\u0016\u0003!iW\r^1eCR\f'B\u0001\f\u0018\u0003\u0011\u0001H.\u00198\u000b\u0005aI\u0012a\u00029mC:tWM\u001d\u0006\u00035m\tQ\u0001^1cY\u0016T!\u0001H\u000f\u0002\u000b\u0019d\u0017N\\6\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0002\u0001'\t\u00011\u0005\u0005\u0002%K5\t1#\u0003\u0002''\tIb\t\\5oWJ+G.\u00143IC:$G.\u001a:UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002%\u0001\u0005\u0001C/Z:u\u000f\u0016$\bk\u001c9vY\u0006$\u0018n\u001c8TSj,wJ\u001c+bE2,7kY1o)\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#\u0001B+oSRD#AA\u001a\u0011\u0005QZT\"A\u001b\u000b\u0005Y:\u0014aA1qS*\u0011\u0001(O\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQt$A\u0003kk:LG/\u0003\u0002=k\t!A+Z:u\u0003u!Xm\u001d;HKR\u0004v\u000e];mCRLwN\\*ju\u0016|eNV1mk\u0016\u001c\bFA\u00024\u0003y!Xm\u001d;HKR\u0004v\u000e];mCRLwN\\*ju\u0016|e\u000e\u0015:pU\u0016\u001cG\u000f\u000b\u0002\u0005g\u0005iB/Z:u\u000f\u0016$\bk\u001c9vY\u0006$\u0018n\u001c8TSj,wJ\u001c$jYR,'\u000f\u000b\u0002\u0006g\u0005YB/Z:u\u000f\u0016$\bk\u001c9vY\u0006$\u0018n\u001c8TSj,wJ\\\"bY\u000eD#AB\u001a\u0002;Q,7\u000f^$fiB{\u0007/\u001e7bi&|gnU5{K>sW\t\u001f9b]\u0012D#aB\u001a\u0002?Q,7\u000f^$fiB{\u0007/\u001e7bi&|gnU5{K>sW\t_2iC:<W\r\u000b\u0002\tg\u0005YB/Z:u\u000f\u0016$\bk\u001c9vY\u0006$\u0018n\u001c8TSj,wJ\u001c*b].D#!C\u001a\u00027Q,7\u000f^$fiB{\u0007/\u001e7bi&|gnU5{K>s7k\u001c:uQ\tQ1'\u0001\u0011uKN$x)\u001a;Q_B,H.\u0019;j_:\u001c\u0016N_3P]\u0006;wM]3hCR,\u0007FA\u00064\u0003\u0001\"Xm\u001d;HKR\u0004v\u000e];mCRLwN\\*ju\u0016|enV5oI><\u0018iZ4)\u00051\u0019\u0014A\b;fgR<U\r\u001e)paVd\u0017\r^5p]NK'0Z(o\u001fZ,'/Q4hQ\ti1'A\u000euKN$x)\u001a;Q_B,H.\u0019;j_:\u001c\u0016N_3P]*{\u0017N\u001c\u0015\u0003\u001dM\nA\u0004^3ti\u001e+G\u000fU8qk2\fG/[8o'&TXm\u00148V]&|g\u000e\u000b\u0002\u0010g\u0005qB/Z:u\u000f\u0016$\bk\u001c9vY\u0006$\u0018n\u001c8TSj,wJ\u001c#fM\u0006,H\u000e\u001e\u0015\u0003!M\na\u0005^3ti\u001e+G\u000fU8qk2\fG/[8o'&TXm\u00148MCJ<W\rR8nC&t7+\u001b>fQ\t\t2\u0007")
public class FlinkRelMdPopulationSizeTest
extends FlinkRelMdHandlerTestBase {
    @Test
    public void testGetPopulationSizeOnTableScan() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.studentLogicalScan(), this.studentBatchScan(), this.studentStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdPopulationSizeTest.$anonfun$testGetPopulationSizeOnTableScan$1(this, scan);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.empLogicalScan(), this.empBatchScan(), this.empStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdPopulationSizeTest.$anonfun$testGetPopulationSizeOnTableScan$2(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetPopulationSizeOnValues() {
        Assertions.assertEquals((double)2.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalValues(), ImmutableBitSet.of()));
        Assertions.assertEquals((double)2.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)2.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)2.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.emptyValues(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.emptyValues(), ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.emptyValues(), ImmutableBitSet.of((int[])new int[]{0, 1})));
    }

    @Test
    public void testGetPopulationSizeOnProject() {
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of()));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)48.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)16.43, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{2}))), (double)0.01);
        Assertions.assertEquals((double)6.99, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{3}))), (double)0.01);
        Assertions.assertEquals((double)20.37, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{4}))), (double)0.01);
        Assertions.assertEquals((double)20.37, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{5}))), (double)0.01);
        Assertions.assertEquals((double)35.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{6})));
        Assertions.assertEquals((double)5.0, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{7}))), (double)0.01);
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{8})));
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{9})));
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{10})));
        Assertions.assertEquals((double)16.43, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{11}))), (double)0.01);
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertEquals((double)31.24, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{1, 8}))), (double)0.01);
    }

    @Test
    public void testGetPopulationSizeOnFilter() {
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of()));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)48.0, (Double)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)20.0, (Double)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals((double)7.0, (Double)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertEquals((double)35.0, (Double)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{4})));
        Assertions.assertEquals((double)2.0, (Double)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertNull((Object)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{6})));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0, 2})));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{2, 3})));
        Assertions.assertEquals((double)14.0, (Double)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{3, 5})));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0, 6})));
    }

    @Test
    public void testGetPopulationSizeOnCalc() {
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of()));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)48.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)11.22, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{2}))), (double)0.01);
        Assertions.assertEquals((double)6.67, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{3}))), (double)0.01);
        Assertions.assertEquals((double)12.3, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{4}))), (double)0.01);
        Assertions.assertEquals((double)12.3, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{5}))), (double)0.01);
        Assertions.assertEquals((double)35.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{6})));
        Assertions.assertEquals((double)2.5, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{7}))), (double)0.01);
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{8})));
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{9})));
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{10})));
        Assertions.assertEquals((double)11.22, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{11}))), (double)0.01);
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertEquals((double)19.64, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{1, 8}))), (double)0.01);
    }

    @Test
    public void testGetPopulationSizeOnExpand() {
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalExpand(), ImmutableBitSet.of()));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalExpand(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)48.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalExpand(), ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)20.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalExpand(), ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals((double)7.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalExpand(), ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertEquals((double)35.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalExpand(), ImmutableBitSet.of((int[])new int[]{4})));
        Assertions.assertEquals((double)2.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalExpand(), ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertNull((Object)this.mq().getPopulationSize((RelNode)this.logicalExpand(), ImmutableBitSet.of((int[])new int[]{6})));
        Assertions.assertEquals((double)3.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalExpand(), ImmutableBitSet.of((int[])new int[]{7})));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalExpand(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertEquals((double)14.0, (Double)this.mq().getPopulationSize((RelNode)this.logicalExpand(), ImmutableBitSet.of((int[])new int[]{3, 5})));
    }

    @Test
    public void testGetPopulationSizeOnExchange() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.batchExchange(), this.streamExchange()})).foreach((Function1 & Serializable & scala.Serializable)exchange -> {
            FlinkRelMdPopulationSizeTest.$anonfun$testGetPopulationSizeOnExchange$1(this, exchange);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetPopulationSizeOnRank() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalRank(), this.flinkLogicalRank(), this.batchLocalRank(), this.batchGlobalRank(), this.streamRank()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdPopulationSizeTest.$anonfun$testGetPopulationSizeOnRank$1(this, rank);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetPopulationSizeOnSort() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSort(), this.flinkLogicalSort(), this.batchSort(), this.streamSort(), this.logicalLimit(), this.flinkLogicalLimit(), this.batchLimit(), this.batchLocalLimit(), this.batchGlobalLimit(), this.streamLimit(), this.logicalSortLimit(), this.flinkLogicalSortLimit(), this.batchSortLimit(), this.batchLocalSortLimit(), this.batchGlobalSortLimit(), this.streamSortLimit()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdPopulationSizeTest.$anonfun$testGetPopulationSizeOnSort$1(this, sort);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetPopulationSizeOnAggregate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAgg(), this.flinkLogicalAgg(), this.batchGlobalAggWithLocal(), this.batchGlobalAggWithoutLocal(), this.batchLocalAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdPopulationSizeTest.$anonfun$testGetPopulationSizeOnAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetPopulationSizeOnWindowAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAgg(), this.flinkLogicalWindowAgg(), this.batchGlobalWindowAggWithoutLocalAgg(), this.batchGlobalWindowAggWithLocalAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdPopulationSizeTest.$anonfun$testGetPopulationSizeOnWindowAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((double)30.0, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)5.0, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals(null, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertEquals(null, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0, 2})));
        Assertions.assertEquals((double)10.0, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0, 3})));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{1, 3})));
        Assertions.assertEquals(null, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{2, 3})));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAggWithAuxGroup(), this.flinkLogicalWindowAggWithAuxGroup(), this.batchGlobalWindowAggWithoutLocalAggWithAuxGroup(), this.batchGlobalWindowAggWithLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdPopulationSizeTest.$anonfun$testGetPopulationSizeOnWindowAgg$2(this, agg);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertNull((Object)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)48.0, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals((double)10.0, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertNull((Object)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0, 2})));
        Assertions.assertNull((Object)this.mq().getPopulationSize((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0, 1, 3})));
    }

    @Test
    public void testGetPopulationSizeOnOverAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonCalc[]{this.flinkLogicalOverAgg(), this.batchOverAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdPopulationSizeTest.$anonfun$testGetPopulationSizeOnOverAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetPopulationSizeOnJoin() {
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of()));
        Assertions.assertEquals((double)49.999938, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}))), (double)1.0E-6);
        Assertions.assertEquals((double)49.999998, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}))), (double)1.0E-6);
        Assertions.assertEquals((double)50.0, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5}))), (double)1.0E-6);
        Assertions.assertEquals((double)49.999991, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 6}))), (double)1.0E-6);
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize(this.logicalLeftJoinNotOnUniqueKeys(), ImmutableBitSet.of()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getPopulationSize(this.logicalLeftJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)5.0569644724678594E8, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(this.logicalLeftJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}))), (double)0.01);
        Assertions.assertEquals((double)7.999999791508117E8, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(this.logicalLeftJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5}))), (double)0.01);
        Assertions.assertEquals((double)7.937727457918736E8, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(this.logicalLeftJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 6}))), (double)0.01);
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize(this.logicalRightJoinOnLHSUniqueKeys(), ImmutableBitSet.of()));
        Assertions.assertEquals((double)1.264241136E7, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(this.logicalRightJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}))), (double)0.01);
        Assertions.assertEquals((double)1.9752070389525224E7, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(this.logicalRightJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}))), (double)0.01);
        Assertions.assertEquals((double)1.999999987845058E7, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(this.logicalRightJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5}))), (double)0.01);
        Assertions.assertEquals((double)1.9996088147299763E7, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(this.logicalRightJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 6}))), (double)0.01);
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize(this.logicalFullJoinWithoutEquiCond(), ImmutableBitSet.of()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getPopulationSize(this.logicalFullJoinWithoutEquiCond(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getPopulationSize(this.logicalFullJoinWithoutEquiCond(), ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)6.295509444597865E15, (Double)this.mq().getPopulationSize(this.logicalFullJoinWithoutEquiCond(), ImmutableBitSet.of((int[])new int[]{1, 5})));
        Assertions.assertEquals((double)5.112E10, (Double)this.mq().getPopulationSize(this.logicalFullJoinWithoutEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 6})));
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize(this.logicalSemiJoinOnUniqueKeys(), ImmutableBitSet.of()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getPopulationSize(this.logicalSemiJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getPopulationSize(this.logicalSemiJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getPopulationSize(this.logicalSemiJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getPopulationSize(this.logicalSemiJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2})));
        Assertions.assertEquals((double)1.0, (Double)this.mq().getPopulationSize(this.logicalAntiJoinNotOnUniqueKeys(), ImmutableBitSet.of()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getPopulationSize(this.logicalAntiJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getPopulationSize(this.logicalAntiJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getPopulationSize(this.logicalAntiJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getPopulationSize(this.logicalAntiJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2})));
    }

    @Test
    public void testGetPopulationSizeOnUnion() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalUnion(), this.logicalUnionAll()})).foreach((Function1 & Serializable & scala.Serializable)unoin -> {
            FlinkRelMdPopulationSizeTest.$anonfun$testGetPopulationSizeOnUnion$1(this, unoin);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetPopulationSizeOnDefault() {
        Assertions.assertNull((Object)this.mq().getPopulationSize((RelNode)this.testRel(), ImmutableBitSet.of()));
        Assertions.assertNull((Object)this.mq().getPopulationSize((RelNode)this.testRel(), ImmutableBitSet.of((int[])new int[]{1})));
    }

    @Test
    public void testGetPopulationSizeOnLargeDomainSize() {
        this.relBuilder().clear();
        RelNode rel = this.relBuilder().scan(new String[]{"MyTable1"}).project(new RexNode[]{this.relBuilder().field(0), this.relBuilder().field(1), this.relBuilder().call((SqlOperator)SqlStdOperatorTable.SUBSTRING, new RexNode[]{this.relBuilder().field(3), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))})}).build();
        Assertions.assertEquals((double)7.999999964933156E8, (double)Predef$.MODULE$.Double2double(this.mq().getPopulationSize(rel, ImmutableBitSet.of((int[])new int[]{0, 1, 2}))), (double)0.01);
    }

    public static final /* synthetic */ void $anonfun$testGetPopulationSizeOnTableScan$1(FlinkRelMdPopulationSizeTest $this, TableScan scan) {
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of()));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)48.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)20.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals((double)7.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertEquals((double)35.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{4})));
        Assertions.assertEquals((double)2.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertNull((Object)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{6})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 2})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{2, 3})));
        Assertions.assertEquals((double)14.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{3, 5})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 6})));
    }

    public static final /* synthetic */ void $anonfun$testGetPopulationSizeOnTableScan$2(FlinkRelMdPopulationSizeTest $this, TableScan scan) {
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of()));
        Assertions.assertNull((Object)$this.mq().getPopulationSize((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0})));
    }

    public static final /* synthetic */ void $anonfun$testGetPopulationSizeOnExchange$1(FlinkRelMdPopulationSizeTest $this, RelNode exchange) {
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of()));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)48.0, (Double)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)20.0, (Double)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals((double)7.0, (Double)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertEquals((double)35.0, (Double)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of((int[])new int[]{4})));
        Assertions.assertEquals((double)2.0, (Double)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertNull((Object)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of((int[])new int[]{6})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of((int[])new int[]{0, 2})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of((int[])new int[]{2, 3})));
        Assertions.assertEquals((double)14.0, (Double)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of((int[])new int[]{3, 5})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize(exchange, ImmutableBitSet.of((int[])new int[]{0, 6})));
    }

    public static final /* synthetic */ void $anonfun$testGetPopulationSizeOnRank$1(FlinkRelMdPopulationSizeTest $this, RelNode rank) {
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of()));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)48.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)20.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals((double)7.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertEquals((double)35.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{4})));
        Assertions.assertEquals((double)2.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertNull((Object)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{6})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{0, 2})));
        RelNode relNode = rank;
        if (relNode instanceof BatchPhysicalRank) {
            BatchPhysicalRank batchPhysicalRank = (BatchPhysicalRank)relNode;
            if (batchPhysicalRank.isGlobal()) {
                Assertions.assertEquals((double)1.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{7})));
                Assertions.assertEquals((double)1.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{7})));
                Assertions.assertEquals((double)1.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{0, 7})));
                Assertions.assertEquals((double)1.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{3, 7})));
                return;
            }
            return;
        }
        Assertions.assertEquals((double)5.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{7})));
        Assertions.assertEquals((double)5.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{0, 7})));
        Assertions.assertEquals((double)5.0, (Double)$this.mq().getPopulationSize(rank, ImmutableBitSet.of((int[])new int[]{3, 7})));
    }

    public static final /* synthetic */ void $anonfun$testGetPopulationSizeOnSort$1(FlinkRelMdPopulationSizeTest $this, RelNode sort) {
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getPopulationSize(sort, ImmutableBitSet.of()));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize(sort, ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)48.0, (Double)$this.mq().getPopulationSize(sort, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)20.0, (Double)$this.mq().getPopulationSize(sort, ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals((double)7.0, (Double)$this.mq().getPopulationSize(sort, ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertEquals((double)35.0, (Double)$this.mq().getPopulationSize(sort, ImmutableBitSet.of((int[])new int[]{4})));
        Assertions.assertEquals((double)2.0, (Double)$this.mq().getPopulationSize(sort, ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertNull((Object)$this.mq().getPopulationSize(sort, ImmutableBitSet.of((int[])new int[]{6})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize(sort, ImmutableBitSet.of((int[])new int[]{0, 2})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize(sort, ImmutableBitSet.of((int[])new int[]{2, 3})));
        Assertions.assertEquals((double)14.0, (Double)$this.mq().getPopulationSize(sort, ImmutableBitSet.of((int[])new int[]{3, 5})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize(sort, ImmutableBitSet.of((int[])new int[]{0, 6})));
    }

    public static final /* synthetic */ void $anonfun$testGetPopulationSizeOnAggregate$1(FlinkRelMdPopulationSizeTest $this, SingleRel agg) {
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of()));
        Assertions.assertEquals((double)7.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)2.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)2.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals((double)3.5, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertEquals((double)3.5, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{4})));
        Assertions.assertEquals((double)10.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertEquals((double)7.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertEquals((double)7.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 5})));
    }

    public static final /* synthetic */ void $anonfun$testGetPopulationSizeOnWindowAgg$1(FlinkRelMdPopulationSizeTest $this, SingleRel agg) {
        Assertions.assertEquals((double)30.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)5.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2})));
        Assertions.assertEquals(null, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertEquals(null, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3})));
        Assertions.assertEquals(null, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 3})));
        Assertions.assertEquals(null, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{2, 3})));
    }

    public static final /* synthetic */ void $anonfun$testGetPopulationSizeOnWindowAgg$2(FlinkRelMdPopulationSizeTest $this, SingleRel agg) {
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)48.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)10.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals(null, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        Assertions.assertEquals(null, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 3})));
    }

    public static final /* synthetic */ void $anonfun$testGetPopulationSizeOnOverAgg$1(FlinkRelMdPopulationSizeTest $this, CommonCalc agg) {
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of()));
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)48.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)20.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals((double)7.0, (Double)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3})));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(4), 11).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertNull((Object)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx}))));
        Assertions.assertNull((Object)$this.mq().getPopulationSize((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 6})));
    }

    public static final /* synthetic */ void $anonfun$testGetPopulationSizeOnUnion$1(FlinkRelMdPopulationSizeTest $this, RelNode unoin) {
        Assertions.assertEquals((double)2.0, (Double)$this.mq().getPopulationSize(unoin, ImmutableBitSet.of()));
        Assertions.assertEquals((double)4.0E7, (Double)$this.mq().getPopulationSize(unoin, ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertEquals((double)8.00002556E8, (Double)$this.mq().getPopulationSize(unoin, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertEquals((double)2263.0, (Double)$this.mq().getPopulationSize(unoin, ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertEquals((double)8.2E8, (Double)$this.mq().getPopulationSize(unoin, ImmutableBitSet.of((int[])new int[]{0, 2})));
    }
}

