/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRank;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableAggregate;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I3Aa\u0004\t\u0001?!)A\u0005\u0001C\u0001K!)q\u0005\u0001C\u0001Q!)!\b\u0001C\u0001Q!)A\b\u0001C\u0001Q!)a\b\u0001C\u0001Q!)\u0001\t\u0001C\u0001Q!)!\t\u0001C\u0001Q!)A\t\u0001C\u0001Q!)a\t\u0001C\u0001Q!)\u0001\n\u0001C\u0001Q!)!\n\u0001C\u0001Q!)A\n\u0001C\u0001Q!)a\n\u0001C\u0001Q!)\u0001\u000b\u0001C\u0001Q\t\u0011c\t\\5oWJ+G.\u00143N_\u0012Lg-[3e\u001b>tw\u000e^8oS\u000eLG/\u001f+fgRT!!\u0005\n\u0002\u00115,G/\u00193bi\u0006T!a\u0005\u000b\u0002\tAd\u0017M\u001c\u0006\u0003+Y\tq\u0001\u001d7b]:,'O\u0003\u0002\u00181\u0005)A/\u00192mK*\u0011\u0011DG\u0001\u0006M2Lgn\u001b\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011#\u001b\u0005\u0001\u0012BA\u0012\u0011\u0005e1E.\u001b8l%\u0016dW\n\u001a%b]\u0012dWM\u001d+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0011\u0001\u0003\u0005\"Xm\u001d;HKR\u0014V\r\\'p]>$xN\\5dSRLxJ\u001c+bE2,7kY1o)\u0005I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#\u0001B+oSRD#A\u0001\u0019\u0011\u0005EBT\"\u0001\u001a\u000b\u0005M\"\u0014aA1qS*\u0011QGN\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9D$A\u0003kk:LG/\u0003\u0002:e\t!A+Z:u\u0003u!Xm\u001d;N_:|Go\u001c8jG&$\u0018pV5uQ\u000e{g\u000eZ5uS>t\u0007FA\u00021\u0003}!Xm\u001d;HKR\u0014V\r\\'p]>$xN\\5dSRLxJ\u001c)s_*,7\r\u001e\u0015\u0003\tA\nA\u0004^3ti\u001e+GOU3m\u001b>tw\u000e^8oS\u000eLG/_(o%\u0006t7\u000e\u000b\u0002\u0006a\u0005yC/Z:u\u000f\u0016$(+\u001a7N_:|Go\u001c8jG&$\u0018p\u00148UC\ndW-Q4he\u0016<\u0017\r^3BMR,'oU2b]\"\u0012a\u0001M\u00015i\u0016\u001cHoR3u%\u0016dWj\u001c8pi>t\u0017nY5us>sG+\u00192mK\u0006;wM]3hCR,\u0017I\u001a;fe\u0006;wM]3hCR,\u0007FA\u00041\u00031\"Xm\u001d;HKR\u0014V\r\\'p]>$xN\\5dSRLxJ\\,j]\u0012|w\u000fV1cY\u0016\fum\u001a:fO\u0006$X\r\u000b\u0002\ta\u0005\tC/Z:u\u000f\u0016$(+\u001a7N_:|Go\u001c8jG&$\u0018p\u00148BO\u001e\u0014XmZ1uK\"\u0012\u0011\u0002M\u0001\u001di\u0016\u001cHoR3u%\u0016dWj\u001c8pi>t\u0017nY5us>s'j\\5oQ\tQ\u0001'A\u0012uKN$x)\u001a;SK2luN\\8u_:L7-\u001b;z\u001f:$U\rZ;qY&\u001c\u0017\r^3)\u0005-\u0001\u0014A\u000b;fgR<U\r\u001e*fY6{gn\u001c;p]&\u001c\u0017\u000e^=P]\u000eC\u0017M\\4fY><gj\u001c:nC2L'0\u001a\u0015\u0003\u0019A\n\u0001\u0006^3ti\u001e+GOU3m\u001b>tw\u000e^8oS\u000eLG/_(o\tJ|\u0007/\u00169eCR,')\u001a4pe\u0016D#!\u0004\u0019\u0002EQ,7\u000f^$fiJ+G.T8o_R|g.[2jif|e\u000eT8pWV\u0004(j\\5oQ\tq\u0001\u0007")
public class FlinkRelMdModifiedMonotonicityTest
extends FlinkRelMdHandlerTestBase {
    @Test
    public void testGetRelMonotonicityOnTableScan() {
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])Array$.MODULE$.fill(7, (Function0 & Serializable & scala.Serializable)() -> SqlMonotonicity.CONSTANT, ClassTag$.MODULE$.apply(SqlMonotonicity.class))), (Object)this.mq().getRelModifiedMonotonicity((RelNode)this.studentLogicalScan()));
    }

    @Test
    public void testMonotonicityWithCondition() {
        RelNode inputAgg = this.relBuilder().scan(new String[]{"student"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("id"), this.relBuilder().field("age")}), new RelBuilder.AggCall[]{this.relBuilder().count(new RexNode[0]).as("count")}).build();
        this.relBuilder().push(inputAgg);
        .colon.colon projection = new .colon.colon((Object)this.relBuilder().field("age"), (List)Nil$.MODULE$);
        Buffer ageFieldType = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inputAgg.getRowType().getFieldList()).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)FlinkRelMdModifiedMonotonicityTest.$anonfun$testMonotonicityWithCondition$1(x)));
        RelRecordType outputType = new RelRecordType(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(ageFieldType));
        RexNode condition = this.relBuilder().and(new RexNode[]{this.relBuilder().greaterThan((RexNode)this.relBuilder().field("count"), (RexNode)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))), this.relBuilder().lessThan((RexNode)this.relBuilder().field("count"), (RexNode)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)3)))});
        this.assertMonotonicity$1(SqlMonotonicity.NOT_MONOTONIC, condition, inputAgg, (List)projection, outputType);
        condition = this.relBuilder().greaterThan((RexNode)this.relBuilder().field("count"), (RexNode)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1)));
        this.assertMonotonicity$1(SqlMonotonicity.CONSTANT, condition, inputAgg, (List)projection, outputType);
        condition = this.relBuilder().lessThan((RexNode)this.relBuilder().field("count"), (RexNode)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)3)));
        this.assertMonotonicity$1(SqlMonotonicity.NOT_MONOTONIC, condition, inputAgg, (List)projection, outputType);
        condition = this.relBuilder().or(new RexNode[]{this.relBuilder().greaterThan((RexNode)this.relBuilder().field("count"), (RexNode)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))), this.relBuilder().lessThan((RexNode)this.relBuilder().field("count"), (RexNode)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)3)))});
        this.assertMonotonicity$1(SqlMonotonicity.NOT_MONOTONIC, condition, inputAgg, (List)projection, outputType);
        this.assertMonotonicity$1(SqlMonotonicity.CONSTANT, null, inputAgg, (List)projection, outputType);
        condition = this.relBuilder().in((RexNode)this.relBuilder().field("count"), new RexNode[]{this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1)), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2)), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)3))});
        this.assertMonotonicity$1(SqlMonotonicity.NOT_MONOTONIC, condition, inputAgg, (List)projection, outputType);
        this.assertMonotonicity$1(SqlMonotonicity.NOT_MONOTONIC, this.relBuilder().not(condition), inputAgg, (List)projection, outputType);
        condition = this.relBuilder().equals((RexNode)this.relBuilder().field("count"), (RexNode)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10)));
        this.assertMonotonicity$1(SqlMonotonicity.NOT_MONOTONIC, condition, inputAgg, (List)projection, outputType);
        condition = this.relBuilder().notEquals((RexNode)this.relBuilder().field("count"), (RexNode)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10)));
        this.assertMonotonicity$1(SqlMonotonicity.NOT_MONOTONIC, condition, inputAgg, (List)projection, outputType);
        condition = this.relBuilder().or(new RexNode[]{this.relBuilder().greaterThan((RexNode)this.relBuilder().field("count"), (RexNode)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)5))), this.relBuilder().lessThan((RexNode)this.relBuilder().field("count"), (RexNode)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2)))});
        this.assertMonotonicity$1(SqlMonotonicity.NOT_MONOTONIC, condition, inputAgg, (List)projection, outputType);
        condition = this.relBuilder().isNotNull((RexNode)this.relBuilder().field("age"));
        this.assertMonotonicity$1(SqlMonotonicity.CONSTANT, condition, inputAgg, (List)projection, outputType);
    }

    @Test
    public void testGetRelMonotonicityOnProject() {
        RelNode projectWithMaxAgg = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.INCREASING, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity(projectWithMaxAgg));
        RelNode aggWithMaxMax = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_max_c", (RexNode)this.relBuilder().field("max_c"))}).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMaxMax));
        RelNode aggWithMaxMin = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().min("min_max_c", (RexNode)this.relBuilder().field("max_c"))}).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMaxMin));
    }

    @Test
    public void testGetRelMonotonicityOnRank() {
        FlinkLogicalRank rank = new FlinkLogicalRank(this.cluster(), this.logicalTraits(), (RelNode)this.testRel(), ImmutableBitSet.of(), RelCollations.of((int)1), RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 3L), (RelDataTypeField)new RelDataTypeFieldImpl("rk", 7, this.longType()), false);
        Assertions.assertEquals(null, (Object)this.mq().getRelModifiedMonotonicity((RelNode)rank));
    }

    @Test
    public void testGetRelMonotonicityOnTableAggregateAfterScan() {
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity((RelNode)this.logicalTableAgg()));
    }

    @Test
    public void testGetRelMonotonicityOnTableAggregateAfterAggregate() {
        RelNode projectWithMaxAgg = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        FlinkLogicalTableAggregate tableAggregate = new FlinkLogicalTableAggregate(this.cluster(), this.logicalTraits(), projectWithMaxAgg, ImmutableBitSet.of((int[])new int[]{0}), null, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)this.tableAggCall(), (List)Nil$.MODULE$)));
        Assertions.assertEquals(null, (Object)this.mq().getRelModifiedMonotonicity((RelNode)tableAggregate));
    }

    @Test
    public void testGetRelMonotonicityOnWindowTableAggregate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowTableAgg(), this.flinkLogicalWindowTableAgg(), this.streamWindowTableAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdModifiedMonotonicityTest.$anonfun$testGetRelMonotonicityOnWindowTableAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRelMonotonicityOnAggregate() {
        RelNode aggWithSum = this.relBuilder().scan(new String[]{"MyTable3"}).project(new RexNode[]{this.relBuilder().alias(this.relBuilder().call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))}), "a"), this.relBuilder().field(1)}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().sum(false, "sum_a", (RexNode)this.relBuilder().field("a"))}).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithSum));
        RelNode aggWithCount = this.relBuilder().scan(new String[]{"MyTable3"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().count(false, "count_a", new RexNode[]{this.relBuilder().field("a")})}).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithCount));
        RelNode aggWithMax = this.relBuilder().scan(new String[]{"MyTable3"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_a", (RexNode)this.relBuilder().field("a"))}).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMax));
        RelNode aggWithMin = this.relBuilder().scan(new String[]{"MyTable3"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().min("min_a", (RexNode)this.relBuilder().field("a"))}).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.DECREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMin));
        RelNode aggWithAvg = this.relBuilder().scan(new String[]{"MyTable3"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a")}), new RelBuilder.AggCall[]{this.relBuilder().avg(false, "avg_b", (RexNode)this.relBuilder().field("b"))}).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity(aggWithAvg));
        RelNode aggWithMaxSum = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("max_c")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_sum_d", (RexNode)this.relBuilder().field("sum_d"))}).build();
        Assertions.assertEquals(null, (Object)this.mq().getRelModifiedMonotonicity(aggWithMaxSum));
        RelNode aggWithMaxSumMin = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().min("min_max_c", (RexNode)this.relBuilder().field("max_c"))}).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMaxSumMin));
        RelNode aggWithMaxSumMax = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "max_d", (RexNode)this.relBuilder().field("d"))}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_max_c", (RexNode)this.relBuilder().field("max_c"))}).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMaxSumMax));
    }

    @Test
    public void testGetRelMonotonicityOnJoin() {
        RelNode left1 = this.relBuilder().scan(new String[]{"MyTable4"}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        RelNode right1 = this.relBuilder().scan(new String[]{"MyTable4"}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        RelNode join1 = this.relBuilder().push(left1).push(right1).join(JoinRelType.LEFT, this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(2, 0, 1), this.relBuilder().field(2, 1, 1)})).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity(join1));
        RelNode left = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        RelNode right = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().min("min_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        RelNode join2 = this.relBuilder().push(left).push(right).join(JoinRelType.INNER, this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(2, 0, 1), this.relBuilder().field(2, 1, 1)})).build();
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.INCREASING, SqlMonotonicity.CONSTANT, SqlMonotonicity.DECREASING, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity(join2));
        RelNode join3 = this.relBuilder().push(left).push(right).join(JoinRelType.INNER, this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(2, 0, 0), this.relBuilder().field(2, 1, 1)})).build();
        Assertions.assertEquals(null, (Object)this.mq().getRelModifiedMonotonicity(join3));
        Assertions.assertNull((Object)this.mq().getRelModifiedMonotonicity(this.logicalAntiJoinNotOnUniqueKeys()));
        Assertions.assertNull((Object)this.mq().getRelModifiedMonotonicity(this.logicalAntiJoinOnUniqueKeys()));
    }

    @Test
    public void testGetRelMonotonicityOnDeduplicate() {
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity(this.streamProcTimeDeduplicateFirstRow()));
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity(this.streamProcTimeDeduplicateLastRow()));
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity(this.streamRowTimeDeduplicateFirstRow()));
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity(this.streamRowTimeDeduplicateLastRow()));
    }

    @Test
    public void testGetRelMonotonicityOnChangelogNormalize() {
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity((RelNode)this.streamChangelogNormalize()));
    }

    @Test
    public void testGetRelMonotonicityOnDropUpdateBefore() {
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])Array$.MODULE$.fill(7, (Function0 & Serializable & scala.Serializable)() -> SqlMonotonicity.CONSTANT, ClassTag$.MODULE$.apply(SqlMonotonicity.class))), (Object)this.mq().getRelModifiedMonotonicity((RelNode)this.streamDropUpdateBefore()));
    }

    @Test
    public void testGetRelMonotonicityOnLookupJoin() {
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity((RelNode)this.streamLookupJoin()));
    }

    public static final /* synthetic */ boolean $anonfun$testMonotonicityWithCondition$1(RelDataTypeField x) {
        return x.getName().equals("age");
    }

    private final LogicalCalc createCalc$1(RexNode condition, RelNode inputAgg$1, List projection$1, RelRecordType outputType$1) {
        RexProgram program = RexProgram.create((RelDataType)inputAgg$1.getRowType(), (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)projection$1), (RexNode)condition, (RelDataType)outputType$1, (RexBuilder)this.rexBuilder());
        return new LogicalCalc(this.cluster(), this.logicalTraits(), new ArrayList(), inputAgg$1, program);
    }

    private final void assertMonotonicity$1(SqlMonotonicity monotonicity, RexNode condition, RelNode inputAgg$1, List projection$1, RelRecordType outputType$1) {
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{monotonicity})), (Object)this.mq().getRelModifiedMonotonicity((RelNode)this.createCalc$1(condition, inputAgg$1, projection$1, outputType$1)));
    }

    public static final /* synthetic */ void $anonfun$testGetRelMonotonicityOnWindowTableAggregate$1(FlinkRelMdModifiedMonotonicityTest $this, SingleRel agg) {
        Assertions.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])Array$.MODULE$.fill(agg.getRowType().getFieldCount(), (Function0 & Serializable & scala.Serializable)() -> SqlMonotonicity.CONSTANT, ClassTag$.MODULE$.apply(SqlMonotonicity.class))), (Object)$this.mq().getRelModifiedMonotonicity((RelNode)agg));
    }
}

