/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.hint;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.StatementSetImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.hint.OptionsHintTest$;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalLegacySink;
import org.apache.flink.table.planner.utils.OptionsTableSink;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u00181\u0001}B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0007I\u0002!\t!!?\t\u0013\u0005M\u0007A1A\u0005\n\u0005}\bb\u0002B\u0001\u0001\u0001\u0006IA \u0005\n\u0005\u0007\u0001!\u0019!C\u0005\u0003\u000fA\u0001B!\u0002\u0001A\u0003%\u0011\u0011\u0002\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0011\u001d\u0011)\u0003\u0001C\u0001\u0005\u0013AqAa\f\u0001\t\u0003\u0011I\u0001C\u0004\u00034\u0001!\tA!\u0003\t\u000f\t]\u0002\u0001\"\u0001\u0003\n!9!1\b\u0001\u0005\u0002\t%\u0001b\u0002B \u0001\u0011\u0005!\u0011\u0002\u0005\b\u0005\u0007\u0002A\u0011\u0001B\u0005\u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u0013AqAa\u0013\u0001\t\u0003\u0011IaB\u0003[a!\u00051LB\u00030a!\u0005Q\fC\u0003e%\u0011\u0005Q\rC\u0004g%\t\u0007I\u0011A4\t\rA\u0014\u0002\u0015!\u0003i\r\u0011\t(\u0003\u0011:\t\u0011e4\"Q3A\u0005\u0002iD\u0011\"a\u0001\u0017\u0005#\u0005\u000b\u0011B>\t\u0015\u0005\u0015aC!f\u0001\n\u0003\t9\u0001\u0003\u0006\u0002\u0010Y\u0011\t\u0012)A\u0005\u0003\u0013Aa\u0001\u001a\f\u0005\u0002\u0005E\u0001bBA\u000e-\u0011\u0005\u0013Q\u0004\u0005\n\u0003[1\u0012\u0011!C\u0001\u0003_A\u0011\"!\u000e\u0017#\u0003%\t!a\u000e\t\u0013\u00055c#%A\u0005\u0002\u0005=\u0003\u0002CA*-\u0005\u0005I\u0011I4\t\u0013\u0005Uc#!A\u0005\u0002\u0005]\u0003\"CA0-\u0005\u0005I\u0011AA1\u0011%\tiGFA\u0001\n\u0003\ny\u0007C\u0005\u0002~Y\t\t\u0011\"\u0001\u0002\u0000!I\u00111\u0011\f\u0002\u0002\u0013\u0005\u0013Q\u0011\u0005\n\u0003\u000f3\u0012\u0011!C!\u0003\u0013;\u0011\"!$\u0013\u0003\u0003E\t!a$\u0007\u0011E\u0014\u0012\u0011!E\u0001\u0003#Ca\u0001\u001a\u0015\u0005\u0002\u0005}\u0005\"CA\u000eQ\u0005\u0005IQIAQ\u0011%\t\u0019\u000bKA\u0001\n\u0003\u000b)\u000bC\u0005\u0002,\"\n\t\u0011\"!\u0002.\"I\u0011q\u0018\u0015\u0002\u0002\u0013%\u0011\u0011\u0019\u0005\b\u0003\u0013\u0014B\u0011AAf\u0005=y\u0005\u000f^5p]ND\u0015N\u001c;UKN$(BA\u00193\u0003\u0011A\u0017N\u001c;\u000b\u0005M\"\u0014\u0001\u00029mC:T!!\u000e\u001c\u0002\u000fAd\u0017M\u001c8fe*\u0011q\u0007O\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003si\nQA\u001a7j].T!a\u000f\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0014aA8sO\u000e\u00011C\u0001\u0001A!\t\tE)D\u0001C\u0015\t\u0019E'A\u0003vi&d7/\u0003\u0002F\u0005\niA+\u00192mKR+7\u000f\u001e\"bg\u0016\fQ\u0001]1sC6\u0004\"\u0001\u0013\f\u000f\u0005%\u000bbB\u0001&Z\u001d\tY\u0005L\u0004\u0002M/:\u0011QJ\u0016\b\u0003\u001dVs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005Is\u0014A\u0002\u001fs_>$h(C\u0001>\u0013\tYD(\u0003\u0002:u%\u0011q\u0007O\u0005\u0003kYJ!a\r\u001b\n\u0005E\u0012\u0014aD(qi&|gn\u001d%j]R$Vm\u001d;\u0011\u0005q\u0013R\"\u0001\u0019\u0014\u0005Iq\u0006CA0c\u001b\u0005\u0001'\"A1\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0004'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00027\u0006Q\u0011jU0C\u001fVsE)\u0012#\u0016\u0003!\u0004\"!\u001b8\u000e\u0003)T!a\u001b7\u0002\t1\fgn\u001a\u0006\u0002[\u0006!!.\u0019<b\u0013\ty'N\u0001\u0004TiJLgnZ\u0001\f\u0013N{&iT+O\t\u0016#\u0005EA\u0003QCJ\fWn\u0005\u0003\u0017=N4\bCA0u\u0013\t)\bMA\u0004Qe>$Wo\u0019;\u0011\u0005};\u0018B\u0001=a\u00051\u0019VM]5bY&T\u0018M\u00197f\u00031)H/\u001b7TkB\u0004H.[3s+\u0005Y\b\u0003B0}\u0001zL!! 1\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA!\u0000\u0013\r\t\tA\u0011\u0002\u000e)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u001bU$\u0018\u000e\\*vaBd\u0017.\u001a:!\u0003%I7OQ8v]\u0012,G-\u0006\u0002\u0002\nA\u0019q,a\u0003\n\u0007\u00055\u0001MA\u0004C_>dW-\u00198\u0002\u0015%\u001c(i\\;oI\u0016$\u0007\u0005\u0006\u0004\u0002\u0014\u0005]\u0011\u0011\u0004\t\u0004\u0003+1R\"\u0001\n\t\u000be\\\u0002\u0019A>\t\u000f\u0005\u00151\u00041\u0001\u0002\n\u0005AAo\\*ue&tw\r\u0006\u0002\u0002 A!\u0011\u0011EA\u0015\u001d\u0011\t\u0019#!\n\u0011\u0005A\u0003\u0017bAA\u0014A\u00061\u0001K]3eK\u001aL1a\\A\u0016\u0015\r\t9\u0003Y\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002\u0014\u0005E\u00121\u0007\u0005\bsv\u0001\n\u00111\u0001|\u0011%\t)!\bI\u0001\u0002\u0004\tI!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e\"fA>\u0002<-\u0012\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003%)hn\u00195fG.,GMC\u0002\u0002H\u0001\f!\"\u00198o_R\fG/[8o\u0013\u0011\tY%!\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E#\u0006BA\u0005\u0003w\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAA-!\ry\u00161L\u0005\u0004\u0003;\u0002'aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA2\u0003S\u00022aXA3\u0013\r\t9\u0007\u0019\u0002\u0004\u0003:L\b\"CA6E\u0005\u0005\t\u0019AA-\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u000f\t\u0007\u0003g\nI(a\u0019\u000e\u0005\u0005U$bAA<A\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0014Q\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\n\u0005\u0005\u0005\"CA6I\u0005\u0005\t\u0019AA2\u0003!A\u0017m\u001d5D_\u0012,GCAA-\u0003\u0019)\u0017/^1mgR!\u0011\u0011BAF\u0011%\tYGJA\u0001\u0002\u0004\t\u0019'A\u0003QCJ\fW\u000eE\u0002\u0002\u0016!\u001aB\u0001KAJmBI\u0011QSANw\u0006%\u00111C\u0007\u0003\u0003/S1!!'a\u0003\u001d\u0011XO\u001c;j[\u0016LA!!(\u0002\u0018\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005=E#\u00015\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005M\u0011qUAU\u0011\u0015I8\u00061\u0001|\u0011\u001d\t)a\u000ba\u0001\u0003\u0013\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u00020\u0006m\u0006#B0\u00022\u0006U\u0016bAAZA\n1q\n\u001d;j_:\u0004baXA\\w\u0006%\u0011bAA]A\n1A+\u001e9mKJB\u0011\"!0-\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAb!\rI\u0017QY\u0005\u0004\u0003\u000fT'AB(cU\u0016\u001cG/\u0001\u0006qCJ\fW.\u001a;feN$\"!!4\u0011\r\u0005=\u0017Q[A\n\u001b\t\t\tNC\u0002\u0002T2\fA!\u001e;jY&!\u0011q[Ai\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\u0015\b]\u0005m\u00171_A{!\u0011\ti.a<\u000e\u0005\u0005}'\u0002BAq\u0003G\fQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BAs\u0003O\f!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\u0011\tI/a;\u0002\u000b),h.\u001b;\u000b\u0007\u00055\b(A\u0005uKN$X\u000f^5mg&!\u0011\u0011_Ap\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0005]\u0006lW-\t\u0002\u0002x\u0006\u00191\u0010M?\u0015\t\u0005m\u0018Q \t\u00039\u0002AQA\u0012\u0002A\u0002\u001d+\u0012A`\u0001\u0006kRLG\u000eI\u0001\u000bSN|&m\\;oI\u0016$\u0017aC5t?\n|WO\u001c3fI\u0002\naAY3g_J,GC\u0001B\u0006!\ry&QB\u0005\u0004\u0005\u001f\u0001'\u0001B+oSRD3a\u0002B\n!\u0011\u0011)B!\t\u000e\u0005\t]!\u0002\u0002B\r\u00057\t1!\u00199j\u0015\u0011\u0011iBa\b\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011\u001e\u001f\n\t\t\r\"q\u0003\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\t;fgR|\u0005\u000f^5p]N<\u0016\u000e\u001e5HY>\u0014\u0017\r\\\"p]\u001a$\u0015n]1cY\u0016$\u0007f\u0001\u0005\u0003*A!!Q\u0003B\u0016\u0013\u0011\u0011iCa\u0006\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\u00029Q,7\u000f^%og\u0016\u0014HoV5uQ\u0012Kh.Y7jG>\u0003H/[8og\"\u001a\u0011B!\u000b\u0002#Q,7\u000f^!qa\u0016tGm\u00149uS>t7\u000fK\u0002\u000b\u0005S\t1\u0003^3ti>3XM\u001d:jI\u0016|\u0005\u000f^5p]ND3a\u0003B\u0015\u0003m!Xm\u001d;K_&tw+\u001b;i\u0003B\u0004XM\u001c3fI>\u0003H/[8og\"\u001aAB!\u000b\u0002;Q,7\u000f\u001e&pS:<\u0016\u000e\u001e5Pm\u0016\u0014(/\u001b3eK:|\u0005\u000f^5p]ND3!\u0004B\u0015\u0003u!Xm\u001d;PaRLwN\\:IS:$xJ\u001c+bE2,\u0017\t]5WS\u0016<\bf\u0001\b\u0003*\u0005AB/Z:u\u001fB$\u0018n\u001c8t\u0011&tGo\u00148T#23\u0016.Z<)\u0007=\u0011I#A\ruKN$x\n\u001d;j_:\u001c\b*\u001b8u\u0013:\u001c\u0018\u000eZ3WS\u0016<\bf\u0001\t\u0003*!:\u0001A!\u0015\u0003^\t}\u0003\u0003\u0002B*\u00053j!A!\u0016\u000b\t\t]#qC\u0001\nKb$XM\\:j_:LAAa\u0017\u0003V\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\t\u00054E\u0001B2!\u0011\tiN!\u001a\n\t\t\u001d\u0014q\u001c\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\u001c")
public class OptionsHintTest
extends TableTestBase {
    private final TableTestUtil util;
    private final boolean is_bounded;

    @Parameters(name="{0}")
    public static Collection<Param> parameters() {
        return OptionsHintTest$.MODULE$.parameters();
    }

    public static String IS_BOUNDED() {
        return OptionsHintTest$.MODULE$.IS_BOUNDED();
    }

    private TableTestUtil util() {
        return this.util;
    }

    private boolean is_bounded() {
        return this.is_bounded;
    }

    @BeforeEach
    public void before() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n                     |create table t1(\n                     |  a int,\n                     |  b varchar,\n                     |  c as a + 1\n                     |) with (\n                     |  'connector' = 'OPTIONS',\n                     |  '").append(OptionsHintTest$.MODULE$.IS_BOUNDED()).append("' = '").append(this.is_bounded()).append("',\n                     |  'k1' = 'v1',\n                     |  'k2' = 'v2'\n                     |)\n       ").toString())).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(356).append("\n                     |create table t2(\n                     |  d int,\n                     |  e varchar,\n                     |  f bigint\n                     |) with (\n                     |  'connector' = 'OPTIONS',\n                     |  '").append(OptionsHintTest$.MODULE$.IS_BOUNDED()).append("' = '").append(this.is_bounded()).append("',\n                     |  'k3' = 'v3',\n                     |  'k4' = 'v4'\n                     |)\n       ").toString())).stripMargin());
    }

    @TestTemplate
    public void testOptionsWithGlobalConfDisabled() {
        this.util().tableEnv().getConfig().set(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("select * from t1/*+ OPTIONS(connector='COLLECTION', k2='#v2') */")).hasMessageContaining(new StringBuilder(49).append("OPTIONS hint is allowed only when ").append(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED.key()).append(" is set to true").toString()) instanceof ValidationException;
    }

    @TestTemplate
    public void testInsertWithDynamicOptions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |insert into t1 /*+ OPTIONS(k1='#v1', k5='v5') */\n         |select d, e from t2\n         |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        StatementSetImpl testStmtSet = (StatementSetImpl)stmtSet;
        PlannerBase plannerBase = this.util().getPlanner();
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(testStmtSet.getOperations()).map((Function1 & Serializable & scala.Serializable)modifyOperation -> plannerBase.translateToRel(modifyOperation), Buffer$.MODULE$.canBuildFrom());
        Assertions.assertThat((int)relNodes.length()).isOne();
        Predef$.MODULE$.assert(relNodes.head() instanceof LogicalLegacySink);
        LogicalLegacySink sink = (LogicalLegacySink)relNodes.head();
        Assertions.assertThat((String)((OptionsTableSink)sink.sink()).props().toString()).isEqualTo("{k1=#v1, k2=v2, k5=v5}");
    }

    @TestTemplate
    public void testAppendOptions() {
        this.util().verifyExecPlan("select * from t1/*+ OPTIONS(k5='v5', 'a.b.c'='fakeVal') */");
    }

    @TestTemplate
    public void testOverrideOptions() {
        this.util().verifyExecPlan("select * from t1/*+ OPTIONS(k1='#v1', k2='#v2') */");
    }

    @TestTemplate
    public void testJoinWithAppendedOptions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select * from\n         |t1 /*+ OPTIONS(k5='v5', 'a.b.c'='fakeVal') */\n         |join\n         |t2 /*+ OPTIONS(k6='v6', 'd.e.f'='fakeVal') */\n         |on t1.a = t2.d\n         |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinWithOverriddenOptions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select * from\n         |t1 /*+ OPTIONS(k1='#v1', k2='#v2') */\n         |join\n         |t2 /*+ OPTIONS(k3='#v3', k4='#v4') */\n         |on t1.a = t2.d\n         |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testOptionsHintOnTableApiView() {
        Table view1 = this.util().tableEnv().sqlQuery("select * from t1 join t2 on t1.a = t2.d");
        this.util().tableEnv().createTemporaryView("view1", view1);
        String sql = "select * from view1/*+ OPTIONS(k1='#v1', k2='#v2', k3='#v3', k4='#v4') */";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("View '`default_catalog`.`default_database`.`view1`' cannot be enriched with new options. Hints can only be applied to tables.") instanceof ValidationException;
    }

    @TestTemplate
    public void testOptionsHintOnSQLView() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("k1", "v1");
        props.put("k2", "v2");
        props.put("k3", "v3");
        props.put("k4", "v4");
        CatalogView view1 = CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.INT()), Column.physical((String)"b", (DataType)DataTypes.STRING()), Column.physical((String)"c", (DataType)DataTypes.INT()), Column.physical((String)"d", (DataType)DataTypes.INT()), Column.physical((String)"e", (DataType)DataTypes.STRING()), Column.physical((String)"f", (DataType)DataTypes.BIGINT())})).build(), (String)"a view table", (String)"select * from t1 join t2 on t1.a = t2.d", (String)"select * from t1 join t2 on t1.a = t2.d", props);
        Catalog catalog = (Catalog)this.util().tableEnv().getCatalog(this.util().tableEnv().getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(this.util().tableEnv().getCurrentDatabase(), "view1"), (CatalogBaseTable)view1, false);
        String sql = "select * from view1/*+ OPTIONS(k1='#v1', k2='#v2', k3='#v3', k4='#v4') */";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("View '`default_catalog`.`default_database`.`view1`' cannot be enriched with new options. Hints can only be applied to tables.") instanceof ValidationException;
    }

    @TestTemplate
    public void testOptionsHintInsideView() {
        this.util().tableEnv().executeSql("create view v1 as select * from t1 /*+ OPTIONS(k1='#v111', k4='#v444')*/");
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                           |select * from t2 join v1 on v1.a = t2.d\n                           |")).stripMargin());
    }

    public OptionsHintTest(Param param) {
        this.util = (TableTestUtil)param.utilSupplier().apply((Object)this);
        this.is_bounded = param.isBounded();
    }

    public static class Param
    implements Product,
    scala.Serializable {
        private final Function1<TableTestBase, TableTestUtil> utilSupplier;
        private final boolean isBounded;

        public Function1<TableTestBase, TableTestUtil> utilSupplier() {
            return this.utilSupplier;
        }

        public boolean isBounded() {
            return this.isBounded;
        }

        public String toString() {
            return new StringBuilder(1).append(OptionsHintTest$.MODULE$.IS_BOUNDED()).append("=").append(this.isBounded()).toString();
        }

        public Param copy(Function1<TableTestBase, TableTestUtil> utilSupplier, boolean isBounded) {
            return new Param(utilSupplier, isBounded);
        }

        public Function1<TableTestBase, TableTestUtil> copy$default$1() {
            return this.utilSupplier();
        }

        public boolean copy$default$2() {
            return this.isBounded();
        }

        public String productPrefix() {
            return "Param";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.utilSupplier();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isBounded());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Param;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.utilSupplier()));
            n = Statics.mix((int)n, (int)(this.isBounded() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Param)) return false;
            boolean bl = true;
            if (!bl) return false;
            Param param = (Param)x$1;
            Function1<TableTestBase, TableTestUtil> function1 = this.utilSupplier();
            Function1<TableTestBase, TableTestUtil> function12 = param.utilSupplier();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (this.isBounded() != param.isBounded()) return false;
            if (!param.canEqual(this)) return false;
            return true;
        }

        public Param(Function1<TableTestBase, TableTestUtil> utilSupplier, boolean isBounded) {
            this.utilSupplier = utilSupplier;
            this.isBounded = isBounded;
            Product.$init$((Product)this);
        }
    }
}

