/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.common.PartialInsertTest$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\f\u0019\u0001\u001dB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006k\u0001!\tA\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019A\u0005\u0001)A\u0005y!)\u0011\n\u0001C\u0001\u0015\")\u0011\f\u0001C\u0001\u0015\")1\f\u0001C\u0001\u0015\")Q\f\u0001C\u0001\u0015\")q\f\u0001C\u0001\u0015\")\u0011\r\u0001C\u0001\u0015\")1\r\u0001C\u0005I\")!\u000f\u0001C\u0001\u0015\")A\u000f\u0001C\u0001\u0015\")a\u000f\u0001C\u0001\u0015\")\u0001\u0010\u0001C\u0001\u0015\")!\u0010\u0001C\u0001\u0015\")A\u0010\u0001C\u0001\u0015\")a\u0010\u0001C\u0001\u0015\u001e9\u00111\u0006\r\t\u0002\u00055bAB\f\u0019\u0011\u0003\ty\u0003\u0003\u00046)\u0011\u0005\u0011q\u0007\u0005\b\u0003s!B\u0011AA\u001e\u0005E\u0001\u0016M\u001d;jC2Len]3siR+7\u000f\u001e\u0006\u00033i\taaY8n[>t'BA\u000e\u001d\u0003\u0011\u0001H.\u00198\u000b\u0005uq\u0012a\u00029mC:tWM\u001d\u0006\u0003?\u0001\nQ\u0001^1cY\u0016T!!\t\u0012\u0002\u000b\u0019d\u0017N\\6\u000b\u0005\r\"\u0013AB1qC\u000eDWMC\u0001&\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!F\u0003\u0002,9\u0005)Q\u000f^5mg&\u0011QF\u000b\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\u000f%\u001c()\u0019;dQB\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u00028sA\u0011\u0001\bA\u0007\u00021!)aF\u0001a\u0001_\u0005!Q\u000f^5m+\u0005a$\u0003B\u001f@\u0005\u00163AA\u0010\u0001\u0001y\taAH]3gS:,W.\u001a8u}A\u0011\u0011\u0006Q\u0005\u0003\u0003*\u0012Q\u0002V1cY\u0016$Vm\u001d;Vi&d\u0007C\u0001\u0019D\u0013\t!\u0015GA\u0004Qe>$Wo\u0019;\u0011\u0005A2\u0015BA$2\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015)H/\u001b7!\u0003\r\"Xm\u001d;QCJ$\u0018.\u00197J]N,'\u000f^,ji\"\u001cu.\u001c9mKb\u0014Vm\u001c:eKJ$\u0012a\u0013\t\u0003a1K!!T\u0019\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u000b=\u0003\"\u0001U,\u000e\u0003ES!AU*\u0002\u0007\u0005\u0004\u0018N\u0003\u0002U+\u00069!.\u001e9ji\u0016\u0014(B\u0001,%\u0003\u0015QWO\\5u\u0013\tA\u0016K\u0001\u0007UKN$H+Z7qY\u0006$X-\u0001\u001buKN$\b+\u0019:uS\u0006d\u0017J\\:feR<\u0016\u000e\u001e5D_6\u0004H.\u001a=SK>\u0014H-\u001a:B]\u0012\u001cu.\u001c9vi\u0016$7i\u001c7v[:D#AB(\u00025Q,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014HoV5uQVs\u0017n\u001c8)\u0005\u001dy\u0015!\b;fgR\u0004\u0016M\u001d;jC2Len]3si^KG\u000f[+oS>t\u0017\t\u001c7)\u0005!y\u0015!\t;fgR\u0004\u0016M\u001d;jC2Len]3si^KG\u000f[%oi\u0016\u00148/Z2u\u00032d\u0007FA\u0005P\u0003y!Xm\u001d;QCJ$\u0018.\u00197J]N,'\u000f^,ji\",\u0005pY3qi\u0006cG\u000e\u000b\u0002\u000b\u001f\u0006\u0001C/Z:u!\u0006\u0014H/[1m\u0013:\u001cXM\u001d;XSRD7+\u001a;Pa\u0016\u0014\u0018\r^8s)\tYU\rC\u0003g\u0017\u0001\u0007q-\u0001\u0005pa\u0016\u0014\u0018\r^8s!\tAwN\u0004\u0002j[B\u0011!.M\u0007\u0002W*\u0011ANJ\u0001\u0007yI|w\u000e\u001e \n\u00059\f\u0014A\u0002)sK\u0012,g-\u0003\u0002qc\n11\u000b\u001e:j]\u001eT!A\\\u0019\u0002GQ,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014HoV5uQVs\u0017n\u001c8BY2tUm\u001d;fI\"\u0012AbT\u0001\u001di\u0016\u001cH\u000fU1si&\fG.\u00138tKJ$x+\u001b;i\u001fJ$WM\u001d\"zQ\tiq*\u0001\u0014uKN$\b+\u0019:uS\u0006d\u0017J\\:feR<\u0016\u000e\u001e5QKJ\u001c\u0018n\u001d;fI6+G/\u00193bi\u0006D#AD(\u0002UQ,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014HoV5uQZK'\u000f^;bY6+G/\u0019#bi\u0006\u001cu\u000e\\;n]\"\u0012qbT\u0001$i\u0016\u001cH\u000fU1si&\fG.\u00138tKJ$x+\u001b;i\u0007>l\u0007/\u001e;fI\u000e{G.^7oQ\t\u0001r*\u0001\u000fuKN$\b+\u0019:uS\u0006d\u0017J\\:feR<\u0016\u000e\u001e5He>,\bOQ=)\u0005Ey\u0015A\b;fgR\u0004\u0016M\u001d;jC2Len]3si\u000e{W\u000e]8tSR,G+\u001f9fQ\t\u0011r\nK\u0004\u0001\u0003\u0007\ty!!\u0005\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003R\u0003%)\u0007\u0010^3og&|g.\u0003\u0003\u0002\u000e\u0005\u001d!AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\u0012\u00111C\u0012\u0003\u0003+\u0001B!a\u0006\u0002(5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0005\u0003?\t\t#\u0001\u0006fqR,gn]5p]NT1AVA\u0012\u0015\r\t)\u0003I\u0001\ni\u0016\u001cH/\u001e;jYNLA!!\u000b\u0002\u001a\tQ\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;FqR,gn]5p]\u0006\t\u0002+\u0019:uS\u0006d\u0017J\\:feR$Vm\u001d;\u0011\u0005a\"2c\u0001\u000b\u00022A\u0019\u0001'a\r\n\u0007\u0005U\u0012G\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003[\t!\u0002]1sC6,G/\u001a:t)\t\ti\u0004E\u0003\u0002@\u0005\u001ds&\u0004\u0002\u0002B)\u0019!(a\u0011\u000b\u0005\u0005\u0015\u0013\u0001\u00026bm\u0006LA!!\u0013\u0002B\tQ1i\u001c7mK\u000e$\u0018n\u001c8)\u000fY\ti%a\u0015\u0002VA!\u0011qCA(\u0013\u0011\t\t&!\u0007\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\u0003oC6,\u0017EAA,\u00031I7OQ1uG\"T\u0004e\u001f\u0019~\u0001")
public class PartialInsertTest
extends TableTestBase {
    private final TableTestUtil util;

    @Parameters(name="isBatch: {0}")
    public static Collection<Object> parameters() {
        return PartialInsertTest$.MODULE$.parameters();
    }

    private TableTestUtil util() {
        return this.util;
    }

    @TestTemplate
    public void testPartialInsertWithComplexReorder() {
        this.util().verifyRelPlanInsert("INSERT INTO sink (b,e,a,g,f,c,d) SELECT b,e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e");
    }

    @TestTemplate
    public void testPartialInsertWithComplexReorderAndComputedColumn() {
        this.util().verifyRelPlanInsert("INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e");
    }

    @TestTemplate
    public void testPartialInsertWithUnion() {
        this.testPartialInsertWithSetOperator("UNION");
    }

    @TestTemplate
    public void testPartialInsertWithUnionAll() {
        this.testPartialInsertWithSetOperator("UNION ALL");
    }

    @TestTemplate
    public void testPartialInsertWithIntersectAll() {
        this.testPartialInsertWithSetOperator("INTERSECT ALL");
    }

    @TestTemplate
    public void testPartialInsertWithExceptAll() {
        this.testPartialInsertWithSetOperator("EXCEPT ALL");
    }

    private void testPartialInsertWithSetOperator(String operator) {
        this.util().verifyRelPlanInsert(new StringBuilder(154).append("INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e ").append(operator).append(" ").append("SELECT e,a,789,456,c,d FROM MyTable GROUP BY a,b,c,d,e ").toString());
    }

    @TestTemplate
    public void testPartialInsertWithUnionAllNested() {
        this.util().verifyRelPlanInsert("INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e UNION ALL SELECT e,a,789,456,c,d FROM MyTable GROUP BY a,b,c,d,e UNION ALL SELECT e,a,123,456,c,d FROM MyTable GROUP BY a,b,c,d,e ");
    }

    @TestTemplate
    public void testPartialInsertWithOrderBy() {
        this.util().verifyRelPlanInsert("INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable ORDER BY a,e,c,d");
    }

    @TestTemplate
    public void testPartialInsertWithPersistedMetadata() {
        this.util().verifyRelPlanInsert("INSERT INTO metadata_sink (a,b,c,d,e,f) SELECT a,b,c,d,e,123 FROM MyTable");
    }

    @TestTemplate
    public void testPartialInsertWithVirtualMetaDataColumn() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlanInsert("INSERT INTO metadata_sink (a,b,c,d,e,g) SELECT a,b,c,d,e,123 FROM MyTable")).hasMessageContaining("SQL validation failed. At line 1, column 38: Unknown target column 'g'") instanceof ValidationException;
    }

    @TestTemplate
    public void testPartialInsertWithComputedColumn() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlanInsert("INSERT INTO metadata_sink (a,b,c,d,e,h) SELECT a,b,c,d,e,123 FROM MyTable")).hasMessageContaining("SQL validation failed. At line 1, column 38: Unknown target column 'h'") instanceof ValidationException;
    }

    @TestTemplate
    public void testPartialInsertWithGroupBy() {
        this.util().verifyExplainInsert("INSERT INTO partitioned_sink (e,a,d) SELECT e,a,d FROM MyTable GROUP BY a,b,c,d,e");
    }

    @TestTemplate
    public void testPartialInsertCompositeType() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExplainInsert("INSERT INTO complex_type_sink (a,b.b1,c.c2,f) SELECT a,b.b1,c.c2,f FROM complex_type_src"));
    }

    public PartialInsertTest(boolean isBatch) {
        this.util = isBatch ? this.batchTestUtil(this.batchTestUtil$default$1()) : this.streamTestUtil(this.streamTestUtil$default$1());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}), new CaseClassTypeInfo<Tuple5<Object, String, String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, String, String, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, String, String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, String, String, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, String, String, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.common.PartialInsertTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |create table sink (\n                              |  `a` INT,\n                              |  `b` STRING,\n                              |  `c` STRING,\n                              |  `d` STRING,\n                              |  `e` DOUBLE,\n                              |  `f` BIGINT,\n                              |  `g` INT\n                              |) with (\n                              |  'connector' = 'values',\n                              |  'sink-insert-only' = 'false'\n                              |)\n                              |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |create table partitioned_sink (\n                              |  `a` INT,\n                              |  `b` AS `a` + 1,\n                              |  `c` STRING,\n                              |  `d` STRING,\n                              |  `e` DOUBLE,\n                              |  `f` BIGINT,\n                              |  `g` INT\n                              |) PARTITIONED BY (`c`, `d`) with (\n                              |  'connector' = 'values',\n                              |  'sink-insert-only' = 'false'\n                              |)\n                              |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |create table complex_type_src (\n                              |  `a` BIGINT,\n                              |  `b` ROW<b1 STRING, b2 INT>,\n                              |  `c` ROW<c1 BIGINT, c2 STRING>,\n                              |  `d` MAP<STRING, STRING>,\n                              |  `e` DOUBLE,\n                              |  `f` BIGINT,\n                              |  `g` INT\n                              |) with (\n                              |  'connector' = 'values'\n                              |)\n                              |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |create table complex_type_sink (\n                              |  `a` BIGINT,\n                              |  `b` ROW<b1 STRING, b2 INT>,\n                              |  `c` ROW<c1 BIGINT, c2 STRING>,\n                              |  `d` MAP<STRING, STRING>,\n                              |  `e` DOUBLE,\n                              |  `f` BIGINT METADATA,\n                              |  `g` INT,\n                              |  primary key (`a`) not enforced\n                              |) with (\n                              |  'connector' = 'values',\n                              |  'sink-insert-only' = 'false',\n                              |  'writable-metadata' = 'f:bigint'\n                              |)\n                              |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("create table metadata_sink (\n                              |  `a` INT,\n                              |  `b` STRING,\n                              |  `c` STRING,\n                              |  `d` STRING,\n                              |  `e` DOUBLE,\n                              |  `f` BIGINT METADATA,\n                              |  `g` INT METADATA VIRTUAL,\n                              |  `h` AS `a` + 1\n                              |) with (\n                              |  'connector' = 'values',\n                              |  'sink-insert-only' = 'false',\n                              |  'writable-metadata' = 'f:BIGINT, g:INT'\n                              |)")).stripMargin());
    }
}

