/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.join;

import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000113A!\u0003\u0006\u0001;!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001b\u0001\n\u0003I\u0003BB\u0017\u0001A\u0003%!\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u0003B\u0001\u0011\u0005q\u0006C\u0003G\u0001\u0011\u0005q\u0006C\u0003I\u0001\u0011\u0005q\u0006C\u0003K\u0001\u0011\u0005qF\u0001\tUK6\u0004xN]1m\u0015>Lg\u000eV3ti*\u00111\u0002D\u0001\u0005U>LgN\u0003\u0002\u000e\u001d\u0005\u00191/\u001d7\u000b\u0005=\u0001\u0012!\u00022bi\u000eD'BA\t\u0013\u0003\u0011\u0001H.\u00198\u000b\u0005M!\u0012a\u00029mC:tWM\u001d\u0006\u0003+Y\tQ\u0001^1cY\u0016T!a\u0006\r\u0002\u000b\u0019d\u0017N\\6\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0004\u0005\u0002 E5\t\u0001E\u0003\u0002\"%\u0005)Q\u000f^5mg&\u00111\u0005\t\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0014\u0001\u001b\u0005Q\u0011\u0001B;uS2,\u0012A\u000b\t\u0003?-J!\u0001\f\u0011\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\\\u0001\u0006kRLG\u000eI\u0001\u0007E\u00164wN]3\u0015\u0003A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012A!\u00168ji\"\u0012Aa\u000e\t\u0003q}j\u0011!\u000f\u0006\u0003um\n1!\u00199j\u0015\taT(A\u0004kkBLG/\u001a:\u000b\u0005yR\u0012!\u00026v]&$\u0018B\u0001!:\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u000fi\u0016\u001cHoU5na2,'j\\5oQ\t)1\t\u0005\u00029\t&\u0011Q)\u000f\u0002\u0005)\u0016\u001cH/\u0001\u0012uKN$8+[7qY\u0016\u0014vn\u001e;j[\u00164VM]:j_:,GMV5fo*{\u0017N\u001c\u0015\u0003\r\r\u000b1\u0005^3tiNKW\u000e\u001d7f!J|7\r^5nKZ+'o]5p]\u0016$g+[3x\u0015>Lg\u000e\u000b\u0002\b\u0007\u0006QB/Z:u'&l\u0007\u000f\\3WS\u0016<\bK]8d)&lWMS8j]\"\u0012\u0001b\u0011")
public class TemporalJoinTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE Orders (\n                    | o_amount INT,\n                    | o_currency STRING,\n                    | o_rowtime TIMESTAMP(3),\n                    | o_proctime as PROCTIME(),\n                    | WATERMARK FOR o_rowtime AS o_rowtime\n                    |) WITH (\n                    | 'connector' = 'values',\n                    | 'bounded' = 'true'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE RatesHistory (\n                    | currency STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'values',\n                    | 'bounded' = 'true'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE RatesHistoryWithPK (\n                    | currency STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime,\n                    | PRIMARY KEY(currency) NOT ENFORCED\n                    |) WITH (\n                    | 'connector' = 'values',\n                    | 'bounded' = 'true'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE RatesOnly (\n                    | currency STRING,\n                    | rate INT,\n                    | proctime AS PROCTIME()\n                    |) WITH (\n                    | 'connector' = 'values',\n                    | 'bounded' = 'true'\n                    |)\n      ")).stripMargin());
        this.util().addTable(" CREATE VIEW rates_last_row_rowtime as SELECT currency, rate, rowtime FROM   (SELECT *,           ROW_NUMBER() OVER (PARTITION BY currency ORDER BY rowtime DESC) AS rowNum    FROM RatesHistory  ) T   WHERE rowNum = 1");
        this.util().addTable(" CREATE VIEW rates_last_row_proctime as SELECT currency, rate, proctime FROM   (SELECT *,           ROW_NUMBER() OVER (PARTITION BY currency ORDER BY proctime DESC) AS rowNum    FROM RatesOnly  ) T  WHERE rowNum = 1");
        this.util().addTable("CREATE VIEW rates_last_value AS SELECT currency, LAST_VALUE(rate) AS rate FROM RatesHistory GROUP BY currency ");
    }

    @Test
    public void testSimpleJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o JOIN RatesHistoryWithPK FOR SYSTEM_TIME AS OF o.o_rowtime as r on o.o_currency = r.currency";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testSimpleRowtimeVersionedViewJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o JOIN rates_last_row_rowtime FOR SYSTEM_TIME AS OF o.o_rowtime as r1 on o.o_currency = r1.currency";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testSimpleProctimeVersionedViewJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o JOIN rates_last_row_proctime FOR SYSTEM_TIME AS OF o.o_proctime as r1 on o.o_currency = r1.currency";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testSimpleViewProcTimeJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o JOIN rates_last_value FOR SYSTEM_TIME AS OF o.o_proctime as r1 on o.o_currency = r1.currency";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }
}

