/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.join.LookupJoinTest$;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001\u0002\u000e\u001c\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013%!\b\u0003\u0004?\u0001\u0001\u0006Ia\u000f\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006%\u0002!\t\u0001\u0011\u0005\u0006/\u0002!\t\u0001\u0011\u0005\u00063\u0002!\t\u0001\u0011\u0005\u00067\u0002!\t\u0001\u0011\u0005\u0006;\u0002!\t\u0001\u0011\u0005\u0006?\u0002!\t\u0001\u0011\u0005\u0006C\u0002!\t\u0001\u0011\u0005\u0006G\u0002!\t\u0001\u0011\u0005\u0006K\u0002!\t\u0001\u0011\u0005\u0006O\u0002!\t\u0001\u0011\u0005\u0006S\u0002!\t\u0001\u0011\u0005\u0006W\u0002!\t\u0001\u0011\u0005\u0006[\u0002!\t\u0001\u0011\u0005\u0006_\u0002!\t\u0001\u0011\u0005\u0006c\u0002!\t\u0001\u0011\u0005\u0006g\u0002!\t\u0001\u0011\u0005\u0006k\u0002!\t\u0001\u0011\u0005\u0006o\u0002!\t\u0001\u0011\u0005\u0006s\u0002!\t\u0001\u0011\u0005\u0006w\u0002!I\u0001 \u0005\n\u0003\u000b\u0002\u0011\u0013!C\u0005\u0003\u000f\u0012a\u0002T8pWV\u0004(j\\5o)\u0016\u001cHO\u0003\u0002\u001d;\u0005!!n\\5o\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000b\t\fGo\u00195\u000b\u0005\t\u001a\u0013\u0001\u00029mC:T!\u0001J\u0013\u0002\u000fAd\u0017M\u001c8fe*\u0011aeJ\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003Q%\nQA\u001a7j].T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011C\u0001\u00010!\t\u00014'D\u00012\u0015\t\u00114%A\u0003vi&d7/\u0003\u00025c\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u001c\u0011\u0005a\u0002Q\"A\u000e\u0002\u0011Q,7\u000f^+uS2,\u0012a\u000f\t\u0003aqJ!!P\u0019\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\\\u0001\ni\u0016\u001cH/\u0016;jY\u0002\naAY3g_J,G#A!\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t!\u0003\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\u0007\u0005\u0004\u0018N\u0003\u0002N\u001d\u00069!.\u001e9ji\u0016\u0014(BA(,\u0003\u0015QWO\\5u\u0013\t\t&J\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0005^3ti*{\u0017N\\%om\u0006d\u0017\u000e\u001a&pS:$V-\u001c9pe\u0006dG+\u00192mK\"\u0012Q\u0001\u0016\t\u0003\u0013VK!A\u0016&\u0003\tQ+7\u000f^\u0001#i\u0016\u001cHOT8u\t&\u001cH/\u001b8di\u001a\u0013x.\\%o\u0015>LgnQ8oI&$\u0018n\u001c8)\u0005\u0019!\u0016\u0001\b;fgR\u0004\u0016\u0010\u001e5p]V#e)\u00138K_&t7i\u001c8eSRLwN\u001c\u0015\u0003\u000fQ\u000bq\u0002^3ti2{w-[2bYBc\u0017M\u001c\u0015\u0003\u0011Q\u000b1\u0005^3ti2{w-[2bYBc\u0017M\\,ji\"LU\u000e\u001d7jG&$H+\u001f9f\u0007\u0006\u001cH\u000f\u000b\u0002\n)\u0006)B/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,\u0007F\u0001\u0006U\u0003e!Xm\u001d;MK\u001a$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3)\u0005-!\u0016\u0001\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"tUm\u001d;fIF+XM]=)\u00051!\u0016a\u000b;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"\u0004&o\u001c6fGRLwN\u001c)vg\"$un\u001e8)\u00055!\u0016a\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"4\u0015\u000e\u001c;feB+8\u000f\u001b#po:D#A\u0004+\u00025Q,7\u000f^!w_&$\u0017iZ4sK\u001e\fG/\u001a)vg\"$un\u001e8)\u0005=!\u0016A\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"$&/^3D_:$\u0017\u000e^5p]\"\u0012\u0001\u0003V\u0001(i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\bnQ8naV$X\rZ\"pYVlg\u000e\u000b\u0002\u0012)\u0006\u0011D/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0007>l\u0007/\u001e;fI\u000e{G.^7o\u0003:$\u0007+^:i\t><h\u000e\u000b\u0002\u0013)\u0006YA/Z:u%\u0016,8/\u001b8hQ\t\u0019B+\u0001\u0016uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD7\u000b[;gM2,Gj\\8lkBD\u0015N\u001c;)\u0005Q!\u0016!\f;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"tu\u000e^*ik\u001a4G.\u001a'p_.,\b\u000fS5oi\"\u0012Q\u0003V\u0001;i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\bn\u00155vM\u001adW\rT8pWV\u0004\b*\u001b8u\u000b6\u0004H/\u001f)beRLG/[8oKJD#A\u0006+\u0002mQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b(p]\u0012+G/\u001a:nS:L7\u000f^5d\u0007V\u001cHo\\7TQV4g\r\\3)\u0005]!\u0016!F3ya\u0016\u001cG/\u0012=dKB$\u0018n\u001c8UQJ|wO\u001c\u000b\u0007\u0003v\f\u0019\"a\u0006\t\u000byA\u0002\u0019\u0001@\u0011\u0007}\fiA\u0004\u0003\u0002\u0002\u0005%\u0001cAA\u0002\u00076\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fi\u0013A\u0002\u001fs_>$h(C\u0002\u0002\f\r\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0003#\u0011aa\u0015;sS:<'bAA\u0006\u0007\"1\u0011Q\u0003\rA\u0002y\f\u0001b[3zo>\u0014Hm\u001d\u0005\n\u00033A\u0002\u0013!a\u0001\u00037\tQa\u00197buj\u0004D!!\b\u0002(A)q0a\b\u0002$%!\u0011\u0011EA\t\u0005\u0015\u0019E.Y:t!\u0011\t)#a\n\r\u0001\u0011a\u0011\u0011FA\f\u0003\u0003\u0005\tQ!\u0001\u0002,\t\u0019q\fJ\u0019\u0012\t\u00055\u00121\u0007\t\u0004\u0005\u0006=\u0012bAA\u0019\u0007\n9aj\u001c;iS:<\u0007\u0003BA\u001b\u0003\u007fqA!a\u000e\u0002<9!\u00111AA\u001d\u0013\u0005!\u0015bAA\u001f\u0007\u00069\u0001/Y2lC\u001e,\u0017\u0002BA!\u0003\u0007\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005u2)A\u0010fqB,7\r^#yG\u0016\u0004H/[8o)\"\u0014xn\u001e8%I\u00164\u0017-\u001e7uIM*\"!!\u00131\t\u0005-\u0013q\n\t\u0006\u007f\u0006}\u0011Q\n\t\u0005\u0003K\ty\u0005B\u0006\u0002*e\t\t\u0011!A\u0003\u0002\u0005-\u0002")
public class LookupJoinTest
extends TableTestBase {
    private final BatchTableTestUtil testUtil = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil testUtil() {
        return this.testUtil;
    }

    @BeforeEach
    public void before() {
        this.testUtil().addDataStream("T0", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.join.LookupJoinTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.testUtil().addDataStream("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.join.LookupJoinTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.testUtil().addDataStream("nonTemporal", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.join.LookupJoinTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        Table myTable = this.testUtil().tableEnv().sqlQuery("SELECT *, PROCTIME() as proctime FROM T0");
        this.testUtil().tableEnv().createTemporaryView("MyTable", myTable);
        this.testUtil().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                        |CREATE TABLE LookupTable (\n                        |  `id` INT,\n                        |  `name` STRING,\n                        |  `age` INT\n                        |) WITH (\n                        |  'connector' = 'values',\n                        |  'bounded' = 'true'\n                        |)\n                        |")).stripMargin());
        this.testUtil().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                        |CREATE TABLE LookupTableWithComputedColumn (\n                        |  `id` INT,\n                        |  `name` STRING,\n                        |  `age` INT,\n                        |  `nominal_age` as age + 1\n                        |) WITH (\n                        |  'connector' = 'values',\n                        |  'bounded' = 'true'\n                        |)\n                        |")).stripMargin());
        this.testUtil().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                        |CREATE TABLE LookupTableWithCustomShuffle1 (\n                        |  `id` INT,\n                        |  `name` STRING,\n                        |  `age` INT,\n                        |  PRIMARY KEY(id) NOT ENFORCED\n                        |) WITH (\n                        |  'connector' = 'values',\n                        |  'enable-custom-shuffle' = 'true',\n                        |  'bounded' = 'true'\n                        |)\n                        |")).stripMargin());
        this.testUtil().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                        |CREATE TABLE LookupTableWithCustomShuffle2 (\n                        |  `id` INT,\n                        |  `name` STRING,\n                        |  `age` INT,\n                        |  PRIMARY KEY(id) NOT ENFORCED\n                        |) WITH (\n                        |  'connector' = 'values',\n                        |  'enable-custom-shuffle' = 'true',\n                        |  'bounded' = 'true',\n                        |  'custom-shuffle-deterministic' = 'false'\n                        |)\n                        |")).stripMargin());
        this.testUtil().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                        |CREATE TABLE LookupTableWithCustomShuffle3 (\n                        |  `id` INT,\n                        |  `name` STRING,\n                        |  `age` INT,\n                        |  PRIMARY KEY(id) NOT ENFORCED\n                        |) WITH (\n                        |  'connector' = 'values',\n                        |  'enable-custom-shuffle' = 'true',\n                        |  'bounded' = 'true',\n                        |  'custom-shuffle-empty-partitioner' = 'true'\n                        |\n                        |)\n                        |")).stripMargin());
    }

    @Test
    public void testJoinInvalidJoinTemporalTable() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T JOIN LookupTable T.proc AS D ON T.a = D.id", "SQL parse failed", SqlParserException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T RIGHT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id", null, AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a + 1 = D.id + 1", "Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable].", TableException.class);
    }

    @Test
    public void testNotDistinctFromInJoinCondition() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a IS NOT  DISTINCT FROM D.id", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id OR (T.a IS NULL AND D.id IS NULL)", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
    }

    @Test
    public void testPythonUDFInJoinCondition() {
        this.testUtil().addTemporarySystemFunction("pyFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc"));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |LEFT OUTER JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10 AND pyFunc(D.age, T.a) > 100\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.testUtil().verifyExecPlan(sql)).hasMessageContaining("Only inner join condition with equality predicates supports the Python UDF taking the inputs from the left table and the right table at the same time, e.g., ON T1.id = T2.id && pythonUdf(T1.a, T2.b)") instanceof TableException;
    }

    @Test
    public void testLogicalPlan() {
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proctime\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(157).append("\n         |SELECT T.* FROM (").append(sql1).append(") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      ").toString())).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n         |SELECT b, count(a), sum(c), sum(d)\n         |FROM (").append(sql2).append(") AS T\n         |GROUP BY b\n      ").toString())).stripMargin();
        FlinkChainedProgram programs = FlinkBatchProgram$.MODULE$.buildProgram((ReadableConfig)this.testUtil().tableEnv().getConfig());
        programs.remove(FlinkBatchProgram$.MODULE$.PHYSICAL());
        this.testUtil().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.testUtil().verifyRelPlan(sql);
    }

    @Test
    public void testLogicalPlanWithImplicitTypeCast() {
        FlinkChainedProgram programs = FlinkBatchProgram$.MODULE$.buildProgram((ReadableConfig)this.testUtil().tableEnv().getConfig());
        programs.remove(FlinkBatchProgram$.MODULE$.PHYSICAL());
        this.testUtil().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.testUtil().verifyRelPlan("SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.b = D.id")).hasMessageContaining("implicit type conversion between VARCHAR(2147483647) and INTEGER is not supported on join's condition now") instanceof TableException;
    }

    @Test
    public void testJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithNestedQuery() {
        String sql = "SELECT * FROM (SELECT a, b, proctime FROM MyTable WHERE c > 1000) AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithProjectionPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T.*, D.id\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithFilterPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidAggregatePushDown() {
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proctime\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(157).append("\n         |SELECT T.* FROM (").append(sql1).append(") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      ").toString())).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n         |SELECT b, count(a), sum(c), sum(d)\n         |FROM (").append(sql2).append(") AS T\n         |GROUP BY b\n      ").toString())).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithTrueCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON true\n        |WHERE T.c > 1000\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.testUtil().verifyExplain(sql)).hasMessageContaining("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable]") instanceof TableException;
    }

    @Test
    public void testJoinTemporalTableWithComputedColumn() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id and D.nominal_age > 12\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testReusing() {
        this.testUtil().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proctime\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n         |SELECT * FROM (").append(sql1).append(") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      ").toString())).stripMargin();
        String sql3 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n         |SELECT id as a, b FROM (").append(sql2).append(") AS T\n       ").toString())).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n         |SELECT count(T1.a), count(T1.id), sum(T2.a)\n         |FROM (").append(sql2).append(") AS T1, (").append(sql3).append(") AS T2\n         |WHERE T1.a = T2.a\n         |GROUP BY T1.b, T2.b\n      ").toString())).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithShuffleLookupHint() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ * FROM MyTable AS T JOIN LookupTableWithCustomShuffle1 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExplain(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinTemporalTableWithNotShuffleLookupHint() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'shuffle'='false') */ * FROM MyTable AS T JOIN LookupTableWithCustomShuffle1 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExplain(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinTemporalTableWithShuffleLookupHintEmptyPartitioner() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ * FROM MyTable AS T JOIN LookupTableWithCustomShuffle3 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExplain(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testJoinTemporalTableWithNonDeterministicCustomShuffle() {
        String sql = "SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ * FROM MyTable AS T JOIN LookupTableWithCustomShuffle2 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExplain(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    private void expectExceptionThrown(String sql, String keywords, Class<? extends Throwable> clazz) {
        ThrowableAssert.ThrowingCallable callable = () -> this.testUtil().verifyExplain(sql);
        if (keywords != null) {
            Assertions.assertThatExceptionOfType(clazz).isThrownBy(callable).withMessageContaining(keywords);
            return;
        }
        Assertions.assertThatExceptionOfType(clazz).isThrownBy(callable);
    }

    private Class<? extends Throwable> expectExceptionThrown$default$3() {
        return ValidationException.class;
    }
}

