/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple10;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0015+\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\u0006\u001d\u0002!\ta\u0014\u0005\u0006C\u0002!\ta\u0014\u0005\u0006G\u0002!\ta\u0014\u0005\u0006K\u0002!\ta\u0014\u0005\u0006O\u0002!\ta\u0014\u0005\u0006S\u0002!\ta\u0014\u0005\u0006W\u0002!\ta\u0014\u0005\u0006[\u0002!\ta\u0014\u0005\u0006_\u0002!\ta\u0014\u0005\u0006c\u0002!\ta\u0014\u0005\u0006g\u0002!\ta\u0014\u0005\u0006k\u0002!\ta\u0014\u0005\u0006o\u0002!\ta\u0014\u0005\u0006s\u0002!\ta\u0014\u0005\u0006w\u0002!\ta\u0014\u0005\u0006{\u0002!\ta\u0014\u0005\u0006\u007f\u0002!\ta\u0014\u0005\u0007\u0003\u0007\u0001A\u0011A(\t\r\u0005\u001d\u0001\u0001\"\u0001P\u0011\u0019\tY\u0001\u0001C\u0001\u001f\"1\u0011q\u0002\u0001\u0005\u0002=Ca!a\u0005\u0001\t\u0003y\u0005BBA\f\u0001\u0011\u0005q\n\u0003\u0004\u0002\u001c\u0001!\ta\u0014\u0005\u0007\u0003?\u0001A\u0011A(\t\r\u0005\r\u0002\u0001\"\u0001P\u0011\u0019\t9\u0003\u0001C\u0001\u001f\"1\u00111\u0006\u0001\u0005\u0002=Ca!a\f\u0001\t\u0003y\u0005BBA\u001a\u0001\u0011\u0005q\n\u0003\u0004\u00028\u0001!\ta\u0014\u0005\u0007\u0003w\u0001A\u0011A(\t\r\u0005}\u0002\u0001\"\u0001P\u0011\u0019\t\u0019\u0005\u0001C\u0001\u001f\"1\u0011q\t\u0001\u0005\u0002=Ca!a\u0013\u0001\t\u0003y\u0005bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0002\u0011\u000fJ|W\u000f]5oON+Go\u001d+fgRT!a\u000b\u0017\u0002\u0007\u0005<wM\u0003\u0002.]\u0005\u00191/\u001d7\u000b\u0005=\u0002\u0014!\u00022bi\u000eD'BA\u00193\u0003\u0011\u0001H.\u00198\u000b\u0005M\"\u0014a\u00029mC:tWM\u001d\u0006\u0003kY\nQ\u0001^1cY\u0016T!a\u000e\u001d\u0002\u000b\u0019d\u0017N\\6\u000b\u0005eR\u0014AB1qC\u000eDWMC\u0001<\u0003\ry'oZ\u0002\u0001'\t\u0001a\b\u0005\u0002@\u00056\t\u0001I\u0003\u0002Be\u0005)Q\u000f^5mg&\u00111\t\u0011\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u00051\u0005CA$\u0001\u001b\u0005Q\u0013\u0001B;uS2,\u0012A\u0013\t\u0003\u007f-K!\u0001\u0014!\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\\\u0001\u0006kRLG\u000eI\u0001\u0011i\u0016\u001cHo\u0012:pkBLgnZ*fiN$\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0002'\u0006)1oY1mC&\u0011QK\u0015\u0002\u0005+:LG\u000f\u000b\u0002\u0005/B\u0011\u0001lX\u0007\u00023*\u0011!lW\u0001\u0004CBL'B\u0001/^\u0003\u001dQW\u000f]5uKJT!A\u0018\u001e\u0002\u000b),h.\u001b;\n\u0005\u0001L&\u0001\u0002+fgR\f\u0011\u0003^3ti\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:3Q\t)q+A\tuKN$xI]8va&twmU3ugNB#AB,\u0002EQ,7\u000f^$s_V\u0004\u0018N\\4TKR\u001cx*\u001e;qkR\u001ch*\u001e7mC\nLG.\u001b;zQ\t9q+\u0001\u0005uKN$8)\u001e2fQ\tAq+\u0001\u0006uKN$(k\u001c7mkBD#!C,\u0002?Q,7\u000f^$s_V\u0004\u0018N\\4TKR\u001cx+\u001b;i\u001f:,wI]8va&tw\r\u000b\u0002\u000b/\u0006)B/Z:u\u0005\u0006\u001c\u0018nY$s_V\u0004\u0018N\\4TKR\u001c\bFA\u0006X\u0003q!Xm\u001d;He>,\b/\u001b8h'\u0016$8o\u00148FqB\u0014Xm]:j_:D#\u0001D,\u0002\u001dQ,7\u000f^*j[BdWmQ;cK\"\u0012QbV\u0001\u0014i\u0016\u001cHOU8mYV\u0004xJ\\\u0019D_2,XN\u001c\u0015\u0003\u001d]\u000b1\u0003^3tiJ{G\u000e\\;q\u001f:\u00144i\u001c7v[:D#aD,\u00027Q,7\u000f\u001e*pY2,\bo\u00148D_2,XN\\,ji\"tU\u000f\u001c7tQ\t\u0001r+A\u000buKN$(k\u001c7mkB\u0004F.^:Pe\u0012,'OQ=)\u0005E9\u0016A\u0007;fgR\u0014v\u000e\u001c7va\u000e\u000b'\u000f^3tS\u0006t\u0007K]8ek\u000e$\bF\u0001\nX\u0003M\"Xm\u001d;S_2dW\u000f]\"beR,7/[1o!J|G-^2u\u001f\u001a<\u0016\u000e\u001e5UkBdWmV5uQ\u0016C\bO]3tg&|g\u000e\u000b\u0002\u0014/\u0006!B/Z:u%>dG.\u001e9XSRD\u0007*\u0019<j]\u001eD#\u0001F,\u0002'Q,7\u000f^\"vE\u0016\fe\u000e\u001a#jgRLgn\u0019;)\u0005U9\u0016a\u0004;fgR\u001cUOY3B]\u0012Tu.\u001b8)\u0005Y9\u0016\u0001\u000b;fgR<%o\\;qS:<\u0017J\\*fY\u0016\u001cGo\u00117bkN,wJZ$s_V\u0004()_)vKJL\bFA\fX\u0003\u0015\"Xm\u001d;He>,\b/\u001b8h\u0013:\u001cV\r\\3di\u000ec\u0017-^:f\u001f\u001a\u001cUOY3Rk\u0016\u0014\u0018\u0010\u000b\u0002\u0019/\u0006YD/Z:u\u000fJ|W\u000f]5oO\u001e\u0013x.\u001e9`S\u0012<%o\\;qS:<w,\u001b3J]N+G.Z2u\u00072\fWo]3PM\u001e\u0013x.\u001e9CsF+XM]=)\u0005e9\u0016\u0001\u0011;fgR<%o\\;qS:<\u0017iY2faR\u001cX*\u001e7uSBdW-\u0011:hk6,g\u000e^:HSZ,7oU1nKJ+7/\u001e7u\u0003N<%o\\;qS:<w,\u001b3)\u0005i9\u0016a\u0007;fgR<%o\\;qS:<\u0017J\\(sI\u0016\u0014()_\"mCV\u001cX\r\u000b\u0002\u001c/\u0006\u0011C/Z:u\tV\u0004H.[2bi\u0016\f%oZ;nK:$Hk\\$s_V\u0004\u0018N\\4`S\u0012D#\u0001H,\u0002OQ,7\u000f^$s_V\u0004\u0018N\\4J]N+G.Z2u\u00072\fWo]3PMJ{G\u000e\\;q#V,'/\u001f\u0015\u0003;]\u000b!\u0005^3ti\u001e\u0013x.\u001e9j]\u001e<%o\\;qS:<w,\u001b3B]\u0012<%o\\;q?&$\u0007F\u0001\u0010X\u0003q!Xm\u001d;BY2|w/\u0012=qe\u0016\u001c8/[8o\u0013:\u0014v\u000e\u001c7vaFB#aH,\u00025Q,7\u000f^!mY><X\t\u001f9sKN\u001c\u0018n\u001c8J]\u000e+(-Z\u0019)\u0005\u0001:\u0016\u0001\b;fgR\fE\u000e\\8x\u000bb\u0004(/Z:tS>t\u0017J\u001c*pY2,\bO\r\u0015\u0003C]\u000b!\u0004^3ti\u0006cGn\\<FqB\u0014Xm]:j_:LenQ;cKJB#AI,\u00029Q,7\u000f^!mY><X\t\u001f9sKN\u001c\u0018n\u001c8J]J{G\u000e\\;qg!\u00121eV\u0001\u0010i\u0016\u001cHoQ!M\u0007&#V)\r\u001d3i!\u0012AeV\u0001\u0011i\u0016\u001cHO\u0012:p[\ncwnZ:q_RD#!J,\u0002-Q,7\u000f^\"vE\u0016\f5o\u0012:pkBLgnZ*fiND#AJ,\u00021Q,7\u000f\u001e*pY2,\b/Q:He>,\b/\u001b8h'\u0016$8\u000f\u000b\u0002(/\u0006\u0019b/\u001a:jMf\u0004F.\u00198JI\u0016tG/[2bYR)\u0001+a\u0015\u0002n!9\u0011Q\u000b\u0015A\u0002\u0005]\u0013\u0001B:rYF\u0002B!!\u0017\u0002h9!\u00111LA2!\r\tiFU\u0007\u0003\u0003?R1!!\u0019=\u0003\u0019a$o\\8u}%\u0019\u0011Q\r*\u0002\rA\u0013X\rZ3g\u0013\u0011\tI'a\u001b\u0003\rM#(/\u001b8h\u0015\r\t)G\u0015\u0005\b\u0003_B\u0003\u0019AA,\u0003\u0011\u0019\u0018\u000f\u001c\u001a")
public class GroupingSetsTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testGroupingSets() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c, avg(a) AS a, GROUP_ID() AS g FROM MyTable\n        |GROUP BY GROUPING SETS (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSets2() {
        this.util().verifyExecPlan("SELECT b, c, AVG(a) AS a FROM MyTable GROUP BY GROUPING SETS (b, c, ())");
    }

    @Test
    public void testGroupingSets3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid,\n        |    COUNT(*) AS cnt\n        |FROM MyTable\n        |     GROUP BY GROUPING SETS (b, c, ())\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsOutputsNullability() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |create table t1(\n         |  a int,\n         |  b varchar,\n         |  c varchar not null,\n         |  d bigint\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '/to/my/path1',\n         |  'format' = 'testcsv'\n         |)\n      ")).stripMargin();
        this.util().tableEnv().executeSql(sourceDDL);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        | a,\n        | b,\n        | coalesce(c, 'empty'),\n        | avg(d)\n        |FROM t1\n        |GROUP BY GROUPING SETS ((a, b), (a, b, c))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCube() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) as gid\n        |FROM MyTable\n        |     GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithOneGrouping() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno,\n        |    AVG(age) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(deptno) AS gb,\n        |    GROUPING_ID(deptno) AS gib\n        |FROM emps GROUP BY GROUPING SETS (deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testBasicGroupingSets() {
        this.util().verifyExecPlan("SELECT deptno, COUNT(*) AS c FROM emps GROUP BY GROUPING SETS ((), (deptno))");
    }

    @Test
    public void testGroupingSetsOnExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1, COUNT(*) AS c FROM emps GROUP BY GROUPING SETS ((), (deptno + 1))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSimpleCube() {
        this.util().verifyExecPlan("SELECT deptno + 1, COUNT(*) AS c FROM emp GROUP BY CUBE(deptno, gender)");
    }

    @Test
    public void testRollupOn1Column() {
        this.util().verifyExecPlan("SELECT deptno + 1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno)");
    }

    @Test
    public void testRollupOn2Column() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT gender, deptno + 1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollupOnColumnWithNulls() {
        this.util().verifyExecPlan("SELECT gender, COUNT(*) AS c FROM emp GROUP BY ROLLUP(gender)");
    }

    @Test
    public void testRollupPlusOrderBy() {
        this.util().verifyExecPlan("SELECT gender, COUNT(*) AS c FROM emp GROUP BY ROLLUP(gender) ORDER BY c DESC");
    }

    @Test
    public void testRollupCartesianProduct() {
        this.util().verifyExecPlan("SELECT deptno, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno), ROLLUP(gender)");
    }

    @Test
    public void testRollupCartesianProductOfWithTupleWithExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno / 2 + 1 AS half1, COUNT(*) AS c FROM emp\n        |GROUP BY ROLLUP(deptno / 2, gender), ROLLUP(substring(ename FROM 1 FOR 1))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollupWithHaving() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1 AS d1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno) HAVING COUNT(*) > 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCubeAndDistinct() {
        this.util().verifyExecPlan("SELECT DISTINCT COUNT(*) FROM emp GROUP BY CUBE(deptno, gender)");
    }

    @Test
    public void testCubeAndJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT e.deptno, e.gender,\n        |    MIN(e.ename) AS min_name\n        |FROM emp AS e JOIN dept AS d USING (deptno)\n        |    GROUP BY CUBE(e.deptno, d.deptno, e.gender)\n        |    HAVING COUNT(*) > 2 OR gender = 'M' AND e.deptno = 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInSelectClauseOfGroupByQuery() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c, GROUPING(deptno) AS g FROM emp GROUP BY deptno");
    }

    @Test
    public void testGroupingInSelectClauseOfCubeQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, job,\n        |    COUNT(*) AS c,\n        |    GROUPING(deptno) AS d,\n        |    GROUPING(job) j,\n        |    GROUPING(deptno, job) AS x\n        |FROM scott_emp GROUP BY CUBE(deptno, job)\n        |\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingGroup_idGrouping_idInSelectClauseOfGroupByQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) as c,\n        |    GROUPING(deptno) AS g,\n        |    GROUP_ID() AS gid,\n        |    GROUPING_ID(deptno) AS gd,\n        |    GROUPING_ID(gender) AS gg,\n        |    GROUPING_ID(gender, deptno) AS ggd,\n        |    GROUPING_ID(deptno, gender) AS gdg\n        |FROM emp GROUP BY ROLLUP(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingAcceptsMultipleArgumentsGivesSameResultAsGrouping_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c,\n        |    GROUPING(deptno) AS gd,\n        |    GROUPING_ID(deptno) AS gid,\n        |    GROUPING(deptno, gender, deptno) AS gdgd,\n        |    GROUPING_ID(deptno, gender, deptno) AS gidgd\n        |FROM emp\n        |    GROUP BY ROLLUP(deptno, gender)\n        |    HAVING GROUPING(deptno) <= GROUPING_ID(deptno, gender, deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInOrderByClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno) ORDER BY GROUPING(deptno), c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDuplicateArgumentToGrouping_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, gender,\n        |    GROUPING_ID(deptno, gender, deptno),\n        |    COUNT(*) AS c\n        |FROM emp WHERE deptno = 10\n        |    GROUP BY ROLLUP(gender, deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInSelectClauseOfRollupQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c, deptno, GROUPING(deptno) AS g FROM emp GROUP BY ROLLUP(deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingGrouping_idAndGroup_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, gender,\n        |    GROUPING(deptno) gd,\n        |    GROUPING(gender) gg,\n        |    GROUPING_ID(deptno, gender) dg,\n        |    GROUPING_ID(gender, deptno) gd,\n        |    GROUP_ID() gid,\n        |    COUNT(*) c\n        |FROM emp\n        |    GROUP BY CUBE(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInRollup1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1 AS d1, deptno + 1 - 1 AS d0, COUNT(*) AS c\n        |FROM emp GROUP BY ROLLUP (deptno + 1)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInCube1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MOD(deptno, 20) AS d, COUNT(*) AS c, gender AS g\n        |FROM emp GROUP BY CUBE(MOD(deptno, 20), gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInRollup2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select MOD(deptno, 20) AS d, COUNT(*) AS c, gender AS g\n        |FROM emp GROUP BY ROLLUP(MOD(deptno, 20), gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInCube2() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c FROM emp GROUP BY CUBE(1)");
    }

    @Test
    public void testAllowExpressionInRollup3() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c FROM emp GROUP BY ROLLUP(1)");
    }

    @Test
    public void testCALCITE1824() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, GROUP_ID() AS g, COUNT(*) AS c\n        |FROM scott_emp GROUP BY GROUPING SETS (deptno, (), ())\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testFromBlogspot() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, job, empno, ename, SUM(sal) sumsal,\n        |    CASE GROUPING_ID(deptno, job, empno)\n        |    WHEN 0 THEN CAST('grouped by deptno,job,empno,ename' as varchar)\n        |    WHEN 1 THEN CAST('grouped by deptno,job' as varchar)\n        |    WHEN 3 THEN CAST('grouped by deptno' as varchar)\n        |    WHEN 7 THEN CAST('grouped by ()' as varchar)\n        |    END gr_text\n        |from scott_emp\n        |    GROUP BY ROLLUP(deptno, job, (empno,ename))\n        |    ORDER BY deptno, job, empno\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCubeAsGroupingSets() {
        String cubeQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        String groupingSetsQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS ((b, c), (b), (c), ())\n      ")).stripMargin();
        this.verifyPlanIdentical(cubeQuery, groupingSetsQuery);
        this.util().verifyExecPlan(cubeQuery);
    }

    @Test
    public void testRollupAsGroupingSets() {
        String rollupQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        String groupingSetsQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS ((b, c), (b), ())\n      ")).stripMargin();
        this.verifyPlanIdentical(rollupQuery, groupingSetsQuery);
        this.util().verifyExecPlan(rollupQuery);
    }

    public void verifyPlanIdentical(String sql1, String sql2) {
        Table table1 = this.util().tableEnv().sqlQuery(sql1);
        Table table2 = this.util().tableEnv().sqlQuery(sql2);
        RelNode optimized1 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table1));
        RelNode optimized2 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table2));
        Assertions.assertThat((String)FlinkRelOptUtil$.MODULE$.toString(optimized2, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7())).isEqualTo(FlinkRelOptUtil$.MODULE$.toString(optimized1, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()));
    }

    public GroupingSetsTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "gender"))}), new CaseClassTypeInfo<Tuple3<String, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, String>>(this, fieldSerializers){

                    public Tuple3<String, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("dept", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "dname"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("emps", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "gender")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "city")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empid")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "slacker")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "manager")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "joinedat"))}), new CaseClassTypeInfo<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>> unused = new ScalaCaseClassSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>>(this, fieldSerializers){

                    public Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date> createInstance(Object[] fields) {
                        return new Tuple10((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)((String)fields[4]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[5])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[6])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[7])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[8])), (Object)((Date)fields[9]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("scott_emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "job")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "mgr")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "hiredate")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "sal")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "comm")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno"))}), new CaseClassTypeInfo<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple8<Object, String, String, Object, Date, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple8((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)((Date)fields[4]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[6])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[7])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

