/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.agg.AggregateTestBase$;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001M4Qa\u0006\r\u0002\u0002-BQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013Eq\u0007\u0003\u0004<\u0001\u0001\u0006I\u0001\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\u0006\u001f\u0002!\t!\u0010\u0005\u0006#\u0002!\t!\u0010\u0005\u0006'\u0002!\t!\u0010\u0005\u0006+\u0002!\t!\u0010\u0005\u0006/\u0002!\t!\u0010\u0005\u00063\u0002!\t!\u0010\u0005\u00067\u0002!\t!\u0010\u0005\u0006;\u0002!\t!\u0010\u0005\u0006?\u0002!\t!\u0010\u0005\u0006C\u0002!\t!\u0010\u0005\u0006G\u0002!\t!\u0010\u0005\u0006K\u0002!\t!\u0010\u0005\u0006O\u0002!\t!\u0010\u0005\u0006S\u0002!\t!\u0010\u0005\u0006W\u0002!\t!\u0010\u0005\u0006[\u0002!\t!\u0010\u0005\u0006_\u0002!\t!\u0010\u0005\u0006c\u0002!\t!\u0010\u0002\u0012\u0003\u001e<'/Z4bi\u0016$Vm\u001d;CCN,'BA\r\u001b\u0003\r\twm\u001a\u0006\u00037q\t1a]9m\u0015\tib$A\u0003cCR\u001c\u0007N\u0003\u0002 A\u0005!\u0001\u000f\\1o\u0015\t\t#%A\u0004qY\u0006tg.\u001a:\u000b\u0005\r\"\u0013!\u0002;bE2,'BA\u0013'\u0003\u00151G.\u001b8l\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0003_\u0001\nQ!\u001e;jYNL!!\r\u0018\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tA\u0007\u0005\u00026\u00015\t\u0001$\u0001\u0003vi&dW#\u0001\u001d\u0011\u00055J\u0014B\u0001\u001e/\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u0002\u000fQ,7\u000f^!wOR\ta\b\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005I\u0001\u0003V]&$\bF\u0001\u0003F!\t1U*D\u0001H\u0015\tA\u0015*A\u0002ba&T!AS&\u0002\u000f),\b/\u001b;fe*\u0011A\nK\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u001d\u001e\u0013A\u0002V3tiR+W\u000e\u001d7bi\u0016\fq\u0001^3tiN+X\u000e\u000b\u0002\u0006\u000b\u0006IA/Z:u\u0007>,h\u000e\u001e\u0015\u0003\r\u0015\u000ba\u0002^3ti\u000e{WO\u001c;Ti\u0006\u0014H\u000f\u000b\u0002\b\u000b\u0006\tC/Z:u\u0007>,h\u000e^*uCJ$x+\u001b;i!J|'.Z2u!V\u001c\b\u000eR8x]\"\u0012\u0001\"R\u0001\u001di\u0016\u001cHoQ1o]>$8i\\;oi>sW*\u001e7uS\u001aKW\r\u001c3tQ\tIQ)\u0001\ruKN$X*\u001b8XSRDg)\u001b=MK:<G\u000f\u001b+za\u0016D#AC#\u0002;Q,7\u000f^'j]^KG\u000f\u001b,be&\f'\r\\3MK:<G\u000f\u001b+za\u0016D#aC#\u00021Q,7\u000f^'bq^KG\u000f\u001b$jq2+gn\u001a;i)f\u0004X\r\u000b\u0002\r\u000b\u0006iB/Z:u\u001b\u0006Dx+\u001b;i-\u0006\u0014\u0018.\u00192mK2+gn\u001a;i)f\u0004X\r\u000b\u0002\u000e\u000b\u0006aB/Z:u\u0003\u001e<'/Z4bi\u0016<\u0016\u000e\u001e5pkR4UO\\2uS>t\u0007F\u0001\bF\u0003m!Xm\u001d;BO\u001e\u0014XmZ1uK^KG\u000f[8vi\u001e\u0013x.\u001e9Cs\"\u0012q\"R\u0001\u0018i\u0016\u001cH/Q4he\u0016<\u0017\r^3XSRDg)\u001b7uKJD#\u0001E#\u0002KQ,7\u000f^!hOJ,w-\u0019;f/&$\bNR5mi\u0016\u0014xJ\u001c(fgR,GMR5fY\u0012\u001c\bFA\tF\u0003I!Xm\u001d;He>,\b/Q4he\u0016<\u0017\r^3)\u0005I)\u0015\u0001\b;fgR<%o\\;q\u0003\u001e<'/Z4bi\u0016<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003'\u0015\u000ba\u0003^3ti\u0006;wMT8u'V\u0004\bo\u001c:u\u001b\u0016\u0014x-\u001a\u0015\u0003)\u0015\u000b1\u0003^3tiB{'n\\!dGVlW\u000f\\1u_JD#!F#\u00025Q,7\u000f^$s_V\u0004()_,ji\"\u001cuN\\:uC:$8*Z=)\u0005Y)\u0005")
public abstract class AggregateTestBase
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BatchTableTestUtil util() {
        return this.util;
    }

    @TestTemplate
    public void testAvg() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT AVG(`byte`),\n                                 |       AVG(`short`),\n                                 |       AVG(`int`),\n                                 |       AVG(`long`),\n                                 |       AVG(`float`),\n                                 |       AVG(`double`),\n                                 |       AVG(`decimal3020`),\n                                 |       AVG(`decimal105`)\n                                 |FROM MyTable\n      ")).stripMargin());
    }

    @TestTemplate
    public void testSum() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT SUM(`byte`),\n                                 |       SUM(`short`),\n                                 |       SUM(`int`),\n                                 |       SUM(`long`),\n                                 |       SUM(`float`),\n                                 |       SUM(`double`),\n                                 |       SUM(`decimal3020`),\n                                 |       SUM(`decimal105`)\n                                 |FROM MyTable\n      ")).stripMargin());
    }

    @TestTemplate
    public void testCount() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT COUNT(`byte`),\n                                 |       COUNT(`short`),\n                                 |       COUNT(`int`),\n                                 |       COUNT(`long`),\n                                 |       COUNT(`float`),\n                                 |       COUNT(`double`),\n                                 |       COUNT(`decimal3020`),\n                                 |       COUNT(`decimal105`),\n                                 |       COUNT(`boolean`),\n                                 |       COUNT(`date`),\n                                 |       COUNT(`time`),\n                                 |       COUNT(`timestamp`),\n                                 |       COUNT(`string`)\n                                 |FROM MyTable\n      ")).stripMargin());
    }

    @TestTemplate
    public void testCountStart() {
        this.util().verifyRelPlanWithType("SELECT COUNT(*) FROM MyTable");
    }

    @TestTemplate
    public void testCountStartWithProjectPushDown() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | id VARCHAR,\n                               | cnt BIGINT\n                               |) WITH (\n                               | 'connector' = 'values'\n                               | ,'bounded' = 'true'\n                               |)\n                               |")).stripMargin());
        this.util().verifyRelPlanWithType("SELECT COUNT(*) FROM src");
    }

    @TestTemplate
    public void testCannotCountOnMultiFields() {
        String sql = "SELECT b, COUNT(a, c) FROM MyTable1 GROUP BY b";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("We now only support the count of one field") instanceof TableException;
    }

    @TestTemplate
    public void testMinWithFixLengthType() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT MIN(`byte`),\n                                 |       MIN(`short`),\n                                 |       MIN(`int`),\n                                 |       MIN(`long`),\n                                 |       MIN(`float`),\n                                 |       MIN(`double`),\n                                 |       MIN(`decimal3020`),\n                                 |       MIN(`decimal105`),\n                                 |       MIN(`boolean`),\n                                 |       MIN(`date`),\n                                 |       MIN(`time`),\n                                 |       MIN(`timestamp`)\n                                 |FROM MyTable\n      ")).stripMargin());
    }

    @TestTemplate
    public void testMinWithVariableLengthType() {
        this.util().verifyRelPlanWithType("SELECT MIN(`string`) FROM MyTable");
    }

    @TestTemplate
    public void testMaxWithFixLengthType() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT MAX(`byte`),\n                                 |       MAX(`short`),\n                                 |       MAX(`int`),\n                                 |       MAX(`long`),\n                                 |       MAX(`float`),\n                                 |       MAX(`double`),\n                                 |       MAX(`decimal3020`),\n                                 |       MAX(`decimal105`),\n                                 |       MAX(`boolean`),\n                                 |       MAX(`date`),\n                                 |       MAX(`time`),\n                                 |       MAX(`timestamp`)\n                                 |FROM MyTable\n      ")).stripMargin());
    }

    @TestTemplate
    public void testMaxWithVariableLengthType() {
        this.util().verifyRelPlanWithType("SELECT MAX(`string`) FROM MyTable");
    }

    @TestTemplate
    public void testAggregateWithoutFunction() {
        this.util().verifyExecPlan("SELECT a, b FROM MyTable1 GROUP BY a, b");
    }

    @TestTemplate
    public void testAggregateWithoutGroupBy() {
        this.util().verifyExecPlan("SELECT AVG(a), SUM(b), COUNT(c) FROM MyTable1");
    }

    @TestTemplate
    public void testAggregateWithFilter() {
        this.util().verifyExecPlan("SELECT AVG(a), SUM(b), COUNT(c) FROM MyTable1 WHERE a = 1");
    }

    @TestTemplate
    public void testAggregateWithFilterOnNestedFields() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Tuple2<Object, Object>>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Tuple2<Object, Object>>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Tuple2<Object, Object>>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Tuple2<Object, Object>>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Tuple2<Object, Object>> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((Tuple2)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.batch.sql.agg.AggregateTestBase$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT AVG(a), SUM(b), COUNT(c), SUM(c._1) FROM MyTable2 WHERE a = 1");
    }

    @TestTemplate
    public void testGroupAggregate() {
        this.util().verifyExecPlan("SELECT a, SUM(b), COUNT(c) FROM MyTable1 GROUP BY a");
    }

    @TestTemplate
    public void testGroupAggregateWithFilter() {
        this.util().verifyExecPlan("SELECT a, SUM(b), count(c) FROM MyTable1 WHERE a = 1 GROUP BY a");
    }

    @TestTemplate
    public void testAggNotSupportMerge() {
        this.util().addTemporarySystemFunction("var_sum", (UserDefinedFunction)new JavaUserDefinedAggFunctions.VarSum2AggFunction());
        this.util().verifyExecPlan("SELECT b, var_sum(a) FROM MyTable1 GROUP BY b");
    }

    @TestTemplate
    public void testPojoAccumulator() {
        this.util().addTemporarySystemFunction("var_sum", (UserDefinedFunction)new JavaUserDefinedAggFunctions.VarSum1AggFunction());
        this.util().verifyExecPlan("SELECT b, var_sum(a) FROM MyTable1 GROUP BY b");
    }

    @TestTemplate
    public void testGroupByWithConstantKey() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, MAX(b), c FROM (SELECT a, 'test' AS c, b FROM MyTable1) t GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public AggregateTestBase() {
        this.util().addTableSource("MyTable", (AbstractDataType[])((Object[])new AbstractDataType[]{DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.BOOLEAN(), DataTypes.STRING(), DataTypes.DATE(), DataTypes.TIME(), DataTypes.TIMESTAMP((int)3), DataTypes.DECIMAL((int)30, (int)20), DataTypes.DECIMAL((int)10, (int)5)}), (String[])((Object[])new String[]{"byte", "short", "int", "long", "float", "double", "boolean", "string", "date", "time", "timestamp", "decimal3020", "decimal105"}));
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.agg.AggregateTestBase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

