/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.WindowTableFunctionTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!4Aa\u0005\u000b\u0001K!)A\u0006\u0001C\u0001[!9\u0001\u0007\u0001b\u0001\n\u0013\t\u0004BB\u001b\u0001A\u0003%!\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003J\u0001\u0011\u0005q\u0007C\u0003O\u0001\u0011\u0005q\u0007C\u0003Q\u0001\u0011\u0005q\u0007C\u0003S\u0001\u0011\u0005q\u0007C\u0003U\u0001\u0011\u0005q\u0007C\u0003W\u0001\u0011\u0005q\u0007C\u0003Y\u0001\u0011\u0005q\u0007C\u0003[\u0001\u0011\u0005q\u0007C\u0003]\u0001\u0011\u0005q\u0007C\u0003_\u0001\u0011\u0005q\u0007C\u0003a\u0001\u0011\u0005q\u0007C\u0003c\u0001\u0011\u0005q\u0007C\u0003e\u0001\u0011\u0005q\u0007C\u0003g\u0001\u0011\u0005qGA\fXS:$wn\u001e+bE2,g)\u001e8di&|g\u000eV3ti*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0011\u0017\r^2i\u0015\tI\"$\u0001\u0003qY\u0006t'BA\u000e\u001d\u0003\u001d\u0001H.\u00198oKJT!!\b\u0010\u0002\u000bQ\f'\r\\3\u000b\u0005}\u0001\u0013!\u00024mS:\\'BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001MA\u0011qEK\u0007\u0002Q)\u0011\u0011FG\u0001\u0006kRLGn]\u0005\u0003W!\u0012Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001/!\ty\u0003!D\u0001\u0015\u0003\u0011)H/\u001b7\u0016\u0003I\u0002\"aJ\u001a\n\u0005QB#A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\naAY3g_J,G#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t}\u0002\"\u0001Q$\u000e\u0003\u0005S!AQ\"\u0002\u0007\u0005\u0004\u0018N\u0003\u0002E\u000b\u00069!.\u001e9ji\u0016\u0014(B\u0001$#\u0003\u0015QWO\\5u\u0013\tA\u0015I\u0001\u0006CK\u001a|'/Z#bG\"\fa\u0003^3ti&sg/\u00197jIRKW.Z\"pYRK\b/\u001a\u0015\u0003\u000b-\u0003\"\u0001\u0011'\n\u00055\u000b%\u0001\u0002+fgR\fQ\u0002^3tiR+XN\u00197f)Z3\u0005F\u0001\u0004L\u0003U!Xm\u001d;Uk6\u0014G.\u001a+W\rB\u0013xn\u0019;j[\u0016D#aB&\u0002\u0015Q,7\u000f\u001e%paR3f\t\u000b\u0002\t\u0017\u0006\u0011B/Z:u\u0011>\u0004HK\u0016$Qe>\u001cG/[7fQ\tI1*A\buKN$8)^7vY\u0006$X\r\u0016,GQ\tQ1*A\fuKN$8)^7vY\u0006$X\r\u0016,G!J|7\r^5nK\"\u00121bS\u0001\u0014i\u0016\u001cHoV5oI><\u0018iZ4sK\u001e\fG/\u001a\u0015\u0003\u0019-\u000bA\u0004^3ti\u000e\u000b7oY1eS:<w+\u001b8e_^\fum\u001a:fO\u0006$X\r\u000b\u0002\u000e\u0017\u0006qA/Z:u/&tGm\\<K_&t\u0007F\u0001\bL\u00039!Xm\u001d;XS:$wn\u001e*b].D#aD&\u00027Q,7\u000f\u001e)s_*,7\r^,U\rR\u0013\u0018M\\:q_N,'+\u001e7fQ\t\u00012*\u0001\buKN$8+Z:tS>tGK\u0016$)\u0005EY\u0015A\u0006;fgR\u001cVm]:j_:$fK\u0012)s_\u000e$\u0018.\\3)\u0005IY\u0005")
public class WindowTableFunctionTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple4<Timestamp, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Timestamp, Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Timestamp, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple4<Timestamp, Object, Object, String>>(this, fieldSerializers){

                    public Tuple4<Timestamp, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((Timestamp)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.WindowTableFunctionTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple5<Object, Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple5<Object, Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)((Timestamp)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.WindowTableFunctionTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |create table MyTable2 (\n                                |  a int,\n                                |  b bigint,\n                                |  c as proctime()\n                                |) with (\n                                |  'connector' = 'values',\n                                |  'bounded' = 'true'\n                                |)\n                                |")).stripMargin());
    }

    @Test
    public void testInvalidTimeColType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(b), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("The window function TUMBLE(TABLE table_name, DESCRIPTOR(timecol), datetime interval[, datetime interval]) requires the timecol to be TIMESTAMP or TIMESTAMP_LTZ, but is BIGINT.") instanceof ValidationException;
    }

    @Test
    public void testTumbleTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumbleTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(c), INTERVAL '15' MINUTE))\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window TableFunction is not supported yet.") instanceof TableException;
    }

    @Test
    public void testHopTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(HOP(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '1' HOUR, INTERVAL '2' HOUR))\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testHopTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(HOP(TABLE MyTable2, DESCRIPTOR(c), INTERVAL '1' HOUR, INTERVAL '2' HOUR))\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window TableFunction is not supported yet.") instanceof TableException;
    }

    @Test
    public void testCumulateTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | CUMULATE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testCumulateTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | CUMULATE(TABLE MyTable2, DESCRIPTOR(c), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window TableFunction is not supported yet.") instanceof TableException;
    }

    @Test
    public void testWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_start,\n        |  window_end,\n        |  a,\n        |  MAX(c)\n        |FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '3' SECOND))\n        |GROUP BY window_start, window_end, a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testCascadingWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, b, SUM(cnt)\n        |FROM (\n        |  SELECT\n        |    window_start, window_end, a, b, COUNT(1) AS cnt\n        |  FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '3' SECOND))\n        |  GROUP BY window_start, window_end, a, b\n        |)\n        |GROUP BY window_start, window_end, b\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(ts), INTERVAL '15' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '15' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowRank() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |SELECT *,\n        |  RANK() OVER(PARTITION BY a, window_start, window_end ORDER BY b) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(ts), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testProjectWTFTransposeRule() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  MAX(c)\n        |FROM TABLE(TUMBLE(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '3' SECOND))\n        |GROUP BY window_start, window_end, a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSessionTVF() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | SESSION(TABLE MyTable1, DESCRIPTOR(ts), INTERVAL '10' MINUTE))\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Unaligned windows like session are not supported in batch mode yet.") instanceof TableException;
    }

    @Test
    public void testSessionTVFProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(\n        | SESSION(TABLE MyTable2, DESCRIPTOR(c), INTERVAL '10' MINUTE))\n        |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessageContaining("Processing time Window TableFunction is not supported yet.") instanceof TableException;
    }
}

