/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.time.ZoneId;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.planner.factories.TestTimeTravelCatalog;
import org.apache.flink.table.planner.runtime.utils.TimeTravelTestUtil;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.DateTimeTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TimeTravelTest
extends TableTestBase {
    private BatchTableTestUtil util;

    TimeTravelTest() {
    }

    @BeforeEach
    void before() {
        this.util = this.batchTestUtil(TableConfig.getDefault());
        String catalogName = "TimeTravelCatalog";
        TestTimeTravelCatalog catalog = TimeTravelTestUtil.getTestingCatalogWithVersionedTable(catalogName, "t1");
        TableEnvironment tEnv = this.util.tableEnv();
        tEnv.registerCatalog(catalogName, (Catalog)catalog);
        tEnv.useCatalog(catalogName);
        tEnv.getConfig().setLocalTimeZone(ZoneId.of("UTC"));
    }

    @Test
    void testTimeTravel() {
        this.util.verifyExecPlan("SELECT * FROM t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 02:00:00'");
    }

    @Test
    void testTimeTravelWithAsExpression() {
        this.util.verifyExecPlan("SELECT * FROM t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 02:00:00' AS t2");
    }

    @Test
    void testTimeTravelWithSimpleExpression() {
        this.util.verifyExecPlan("SELECT * FROM t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 00:00:00'+INTERVAL '60' DAY");
    }

    @Test
    void testTimeTravelWithDifferentTimezone() {
        this.util.tableEnv().getConfig().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        this.util.verifyExecPlan(String.format("SELECT * FROM t1 FOR SYSTEM_TIME AS OF TIMESTAMP '%s'", DateTimeTestUtil.timezoneConvert("2023-01-01 02:00:00", "yyyy-MM-dd HH:mm:ss", ZoneId.of("UTC"), ZoneId.of("Asia/Shanghai"))));
    }

    @Test
    void testTimeTravelOneTableMultiTimes() {
        this.util.verifyExecPlan("SELECT\n    f1\nFROM\n    t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 01:00:00'\nUNION ALL\nSELECT\n    f2\nFROM\n    t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 02:00:00'");
    }

    @Test
    void testTimeTravelWithLookupJoin() {
        this.util.verifyExecPlan("SELECT\n    l.f2,\n    r.f3\nFROM\n    (\n        SELECT\n            *,\n            proctime () as p\n        FROM\n            t1 FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 02:00:00'\n    ) l\n    LEFT JOIN t1 FOR SYSTEM_TIME AS OF l.p r ON l.f1=r.f1");
    }

    @Test
    void testTimeTravelWithHints() {
        this.util.verifyExecPlan("SELECT * FROM t1 /*+ options('bounded'='true') */ FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 02:00:00' AS t2");
    }

    @Test
    void testTimeTravelWithUnsupportedExpression() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.tableEnv().executeSql("SELECT\n    *\nFROM\n    t1 FOR SYSTEM_TIME AS OF TO_TIMESTAMP_LTZ (0, 3)")).isInstanceOf(ValidationException.class)).hasMessageContaining("SQL validation failed. Unsupported time travel expression: `TO_TIMESTAMP_LTZ`(0, 3) for the expression can not be reduced to a constant by Flink.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.tableEnv().executeSql("SELECT\n    *\nFROM\n    t1 FOR SYSTEM_TIME AS OF PROCTIME()")).isInstanceOf(ValidationException.class)).hasMessageContaining("Unsupported time travel expression: PROCTIME() for the expression can not be reduced to a constant by Flink.");
    }

    @Test
    void testTimeTravelWithIdentifierSnapshot() {
        this.util.tableEnv().executeSql("CREATE TABLE\n    t2 (f1 VARCHAR, f2 TIMESTAMP(3))\nWITH\n    ('connector'='values', 'bounded'='true')");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.tableEnv().executeSql("SELECT\n    *\nFROM\n    t2 FOR SYSTEM_TIME AS OF f2")).isInstanceOf(TableException.class)).hasMessageContaining("Cannot generate a valid execution plan for the given query");
    }

    @Test
    void testTimeTravelWithView() {
        this.util.tableEnv().executeSql("CREATE VIEW tb_view AS SELECT * FROM t1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.tableEnv().executeSql("SELECT\n    *\nFROM\n    tb_view FOR SYSTEM_TIME AS OF TIMESTAMP '2023-01-01 01:00:00'")).isInstanceOf(ValidationException.class)).hasMessageContaining("TimeTravelCatalog.default.tb_view is a view, but time travel is not supported for view.");
    }
}

