/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.TableSinkTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001}3AAD\b\u0001A!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0003a\u0003BB\u001b\u0001A\u0003%Q\u0006C\u00047\u0001\t\u0007I\u0011A\u001c\t\rm\u0002\u0001\u0015!\u00039\u0011\u001da\u0004A1A\u0005\nuBa!\u0011\u0001!\u0002\u0013q\u0004\"\u0002\"\u0001\t\u0003\u0019\u0005\"B+\u0001\t\u0003\u0019\u0005\"B,\u0001\t\u0003\u0019\u0005\"B-\u0001\t\u0003\u0019\u0005\"B.\u0001\t\u0003\u0019\u0005\"B/\u0001\t\u0003\u0019%!\u0004+bE2,7+\u001b8l)\u0016\u001cHO\u0003\u0002\u0011#\u0005\u00191/\u001d7\u000b\u0005I\u0019\u0012!\u00022bi\u000eD'B\u0001\u000b\u0016\u0003\u0011\u0001H.\u00198\u000b\u0005Y9\u0012a\u00029mC:tWM\u001d\u0006\u00031e\tQ\u0001^1cY\u0016T!AG\u000e\u0002\u000b\u0019d\u0017N\\6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1E\u0003\u0002%+\u0005)Q\u000f^5mg&\u0011ae\t\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005y\u0011\u0001\u0002'P\u001d\u001e+\u0012!\f\t\u0003]Mj\u0011a\f\u0006\u0003aE\nq\u0001\\8hS\u000e\fGN\u0003\u00023/\u0005)A/\u001f9fg&\u0011Ag\f\u0002\u000b\u0005&<\u0017J\u001c;UsB,\u0017!\u0002'P\u001d\u001e\u0003\u0013aA%O)V\t\u0001\b\u0005\u0002/s%\u0011!h\f\u0002\b\u0013:$H+\u001f9f\u0003\u0011Ie\n\u0016\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002}A\u0011!eP\u0005\u0003\u0001\u000e\u0012!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\u0006)Q\u000f^5mA\u0005qA/Z:u'&tw\r\\3TS:\\G#\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0011-\u0003\"\u0001T*\u000e\u00035S!AT(\u0002\u0007\u0005\u0004\u0018N\u0003\u0002Q#\u00069!.\u001e9ji\u0016\u0014(B\u0001*\u001e\u0003\u0015QWO\\5u\u0013\t!VJ\u0001\u0003UKN$\u0018A\u0004;fgRlU\u000f\u001c;j'&t7n\u001d\u0015\u0003\u0013-\u000b!\u0004^3ti\u0012Kh.Y7jGB\u000b'\u000f^,ji\"|%\u000fZ3s\u0005fD#AC&\u0002!Q,7\u000f\u001e#jgR\u0014\u0018NY;uS>t\u0007FA\u0006L\u00039!Xm\u001d;UC\ndW\rS5oiND#\u0001D&\u0002_Q,7\u000f^\"sK\u0006$X\rV1cY\u0016\f5oU3mK\u000e$x+\u001b;i\u001fJ$WM]&fs:{G\u000f\u0015:pU\u0016\u001cG/\u001a3)\u00055Y\u0005")
public class TableSinkTest
extends TableTestBase {
    private final BigIntType LONG = new BigIntType();
    private final IntType INT = new IntType();
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BigIntType LONG() {
        return this.LONG;
    }

    public IntType INT() {
        return this.INT;
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testSingleSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().verifyRelPlan(stmtSet);
    }

    @Test
    public void testMultiSinks() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink1 (\n                     |  `total_sum` INT\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink2 (\n                     |  `total_min` INT\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Table table1 = this.util().tableEnv().sqlQuery("SELECT SUM(a) AS sum_a, c FROM MyTable GROUP BY c");
        this.util().tableEnv().createTemporaryView("table1", table1);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink1 SELECT SUM(sum_a) AS total_sum FROM table1");
        stmtSet.addInsertSql("INSERT INTO sink2 SELECT MIN(sum_a) AS total_min FROM table1");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testDynamicPartWithOrderBy() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT\n                     |) PARTITIONED BY (\n                     |  `b`\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT a,b FROM MyTable ORDER BY a");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testDistribution() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT\n                     |) DISTRIBUTED BY (\n                     |  `b`\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT a,b FROM MyTable ORDER BY a");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testTableHints() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable (\n                                |  `a` INT,\n                                |  `b` BIGINT,\n                                |  `c` STRING\n                                |) WITH (\n                                |  'connector' = 'values',\n                                |  'bounded' = 'true'\n                                |)\n       ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MySink (\n                                |  `a` INT,\n                                |  `b` BIGINT,\n                                |  `c` STRING\n                                |) WITH (\n                                |  'connector' = 'filesystem',\n                                |  'format' = 'testcsv',\n                                |  'path' = '/tmp/test'\n                                |)\n       ")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("insert into MySink /*+ OPTIONS('path' = '/tmp1') */ select * from MyTable");
        stmtSet.addInsertSql("insert into MySink /*+ OPTIONS('path' = '/tmp2') */ select * from MyTable");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testCreateTableAsSelectWithOrderKeyNotProjected() {
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n                                |create table MyCtasSource\n                                |WITH (\n                                |   'connector' = 'values'\n                                |) as select b, c, d from\n                                |  (values\n                                |    (1, 1, 2, 'd1')\n                                |  ) as V(a, b, c, d)\n                                |  order by a\n                                |")).stripMargin());
    }

    public TableSinkTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.TableSinkTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

