/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.runtime.functions.aggregate.FirstValueAggFunction;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\u0017.\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004O\u0001\u0001\u0006Ia\u0013\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u0006E\u0002!\t\u0001\u0015\u0005\u0006O\u0002!\t\u0001\u0015\u0005\u0006S\u0002!\t\u0001\u0015\u0005\u0006W\u0002!\t\u0001\u0015\u0005\u0006[\u0002!\t\u0001\u0015\u0005\u0006_\u0002!\t\u0001\u0015\u0005\u0006c\u0002!\t\u0001\u0015\u0005\u0006g\u0002!\t\u0001\u0015\u0005\u0006k\u0002!\t\u0001\u0015\u0005\u0006o\u0002!\t\u0001\u0015\u0005\u0006s\u0002!\t\u0001\u0015\u0005\u0006w\u0002!\t\u0001\u0015\u0005\u0006{\u0002!\t\u0001\u0015\u0005\u0006\u007f\u0002!\t\u0001\u0015\u0005\u0007\u0003\u0007\u0001A\u0011\u0001)\t\r\u0005\u001d\u0001\u0001\"\u0001Q\u0011\u0019\tY\u0001\u0001C\u0001!\"1\u0011q\u0002\u0001\u0005\u0002ACa!a\u0005\u0001\t\u0003\u0001\u0006BBA\f\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u0002\u001c\u0001!\t\u0001\u0015\u0005\u0007\u0003?\u0001A\u0011\u0001)\t\r\u0005\r\u0002\u0001\"\u0001Q\u0011\u0019\t9\u0003\u0001C\u0001!\"1\u00111\u0006\u0001\u0005\u0002ACa!a\f\u0001\t\u0003\u0001\u0006BBA\u001a\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u00028\u0001!\t\u0001\u0015\u0005\u0007\u0003w\u0001A\u0011\u0001)\t\r\u0005}\u0002\u0001\"\u0001Q\u0011\u0019\t\u0019\u0005\u0001C\u0001!\"1\u0011q\t\u0001\u0005\u0002ACa!a\u0013\u0001\t\u0003\u0001\u0006BBA(\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u0002T\u0001!\t\u0001\u0015\u0005\u0007\u0003/\u0002A\u0011\u0001)\t\r\u0005m\u0003\u0001\"\u0001Q\u0011\u0019\ty\u0006\u0001C\u0001!\"1\u00111\r\u0001\u0005\nA\u0013\u0001cU;ca2\fgNU3vg\u0016$Vm\u001d;\u000b\u00059z\u0013aA:rY*\u0011\u0001'M\u0001\u0006E\u0006$8\r\u001b\u0006\u0003eM\nA\u0001\u001d7b]*\u0011A'N\u0001\ba2\fgN\\3s\u0015\t1t'A\u0003uC\ndWM\u0003\u00029s\u0005)a\r\\5oW*\u0011!hO\u0001\u0007CB\f7\r[3\u000b\u0003q\n1a\u001c:h\u0007\u0001\u0019\"\u0001A \u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t\u001b\u0014!B;uS2\u001c\u0018B\u0001#B\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012a\u0012\t\u0003\u0011\u0002i\u0011!L\u0001\u0005kRLG.F\u0001L!\t\u0001E*\u0003\u0002N\u0003\n\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0003\u0015)H/\u001b7!\u0003\u0019\u0011WMZ8sKR\t\u0011\u000b\u0005\u0002S+6\t1KC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16K\u0001\u0003V]&$\bF\u0001\u0003Y!\tI\u0006-D\u0001[\u0015\tYF,A\u0002ba&T!!\u00180\u0002\u000f),\b/\u001b;fe*\u0011qlO\u0001\u0006UVt\u0017\u000e^\u0005\u0003Cj\u0013!BQ3g_J,W)Y2i\u0003]!Xm\u001d;ESN\f'\r\\3Tk\n\u0004H.\u00198SKV\u001cX\r\u000b\u0002\u0006IB\u0011\u0011,Z\u0005\u0003Mj\u0013A\u0001V3ti\u0006!C/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z,ji\"$\u0015N\u001a4fe\u0016tGOU8x)f\u0004X\r\u000b\u0002\u0007I\u0006QB/Z:u\u000b:\f'\r\\3SKV\u001cX\rV1cY\u0016\u001cv.\u001e:dK\"\u0012q\u0001Z\u0001\u001ci\u0016\u001cH\u000fR5tC\ndWMU3vg\u0016$\u0016M\u00197f'>,(oY3)\u0005!!\u0017!\t;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:\u001cv.\u001e:dK^KG\u000f\u001b'j[&$\bFA\u0005e\u0003\u0005\"Xm\u001d;Tk\n\u0004H.\u00198SKV\u001cXm\u00148ECR\f7\u000b\u001e:fC6$\u0016M\u00197fQ\tQA-\u0001\fuKN$8+\u001e2qY\u0006t'+Z;tK>s7)\u00197dQ\tYA-A\u0019uKN$8+\u001e2qY\u0006t'+Z;tK>s7)\u00197d/&$\bNT8o\t\u0016$XM]7j]&\u001cH/[2Qe>TWm\u0019;)\u00051!\u0017!\f;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:\u001c\u0015\r\\2XSRDgj\u001c8EKR,'/\\5oSN$\u0018nY+eM\"\u0012Q\u0002Z\u0001\u001bi\u0016\u001cHoU;ca2\fgNU3vg\u0016|e.\u0012=dQ\u0006tw-\u001a\u0015\u0003\u001d\u0011\fq\u0004^3tiN+(\r\u001d7b]J+Wo]3P]\"\u000b7\u000f[!hOJ,w-\u0019;fQ\tyA-A\u0010uKN$8+\u001e2qY\u0006t'+Z;tK>s7k\u001c:u\u0003\u001e<'/Z4bi\u0016D#\u0001\u00053\u0002mQ,7\u000f^*vEBd\u0017M\u001c*fkN,wJ\\!hOJ,w-\u0019;f/&$\bNT8o\t\u0016$XM]7j]&\u001cH/[2BO\u001e\u001c\u0015\r\u001c7)\u0005E!\u0017A\u0006;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:\u001cvN\u001d;)\u0005I!\u0017a\u0006;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:d\u0015.\\5uQ\t\u0019B-A\u000euKN$8+\u001e2qY\u0006t'+Z;tK>s7k\u001c:u\u0019&l\u0017\u000e\u001e\u0015\u0003)\u0011\fq\u0003^3tiN+(\r\u001d7b]J+Wo]3P]Vs\u0017n\u001c8)\u0005U!\u0017A\u0006;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:Tu.\u001b8)\u0005Y!\u0017a\b;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:\u001cvN\u001d;NKJ<WMS8j]\"\u0012q\u0003Z\u0001\u001bi\u0016\u001cHoU;ca2\fgNU3vg\u0016|e\u000eS1tQ*{\u0017N\u001c\u0015\u00031\u0011\f\u0001\u0005^3tiN+(\r\u001d7b]J+Wo]3P]:+7\u000f^3e\u0019>|\u0007OS8j]\"\u0012\u0011\u0004Z\u00014i\u0016\u001cHoU;ca2\fgNU3vg\u0016|eNS8j]:{g\u000eR3uKJl\u0017N\\5ti&\u001c'j\\5o\u0007>tG-\u001b;j_:D#A\u00073\u00029Q,7\u000f^*vEBd\u0017M\u001c*fkN,wJ\\(wKJ<\u0016N\u001c3po\"\u00121\u0004Z\u0001\u001di\u0016\u001cHoU;ca2\fgNU3vg\u0016|enU8si\u0016$g+[3xQ\taB-A\u001cuKN$8+\u001e2qY\u0006t'+Z;tK>swJ^3s/&tGm\\<XSRDgj\u001c8EKR,'/\\5oSN$\u0018nY!hO\u000e\u000bG\u000e\u001c\u0015\u0003;\u0011\f1\u0004^3tiN+(\r\u001d7b]J+Wo]3P]\u000e{'O]3mCR,\u0007F\u0001\u0010e\u0003M\"Xm\u001d;Tk\n\u0004H.\u00198SKV\u001cXm\u00148D_J\u0014X\r\\1uK^KG\u000f\u001b(p]\u0012+G/\u001a:nS:L7\u000f^5d+\u0012#f\t\u000b\u0002 I\u0006\u0019C/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z,ji\"$\u0015P\\1nS\u000e4UO\\2uS>t\u0007F\u0001\u0011e\u0003Y!Xm\u001d;OKN$X\rZ*vEBd\u0017M\u001c*fkN,\u0007FA\u0011e\u0003u!Xm\u001d;Ce\u0016\f7.\u001e9EK\u0006$Gn\\2l\u001f:D\u0015m\u001d5K_&t\u0007F\u0001\u0012e\u0003\r\"Xm\u001d;Ce\u0016\f7.\u001e9EK\u0006$Gn\\2l\u001f:tUm\u001d;fI2{w\u000e\u001d&pS:D#a\t3\u0002KQ,7\u000f^#oC\ndWMU3vg\u0016$\u0016M\u00197f'>,(oY3P]:+woU8ve\u000e,\u0007F\u0001\u0013e\u0003\u0019\"Xm\u001d;ESN\f'\r\\3SKV\u001cX\rV1cY\u0016\u001cv.\u001e:dK>sg*Z<T_V\u00148-\u001a\u0015\u0003K\u0011\fa\u0007^3tiJ+Wo]3UC\ndWmU8ve\u000e,w+\u001b;i!J|'.Z2u!V\u001c\b\u000eR8x]\u0006sG-T3uC\u0012\u000bG/Y&fsFB#A\n3\u0002kQ,7\u000f\u001e*fkN,G+\u00192mKN{WO]2f/&$\b\u000e\u0015:pU\u0016\u001cG\u000fU;tQ\u0012{wO\\!oI6+G/\u0019#bi\u0006\\U-\u001f\u0015\u0003O\u0011\fa\u0007^3tiN{WO]2f%\u0016,8/Z,ji\",U\u000e\u001d;z\r&dG/\u001a:D_:$\u0017I\u001c3JO:|'/Z#naRLh)\u001b7uKJD#\u0001\u000b3\u0002uQ,7\u000f^*pkJ\u001cWMU3vg\u0016<\u0016\u000e\u001e5F[B$\u0018PR5mi\u0016\u00148i\u001c8e\u0003:$\u0017j\u001a8pe\u0016,U\u000e\u001d;z\r&dG/\u001a:UeV,\u0007FA\u0015e\u0003m\"Xm\u001d;T_V\u00148-\u001a*fkN,w+\u001b;i\u000b6\u0004H/\u001f$jYR,'oQ8oI\u0006sG-S4o_J,W)\u001c9us\u001aKG\u000e^3s)J,XM\r\u0015\u0003U\u0011\fA\u0003^3tiJ+Wo]3P]:+woU8ve\u000e,\u0007")
public class SubplanReuseTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().addTableSource("x", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("y", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testDisableSubplanReuse() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (\n        | SELECT a, SUM(b) as b, SUM(e) as e FROM x, y WHERE a = d AND c > 100 GROUP BY a\n        |)\n        |SELECT r1.a, r1.b, r2.e FROM r r1, r r2 WHERE r1.b > 10 AND r2.e < 20 AND r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reused"}));
    }

    @Test
    public void testSubplanReuseWithDifferentRowType() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t1 AS (SELECT CAST(a as BIGINT) AS a, SUM(b) AS b FROM x GROUP BY CAST(a as BIGINT)),\n        |     t2 AS (SELECT CAST(a as DOUBLE) AS a, SUM(b) AS b FROM x GROUP BY CAST(a as DOUBLE))\n        |SELECT t1.*, t2.* FROM t1, t2 WHERE t1.b = t2.b\n      ")).stripMargin();
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reused"}));
    }

    @Test
    public void testEnableReuseTableSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t AS (SELECT x.a AS a, x.b AS b, y.d AS d, y.e AS e FROM x, y WHERE x.a = y.d)\n        |SELECT t1.*, t2.* FROM t t1, t t2 WHERE t1.b = t2.e AND t1.a < 10 AND t2.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDisableReuseTableSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t AS (SELECT * FROM x, y WHERE x.a = y.d)\n        |SELECT t1.*, t2.* FROM t t1, t t2 WHERE t1.b = t2.e AND t1.a < 10 AND t2.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSourceWithLimit() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b FROM x LIMIT 10)\n        |SELECT r1.a, r1.b, r2.a FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnDataStreamTable() {
        this.util().addDataStream("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |(SELECT a FROM t WHERE a > 10)\n        |UNION ALL\n        |(SELECT a FROM t WHERE b > 10)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCalc() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c FROM x WHERE c LIKE 'test%')\n        |(SELECT r.a, LOWER(c) AS c, y.e FROM r, y WHERE r.a = y.d)\n        |UNION ALL\n        |(SELECT r.a, LOWER(c) AS c, y.e FROM r, y WHERE r.a = y.d)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCalcWithNonDeterministicProject() {
        this.util().addTemporarySystemFunction("random_udf", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |(SELECT a, random_udf() FROM x WHERE a > 10)\n        |UNION ALL\n        |(SELECT a, random_udf() FROM x WHERE a > 10)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCalcWithNonDeterministicUdf() {
        this.util().addTemporarySystemFunction("random_udf", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |(SELECT a FROM x WHERE b > random_udf(a))\n        |UNION ALL\n        |(SELECT a FROM x WHERE b > random_udf(a))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnExchange() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c FROM x WHERE c LIKE 'test%')\n        |SELECT * FROM r, y WHERE a = d AND e > 10\n        |UNION ALL\n        |SELECT * FROM r, y WHERE a = d AND f <> ''\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnHashAggregate() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)OperatorType.SortAgg.toString());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b AND r2.a > 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSortAggregate() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)OperatorType.HashAgg.toString());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b AND r2.a > 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnAggregateWithNonDeterministicAggCall() {
        this.util().addTemporarySystemFunction("MyFirst", (UserDefinedFunction)new FirstValueAggFunction(DataTypes.INT().getLogicalType()));
        this.util().addTemporarySystemFunction("MyLast", (UserDefinedFunction)new FirstValueAggFunction(DataTypes.BIGINT().getLogicalType()));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, MyFirst(a) a, MyLast(b) b FROM x GROUP BY c)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b AND r2.a > 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSort() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c ORDER BY a, b DESC)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.a > 1 AND r2.b < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnLimit() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b FROM x LIMIT 10)\n        |SELECT r1.a, r1.b, r2.a FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSortLimit() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c ORDER BY a, b DESC LIMIT 10)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.a > 1 AND r2.b < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnUnion() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, c FROM x WHERE b > 10 UNION ALL SELECT d, f FROM y WHERE e < 100)\n        |SELECT r1.a, r1.c, r2.c FROM r r1, r r2 WHERE r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x FULL OUTER JOIN y ON ABS(a) = ABS(d) OR c = f\n        |           WHERE b > 1 and e < 2)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSortMergeJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnHashJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnNestedLoopJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnJoinNonDeterministicJoinCondition() {
        this.util().addTemporarySystemFunction("random_udf", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x FULL OUTER JOIN y ON random_udf(a) = random_udf(d) OR c = f\n        |           WHERE b > 1 and e < 2)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnOverWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, RANK() OVER (ORDER BY c DESC) FROM x)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.b < 100 AND r2.b > 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSortedView() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE Source (\n                               |   a int,\n                               |   b bigint,\n                               |   c string,\n                               |   d string,\n                               |   e string\n                               |) WITH (\n                               |   'connector' = 'values',\n                               |   'bounded' = 'true'\n                               |)\n                               |")).stripMargin());
        String query = "SELECT * FROM Source order by c";
        Table table = this.util().tableEnv().sqlQuery(query);
        this.util().tableEnv().createTemporaryView("SortedView", table);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE Sink1 (\n                               |   a int,\n                               |   b bigint,\n                               |   c string\n                               |) WITH (\n                               |   'connector' = 'values',\n                               |   'bounded' = 'true'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE Sink2 (\n                               |   a int,\n                               |   b bigint,\n                               |   c string,\n                               |   d string\n                               |) WITH (\n                               |   'connector' = 'values',\n                               |   'bounded' = 'true'\n                               |)\n                               |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO Sink1 select a, b, listagg(d) from SortedView group by a, b");
        stmtSet.addInsertSql("INSERT INTO Sink2 select a, b, c, d from SortedView");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testSubplanReuseOnOverWindowWithNonDeterministicAggCall() {
        this.util().addTemporarySystemFunction("MyFirst", (UserDefinedFunction)new FirstValueAggFunction(DataTypes.STRING().getLogicalType()));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, MyFirst(c) OVER (PARTITION BY c ORDER BY c DESC) FROM x)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.b < 100 AND r2.b > 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCorrelate() {
        this.util().addTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c, v FROM x, LATERAL TABLE(str_split(c, '-')) AS T(v))\n        |SELECT * FROM r r1, r r2 WHERE r1.v = r2.v\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCorrelateWithNonDeterministicUDTF() {
        this.util().addTemporarySystemFunction("TableFun", (UserDefinedFunction)new JavaUserDefinedTableFunctions.NonDeterministicTableFunc());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c, s FROM x, LATERAL TABLE(TableFun(c)) AS T(s))\n        |SELECT * FROM r r1, r r2 WHERE r1.c = r2.s\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseWithDynamicFunction() {
        Table sqlQuery = this.util().tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                                            |(SELECT a AS random FROM x ORDER BY rand() LIMIT 1)\n                                            |INTERSECT\n                                            |(SELECT a AS random FROM x ORDER BY rand() LIMIT 1)\n                                            |INTERSECT\n                                            |(SELECT a AS random FROM x ORDER BY rand() LIMIT 1)\n      ")).stripMargin());
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNestedSubplanReuse() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH v1 AS (\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY c, e) avg_b,\n        |   RANK() OVER (PARTITION BY c, e ORDER BY c, e) rn,\n        |   c, e\n        | FROM x, y\n        | WHERE x.a = y.d AND c IS NOT NULl AND e > 10\n        | GROUP BY c, e\n        |),\n        |   v2 AS (\n        | SELECT\n        |    v11.c,\n        |    v11.e,\n        |    v11.avg_b,\n        |    v11.sum_b,\n        |    v12.sum_b psum,\n        |    v13.sum_b nsum,\n        |    v12.avg_b avg_b2\n        |  FROM v1 v11, v1 v12, v1 v13\n        |  WHERE v11.c = v12.c AND v11.c = v13.c AND\n        |    v11.e = v12.e AND v11.e = v13.e AND\n        |    v11.rn = v12.rn + 1 AND\n        |    v11.rn = v13.rn - 1\n        |)\n        |SELECT * from v2 WHERE c <> '' AND sum_b - avg_b > 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testBreakupDeadlockOnHashJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a FROM x LIMIT 10)\n        |SELECT r1.a FROM r r1, r r2 WHERE r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testBreakupDeadlockOnNestedLoopJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a FROM x LIMIT 10)\n        |SELECT r1.a FROM r r1, r r2 WHERE r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testEnableReuseTableSourceOnNewSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.testReuseOnNewSource();
    }

    @Test
    public void testDisableReuseTableSourceOnNewSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.testReuseOnNewSource();
    }

    @Test
    public void testReuseTableSourceWithProjectPushDownAndMetaDataKey1() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE reuseTable (\n         |  a bigint,\n         |  b varchar(64),\n         |  c bigint,\n         |  d STRING,\n         |  ts1 TIMESTAMP(3) METADATA,\n         |  ts2 TIMESTAMP(3) METADATA\n         | ) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'true',\n         |  'readable-metadata' = 'ts1:TIMESTAMP(3), ts2:TIMESTAMP(3)'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl1);
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE sink1 (\n         |  a1 bigint,\n         |  b1 VARCHAR(32),\n         |  my_time1 timestamp,\n         |  d1 DECIMAL(20,2)\n         | ) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl2);
        String ddl3 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE sink2 (\n         |  a2 bigint,\n         | `update_time` timestamp\n         | ) WITH (\n         | 'connector' = 'values',\n         | 'bounded' = 'true'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl3);
        String query1 = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT a, b, ts1, CAST(d AS DECIMAL(28,2)) AS d1\n         | FROM reuseTable\n         |")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(query1);
        this.util().tableEnv().createTemporaryView("view1", table);
        String query2 = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT a, ts1 AS update_time\n         | FROM reuseTable\n         |")).stripMargin();
        Table table2 = this.util().tableEnv().sqlQuery(query2);
        this.util().tableEnv().createTemporaryView("view2", table2);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink1 SELECT a, b, ts1, d1 FROM view1");
        stmtSet.addInsertSql("INSERT INTO sink2 SELECT a, update_time FROM view2");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testReuseTableSourceWithProjectPushDownAndMetaDataKey() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE reuseTable (\n         |  a bigint,\n         |  b varchar(64),\n         |  c bigint,\n         |  d STRING,\n         |  my_time TIMESTAMP(3) METADATA FROM 'ts1',\n         |  unUse_time TIMESTAMP(3) METADATA FROM 'ts2'\n         | ) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'true',\n         |  'readable-metadata' = 'ts1:TIMESTAMP(3), ts2:TIMESTAMP(3)'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl1);
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE sink1 (\n         |  a1 bigint,\n         |  b1 VARCHAR(32),\n         |  my_time1 timestamp,\n         |  d1 DECIMAL(20,2)\n         | ) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl2);
        String ddl3 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE sink2 (\n         |  a2 bigint,\n         | `update_time` timestamp\n         | ) WITH (\n         | 'connector' = 'values',\n         | 'bounded' = 'true'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl3);
        String query1 = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT a, b, my_time, CAST(d AS DECIMAL(28,2)) AS d1\n         | FROM reuseTable\n         |")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(query1);
        this.util().tableEnv().createTemporaryView("view1", table);
        String query2 = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT a, my_time AS update_time\n         | FROM reuseTable\n         |")).stripMargin();
        Table table2 = this.util().tableEnv().sqlQuery(query2);
        this.util().tableEnv().createTemporaryView("view2", table2);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink1 SELECT a, b, my_time, d1 FROM view1");
        stmtSet.addInsertSql("INSERT INTO sink2 SELECT a, update_time FROM view2");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testSourceReuseWithEmptyFilterCondAndIgnoreEmptyFilter() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table MyTable(\n                     |  a int,\n                     |  b bigint,\n                     |  c varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT * FROM MyTable T1, MyTable T2 WHERE T1.a = T2.a AND T1.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSourceReuseWithEmptyFilterCondAndIgnoreEmptyFilterTrue() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table MyTable(\n                     |  a int,\n                     |  b bigint,\n                     |  c varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT * FROM MyTable T1, MyTable T2 WHERE T1.a = T2.a AND T1.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSourceReuseWithEmptyFilterCondAndIgnoreEmptyFilterTrue2() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table MyTable(\n                     |  a int,\n                     |  b bigint,\n                     |  c varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT * FROM MyTable T1, MyTable T2 WHERE T1.a = T2.a AND T2.a < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    private void testReuseOnNewSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table newX(\n                     |  a int,\n                     |  b bigint,\n                     |  c varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table newY(\n                     |  d int,\n                     |  e bigint,\n                     |  f varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t AS (\n        |  SELECT newX.a AS a, newX.b AS b, newY.d AS d, newY.e AS e\n        |  FROM newX, newY\n        |  WHERE newX.a = newY.d)\n        |SELECT t1.*, t2.* FROM t t1, t t2 WHERE t1.b = t2.e AND t1.a < 10 AND t2.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }
}

