/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.PartitionableSinkTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t4A\u0001D\u0007\u0001=!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003B\u0002\u0018\u0001A\u0003%1\u0006C\u00030\u0001\u0011%\u0001\u0007C\u0003J\u0001\u0011\u0005!\nC\u0003W\u0001\u0011\u0005!\nC\u0003Y\u0001\u0011\u0005!\nC\u0003[\u0001\u0011\u0005!\nC\u0003]\u0001\u0011\u0005!\nC\u0003_\u0001\u0011\u0005!\nC\u0003a\u0001\u0011\u0005!JA\u000bQCJ$\u0018\u000e^5p]\u0006\u0014G.Z*j].$Vm\u001d;\u000b\u00059y\u0011aA:rY*\u0011\u0001#E\u0001\u0006E\u0006$8\r\u001b\u0006\u0003%M\tA\u0001\u001d7b]*\u0011A#F\u0001\ba2\fgN\\3s\u0015\t1r#A\u0003uC\ndWM\u0003\u0002\u00193\u0005)a\r\\5oW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t\u001a\u0012!B;uS2\u001c\u0018B\u0001\u0013\"\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012a\n\t\u0003Q\u0001i\u0011!D\u0001\u0005kRLG.F\u0001,!\t\u0001C&\u0003\u0002.C\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0003\u0015)H/\u001b7!\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u0007E:D\t\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0003V]&$\b\"\u0002\u001d\u0005\u0001\u0004I\u0014\u0001\u00028b[\u0016\u0004\"AO!\u000f\u0005mz\u0004C\u0001\u001f4\u001b\u0005i$B\u0001 \u001e\u0003\u0019a$o\\8u}%\u0011\u0001iM\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002Ag!)Q\t\u0002a\u0001\r\u0006I1\u000f[;gM2,')\u001f\t\u0003e\u001dK!\u0001S\u001a\u0003\u000f\t{w\u000e\\3b]\u0006QA/Z:u'R\fG/[2\u0015\u0003EB#!\u0002'\u0011\u00055#V\"\u0001(\u000b\u0005=\u0003\u0016aA1qS*\u0011\u0011KU\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00196$A\u0003kk:LG/\u0003\u0002V\u001d\n!A+Z:u\u0003-!Xm\u001d;Es:\fW.[2)\u0005\u0019a\u0015\u0001\u0006;fgR$\u0015P\\1nS\u000e\u001c\u0006.\u001e4gY\u0016\u0014\u0015\u0010\u000b\u0002\b\u0019\u0006YA/Z:u!\u0006\u0014H/[1mQ\tAA*A\buKN$xK]8oON#\u0018\r^5dQ\tIA*A\buKN$xK]8oO\u001aKW\r\u001c3tQ\tQA*\u0001\u000buKN$8\u000b^1uS\u000e<\u0016\u000e\u001e5WC2,Xm\u001d\u0015\u0003\u00171\u0003")
public class PartitionableSinkTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    private void createTable(String name, boolean shuffleBy) {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(270).append("\n         |create table ").append(name).append(" (\n         |  a bigint,\n         |  b bigint,\n         |  c bigint\n         |) partitioned by (b, c) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '/non',\n         |  ").append((Object)(shuffleBy ? "'sink.shuffle-by-partition.enable'='true'," : "")).append("\n         |  'format' = 'testcsv'\n         |)\n         |").toString())).stripMargin());
    }

    @Test
    public void testStatic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1, c=1) SELECT a FROM MyTable");
    }

    @Test
    public void testDynamic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testDynamicShuffleBy() {
        this.createTable("sinkShuffleBy", true);
        this.util().verifyExecPlanInsert("INSERT INTO sinkShuffleBy SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testPartial() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, c FROM MyTable");
    }

    @Test
    public void testWrongStatic() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (a=1) SELECT b, c FROM MyTable"));
    }

    @Test
    public void testWrongFields() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, b, c FROM MyTable"));
    }

    @Test
    public void testStaticWithValues() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1, c=1) VALUES (5)");
    }

    public PartitionableSinkTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.PartitionableSinkTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.createTable("sink", false);
    }
}

