/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.LimitTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001E4AAF\f\u0001Q!)q\u0006\u0001C\u0001a!91\u0007\u0001b\u0001\n#!\u0004B\u0002\u001d\u0001A\u0003%Q\u0007C\u0003:\u0001\u0011\u0005!\bC\u0003M\u0001\u0011\u0005!\bC\u0003R\u0001\u0011\u0005!\bC\u0003T\u0001\u0011\u0005!\bC\u0003V\u0001\u0011\u0005!\bC\u0003X\u0001\u0011\u0005!\bC\u0003Z\u0001\u0011\u0005!\bC\u0003\\\u0001\u0011\u0005!\bC\u0003^\u0001\u0011\u0005!\bC\u0003`\u0001\u0011\u0005!\bC\u0003b\u0001\u0011\u0005!\bC\u0003d\u0001\u0011\u0005!\bC\u0003f\u0001\u0011\u0005!\bC\u0003h\u0001\u0011\u0005!\bC\u0003j\u0001\u0011\u0005!\bC\u0003l\u0001\u0011\u0005!\bC\u0003n\u0001\u0011\u0005!\bC\u0003p\u0001\u0011\u0005!HA\u0005MS6LG\u000fV3ti*\u0011\u0001$G\u0001\u0004gFd'B\u0001\u000e\u001c\u0003\u0015\u0011\u0017\r^2i\u0015\taR$\u0001\u0003qY\u0006t'B\u0001\u0010 \u0003\u001d\u0001H.\u00198oKJT!\u0001I\u0011\u0002\u000bQ\f'\r\\3\u000b\u0005\t\u001a\u0013!\u00024mS:\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001SA\u0011!&L\u0007\u0002W)\u0011A&H\u0001\u0006kRLGn]\u0005\u0003]-\u0012Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u00012!\t\u0011\u0004!D\u0001\u0018\u0003\u0011)H/\u001b7\u0016\u0003U\u0002\"A\u000b\u001c\n\u0005]Z#A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\nQa]3ukB$\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0005+:LG\u000f\u000b\u0002\u0005\u0005B\u00111IS\u0007\u0002\t*\u0011QIR\u0001\u0004CBL'BA$I\u0003\u001dQW\u000f]5uKJT!!S\u0013\u0002\u000b),h.\u001b;\n\u0005-#%A\u0003\"fM>\u0014X-R1dQ\u00061B/Z:u\u0019&l\u0017\u000e^,ji\"|W\u000f^(gMN,G\u000f\u000b\u0002\u0006\u001dB\u00111iT\u0005\u0003!\u0012\u0013A\u0001V3ti\u00069B/Z:u\u0019&l\u0017\u000e\u001e\u0019XSRDw.\u001e;PM\u001a\u001cX\r\u001e\u0015\u0003\r9\u000ba\u0004^3ti:+w-\u0019;jm\u0016d\u0015.\\5u/&$\bn\\;u\u001f\u001a47/\u001a;)\u0005\u001dq\u0015a\u0005;fgRd\u0015.\\5u/&$\bn\u00144gg\u0016$\bF\u0001\u0005O\u0003Q!Xm\u001d;MS6LGoV5uQ>3gm]3ua!\u0012\u0011BT\u0001\u0016i\u0016\u001cH\u000fT5nSR\u0004t+\u001b;i\u001f\u001a47/\u001a;1Q\tQa*\u0001\u000buKN$H*[7jiB:\u0016\u000e\u001e5PM\u001a\u001cX\r\u001e\u0015\u0003\u00179\u000b1\u0004^3ti2KW.\u001b;XSRDg*Z4bi&4Xm\u00144gg\u0016$\bF\u0001\u0007O\u0003M!Xm\u001d;GKR\u001c\u0007nV5uQ>3gm]3uQ\tia*\u0001\fuKN$h)\u001a;dQ^KG\u000f[8vi>3gm]3uQ\tqa*A\fuKN$h)\u001a;dQB:\u0016\u000e\u001e5pkR|eMZ:fi\"\u0012qBT\u0001\u000fi\u0016\u001cHo\u00148ms>3gm]3uQ\t\u0001b*\u0001\ruKN$h)\u001a;dQ^KG\u000f\u001b'j[&$8k\\;sG\u0016D#!\u0005(\u00025Q,7\u000f^(sI\u0016\u0014()_,ji\"d\u0015.\\5u'>,(oY3)\u0005Iq\u0015\u0001\u0007;fgRd\u0015.\\5u/&$\b\u000eT5nSR\u001cv.\u001e:dK\"\u00121CT\u0001\"i\u0016\u001cH\u000fT5nSR<\u0016\u000e\u001e5PM\u001a\u001cX\r^!oI2KW.\u001b;T_V\u00148-\u001a\u0015\u0003)9\u000b\u0011\u0005^3ti\u001a+Go\u00195XSRDwJ\u001a4tKR\fe\u000e\u001a'j[&$8k\\;sG\u0016D#!\u0006(")
public class LimitTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.LimitTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE LimitTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testLimitWithoutOffset() {
        this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT 5");
    }

    @Test
    public void testLimit0WithoutOffset() {
        this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT 0");
    }

    @Test
    public void testNegativeLimitWithoutOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT -1"));
    }

    @Test
    public void testLimitWithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET 1");
    }

    @Test
    public void testLimitWithOffset0() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET 0");
    }

    @Test
    public void testLimit0WithOffset0() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 0 OFFSET 0");
    }

    @Test
    public void testLimit0WithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 0 OFFSET 10");
    }

    @Test
    public void testLimitWithNegativeOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET -1"));
    }

    @Test
    public void testFetchWithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable OFFSET 10 ROWS FETCH NEXT 10 ROWS ONLY");
    }

    @Test
    public void testFetchWithoutOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable FETCH FIRST 10 ROWS ONLY");
    }

    @Test
    public void testFetch0WithoutOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable FETCH FIRST 0 ROWS ONLY");
    }

    @Test
    public void testOnlyOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable OFFSET 10 ROWS");
    }

    @Test
    public void testFetchWithLimitSource() {
        String sqlQuery = "SELECT a, c FROM LimitTable FETCH FIRST 10 ROWS ONLY";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOrderByWithLimitSource() {
        String sqlQuery = "SELECT a, c FROM LimitTable ORDER BY c LIMIT 10";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testLimitWithLimitSource() {
        String sqlQuery = "SELECT a, c FROM LimitTable LIMIT 10";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testLimitWithOffsetAndLimitSource() {
        String sqlQuery = "SELECT a, c FROM LimitTable LIMIT 10 OFFSET 1";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testFetchWithOffsetAndLimitSource() {
        String sqlQuery = "SELECT a, c FROM LimitTable OFFSET 10 ROWS FETCH NEXT 10 ROWS ONLY";
        this.util().verifyExecPlan(sqlQuery);
    }
}

