/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.DeadlockBreakupTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!4Aa\u0005\u000b\u0001K!)A\u0006\u0001C\u0001[!9\u0001\u0007\u0001b\u0001\n\u0013\t\u0004BB\u001b\u0001A\u0003%!\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003J\u0001\u0011\u0005q\u0007C\u0003O\u0001\u0011\u0005q\u0007C\u0003Q\u0001\u0011\u0005q\u0007C\u0003S\u0001\u0011\u0005q\u0007C\u0003U\u0001\u0011\u0005q\u0007C\u0003W\u0001\u0011\u0005q\u0007C\u0003Y\u0001\u0011\u0005q\u0007C\u0003[\u0001\u0011\u0005q\u0007C\u0003]\u0001\u0011\u0005q\u0007C\u0003_\u0001\u0011\u0005q\u0007C\u0003a\u0001\u0011\u0005q\u0007C\u0003c\u0001\u0011\u0005q\u0007C\u0003e\u0001\u0011\u0005q\u0007C\u0003g\u0001\u0011\u0005qGA\nEK\u0006$Gn\\2l\u0005J,\u0017m[;q)\u0016\u001cHO\u0003\u0002\u0016-\u0005\u00191/\u001d7\u000b\u0005]A\u0012!\u00022bi\u000eD'BA\r\u001b\u0003\u0011\u0001H.\u00198\u000b\u0005ma\u0012a\u00029mC:tWM\u001d\u0006\u0003;y\tQ\u0001^1cY\u0016T!a\b\u0011\u0002\u000b\u0019d\u0017N\\6\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0005\u0005\u0002(U5\t\u0001F\u0003\u0002*5\u0005)Q\u000f^5mg&\u00111\u0006\u000b\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005q\u0003CA\u0018\u0001\u001b\u0005!\u0012\u0001B;uS2,\u0012A\r\t\u0003OMJ!\u0001\u000e\u0015\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\\\u0001\u0006kRLG\u000eI\u0001\u0007E\u00164wN]3\u0015\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012A!\u00168ji\"\u0012Aa\u0010\t\u0003\u0001\u001ek\u0011!\u0011\u0006\u0003\u0005\u000e\u000b1!\u00199j\u0015\t!U)A\u0004kkBLG/\u001a:\u000b\u0005\u0019\u0013\u0013!\u00026v]&$\u0018B\u0001%B\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001$i\u0016\u001cHoU;ca2\fgNU3vg\u0016|6+\u001a;Fq\u000eD\u0017M\\4f\u0003N\u0014\u0015\r^2iQ\t)1\n\u0005\u0002A\u0019&\u0011Q*\u0011\u0002\u0005)\u0016\u001cH/\u0001\u0017uKN$8+\u001e2qY\u0006t'+Z;tK~\u000bE\rZ#yG\"\fgnZ3Bg\n\u000bGo\u00195`\u0011\u0006\u001c\bNS8j]\"\u0012aaS\u00013i\u0016\u001cHoU;ca2\fgNU3vg\u0016|\u0016\t\u001a3Fq\u000eD\u0017M\\4f\u0003N\u0014\u0015\r^2i?:+7\u000f^3e\u0019>|\u0007OS8j]\"\u0012qaS\u00012i\u0016\u001cHoU;ca2\fgNU3vg\u0016|6+\u001a;Fq\u000eD\u0017M\\4f\u0003N\u0014\u0015\r^2i?N{'\u000f^'fe\u001e,'j\\5oQ\tA1*A\u001duKN$8+\u001e2qY\u0006t'+Z;tK~\u000bE\rZ#yG\"\fgnZ3Bg\n\u000bGo\u00195`\u0005VLG\u000e\u001a'fMR\u001cV-\\5ICND'j\\5oQ\tI1*A\u0016uKN$8+\u001e2qY\u0006t'+Z;tK~\u001bV\r^#yG\"\fgnZ3Bg\n\u000bGo\u00195`\u001fZ,'/Q4hQ\tQ1*A\u000euKN$(+Z;tK\u0012tu\u000eZ3Jg\n\u000b'O]5fe:{G-\u001a\u0015\u0003\u0017-\u000ba\u0005^3ti\u0012\u000bG/Y*ue\u0016\fWNU3vg\u0016|6+\u001a;Fq\u000eD\u0017M\\4f\u0003N\u0014\u0015\r^2iQ\ta1*A\u001buKN$H)\u0019;b'R\u0014X-Y7SKV\u001cXmX!eI\u0016C8\r[1oO\u0016\f5OQ1uG\"|f*Z:uK\u0012dun\u001c9K_&t\u0007FA\u0007L\u0003=\"Xm\u001d;ECR\f7\u000b\u001e:fC6\u0014V-^:f?\u0006#G-\u0012=dQ\u0006tw-Z!t\u0005\u0006$8\r[0ICND'j\\5oQ\tq1*A\u001duKN$8+\u001e2qY\u0006t'+Z;tK~\u0013U/\u001b7e\u0003:$\u0007K]8cK:{7i\\7n_:\u001cVoY2fgN|'o]0ICND'j\\5oQ\ty1*A\u0013uKN$8+\u001e2qY\u0006t'+Z;tK~\u000bE\rZ*j]\u001edW\r^8o\u000bb\u001c\u0007.\u00198hK\"\u0012\u0001cS\u00011i\u0016\u001cHoU;ca2\fgNU3vg\u0016|F)Z1eY>\u001c7nQ1vg\u0016$')\u001f*fkNLgnZ#yG\"\fgnZ3)\u0005EY\u0015A\u000f;fgR\u001cVO\u00199mC:\u0014V-^:f?\u0012+\u0017\r\u001a7pG.\u001c\u0015-^:fI\nK(+Z;tS:<W\t_2iC:<W-\u00138B]\u000e,7\u000f^8sQ\t\u00112\n")
public class DeadlockBreakupTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)BatchShuffleMode.ALL_EXCHANGES_PIPELINED);
        this.util().addTableSource("x", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.DeadlockBreakupTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("y", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.DeadlockBreakupTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addDataStream("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.DeadlockBreakupTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testSubplanReuse_SetExchangeAsBatch() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t AS (SELECT x.a AS a, x.b AS b, y.d AS d, y.e AS e FROM x, y WHERE x.a = y.d)\n        |SELECT t1.*, t2.* FROM t t1, t t2 WHERE t1.b = t2.e AND t1.a < 10 AND t2.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuse_AddExchangeAsBatch_HashJoin() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a FROM x LIMIT 10)\n        |SELECT r1.a FROM r r1, r r2 WHERE r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuse_AddExchangeAsBatch_NestedLoopJoin() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a FROM x LIMIT 10)\n        |SELECT r1.a FROM r r1, r r2 WHERE r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuse_SetExchangeAsBatch_SortMergeJoin() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,HashAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |\n        |WITH v1 AS (SELECT a, SUM(b) AS b, MAX(c) AS c FROM x GROUP BY a),\n        |     v2 AS (SELECT * FROM v1 r1, v1 r2 WHERE r1.a = r2.a AND r1.b > 10),\n        |     v3 AS (SELECT * FROM v1 r1, v1 r2 WHERE r1.a = r2.a AND r1.b < 5)\n        |\n        |select * from v2, v3 where v2.c = v3.c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuse_AddExchangeAsBatch_BuildLeftSemiHashJoin() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b FROM x LIMIT 10)\n        |SELECT r1.a, r2.b FROM x r1,\n        |(SELECT a, b FROM r WHERE a in (select a from x where b > 5)) r2\n        |WHERE r1.a = r2.a and r1.b = 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuse_SetExchangeAsBatch_OverAgg() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r1 AS (SELECT SUM(a) OVER (PARTITION BY b ORDER BY b) AS a, b, c FROM x),\n        | r2 AS (SELECT MAX(a) OVER (PARTITION BY b ORDER BY b\n        | RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) AS a, b, c FROM r1),\n        | r3 AS (SELECT MIN(a) OVER (PARTITION BY b ORDER BY b\n        | RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) AS a, b, c FROM r1)\n        |\n        |SELECT * FROM r2, r3 WHERE r2.c = r3.c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testReusedNodeIsBarrierNode() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c)\n        |    SELECT * FROM r r1, r r2 WHERE r1.a = r2.b AND r2.a > 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDataStreamReuse_SetExchangeAsBatch() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = "SELECT * FROM t t1, t t2 WHERE t1.a = t2.a AND t1.b > 10 AND t2.c LIKE 'Test%'";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDataStreamReuse_AddExchangeAsBatch_NestedLoopJoin() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = "SELECT * FROM t t1, t t2 WHERE t1.a = t2.b";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDataStreamReuse_AddExchangeAsBatch_HashJoin() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = "SELECT * FROM t INTERSECT SELECT * FROM t";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuse_BuildAndProbeNoCommonSuccessors_HashJoin() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |WITH\n         |  T1 AS (SELECT a, COUNT(*) AS cnt1 FROM x GROUP BY a),\n         |  T2 AS (SELECT d, COUNT(*) AS cnt2 FROM y GROUP BY d)\n         |SELECT * FROM\n         |  (SELECT cnt1, cnt2 FROM T1 LEFT JOIN T2 ON a = d)\n         |  UNION ALL\n         |  (SELECT cnt1, cnt2 FROM T2 LEFT JOIN T1 ON d = a)\n         |")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuse_AddSingletonExchange() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin,HashAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |WITH\n         |  T1 AS (SELECT COUNT(*) AS cnt FROM x),\n         |  T2 AS (SELECT cnt FROM T1 WHERE cnt > 3),\n         |  T3 AS (SELECT cnt FROM T1 WHERE cnt < 5)\n         |SELECT * FROM T2 FULL JOIN T3 ON T2.cnt <> T3.cnt\n         |")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuse_DeadlockCausedByReusingExchange() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |WITH T1 AS (SELECT a FROM x)\n         |SELECT * FROM T1\n         |  INNER JOIN T1 AS T2 ON T1.a = T2.a\n         |")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuse_DeadlockCausedByReusingExchangeInAncestor() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }
}

