/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.DescribeCatalogOperation;
import org.apache.flink.table.operations.DescribeFunctionOperation;
import org.apache.flink.table.operations.LoadModuleOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ShowCatalogsOperation;
import org.apache.flink.table.operations.ShowCreateCatalogOperation;
import org.apache.flink.table.operations.ShowDatabasesOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowModulesOperation;
import org.apache.flink.table.operations.ShowPartitionsOperation;
import org.apache.flink.table.operations.ShowProceduresOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.ShowViewsOperation;
import org.apache.flink.table.operations.UnloadModuleOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.UseModulesOperation;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.ClearOperation;
import org.apache.flink.table.operations.command.HelpOperation;
import org.apache.flink.table.operations.command.QuitOperation;
import org.apache.flink.table.operations.command.RemoveJarOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.command.ShowJarsOperation;
import org.apache.flink.table.operations.utils.LikeType;
import org.apache.flink.table.operations.utils.ShowLikeOperator;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversionTestBase;
import org.apache.flink.table.planner.parse.ExtendedParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class SqlOtherOperationConverterTest
extends SqlNodeToOperationConversionTestBase {
    @Test
    void testUseCatalog() {
        String sql = "USE CATALOG cat1";
        Operation operation = this.parse("USE CATALOG cat1");
        Assertions.assertThat((Object)operation).isInstanceOf(UseCatalogOperation.class);
        Assertions.assertThat((String)((UseCatalogOperation)operation).getCatalogName()).isEqualTo("cat1");
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("USE CATALOG cat1");
    }

    @ParameterizedTest
    @CsvSource(value={"true,true", "true,false", "false,true", "false,false"})
    void testDescribeCatalog(boolean abbr, boolean extended) {
        String catalogName = "cat1";
        String sql = String.format("%s CATALOG %s %s", abbr ? "DESC" : "DESCRIBE", extended ? "EXTENDED" : "", "cat1");
        Operation operation = this.parse(sql);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)operation).isInstanceOf(DescribeCatalogOperation.class)).asInstanceOf(InstanceOfAssertFactories.type(DescribeCatalogOperation.class))).extracting(new Function[]{DescribeCatalogOperation::getCatalogName, DescribeCatalogOperation::isExtended, DescribeCatalogOperation::asSummaryString}).containsExactly(new Object[]{"cat1", extended, String.format("DESCRIBE CATALOG: (identifier: [%s], isExtended: [%b])", "cat1", extended)});
    }

    @ParameterizedTest
    @CsvSource(value={"true,true", "true,false", "false,true", "false,false"})
    void testDescribeFunction(boolean abbr, boolean extended) {
        String functionName = "f1";
        UnresolvedIdentifier functionIdentifier = UnresolvedIdentifier.of((String[])new String[]{"f1"});
        String sql = String.format("%s FUNCTION %s %s", abbr ? "DESC" : "DESCRIBE", extended ? "EXTENDED" : "", "f1");
        Operation operation = this.parse(sql);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)operation).isInstanceOf(DescribeFunctionOperation.class)).asInstanceOf(InstanceOfAssertFactories.type(DescribeFunctionOperation.class))).extracting(new Function[]{DescribeFunctionOperation::getSqlIdentifier, DescribeFunctionOperation::isExtended, DescribeFunctionOperation::asSummaryString}).containsExactly(new Object[]{functionIdentifier, extended, String.format("DESCRIBE FUNCTION: (identifier: [%s], isExtended: [%b])", functionIdentifier, extended)});
    }

    @Test
    void testUseDatabase() {
        String sql1 = "USE db1";
        Operation operation1 = this.parse("USE db1");
        Assertions.assertThat((Object)operation1).isInstanceOf(UseDatabaseOperation.class);
        Assertions.assertThat((String)((UseDatabaseOperation)operation1).getCatalogName()).isEqualTo("builtin");
        Assertions.assertThat((String)((UseDatabaseOperation)operation1).getDatabaseName()).isEqualTo("db1");
        String sql2 = "USE cat1.db1";
        Operation operation2 = this.parse("USE cat1.db1");
        Assertions.assertThat((Object)operation2).isInstanceOf(UseDatabaseOperation.class);
        Assertions.assertThat((String)((UseDatabaseOperation)operation2).getCatalogName()).isEqualTo("cat1");
        Assertions.assertThat((String)((UseDatabaseOperation)operation2).getDatabaseName()).isEqualTo("db1");
    }

    @Test
    void testUseDatabaseWithException() {
        String sql = "USE cat1.db1.tbl1";
        Assertions.assertThatThrownBy(() -> this.parse("USE cat1.db1.tbl1")).isInstanceOf(ValidationException.class);
    }

    @Test
    void testLoadModule() {
        String sql = "LOAD MODULE dummy WITH ('k1' = 'v1', 'k2' = 'v2')";
        String expectedModuleName = "dummy";
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("k1", "v1");
        expectedOptions.put("k2", "v2");
        Operation operation = this.parse("LOAD MODULE dummy WITH ('k1' = 'v1', 'k2' = 'v2')");
        Assertions.assertThat((Object)operation).isInstanceOf(LoadModuleOperation.class);
        LoadModuleOperation loadModuleOperation = (LoadModuleOperation)operation;
        Assertions.assertThat((String)loadModuleOperation.getModuleName()).isEqualTo("dummy");
        Assertions.assertThat((Map)loadModuleOperation.getOptions()).isEqualTo(expectedOptions);
    }

    @Test
    void testUnloadModule() {
        String sql = "UNLOAD MODULE dummy";
        String expectedModuleName = "dummy";
        Operation operation = this.parse("UNLOAD MODULE dummy");
        Assertions.assertThat((Object)operation).isInstanceOf(UnloadModuleOperation.class);
        UnloadModuleOperation unloadModuleOperation = (UnloadModuleOperation)operation;
        Assertions.assertThat((String)unloadModuleOperation.getModuleName()).isEqualTo("dummy");
    }

    @Test
    void testUseOneModule() {
        String sql = "USE MODULES dummy";
        List<String> expectedModuleNames = Collections.singletonList("dummy");
        Operation operation = this.parse("USE MODULES dummy");
        Assertions.assertThat((Object)operation).isInstanceOf(UseModulesOperation.class);
        UseModulesOperation useModulesOperation = (UseModulesOperation)operation;
        Assertions.assertThat((List)useModulesOperation.getModuleNames()).isEqualTo(expectedModuleNames);
        Assertions.assertThat((String)useModulesOperation.asSummaryString()).isEqualTo("USE MODULES: [dummy]");
    }

    @Test
    void testUseMultipleModules() {
        String sql = "USE MODULES x, y, z";
        List<String> expectedModuleNames = Arrays.asList("x", "y", "z");
        Operation operation = this.parse("USE MODULES x, y, z");
        Assertions.assertThat((Object)operation).isInstanceOf(UseModulesOperation.class);
        UseModulesOperation useModulesOperation = (UseModulesOperation)operation;
        Assertions.assertThat((List)useModulesOperation.getModuleNames()).isEqualTo(expectedModuleNames);
        Assertions.assertThat((String)useModulesOperation.asSummaryString()).isEqualTo("USE MODULES: [x, y, z]");
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"inputForShowCatalogsTest"})
    void testShowCatalogs(String sql, ShowCatalogsOperation expected, String expectedSummary) {
        Operation operation = this.parse(sql);
        ((ObjectAssert)Assertions.assertThat((Object)operation).isInstanceOf(ShowCatalogsOperation.class)).isEqualTo((Object)expected);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo(expectedSummary);
    }

    private static Stream<Arguments> inputForShowCatalogsTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{"show catalogs", new ShowCatalogsOperation(null), "SHOW CATALOGS"}), Arguments.of((Object[])new Object[]{"show catalogs like 'c%'", new ShowCatalogsOperation(ShowLikeOperator.of((LikeType)LikeType.LIKE, (String)"c%")), "SHOW CATALOGS LIKE 'c%'"}), Arguments.of((Object[])new Object[]{"show catalogs not like 'c%'", new ShowCatalogsOperation(ShowLikeOperator.of((LikeType)LikeType.NOT_LIKE, (String)"c%")), "SHOW CATALOGS NOT LIKE 'c%'"}), Arguments.of((Object[])new Object[]{"show catalogs ilike 'c%'", new ShowCatalogsOperation(ShowLikeOperator.of((LikeType)LikeType.ILIKE, (String)"c%")), "SHOW CATALOGS ILIKE 'c%'"}), Arguments.of((Object[])new Object[]{"show catalogs not ilike 'c%'", new ShowCatalogsOperation(ShowLikeOperator.of((LikeType)LikeType.NOT_ILIKE, (String)"c%")), "SHOW CATALOGS NOT ILIKE 'c%'"}));
    }

    @Test
    void testShowModules() {
        String sql = "SHOW MODULES";
        Operation operation = this.parse("SHOW MODULES");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowModulesOperation.class);
        ShowModulesOperation showModulesOperation = (ShowModulesOperation)operation;
        Assertions.assertThat((boolean)showModulesOperation.requireFull()).isFalse();
        Assertions.assertThat((String)showModulesOperation.asSummaryString()).isEqualTo("SHOW MODULES");
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"inputForShowTablesTest"})
    void testShowTables(String sql, ShowTablesOperation expected, String expectedSummary) {
        Operation operation = this.parse(sql);
        ((ObjectAssert)Assertions.assertThat((Object)operation).isInstanceOf(ShowTablesOperation.class)).isEqualTo((Object)expected);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo(expectedSummary);
    }

    private static Stream<Arguments> inputForShowTablesTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{"SHOW TABLES from cat1.db1 not like 't%'", new ShowTablesOperation("cat1", "db1", "FROM", ShowLikeOperator.of((LikeType)LikeType.NOT_LIKE, (String)"t%")), "SHOW TABLES FROM cat1.db1 NOT LIKE 't%'"}), Arguments.of((Object[])new Object[]{"SHOW TABLES in db2", new ShowTablesOperation("builtin", "db2", "IN", null), "SHOW TABLES IN builtin.db2"}), Arguments.of((Object[])new Object[]{"SHOW TABLES", new ShowTablesOperation("builtin", "default", null, null), "SHOW TABLES"}));
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"inputForShowViewsTest"})
    void testShowViews(String sql, ShowViewsOperation expected, String expectedSummary) {
        Operation operation = this.parse(sql);
        ((ObjectAssert)Assertions.assertThat((Object)operation).isInstanceOf(ShowViewsOperation.class)).isEqualTo((Object)expected);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo(expectedSummary);
    }

    private static Stream<Arguments> inputForShowViewsTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{"SHOW VIEWS from cat1.db1 not like 't%'", new ShowViewsOperation("cat1", "db1", "FROM", ShowLikeOperator.of((LikeType)LikeType.NOT_LIKE, (String)"t%")), "SHOW VIEWS FROM cat1.db1 NOT LIKE 't%'"}), Arguments.of((Object[])new Object[]{"SHOW VIEWS in db2", new ShowViewsOperation("builtin", "db2", "IN", null), "SHOW VIEWS IN builtin.db2"}), Arguments.of((Object[])new Object[]{"SHOW VIEWS", new ShowViewsOperation("builtin", "default", null, null), "SHOW VIEWS"}));
    }

    @Test
    void testShowCreateCatalog() {
        Operation operation = this.parse("show create catalog cat1");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowCreateCatalogOperation.class);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("SHOW CREATE CATALOG cat1");
    }

    @Test
    void testShowFullModules() {
        String sql = "SHOW FULL MODULES";
        Operation operation = this.parse("SHOW FULL MODULES");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowModulesOperation.class);
        ShowModulesOperation showModulesOperation = (ShowModulesOperation)operation;
        Assertions.assertThat((boolean)showModulesOperation.requireFull()).isTrue();
        Assertions.assertThat((String)showModulesOperation.asSummaryString()).isEqualTo("SHOW FULL MODULES");
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"inputForShowFunctionsTest"})
    void testShowFunctions(String sql, ShowFunctionsOperation expected, String expectedSummary) {
        Operation operation = this.parse(sql);
        ((ObjectAssert)Assertions.assertThat((Object)operation).isInstanceOf(ShowFunctionsOperation.class)).isEqualTo((Object)expected);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo(expectedSummary);
    }

    private static Stream<Arguments> inputForShowFunctionsTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{"show functions", new ShowFunctionsOperation(ShowFunctionsOperation.FunctionScope.ALL, null, "builtin", "default", null), "SHOW FUNCTIONS"}), Arguments.of((Object[])new Object[]{"show user functions", new ShowFunctionsOperation(ShowFunctionsOperation.FunctionScope.USER, null, "builtin", "default", null), "SHOW USER FUNCTIONS"}), Arguments.of((Object[])new Object[]{"show functions from cat1.db1 not like 'f%'", new ShowFunctionsOperation(ShowFunctionsOperation.FunctionScope.ALL, "FROM", "cat1", "db1", ShowLikeOperator.of((LikeType)LikeType.NOT_LIKE, (String)"f%")), "SHOW FUNCTIONS FROM cat1.db1 NOT LIKE 'f%'"}), Arguments.of((Object[])new Object[]{"show user functions in cat1.db1 ilike 'f%'", new ShowFunctionsOperation(ShowFunctionsOperation.FunctionScope.USER, "IN", "cat1", "db1", ShowLikeOperator.of((LikeType)LikeType.ILIKE, (String)"f%")), "SHOW USER FUNCTIONS IN cat1.db1 ILIKE 'f%'"}), Arguments.of((Object[])new Object[]{"show functions in db1", new ShowFunctionsOperation(ShowFunctionsOperation.FunctionScope.ALL, "IN", "builtin", "db1", null), "SHOW FUNCTIONS IN builtin.db1"}));
    }

    @Test
    void testShowDatabasesFailCase() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("show databases in db.t")).isInstanceOf(SqlParserException.class)).hasMessage("SQL parse failed. Show databases from/in identifier [ db.t ] format error, catalog must be a single part identifier.");
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"inputForShowDatabasesTest"})
    void testShowDatabases(String sql, ShowDatabasesOperation expected, String expectedSummary) {
        Operation operation = this.parse(sql);
        ((ObjectAssert)Assertions.assertThat((Object)operation).isInstanceOf(ShowDatabasesOperation.class)).isEqualTo((Object)expected);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo(expectedSummary);
    }

    private static Stream<Arguments> inputForShowDatabasesTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{"SHOW DATABASES", new ShowDatabasesOperation("builtin", null, null), "SHOW DATABASES"}), Arguments.of((Object[])new Object[]{"show databases from cat1 not like 'f%'", new ShowDatabasesOperation("cat1", "FROM", ShowLikeOperator.of((LikeType)LikeType.NOT_LIKE, (String)"f%")), "SHOW DATABASES FROM cat1 NOT LIKE 'f%'"}), Arguments.of((Object[])new Object[]{"show databases from cat1 not ilike 'f%'", new ShowDatabasesOperation("cat1", "FROM", ShowLikeOperator.of((LikeType)LikeType.NOT_ILIKE, (String)"f%")), "SHOW DATABASES FROM cat1 NOT ILIKE 'f%'"}), Arguments.of((Object[])new Object[]{"show databases from cat1 like 'f%'", new ShowDatabasesOperation("cat1", "FROM", ShowLikeOperator.of((LikeType)LikeType.LIKE, (String)"f%")), "SHOW DATABASES FROM cat1 LIKE 'f%'"}), Arguments.of((Object[])new Object[]{"show databases in cat1 ilike 'f%'", new ShowDatabasesOperation("cat1", "IN", ShowLikeOperator.of((LikeType)LikeType.ILIKE, (String)"f%")), "SHOW DATABASES IN cat1 ILIKE 'f%'"}), Arguments.of((Object[])new Object[]{"show databases in cat1", new ShowDatabasesOperation("cat1", "IN", null), "SHOW DATABASES IN cat1"}));
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"inputForShowProceduresTest"})
    void testShowProcedures(String sql, ShowProceduresOperation expected) {
        Operation operation = this.parse(sql);
        ((ObjectAssert)Assertions.assertThat((Object)operation).isInstanceOf(ShowProceduresOperation.class)).isEqualTo((Object)expected);
    }

    private static Stream<Arguments> inputForShowProceduresTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{"SHOW procedures from cat1.db1 not like 't%'", new ShowProceduresOperation("cat1", "db1", "FROM", ShowLikeOperator.of((LikeType)LikeType.NOT_LIKE, (String)"t%"))}), Arguments.of((Object[])new Object[]{"SHOW procedures from cat1.db1 ilike 't%'", new ShowProceduresOperation("cat1", "db1", "FROM", ShowLikeOperator.of((LikeType)LikeType.ILIKE, (String)"t%"))}), Arguments.of((Object[])new Object[]{"SHOW procedures in db1", new ShowProceduresOperation("builtin", "db1", "IN", null)}), Arguments.of((Object[])new Object[]{"SHOW procedures", new ShowProceduresOperation("builtin", "default", null, null)}));
    }

    @ParameterizedTest
    @MethodSource(value={"argsForTestShowFailedCase"})
    void testShowProceduresFailCase(String sql, String expectedErrorMsg) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse(sql)).isInstanceOf(ValidationException.class)).hasMessage(expectedErrorMsg);
    }

    private static Stream<Arguments> argsForTestShowFailedCase() {
        return Stream.of(Arguments.of((Object[])new Object[]{"SHOW procedures in cat.db.t", "SHOW PROCEDURES from/in identifier [ cat.db.t ] format error, it should be [catalog_name.]database_name."}), Arguments.of((Object[])new Object[]{"SHOW Views in cat.db1.t2", "SHOW VIEWS from/in identifier [ cat.db1.t2 ] format error, it should be [catalog_name.]database_name."}), Arguments.of((Object[])new Object[]{"SHOW functions in cat.db3.t5", "SHOW FUNCTIONS from/in identifier [ cat.db3.t5 ] format error, it should be [catalog_name.]database_name."}), Arguments.of((Object[])new Object[]{"SHOW tables in cat1.db3.t2", "SHOW TABLES from/in identifier [ cat1.db3.t2 ] format error, it should be [catalog_name.]database_name."}));
    }

    @Test
    void testShowPartitions() {
        Operation operation = this.parse("show partitions tbl");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowPartitionsOperation.class);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("SHOW PARTITIONS builtin.default.tbl");
        operation = this.parse("show partitions tbl partition (dt='2020-04-30 01:02:03')");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowPartitionsOperation.class);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("SHOW PARTITIONS builtin.default.tbl PARTITION (dt=2020-04-30 01:02:03)");
    }

    @Test
    void testAddJar() {
        Arrays.asList("./test.\njar", "file:///path/to/whatever", "../test-jar.jar", "/root/test.jar", "test\\ jar.jar", "oss://path/helloworld.go").forEach(jarPath -> {
            AddJarOperation operation = (AddJarOperation)this.parser.parse(String.format("ADD JAR '%s'", jarPath)).get(0);
            Assertions.assertThat((String)operation.getPath()).isEqualTo(jarPath);
        });
    }

    @Test
    void testRemoveJar() {
        Arrays.asList("./test.\njar", "file:///path/to/whatever", "../test-jar.jar", "/root/test.jar", "test\\ jar.jar", "oss://path/helloworld.go").forEach(jarPath -> {
            RemoveJarOperation operation = (RemoveJarOperation)this.parser.parse(String.format("REMOVE JAR '%s'", jarPath)).get(0);
            Assertions.assertThat((String)operation.getPath()).isEqualTo(jarPath);
        });
    }

    @Test
    void testShowJars() {
        String sql = "SHOW JARS";
        Operation operation = this.parse("SHOW JARS");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowJarsOperation.class);
        ShowJarsOperation showModulesOperation = (ShowJarsOperation)operation;
        Assertions.assertThat((String)showModulesOperation.asSummaryString()).isEqualTo("SHOW JARS");
    }

    @Test
    void testSet() {
        Operation operation1 = this.parse("SET");
        Assertions.assertThat((Object)operation1).isInstanceOf(SetOperation.class);
        SetOperation setOperation1 = (SetOperation)operation1;
        Assertions.assertThat((Optional)setOperation1.getKey()).isNotPresent();
        Assertions.assertThat((Optional)setOperation1.getValue()).isNotPresent();
        Operation operation2 = this.parse("SET 'test-key' = 'test-value'");
        Assertions.assertThat((Object)operation2).isInstanceOf(SetOperation.class);
        SetOperation setOperation2 = (SetOperation)operation2;
        Assertions.assertThat((Optional)setOperation2.getKey()).hasValue((Object)"test-key");
        Assertions.assertThat((Optional)setOperation2.getValue()).hasValue((Object)"test-value");
    }

    @Test
    void testReset() {
        Operation operation1 = this.parse("RESET");
        Assertions.assertThat((Object)operation1).isInstanceOf(ResetOperation.class);
        Assertions.assertThat((Optional)((ResetOperation)operation1).getKey()).isNotPresent();
        Operation operation2 = this.parse("RESET 'test-key'");
        Assertions.assertThat((Object)operation2).isInstanceOf(ResetOperation.class);
        Assertions.assertThat((Optional)((ResetOperation)operation2).getKey()).isPresent();
        Assertions.assertThat((Optional)((ResetOperation)operation2).getKey()).hasValue((Object)"test-key");
    }

    @ParameterizedTest
    @ValueSource(strings={"SET", "SET;", "SET ;", "SET\t;", "SET\n;"})
    void testSetCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(SetOperation.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"HELP", "HELP;", "HELP ;", "HELP\t;", "HELP\n;"})
    void testHelpCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(HelpOperation.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"CLEAR", "CLEAR;", "CLEAR ;", "CLEAR\t;", "CLEAR\n;"})
    void testClearCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(ClearOperation.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"QUIT;", "QUIT;", "QUIT ;", "QUIT\t;", "QUIT\n;", "EXIT;", "EXIT ;", "EXIT\t;", "EXIT\n;", "EXIT ; "})
    void testQuitCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(QuitOperation.class);
    }
}

