/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.operations.CreateTableASOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversion;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversionTestBase;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.planner.utils.OperationMatchers;
import org.apache.flink.table.planner.utils.TestSimpleDynamicTableSourceFactory;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.junit.jupiter.api.Test;

public class SqlCTASNodeToOperationTest
extends SqlNodeToOperationConversionTestBase {
    private static final Map<String, String> TABLE_OPTIONS = Map.of("connector", TestSimpleDynamicTableSourceFactory.IDENTIFIER());

    @Test
    public void testCreateTableAsWithNotFoundColumnIdentifiers() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.INT()).build()).options(TABLE_OPTIONS).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"src1"), false);
        String sql = "create table tbl1 (f1, f2) AS SELECT * FROM src1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("create table tbl1 (f1, f2) AS SELECT * FROM src1")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column 'f2' not found in the source schema.");
    }

    @Test
    public void testCreateTableAsWithMismatchIdentifiersLength() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.INT()).build()).options(TABLE_OPTIONS).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"src1"), false);
        String sql = "create table tbl1 (f1) AS SELECT * FROM src1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("create table tbl1 (f1) AS SELECT * FROM src1")).isInstanceOf(ValidationException.class)).hasMessageContaining("The number of columns in the column list must match the number of columns in the source schema.");
    }

    @Test
    public void testCreateTableAsWithColumns() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).build()).options(TABLE_OPTIONS).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"src1"), false);
        String sql = "create table tbl1 (c0 int, c1 double metadata, c2 as c0 * f0, c3 timestamp(3), c4 int metadata virtual, watermark FOR c3 AS c3 - interval '3' second) AS SELECT * FROM src1";
        Operation ctas = this.parseAndConvert("create table tbl1 (c0 int, c1 double metadata, c2 as c0 * f0, c3 timestamp(3), c4 int metadata virtual, watermark FOR c3 AS c3 - interval '3' second) AS SELECT * FROM src1");
        CreateTableOperation operation = ((CreateTableASOperation)ctas).getCreateTableOperation();
        Assertions.assertThat((Object)operation).is((Condition)new HamcrestCondition(OperationMatchers.isCreateTableOperation(OperationMatchers.withNoDistribution(), OperationMatchers.withSchema(Schema.newBuilder().column("c0", (AbstractDataType)DataTypes.INT()).columnByMetadata("c1", (AbstractDataType)DataTypes.DOUBLE()).columnByExpression("c2", "`c0` * `f0`").column("c3", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).columnByMetadata("c4", (AbstractDataType)DataTypes.INT(), true).column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).watermark("c3", "`c3` - INTERVAL '3' SECOND").build()))));
    }

    @Test
    public void testCreateTableAsWithColumnsOverridden() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.INT()).column("f2", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).column("f3", (AbstractDataType)DataTypes.STRING()).build()).options(TABLE_OPTIONS).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"src1"), false);
        String sql = "create table tbl1 (c0 int, f0 bigint not null, a1 double, f2 timestamp(3) metadata, a3 string metadata) AS SELECT f0, f1 as `a1`, f2, f3 as `a3` FROM src1";
        Operation ctas = this.parseAndConvert("create table tbl1 (c0 int, f0 bigint not null, a1 double, f2 timestamp(3) metadata, a3 string metadata) AS SELECT f0, f1 as `a1`, f2, f3 as `a3` FROM src1");
        CreateTableOperation operation = ((CreateTableASOperation)ctas).getCreateTableOperation();
        Assertions.assertThat((Object)operation).is((Condition)new HamcrestCondition(OperationMatchers.isCreateTableOperation(OperationMatchers.withNoDistribution(), OperationMatchers.withSchema(Schema.newBuilder().column("c0", (AbstractDataType)DataTypes.INT()).column("f0", DataTypes.BIGINT().notNull()).column("a1", (AbstractDataType)DataTypes.DOUBLE()).columnByMetadata("f2", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).columnByMetadata("a3", (AbstractDataType)DataTypes.STRING()).build()))));
    }

    @Test
    public void testCreateTableAsWithOverriddenVirtualMetadataColumnsNotAllowed() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.BIGINT()).build()).options(TABLE_OPTIONS).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"src1"), false);
        String sql = "create table tbl1 (f1 bigint metadata virtual) AS SELECT * FROM src1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("create table tbl1 (f1 bigint metadata virtual) AS SELECT * FROM src1")).isInstanceOf(ValidationException.class)).hasMessageContaining("A column named 'f1' already exists in the source schema. Virtual metadata columns cannot overwrite columns from source.");
    }

    @Test
    public void testCreateTableAsWithOverriddenComputedColumnsNotAllowed() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.BIGINT()).build()).options(TABLE_OPTIONS).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"src1"), false);
        String sql = "create table tbl1 (f1 as 'f0 * 2') AS SELECT * FROM src1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("create table tbl1 (f1 as 'f0 * 2') AS SELECT * FROM src1")).isInstanceOf(ValidationException.class)).hasMessageContaining("A column named 'f1' already exists in the source schema. Computed columns cannot overwrite columns from source.");
    }

    @Test
    public void testCreateTableAsWithPrimaryAndPartitionKey() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).build()).options(TABLE_OPTIONS).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"src1"), false);
        String sql = "create table tbl1 (PRIMARY KEY (f0) NOT ENFORCED) PARTITIONED BY (f0) AS SELECT * FROM src1";
        Operation ctas = this.parseAndConvert("create table tbl1 (PRIMARY KEY (f0) NOT ENFORCED) PARTITIONED BY (f0) AS SELECT * FROM src1");
        CreateTableOperation operation = ((CreateTableASOperation)ctas).getCreateTableOperation();
        Assertions.assertThat((Object)operation).is((Condition)new HamcrestCondition(OperationMatchers.isCreateTableOperation(OperationMatchers.withNoDistribution(), OperationMatchers.partitionedBy("f0"), OperationMatchers.withSchema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).primaryKey(new String[]{"f0"}).build()))));
    }

    @Test
    public void testCreateTableAsWithWatermark() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).build()).options(TABLE_OPTIONS).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"src1"), false);
        String sql = "create table tbl1 (WATERMARK FOR f1 AS f1 - INTERVAL '3' SECOND) AS SELECT * FROM src1";
        Operation ctas = this.parseAndConvert("create table tbl1 (WATERMARK FOR f1 AS f1 - INTERVAL '3' SECOND) AS SELECT * FROM src1");
        CreateTableOperation operation = ((CreateTableASOperation)ctas).getCreateTableOperation();
        Assertions.assertThat((Object)operation).is((Condition)new HamcrestCondition(OperationMatchers.isCreateTableOperation(OperationMatchers.withNoDistribution(), OperationMatchers.withSchema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).watermark("f1", "`f1` - INTERVAL '3' SECOND").build()))));
    }

    @Test
    public void testCreateTableAsWithNotNullColumnsAreNotAllowed() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.INT()).build()).options(TABLE_OPTIONS).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"src1"), false);
        String sql = "create table tbl1 (c0 int not null) AS SELECT * FROM src1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("create table tbl1 (c0 int not null) AS SELECT * FROM src1")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column 'c0' has no default value and does not allow NULLs.");
    }

    @Test
    public void testCreateTableAsWithIncompatibleImplicitCastTypes() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).build()).options(TABLE_OPTIONS).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"src1"), false);
        String sql = "create table tbl1 (f0 boolean) AS SELECT * FROM src1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert("create table tbl1 (f0 boolean) AS SELECT * FROM src1")).isInstanceOf(ValidationException.class)).hasMessageContaining("Incompatible types for sink column 'f0' at position 0. The source column has type 'INT NOT NULL', while the target column has type 'BOOLEAN'.");
    }

    @Test
    public void testMergingCreateTableAsWithDistribution() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).columnByExpression("f2", "`f0` + 12345").watermark("f1", "`f1` - interval '1' second").build()).options(TABLE_OPTIONS).distribution(TableDistribution.ofHash(Collections.singletonList("f0"), (Integer)3)).partitionKeys(Arrays.asList("f0", "f1")).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable DISTRIBUTED BY HASH(f0) INTO 2 BUCKETS AS SELECT * FROM sourceTable";
        Operation ctas = this.parseAndConvert("create table derivedTable DISTRIBUTED BY HASH(f0) INTO 2 BUCKETS AS SELECT * FROM sourceTable");
        CreateTableOperation operation = ((CreateTableASOperation)ctas).getCreateTableOperation();
        Assertions.assertThat((Object)operation).is((Condition)new HamcrestCondition(OperationMatchers.isCreateTableOperation(OperationMatchers.withDistribution(TableDistribution.ofHash(Collections.singletonList("f0"), (Integer)2)), OperationMatchers.withSchema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).column("f2", DataTypes.INT().notNull()).build()))));
    }

    @Test
    public void testMergingCreateTableAsWitEmptyDistribution() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).columnByExpression("f2", "`f0` + 12345").watermark("f1", "`f1` - interval '1' second").build()).distribution(TableDistribution.ofHash(Collections.singletonList("f0"), (Integer)3)).partitionKeys(Arrays.asList("f0", "f1")).options(TABLE_OPTIONS).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"sourceTable"), false);
        String sql = "create table derivedTable AS SELECT * FROM sourceTable";
        Operation ctas = this.parseAndConvert("create table derivedTable AS SELECT * FROM sourceTable");
        CreateTableOperation operation = ((CreateTableASOperation)ctas).getCreateTableOperation();
        Assertions.assertThat((Object)operation).is((Condition)new HamcrestCondition(OperationMatchers.isCreateTableOperation(OperationMatchers.withNoDistribution(), OperationMatchers.withSchema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).column("f2", DataTypes.INT().notNull()).build()))));
    }

    private Operation parseAndConvert(String sql) {
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse(sql);
        return (Operation)SqlNodeToOperationConversion.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
    }
}

