/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.factories.TestUpdateDeleteTableFactory;
import org.apache.flink.table.planner.operations.DeletePushDownUtils;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.planner.utils.TestSimpleDynamicTableSourceFactory;
import org.apache.flink.table.planner.utils.TimestampStringUtils;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeletePushDownUtilsTest {
    private final TableConfig tableConfig = TableConfig.getDefault();
    private final Catalog catalog = new GenericInMemoryCatalog("MockCatalog", "default");
    private final CatalogManager catalogManager = CatalogManagerMocks.preparedCatalogManager().defaultCatalog("builtin", this.catalog).config((ReadableConfig)Configuration.fromMap(Collections.singletonMap(ExecutionOptions.RUNTIME_MODE.key(), RuntimeExecutionMode.BATCH.name()))).build();
    private final PlannerMocks plannerMocks = PlannerMocks.newBuilder().withBatchMode(true).withTableConfig(this.tableConfig).withCatalogManager(this.catalogManager).withRootSchema(CalciteSchemaBuilder.asRootSchema((org.apache.calcite.schema.Schema)new CatalogManagerCalciteSchema(this.catalogManager, false))).build();
    private final PlannerContext plannerContext = this.plannerMocks.getPlannerContext();
    private final CalciteParser parser = this.plannerContext.createCalciteParser();
    private final FlinkPlannerImpl flinkPlanner = this.plannerContext.createFlinkPlanner();

    @Test
    public void testGetDynamicTableSink() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "test-update-delete");
        CatalogTable catalogTable = this.createTestCatalogTable(options);
        ObjectIdentifier tableId = ObjectIdentifier.of((String)"builtin", (String)"default", (String)"t");
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, tableId, false);
        ContextResolvedTable resolvedTable = ContextResolvedTable.permanent((ObjectIdentifier)tableId, (Catalog)this.catalog, (ResolvedCatalogBaseTable)this.catalogManager.resolveCatalogTable(catalogTable));
        LogicalTableModify tableModify = this.getTableModifyFromSql("DELETE FROM t");
        Optional optionalDynamicTableSink = DeletePushDownUtils.getDynamicTableSink((ContextResolvedTable)resolvedTable, (LogicalTableModify)tableModify);
        Assertions.assertThat((Optional)optionalDynamicTableSink).isPresent();
        Assertions.assertThat((Object)((DynamicTableSink)optionalDynamicTableSink.get())).isInstanceOf(TestUpdateDeleteTableFactory.SupportsDeletePushDownSink.class);
        options.put("connector", "COLLECTION");
        catalogTable = this.createTestCatalogTable(options);
        tableId = ObjectIdentifier.of((String)"builtin", (String)"default", (String)"t1");
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, tableId, false);
        resolvedTable = ContextResolvedTable.permanent((ObjectIdentifier)tableId, (Catalog)this.catalog, (ResolvedCatalogBaseTable)this.catalogManager.resolveCatalogTable(catalogTable));
        tableModify = this.getTableModifyFromSql("DELETE FROM t1");
        optionalDynamicTableSink = DeletePushDownUtils.getDynamicTableSink((ContextResolvedTable)resolvedTable, (LogicalTableModify)tableModify);
        Assertions.assertThat((Optional)optionalDynamicTableSink).isEmpty();
    }

    @Test
    public void testGetResolveFilterExpressions() {
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", DataTypes.STRING().nullable()).column("f2", DataTypes.BIGINT().nullable()).column("f3", DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE().nullable()).build()).options(Map.of("connector", TestSimpleDynamicTableSourceFactory.IDENTIFIER())).build();
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, ObjectIdentifier.of((String)"builtin", (String)"default", (String)"t"), false);
        LogicalTableModify tableModify = this.getTableModifyFromSql("DELETE FROM t");
        Optional optionalResolvedExpressions = DeletePushDownUtils.getResolvedFilterExpressions((LogicalTableModify)tableModify);
        this.verifyExpression(optionalResolvedExpressions, "[]");
        tableModify = this.getTableModifyFromSql("DELETE FROM t where f0 = 1 and f1 = '123'");
        optionalResolvedExpressions = DeletePushDownUtils.getResolvedFilterExpressions((LogicalTableModify)tableModify);
        this.verifyExpression(optionalResolvedExpressions, "[equals(f0, 1), equals(f1, '123')]");
        tableModify = this.getTableModifyFromSql("DELETE FROM t where f0 = 1 + 6 and f0 < 6");
        optionalResolvedExpressions = DeletePushDownUtils.getResolvedFilterExpressions((LogicalTableModify)tableModify);
        Assertions.assertThat((Optional)optionalResolvedExpressions).isPresent();
        this.verifyExpression(optionalResolvedExpressions, "[false]");
        tableModify = this.getTableModifyFromSql("DELETE FROM t where f0 = f2 + 1");
        optionalResolvedExpressions = DeletePushDownUtils.getResolvedFilterExpressions((LogicalTableModify)tableModify);
        this.verifyExpression(optionalResolvedExpressions, "[equals(cast(f0, BIGINT NOT NULL), plus(f2, 1))]");
        tableModify = this.getTableModifyFromSql("DELETE FROM t where f0 > (select count(1) from t)");
        optionalResolvedExpressions = DeletePushDownUtils.getResolvedFilterExpressions((LogicalTableModify)tableModify);
        Assertions.assertThat((Optional)optionalResolvedExpressions).isEmpty();
        String dateTime = "2024-05-13 08:00:00";
        tableModify = this.getTableModifyFromSql(String.format("DELETE FROM t where f3 > '%s'", dateTime));
        LocalDateTime ldt = TimestampStringUtils.toLocalDateTime((TimestampString)new TimestampString(dateTime));
        Instant instant = ldt.toInstant(ZoneId.systemDefault().getRules().getOffset(ldt));
        optionalResolvedExpressions = DeletePushDownUtils.getResolvedFilterExpressions((LogicalTableModify)tableModify);
        Assertions.assertThat((Optional)optionalResolvedExpressions).isPresent();
        this.verifyExpression(optionalResolvedExpressions, String.format("[greaterThan(f3, %s)]", instant.toString()));
    }

    private CatalogTable createTestCatalogTable(Map<String, String> options) {
        return CatalogTable.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", DataTypes.STRING().nullable()).column("f2", DataTypes.BIGINT().nullable()).build()).options(options).build();
    }

    private LogicalTableModify getTableModifyFromSql(String sql) {
        SqlNode sqlNode = this.parser.parse(sql);
        SqlNode validated = this.flinkPlanner.validate(sqlNode);
        RelRoot deleteRelational = this.flinkPlanner.rel(validated);
        return (LogicalTableModify)deleteRelational.rel;
    }

    private void verifyExpression(Optional<List<ResolvedExpression>> optionalResolvedExpressions, String expected) {
        Assertions.assertThat(optionalResolvedExpressions).isPresent();
        Assertions.assertThat((String)optionalResolvedExpressions.get().toString()).isEqualTo(expected);
    }
}

