/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.AggFunctionTestBase;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.Test;

abstract class FirstLastValueAggFunctionWithOrderTestBase<T, ACC>
extends AggFunctionTestBase<T, T, ACC> {
    FirstLastValueAggFunctionWithOrderTestBase() {
    }

    @Override
    protected Method getAccumulateFunc() throws NoSuchMethodException {
        return this.getAggregator().getClass().getMethod("accumulate", this.getAccClass(), Object.class, Long.class);
    }

    protected abstract List<List<Long>> getInputOrderSets();

    @Override
    @Test
    void testAccumulateAndRetractWithoutMerge() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        List inputValueSets = this.getInputValueSets();
        List<List<Long>> inputOrderSets = this.getInputOrderSets();
        List expectedResults = this.getExpectedResults();
        Preconditions.checkArgument((inputValueSets.size() == inputOrderSets.size() ? 1 : 0) != 0, (Object)"The number of inputValueSets is not same with the number of inputOrderSets");
        Preconditions.checkArgument((inputValueSets.size() == expectedResults.size() ? 1 : 0) != 0, (Object)"The number of inputValueSets is not same with the number of expectedResults");
        AggregateFunction aggregator = this.getAggregator();
        int size = this.getInputValueSets().size();
        for (int i = 0; i < size; ++i) {
            List inputValues = inputValueSets.get(i);
            List<Long> inputOrders = inputOrderSets.get(i);
            Object expected = expectedResults.get(i);
            ACC acc = this.accumulateValues(inputValues, inputOrders);
            Object result = aggregator.getValue(acc);
            this.validateResult(expected, result);
            if (!UserDefinedFunctionUtils.ifMethodExistInFunction((String)"retract", aggregator)) continue;
            this.retractValues(acc, inputValues, inputOrders);
            Object expectedAcc = aggregator.createAccumulator();
            this.validateResult(expectedAcc, acc);
        }
    }

    @Override
    @Test
    void testResetAccumulator() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction aggregator = this.getAggregator();
        if (UserDefinedFunctionUtils.ifMethodExistInFunction((String)"resetAccumulator", aggregator)) {
            Method resetAccFunc = aggregator.getClass().getMethod("resetAccumulator", this.getAccClass());
            List inputValueSets = this.getInputValueSets();
            List<List<Long>> inputOrderSets = this.getInputOrderSets();
            List expectedResults = this.getExpectedResults();
            Preconditions.checkArgument((inputValueSets.size() == inputOrderSets.size() ? 1 : 0) != 0, (Object)"The number of inputValueSets is not same with the number of inputOrderSets");
            Preconditions.checkArgument((inputValueSets.size() == expectedResults.size() ? 1 : 0) != 0, (Object)"The number of inputValueSets is not same with the number of expectedResults");
            int size = this.getInputValueSets().size();
            for (int i = 0; i < size; ++i) {
                List inputValues = inputValueSets.get(i);
                List<Long> inputOrders = inputOrderSets.get(i);
                ACC acc = this.accumulateValues(inputValues, inputOrders);
                resetAccFunc.invoke(aggregator, acc);
                Object expectedAcc = aggregator.createAccumulator();
                this.validateResult(expectedAcc, acc);
            }
        }
    }

    protected ACC accumulateValues(List<T> values, List<Long> orders) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Preconditions.checkArgument((values.size() == orders.size() ? 1 : 0) != 0, (Object)("The number of values is not same with the number of orders, \nvalues: " + values + "\norders: " + orders));
        AggregateFunction aggregator = this.getAggregator();
        Object accumulator = this.getAggregator().createAccumulator();
        Method accumulateFunc = this.getAccumulateFunc();
        for (int i = 0; i < values.size(); ++i) {
            accumulateFunc.invoke(aggregator, accumulator, values.get(i), orders.get(i));
        }
        return (ACC)accumulator;
    }

    @Override
    protected void accumulateValues(AggregateFunction<T, ACC> aggregator, ACC accumulator, List<T> values) {
        throw new TableException("Should not call this method");
    }

    protected void retractValues(ACC accumulator, List<T> values, List<Long> orders) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Preconditions.checkArgument((values.size() == orders.size() ? 1 : 0) != 0, (Object)("The number of values is not same with the number of orders, \nvalues: " + values + "\norders: " + orders));
        AggregateFunction aggregator = this.getAggregator();
        Method retractFunc = this.getRetractFunc();
        for (int i = 0; i < values.size(); ++i) {
            retractFunc.invoke(aggregator, accumulator, values.get(i), orders.get(i));
        }
    }

    @Override
    protected void retractValues(ACC accumulator, List<T> values) {
        throw new TableException("Should not call this method");
    }
}

