/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;

class StringFunctionsITCase
extends BuiltInFunctionTestBase {
    StringFunctionsITCase() {
    }

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        return Stream.of(this.bTrimTestCases(), this.eltTestCases(), this.endsWithTestCases(), this.printfTestCases(), this.startsWithTestCases(), this.translateTestCases(), this.concatenateTestCases()).flatMap(s -> s);
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> concatenateTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.PLUS).onFieldsWithData("Beginning", " Middle ", "Ending").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)((ApiExpression)Expressions.$((String)"f0").concat((Object)Expressions.$((String)"f1"))).concat((Object)Expressions.$((String)"f2")), "concat(concat(f0, f1), f2)", "Beginning Middle Ending", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.concat((Object)Expressions.$((String)"f0"), (Object[])new Object[]{Expressions.$((String)"f1"), Expressions.$((String)"f2")}), "concat(f0, f1, f2)", "Beginning Middle Ending", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)((ApiExpression)Expressions.$((String)"f0").plus((Object)Expressions.$((String)"f1"))).plus((Object)Expressions.$((String)"f2")), "concat(concat(f0, f1), f2)", "Beginning Middle Ending", (AbstractDataType<?>)DataTypes.STRING()));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> bTrimTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.BTRIM).onFieldsWithData(null, "  \ud83d\ude00www.apache.org  \f   ").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").btrim(), "BTRIM(f0)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f0").btrim((Object)Expressions.$((String)"f1")), "BTRIM(f0, f1)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").btrim((Object)Expressions.$((String)"f0")), "BTRIM(f1, f0)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").btrim((Object)" \f\ud83d\ude00"), "BTRIM(f1, ' \f\ud83d\ude00')", "www.apache.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").btrim((Object)"\ud83d\ude00 "), "BTRIM(f1, '\ud83d\ude00 ')", "www.apache.org  \f", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"  www.apache.org  ").btrim(), "BTRIM('  www.apache.org  ')", "www.apache.org", DataTypes.STRING().notNull()).testResult((Expression)Expressions.lit((Object)"www.apache.org").btrim((Object)"a"), "BTRIM('www.apache.org', 'a')", "www.apache.org", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f1").btrim(), "BTRIM(f1)", "\ud83d\ude00www.apache.org  \f", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").btrim((Object)"\f"), "BTRIM(f1, '\f')", "  \ud83d\ude00www.apache.org  \f   ", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").btrim((Object)Expressions.$((String)"f1")), "BTRIM(f1, f1)", "", (AbstractDataType<?>)DataTypes.STRING()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.BTRIM, "Validation Error").onFieldsWithData(100, "123").andDataTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING()}).testTableApiValidationError((Expression)Expressions.$((String)"f0").btrim(), "Invalid input arguments. Expected signatures are:\nBTRIM(str <CHARACTER_STRING>)\nBTRIM(str <CHARACTER_STRING>, trimStr <CHARACTER_STRING>)").testSqlValidationError("BTRIM(f0)", "Invalid input arguments. Expected signatures are:\nBTRIM(str <CHARACTER_STRING>)\nBTRIM(str <CHARACTER_STRING>, trimStr <CHARACTER_STRING>)").testTableApiValidationError((Expression)Expressions.$((String)"f1").btrim((Object)Expressions.$((String)"f0")), "Invalid input arguments. Expected signatures are:\nBTRIM(str <CHARACTER_STRING>)\nBTRIM(str <CHARACTER_STRING>, trimStr <CHARACTER_STRING>)").testSqlValidationError("BTRIM(f1, f0)", "Invalid input arguments. Expected signatures are:\nBTRIM(str <CHARACTER_STRING>)\nBTRIM(str <CHARACTER_STRING>, trimStr <CHARACTER_STRING>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> eltTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ELT).onFieldsWithData(null, null, null, new byte[]{1, 2, 3}).andDataTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.BYTES(), DataTypes.BYTES()}).testResult((Expression)Expressions.$((String)"f0").elt((Object)"a", new Object[]{"b"}), "ELT(f0, 'a', 'b')", (Object)null, (AbstractDataType<?>)DataTypes.CHAR((int)1)).testResult((Expression)Expressions.lit((Object)1).elt((Object)Expressions.$((String)"f1"), new Object[0]), "ELT(1, f1)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)1).elt((Object)"a", new Object[]{Expressions.$((String)"f1")}), "ELT(1, 'a', f1)", "a", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)0).elt((Object)"a", new Object[]{"b"}), "ELT(0, 'a', 'b')", (Object)null, (AbstractDataType<?>)DataTypes.CHAR((int)1)).testResult((Expression)Expressions.lit((Object)3).elt((Object)"a", new Object[]{"b"}), "ELT(3, 'a', 'b')", (Object)null, (AbstractDataType<?>)DataTypes.CHAR((int)1)).testResult((Expression)Expressions.lit((Object)Long.MAX_VALUE).elt((Object)"ab", new Object[]{"b"}), "ELT(9223372036854775807, 'ab', 'b')", (Object)null, (AbstractDataType<?>)DataTypes.VARCHAR((int)2)).testResult((Expression)Expressions.lit((Object)1).elt((Object)"scala", new Object[]{"java"}), "ELT(1, 'scala', 'java')", "scala", (AbstractDataType<?>)DataTypes.VARCHAR((int)5)).testResult((Expression)Expressions.lit((Object)2).elt((Object)"a", new Object[]{"b"}), "ELT(2, 'a', 'b')", "b", (AbstractDataType<?>)DataTypes.CHAR((int)1)).testResult((Expression)Expressions.lit((Object)2).elt((Object)Expressions.$((String)"f2"), new Object[]{Expressions.$((String)"f3"), Expressions.$((String)"f3")}), "ELT(2, f2, f3, f3)", new byte[]{1, 2, 3}, (AbstractDataType<?>)DataTypes.BYTES()).testResult((Expression)Expressions.lit((Object)3).elt((Object)Expressions.$((String)"f2"), new Object[]{Expressions.$((String)"f3"), Expressions.$((String)"f2")}), "ELT(3, f2, f3, f2)", (Object)null, (AbstractDataType<?>)DataTypes.BYTES()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ELT, "Validation Error").onFieldsWithData("1", "1".getBytes(), BigDecimal.valueOf(1L)).andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.BYTES(), DataTypes.DECIMAL((int)1, (int)0)}).testTableApiValidationError((Expression)Expressions.lit((Object)1).elt((Object)Expressions.$((String)"f0"), new Object[]{Expressions.$((String)"f1")}), "Invalid input arguments. Expected signatures are:\nELT(index <INTEGER_NUMERIC>, expr <CHARACTER_STRING>, exprs <CHARACTER_STRING>...)\nELT(index <INTEGER_NUMERIC>, expr <BINARY_STRING>, exprs <BINARY_STRING>...)").testSqlValidationError("ELT(1, f0, f1)", "Invalid input arguments. Expected signatures are:\nELT(index <INTEGER_NUMERIC>, expr <CHARACTER_STRING>, exprs <CHARACTER_STRING>...)\nELT(index <INTEGER_NUMERIC>, expr <BINARY_STRING>, exprs <BINARY_STRING>...)").testTableApiValidationError((Expression)Expressions.$((String)"f2").elt((Object)"a", new Object[0]), "Invalid input arguments. Expected signatures are:\nELT(index <INTEGER_NUMERIC>, expr <CHARACTER_STRING>, exprs <CHARACTER_STRING>...)\nELT(index <INTEGER_NUMERIC>, expr <BINARY_STRING>, exprs <BINARY_STRING>...)").testSqlValidationError("ELT(f2, 'a')", "Invalid input arguments. Expected signatures are:\nELT(index <INTEGER_NUMERIC>, expr <CHARACTER_STRING>, exprs <CHARACTER_STRING>...)\nELT(index <INTEGER_NUMERIC>, expr <BINARY_STRING>, exprs <BINARY_STRING>...)").testTableApiValidationError((Expression)Expressions.lit((Object)-1).elt((Object)"a", new Object[0]), "Index must be an integer starting from '0', but was '-1'.").testSqlValidationError("ELT(-1, 'a')", "Index must be an integer starting from '0', but was '-1'."));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> endsWithTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ENDS_WITH, "StringData").onFieldsWithData(null, "www.apache.org", "", "in\u4e2d\u6587", "\ud83d\ude00").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").endsWith((Object)"abc"), "ENDSWITH(f0, 'abc')", (Object)null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").endsWith((Object)Expressions.$((String)"f0")), "ENDSWITH(f1, f0)", (Object)null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f2").endsWith((Object)"abc"), "ENDSWITH(f2, 'abc')", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").endsWith((Object)Expressions.$((String)"f2")), "ENDSWITH(f1, f2)", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.lit((Object)"").endsWith((Object)""), "ENDSWITH('', '')", Boolean.TRUE, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f1").endsWith((Object)"org"), "ENDSWITH(f1, 'org')", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").endsWith((Object)"."), "ENDSWITH(f1, '.')", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f3").endsWith((Object)"n\u4e2d\u6587"), "ENDSWITH(f3, 'n\u4e2d\u6587')", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f3").endsWith((Object)"\u4e2d"), "ENDSWITH(f3, '\u4e2d')", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f4").endsWith((Object)Expressions.$((String)"f4")), "ENDSWITH(f4, f4)", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f4").endsWith((Object)"\ude00"), "ENDSWITH(f4, '\ude00')", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ENDS_WITH, "byte[]").onFieldsWithData(null, new byte[]{1, 2, 3}, new byte[0], new byte[0], new byte[]{2, 3}, new byte[]{1}).andDataTypes(new AbstractDataType[]{DataTypes.BYTES(), DataTypes.BYTES(), DataTypes.BYTES(), DataTypes.BYTES().notNull(), DataTypes.BYTES(), DataTypes.BYTES()}).testResult((Expression)Expressions.$((String)"f0").endsWith((Object)Expressions.$((String)"f1")), "ENDSWITH(f0, f1)", (Object)null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").endsWith((Object)Expressions.$((String)"f0")), "ENDSWITH(f1, f0)", (Object)null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f2").endsWith((Object)Expressions.$((String)"f1")), "ENDSWITH(f2, f1)", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").endsWith((Object)Expressions.$((String)"f2")), "ENDSWITH(f1, f2)", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f3").endsWith((Object)Expressions.$((String)"f3")), "ENDSWITH(f3, f3)", Boolean.TRUE, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f1").endsWith((Object)Expressions.$((String)"f4")), "ENDSWITH(f1, f4)", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").endsWith((Object)Expressions.$((String)"f5")), "ENDSWITH(f1, f5)", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ENDS_WITH, "Validation Error").onFieldsWithData("12345", "123".getBytes()).andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.BYTES()}).testTableApiValidationError((Expression)Expressions.$((String)"f0").endsWith((Object)Expressions.$((String)"f1")), "Invalid input arguments. Expected signatures are:\nENDSWITH(expr <CHARACTER_STRING>, endExpr <CHARACTER_STRING>)\nENDSWITH(expr <BINARY_STRING>, endExpr <BINARY_STRING>)").testSqlValidationError("ENDSWITH(f0, f1)", "Invalid input arguments. Expected signatures are:\nENDSWITH(expr <CHARACTER_STRING>, endExpr <CHARACTER_STRING>)\nENDSWITH(expr <BINARY_STRING>, endExpr <BINARY_STRING>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> printfTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.PRINTF).onFieldsWithData(null, "%d %s ", 1024, 10.24, "1024", LocalDate.of(2024, 7, 30), LocalTime.of(10, 24, 0), LocalDateTime.of(2024, 7, 30, 10, 24, 0, 256), Instant.parse("2024-07-30T10:24:00.256Z"), Duration.of(5L, ChronoUnit.HOURS), Boolean.TRUE, 10.24).andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.INT(), DataTypes.FLOAT(), DataTypes.STRING(), DataTypes.DATE(), DataTypes.TIME(), DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP_LTZ(), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.HOUR()), DataTypes.BOOLEAN(), DataTypes.DECIMAL((int)4, (int)2)}).testResult((Expression)Expressions.$((String)"f0").printf(new Object[0]), "PRINTF(f0)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%d %s").printf(new Object[]{Expressions.$((String)"f0"), Expressions.$((String)"f0")}), "PRINTF('%d %s', f0, f0)", "null null", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"empty").printf(new Object[0]), "PRINTF('empty')", "empty", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%s").printf(new Object[0]), "PRINTF('%s')", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%s %s").printf(new Object[]{1, 2, 3}), "PRINTF('%s %s', 1, 2, 3)", "1 2", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%08d").printf(new Object[]{Expressions.$((String)"f2")}), "PRINTF('%08d', f2)", "00001024", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%.1f").printf(new Object[]{Expressions.$((String)"f3")}), "PRINTF('%.1f', f3)", "10.2", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%s").printf(new Object[]{Expressions.$((String)"f4")}), "PRINTF('%s', f4)", "1024", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%s").printf(new Object[]{Expressions.$((String)"f5")}), "PRINTF('%s', f5)", "19934", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%s").printf(new Object[]{Expressions.$((String)"f6")}), "PRINTF('%s', f6)", "37440000", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%s").printf(new Object[]{Expressions.$((String)"f7")}), "PRINTF('%s', f7)", "2024-07-30T10:24", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%s").printf(new Object[]{Expressions.$((String)"f8")}), "PRINTF('%s', f8)", "2024-07-30T10:24:00.256", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%s").printf(new Object[]{Expressions.$((String)"f9")}), "PRINTF('%s', f9)", "18000000", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%b").printf(new Object[]{Expressions.$((String)"f10")}), "PRINTF('%b', f10)", "true", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"%s").printf(new Object[]{Expressions.$((String)"f11")}), "PRINTF('%s', f11)", "10.24", (AbstractDataType<?>)DataTypes.STRING()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.PRINTF, "Validation Error").onFieldsWithData(1024).andDataTypes(new AbstractDataType[]{DataTypes.INT()}).testTableApiValidationError((Expression)Expressions.$((String)"f0").printf(new Object[0]), "Invalid input arguments. Expected signatures are:\nPRINTF(format <CHARACTER_STRING>, obj <ANY>...)").testSqlValidationError("PRINTF(f0)", "Invalid input arguments. Expected signatures are:\nPRINTF(format <CHARACTER_STRING>, obj <ANY>...)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> startsWithTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.STARTS_WITH, "StringData").onFieldsWithData(null, "www.apache.org", "", "in\u4e2d\u6587", "\ud83d\ude00").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").startsWith((Object)"abc"), "STARTSWITH(f0, 'abc')", (Object)null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").startsWith((Object)Expressions.$((String)"f0")), "STARTSWITH(f1, f0)", (Object)null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f2").startsWith((Object)"abc"), "STARTSWITH(f2, 'abc')", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").startsWith((Object)Expressions.$((String)"f2")), "STARTSWITH(f1, f2)", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.lit((Object)"").startsWith((Object)""), "STARTSWITH('', '')", Boolean.TRUE, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f1").startsWith((Object)"ww"), "STARTSWITH(f1, 'ww')", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").startsWith((Object)"."), "STARTSWITH(f1, '.')", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f3").startsWith((Object)"in\u4e2d"), "STARTSWITH(f3, 'in\u4e2d')", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f3").startsWith((Object)"\u4e2d"), "STARTSWITH(f3, '\u4e2d')", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f4").startsWith((Object)Expressions.$((String)"f4")), "STARTSWITH(f4, f4)", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f4").startsWith((Object)"\ud83d"), "STARTSWITH(f4, '\ud83d')", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.STARTS_WITH, "byte[]").onFieldsWithData(null, new byte[]{1, 2, 3}, new byte[0], new byte[0], new byte[]{1, 2}, new byte[]{3}).andDataTypes(new AbstractDataType[]{DataTypes.BYTES(), DataTypes.BYTES(), DataTypes.BYTES(), DataTypes.BYTES().notNull(), DataTypes.BYTES(), DataTypes.BYTES()}).testResult((Expression)Expressions.$((String)"f0").startsWith((Object)Expressions.$((String)"f1")), "STARTSWITH(f0, f1)", (Object)null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").startsWith((Object)Expressions.$((String)"f0")), "STARTSWITH(f1, f0)", (Object)null, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f2").startsWith((Object)Expressions.$((String)"f1")), "STARTSWITH(f2, f1)", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").startsWith((Object)Expressions.$((String)"f2")), "STARTSWITH(f1, f2)", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f3").startsWith((Object)Expressions.$((String)"f3")), "STARTSWITH(f3, f3)", Boolean.TRUE, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f1").startsWith((Object)Expressions.$((String)"f4")), "STARTSWITH(f1, f4)", Boolean.TRUE, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").startsWith((Object)Expressions.$((String)"f5")), "STARTSWITH(f1, f5)", Boolean.FALSE, (AbstractDataType<?>)DataTypes.BOOLEAN()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.STARTS_WITH, "Validation Error").onFieldsWithData("12345", "123".getBytes()).andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.BYTES()}).testTableApiValidationError((Expression)Expressions.$((String)"f0").startsWith((Object)Expressions.$((String)"f1")), "Invalid input arguments. Expected signatures are:\nSTARTSWITH(expr <CHARACTER_STRING>, startExpr <CHARACTER_STRING>)\nSTARTSWITH(expr <BINARY_STRING>, startExpr <BINARY_STRING>)").testSqlValidationError("STARTSWITH(f0, f1)", "Invalid input arguments. Expected signatures are:\nSTARTSWITH(expr <CHARACTER_STRING>, startExpr <CHARACTER_STRING>)\nSTARTSWITH(expr <BINARY_STRING>, startExpr <BINARY_STRING>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> translateTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TRANSLATE).onFieldsWithData(null, "www.apache.org", "", "\u7ffb\u8bd1test\uff0c\u6d4b\u8bd5", "www.\ud83d\ude00.org").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").translate((Object)"abc", (Object)"123"), "TRANSLATE(f0, 'abc', '123')", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)Expressions.$((String)"f0"), (Object)"123"), "TRANSLATE(f1, f0, '123')", "www.apache.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)"abc", (Object)Expressions.$((String)"f0")), "TRANSLATE(f1, 'abc', f0)", "www.phe.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f2").translate((Object)"abc", (Object)"123"), "TRANSLATE(f2, 'abc', '123')", "", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)Expressions.$((String)"f2"), (Object)"123"), "TRANSLATE(f1, f2, '123')", "www.apache.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)"abc", (Object)Expressions.$((String)"f2")), "TRANSLATE(f1, 'abc', f2)", "www.phe.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)"abcde", (Object)"123"), "TRANSLATE(f1, 'abcde', '123')", "www.1p13h.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)"abcde.", (Object)"123"), "TRANSLATE(f1, 'abcde.', '123')", "www1p13horg", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)"abc", (Object)"12345"), "TRANSLATE(f1, 'abc', '12345')", "www.1p13he.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)"abcae", (Object)"12345"), "TRANSLATE(f1, 'abcae', '12345')", "www.1p13h5.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)"...", (Object)"123"), "TRANSLATE(f1, '...', '123')", "www1apache1org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)"ABCDE", (Object)"12345"), "TRANSLATE(f1, 'ABCDE', '12345')", "www.apache.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f3").translate((Object)"\u7ffb\u8bd1\u6d4b\u8bd5test\uff0c", (Object)"\u6d4b\u8bd5\u7ffb\u8bd1tset\u3002"), "TRANSLATE(f3, '\u7ffb\u8bd1\u6d4b\u8bd5test\uff0c', '\u6d4b\u8bd5\u7ffb\u8bd1tset\u3002')", "\u6d4b\u8bd5tset\u3002\u7ffb\u8bd1", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f3").translate((Object)"\u7ffb\u8bd1\u6d4b\u8bd5test\uff0c", (Object)"test\u7ffb\u8bd1  "), "TRANSLATE(f3, '\u7ffb\u8bd1\u6d4b\u8bd5test\uff0c', 'test\u7ffb\u8bd1  ')", "te\u7ffb\u8bd1 \u7ffbst", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f4").translate((Object)".\ud83d\ude00", (Object)"\ud83d\ude00."), "TRANSLATE(f4, '.\ud83d\ude00', '\ud83d\ude00.')", "www\ud83d\ude00.\ud83d\ude00org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f4").translate((Object)"\ud83d\ude00w", (Object)"\u7b11\u03b1"), "TRANSLATE(f4, '\ud83d\ude00w', '\u7b11\u03b1')", "\u03b1\u03b1\u03b1.\u7b11.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"www.apache.org").translate((Object)"abc", (Object)"123"), "TRANSLATE('www.apache.org', 'abc', '123')", "www.1p13he.org", DataTypes.STRING().notNull()).testResult((Expression)((ApiExpression)Expressions.lit((Object)"www.apache.org").translate((Object)"abc", (Object)"123")).translate((Object)"abc", (Object)"123"), "TRANSLATE(TRANSLATE('www.apache.org', 'abc', '123'), 'abc', '123')", "www.1p13he.org", DataTypes.STRING().notNull()).testResult((Expression)Expressions.$((String)"f1").translate((Object)"abc", (Object)"123"), "TRANSLATE(f1, 'abc', '123')", "www.1p13he.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)"abc", (Object)"ABC"), "TRANSLATE(f1, 'abc', 'ABC')", "www.ApAChe.org", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").translate((Object)"abcworg", (Object)"123 "), "TRANSLATE(f1, 'abcworg', '123 ')", "   .1p13he.", (AbstractDataType<?>)DataTypes.STRING()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TRANSLATE, "Validation Error").onFieldsWithData(12345).andDataTypes(new AbstractDataType[]{DataTypes.INT()}).testTableApiValidationError((Expression)Expressions.$((String)"f0").translate((Object)"3", (Object)"5"), "Invalid input arguments. Expected signatures are:\nTRANSLATE3(expr <CHARACTER_STRING>, fromStr <CHARACTER_STRING>, toStr <CHARACTER_STRING>)").testSqlValidationError("TRANSLATE(f0, '3', '5')", "Invalid input arguments. Expected signatures are:\nTRANSLATE3(expr <CHARACTER_STRING>, fromStr <CHARACTER_STRING>, toStr <CHARACTER_STRING>)"));
    }
}

