/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;

public class ComparisonFunctionITCase
extends BuiltInFunctionTestBase {
    @Override
    Configuration getConfiguration() {
        Configuration config = new Configuration();
        config.set(TableConfigOptions.LOCAL_TIME_ZONE, (Object)"GMT-08:00");
        return config;
    }

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        Instant ltz3 = Instant.ofEpochMilli(1123L);
        Instant ltz0 = Instant.ofEpochMilli(1000L);
        LocalDateTime tmstmp3 = ltz3.atOffset(ZoneOffset.ofHours(-8)).toLocalDateTime();
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.EQUALS).onFieldsWithData(ltz3, ltz0, tmstmp3).andDataTypes(new AbstractDataType[]{DataTypes.TIMESTAMP_LTZ((int)3), DataTypes.TIMESTAMP_LTZ((int)0), DataTypes.TIMESTAMP((int)3)}).testResult((Expression)Expressions.$((String)"f0").isEqual((Object)Expressions.$((String)"f1")), "f0 = f1", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").isEqual((Object)Expressions.$((String)"f0")), "f1 = f0", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").isEqual((Object)Expressions.$((String)"f2")), "f0 = f2", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f2").isEqual((Object)Expressions.$((String)"f0")), "f2 = f0", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").isEqual((Object)Expressions.$((String)"f2")), "f1 = f2", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f2").isEqual((Object)Expressions.$((String)"f1")), "f2 = f1", false, (AbstractDataType<?>)DataTypes.BOOLEAN()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.GREATER_THAN).onFieldsWithData(ltz3, ltz0, tmstmp3.minusSeconds(1L)).andDataTypes(new AbstractDataType[]{DataTypes.TIMESTAMP_LTZ((int)3), DataTypes.TIMESTAMP_LTZ((int)0), DataTypes.TIMESTAMP((int)3)}).testResult((Expression)Expressions.$((String)"f0").isGreater((Object)Expressions.$((String)"f1")), "f0 > f1", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").isGreater((Object)Expressions.$((String)"f0")), "f1 > f0", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").isGreater((Object)Expressions.$((String)"f2")), "f0 > f2", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f2").isGreater((Object)Expressions.$((String)"f0")), "f2 > f0", false, (AbstractDataType<?>)DataTypes.BOOLEAN()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.LESS_THAN).onFieldsWithData(ltz3, ltz0, tmstmp3.minusSeconds(1L)).andDataTypes(new AbstractDataType[]{DataTypes.TIMESTAMP_LTZ((int)3), DataTypes.TIMESTAMP_LTZ((int)0), DataTypes.TIMESTAMP((int)3)}).testResult((Expression)Expressions.$((String)"f0").isLess((Object)Expressions.$((String)"f1")), "f0 < f1", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f1").isLess((Object)Expressions.$((String)"f0")), "f1 < f0", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f0").isLess((Object)Expressions.$((String)"f2")), "f0 < f2", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f2").isLess((Object)Expressions.$((String)"f0")), "f2 < f0", true, (AbstractDataType<?>)DataTypes.BOOLEAN()));
    }
}

