/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.time.LocalDate;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;

class CollectionFunctionsITCase
extends BuiltInFunctionTestBase {
    CollectionFunctionsITCase() {
    }

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        return Stream.of(this.arrayAppendTestCases(), this.arrayContainsTestCases(), this.arrayDistinctTestCases(), this.arrayPositionTestCases(), this.arrayArrayPrependTestCases(), this.arrayRemoveTestCases(), this.arrayReverseTestCases(), this.arrayUnionTestCases(), this.arrayConcatTestCases(), this.arrayMaxTestCases(), this.arrayJoinTestCases(), this.arraySliceTestCases(), this.arrayMinTestCases(), this.arraySortTestCases(), this.arrayExceptTestCases(), this.arrayIntersectTestCases(), this.splitTestCases()).flatMap(s -> s);
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayAppendTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_APPEND).onFieldsWithData(new Integer[]{1, 2}, null, new String[]{"Hello", "World"}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().notNull()))}).testResult((Expression)Expressions.$((String)"f0").arrayAppend(null), "ARRAY_APPEND(f0, NULL)", new Integer[]{1, 2, null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f1").arrayAppend((Object)1), "ARRAY_APPEND(f1, 1)", null, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f2").arrayAppend((Object)"!"), "ARRAY_APPEND(f2, '!')", new String[]{"Hello", "World", "!"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().notNull()))).testResult((Expression)Expressions.$((String)"f2").arrayAppend(null), "ARRAY_APPEND(f2, NULL)", new String[]{"Hello", "World", null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testSqlValidationError("ARRAY_APPEND(f2, 1)", "Invalid input arguments. Expected signatures are:\nARRAY_APPEND(array <ARRAY>, element <ARRAY ELEMENT>)").testTableApiValidationError((Expression)Expressions.$((String)"f2").arrayAppend((Object)1), "Invalid input arguments. Expected signatures are:\nARRAY_APPEND(array <ARRAY>, element <ARRAY ELEMENT>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayContainsTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_CONTAINS).onFieldsWithData(new Integer[]{1, 2, 3}, null, new String[]{"Hello", "World"}, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, new Integer[]{1, null, 3}, new Integer[]{1, 2, 3}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull(), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())).notNull()}).testResult((Expression)Expressions.$((String)"f0").arrayContains((Object)2), "ARRAY_CONTAINS(f0, 2)", true, DataTypes.BOOLEAN().nullable()).testResult((Expression)Expressions.$((String)"f0").arrayContains((Object)42), "ARRAY_CONTAINS(f0, 42)", false, DataTypes.BOOLEAN().nullable()).testResult((Expression)Expressions.$((String)"f1").arrayContains((Object)12), "ARRAY_CONTAINS(f1, 12)", null, DataTypes.BOOLEAN().nullable()).testResult((Expression)Expressions.$((String)"f1").arrayContains(null), "ARRAY_CONTAINS(f1, NULL)", null, DataTypes.BOOLEAN().nullable()).testResult((Expression)Expressions.$((String)"f2").arrayContains((Object)"Hello"), "ARRAY_CONTAINS(f2, 'Hello')", true, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f3").arrayContains((Object)Expressions.row((Object)true, (Object[])new Object[]{LocalDate.of(1990, 10, 14)})), "ARRAY_CONTAINS(f3, (TRUE, DATE '1990-10-14'))", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f3").arrayContains((Object)Expressions.row((Object)false, (Object[])new Object[]{LocalDate.of(1990, 10, 14)})), "ARRAY_CONTAINS(f3, (FALSE, DATE '1990-10-14'))", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f3").arrayContains(null), "ARRAY_CONTAINS(f3, null)", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f4").arrayContains(null), "ARRAY_CONTAINS(f4, NULL)", true, DataTypes.BOOLEAN().nullable()).testResult((Expression)Expressions.$((String)"f5").arrayContains((Object)Expressions.lit(null, (DataType)DataTypes.INT())), "ARRAY_CONTAINS(f5, CAST(NULL AS INT))", false, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f5").arrayContains((Object)Expressions.lit((Object)4, (DataType)((DataType)DataTypes.INT().notNull()))), "ARRAY_CONTAINS(f5, 4)", false, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f5").arrayContains((Object)Expressions.lit((Object)3, (DataType)((DataType)DataTypes.INT().notNull()))), "ARRAY_CONTAINS(f5, 3)", true, DataTypes.BOOLEAN().notNull()).testSqlValidationError("ARRAY_CONTAINS(f0, TRUE)", "Invalid input arguments. Expected signatures are:\nARRAY_CONTAINS(haystack <ARRAY>, needle <ARRAY ELEMENT>)").testTableApiValidationError((Expression)Expressions.$((String)"f0").arrayContains((Object)true), "Invalid input arguments. Expected signatures are:\nARRAY_CONTAINS(haystack <ARRAY>, needle <ARRAY ELEMENT>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayDistinctTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_DISTINCT).onFieldsWithData(new Integer[]{1, 2, 3}, new Integer[]{null, 1, 2, 3, 4, 5, 4, 3, 2, 1, null}, null, new String[]{"Hello", "Hello", "Hello"}, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull(), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()}))}).testResult((Expression)Expressions.$((String)"f0").arrayDistinct(), "ARRAY_DISTINCT(f0)", new Integer[]{1, 2, 3}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f1").arrayDistinct(), "ARRAY_DISTINCT(f1)", new Integer[]{null, 1, 2, 3, 4, 5}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f2").arrayDistinct(), "ARRAY_DISTINCT(f2)", null, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f3").arrayDistinct(), "ARRAY_DISTINCT(f3)", new String[]{"Hello"}, DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull()).testResult((Expression)Expressions.$((String)"f4").arrayDistinct(), "ARRAY_DISTINCT(f4)", new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()}))));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayPositionTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_POSITION).onFieldsWithData(new Object[]{new Integer[]{null, 1, 2, 2, null}, null, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, new Integer[][]{{1, null, 3}, {0}, {1}}, new Map[]{null, CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)"a"), CollectionUtil.entry((Object)2, (Object)"b")}), CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)3, (Object)"c"), CollectionUtil.entry((Object)4, (Object)"d")})}}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())).notNull(), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING()))}).testResult((Expression)Expressions.$((String)"f0").arrayPosition((Object)Expressions.lit((Object)2, (DataType)((DataType)DataTypes.INT().notNull()))), "ARRAY_POSITION(f0, 2)", 3, DataTypes.INT().notNull()).testResult((Expression)Expressions.$((String)"f0").arrayPosition(null), "ARRAY_POSITION(f0, NULL)", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f1").arrayPosition((Object)2), "ARRAY_POSITION(f1, 2)", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f2").arrayPosition((Object)Expressions.row((Object)true, (Object[])new Object[]{LocalDate.of(1990, 10, 14)})), "ARRAY_POSITION(f2, (TRUE, DATE '1990-10-14'))", 2, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f3").arrayPosition((Object)new Integer[]{0, 1}), "ARRAY_POSITION(f3, ARRAY[0, 1])", 0, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f4").arrayPosition((Object)CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)3, (Object)"c"), CollectionUtil.entry((Object)4, (Object)"d")})), "ARRAY_POSITION(f4, MAP[3, 'c', 4, 'd'])", 3, (AbstractDataType<?>)DataTypes.INT()).testSqlValidationError("ARRAY_POSITION(f0, TRUE)", "Invalid input arguments. Expected signatures are:\nARRAY_POSITION(haystack <ARRAY>, needle <ARRAY ELEMENT>)").testTableApiValidationError((Expression)Expressions.$((String)"f0").arrayPosition((Object)true), "Invalid input arguments. Expected signatures are:\nARRAY_POSITION(haystack <ARRAY>, needle <ARRAY ELEMENT>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayArrayPrependTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_PREPEND).onFieldsWithData(new Integer[]{1, 2}, null, new String[]{"Hello", "World"}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().notNull()))}).testResult((Expression)Expressions.$((String)"f0").arrayPrepend((Object)1), "ARRAY_PREPEND(f0, 1)", new Integer[]{1, 1, 2}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f1").arrayPrepend((Object)1), "ARRAY_PREPEND(f1, 1)", null, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f2").arrayPrepend((Object)"!"), "ARRAY_PREPEND(f2, '!')", new String[]{"!", "Hello", "World"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().notNull()))).testResult((Expression)Expressions.$((String)"f2").arrayPrepend(null), "ARRAY_PREPEND(f2, NULL)", new String[]{null, "Hello", "World"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testSqlValidationError("ARRAY_PREPEND(1, f2)", "Invalid input arguments. Expected signatures are:\nARRAY_PREPEND(array <ARRAY>, element <ARRAY ELEMENT>)").testTableApiValidationError((Expression)Expressions.$((String)"f2").arrayPrepend((Object)1), "Invalid input arguments. Expected signatures are:\nARRAY_PREPEND(array <ARRAY>, element <ARRAY ELEMENT>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayRemoveTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_REMOVE).onFieldsWithData(new Object[]{new Integer[]{1, 2, 2}, null, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, new Integer[]{null, null, 1}, new Integer[][]{{1, null, 3}, {0}, {1}}, new Map[]{CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)"a"), CollectionUtil.entry((Object)2, (Object)"b")}), CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)3, (Object)"c"), CollectionUtil.entry((Object)4, (Object)"d")}), null}}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING()))}).testResult((Expression)Expressions.$((String)"f0").arrayRemove((Object)2), "ARRAY_REMOVE(f0, 2)", new Integer[]{1}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f0").arrayRemove((Object)42), "ARRAY_REMOVE(f0, 42)", new Integer[]{1, 2, 2}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f0").arrayRemove(Expressions.lit(null, (DataType)DataTypes.SMALLINT()).cast(DataTypes.INT())), "ARRAY_REMOVE(f0, CAST(NULL AS INT))", new Integer[]{1, 2, 2}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f1").arrayRemove((Object)12), "ARRAY_REMOVE(f1, 12)", null, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f1").arrayRemove(null), "ARRAY_REMOVE(f1, NULL)", null, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f2").arrayRemove((Object)Expressions.row((Object)true, (Object[])new Object[]{LocalDate.of(1990, 10, 14)})), "ARRAY_REMOVE(f2, (TRUE, DATE '1990-10-14'))", new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), null}, DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})).nullable()).testResult((Expression)Expressions.$((String)"f2").arrayRemove(null), "ARRAY_REMOVE(f2, NULL)", new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)})}, DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})).nullable()).testResult((Expression)Expressions.$((String)"f3").arrayRemove(null), "ARRAY_REMOVE(f3, NULL)", new Integer[]{1}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f4").arrayRemove((Object)new Integer[]{0}), "ARRAY_REMOVE(f4, ARRAY[0])", new Integer[][]{{1, null, 3}, {1}}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()))).testResult((Expression)Expressions.$((String)"f5").arrayRemove((Object)CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)3, (Object)"c"), CollectionUtil.entry((Object)4, (Object)"d")})), "ARRAY_REMOVE(f5, MAP[3, 'c', 4, 'd'])", new Map[]{CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)"a"), CollectionUtil.entry((Object)2, (Object)"b")}), null}, DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING())).nullable()).testSqlValidationError("ARRAY_REMOVE(f0, TRUE)", "Invalid input arguments. Expected signatures are:\nARRAY_REMOVE(haystack <ARRAY>, needle <ARRAY ELEMENT>)").testTableApiValidationError((Expression)Expressions.$((String)"f0").arrayRemove((Object)true), "Invalid input arguments. Expected signatures are:\nARRAY_REMOVE(haystack <ARRAY>, needle <ARRAY ELEMENT>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayReverseTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_REVERSE).onFieldsWithData(new Integer[]{1, 2, 2, null}, null, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()}))}).testResult((Expression)Expressions.$((String)"f0").arrayReverse(), "ARRAY_REVERSE(f0)", new Integer[]{null, 2, 2, 1}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f1").arrayReverse(), "ARRAY_REVERSE(f1)", null, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f2").arrayReverse(), "ARRAY_REVERSE(f2)", new Row[]{null, Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)})}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()}))));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayUnionTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_UNION).onFieldsWithData(new Integer[]{1, 2, null}, new Integer[]{1}, null, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, 1).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.INT()}).testResult((Expression)Expressions.$((String)"f0").arrayUnion((Object)new Integer[]{1, null, 4}), "ARRAY_UNION(f0, ARRAY[1, NULL, 4])", new Integer[]{1, 2, null, 4}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f1").arrayUnion((Object)new Integer[]{2, null}), "ARRAY_UNION(f1, ARRAY[2, NULL])", new Integer[]{1, 2, null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f2").arrayUnion((Object)new Integer[]{1, null, 4}), "ARRAY_UNION(f2, ARRAY[1, NULL, 4])", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f3").arrayUnion((Object)new Row[]{null, Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)})}), "ARRAY_UNION(f3, ARRAY[NULL, (TRUE, DATE '1990-10-14')])", new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()}))).testSqlValidationError("ARRAY_UNION(f4, TRUE)", "Invalid input arguments. Expected signatures are:\nARRAY_UNION(<COMMON>, <COMMON>)").testTableApiValidationError((Expression)Expressions.$((String)"f4").arrayUnion((Object)true), "Invalid input arguments. Expected signatures are:\nARRAY_UNION(<COMMON>, <COMMON>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayConcatTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_CONCAT).onFieldsWithData(new Object[]{new Integer[]{1, 2, null}, null, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, new Integer[]{1}, 1, new Integer[][]{{1}}, new String[]{"123"}}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())), DataTypes.INT().notNull(), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())).notNull(), DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull()}).testResult((Expression)Expressions.$((String)"f0").arrayConcat((Object[])new Integer[]{1, null, 4}), "ARRAY_CONCAT(f0, ARRAY[1, NULL, 4])", new Integer[]{1, 2, null, 1, null, 4}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f0").arrayConcat(new Object[0]), "ARRAY_CONCAT(f0)", new Integer[]{1, 2, null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testTableApiValidationError((Expression)Expressions.$((String)"f0").arrayConcat(new Object[]{new Integer[]{null, null, null}, new Integer[]{1, 2, 3}, new Integer[]{3, 4, 5}}), "Invalid function call:\narray(NULL, NULL, NULL)").testResult((Expression)Expressions.$((String)"f1").arrayConcat(new Object[]{new Integer[]{1, null, 4}, new Integer[]{2, 3, 4}, new Integer[]{2, 3, 4}}), "ARRAY_CONCAT(f1, ARRAY[1, NULL, 4], ARRAY[2, 3, 4], ARRAY[2, 3, 4])", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f2").arrayConcat(new Object[]{new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)})}, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)})}}), "ARRAY_CONCAT(f2, ARRAY[(TRUE, DATE '1990-10-14')], ARRAY[(TRUE, DATE '1990-10-14')])", new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null, Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)})}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()}))).testResult((Expression)Expressions.$((String)"f3").arrayConcat((Object[])new Integer[]{2, null}), "ARRAY_CONCAT(f3, ARRAY[2, NULL])", new Integer[]{1, 2, null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testTableApiValidationError((Expression)Expressions.$((String)"f0").arrayConcat(new Object[]{new Integer[]{null, null, null}, new Integer[]{1, 2, 3}, new Integer[]{3, 4, 5}}), "Invalid function call:\narray(NULL, NULL, NULL)").testTableApiValidationError((Expression)Expressions.$((String)"f4").arrayConcat(new Object[]{true}), "Invalid input arguments. Expected signatures are:\nARRAY_CONCAT(<COMMON>, <COMMON>...)").testTableApiValidationError((Expression)Expressions.$((String)"f5").arrayConcat((Object[])new Integer[]{1}), "Invalid function call:\nARRAY_CONCAT(ARRAY<ARRAY<INT>> NOT NULL, ARRAY<INT NOT NULL> NOT NULL)").testTableApiValidationError((Expression)Expressions.$((String)"f6").arrayConcat((Object[])new Integer[]{123}), "Invalid function call:\nARRAY_CONCAT(ARRAY<STRING> NOT NULL, ARRAY<INT NOT NULL> NOT NULL)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayMaxTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_MAX).onFieldsWithData(new Object[]{new Integer[]{1, 2, null}, null, new Double[]{1.2, null, 3.4, 8.0}, new String[]{"a", null, "bc", "d", "def"}, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, new Map[]{CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)"a"), CollectionUtil.entry((Object)2, (Object)"b")}), CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)3, (Object)"c"), CollectionUtil.entry((Object)4, (Object)"d")}), null}, new Integer[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}, null}, new Row[]{Row.of((Object[])new Object[]{LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{LocalDate.of(1990, 10, 14)}), Row.of((Object[])new Object[]{LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{LocalDate.of(1990, 10, 14)}), Row.of((Object[])new Object[]{LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{LocalDate.of(1990, 10, 14)}), null}, new Boolean[]{true, false, true, false, true, null}, new Row[]{Row.of((Object[])new Object[]{true}), Row.of((Object[])new Object[]{false}), Row.of((Object[])new Object[]{true}), Row.of((Object[])new Object[]{false}), Row.of((Object[])new Object[]{true}), Row.of((Object[])new Object[]{false}), null}, new Row[]{Row.of((Object[])new Object[]{1}), Row.of((Object[])new Object[]{2}), Row.of((Object[])new Object[]{8}), Row.of((Object[])new Object[]{4}), Row.of((Object[])new Object[]{5}), Row.of((Object[])new Object[]{8}), null}, 1, new Integer[][]{{1, 2}, {2, 3}, null}, new LocalDate[]{LocalDate.of(2022, 1, 2), LocalDate.of(2023, 4, 21), LocalDate.of(2022, 12, 24), LocalDate.of(2026, 2, 10), LocalDate.of(2012, 5, 16), LocalDate.of(2092, 7, 19)}, null, new Integer[]{1, 2}}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.DOUBLE()), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING())), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.BOOLEAN()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN()})), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT()})), DataTypes.INT().notNull(), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.ARRAY((DataType)DataTypes.DATE()), DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())), DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())).notNull()}).testResult((Expression)Expressions.$((String)"f0").arrayMax(), "ARRAY_MAX(f0)", 2, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f1").arrayMax(), "ARRAY_MAX(f1)", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f2").arrayMax(), "ARRAY_MAX(f2)", 8.0, (AbstractDataType<?>)DataTypes.DOUBLE()).testResult((Expression)Expressions.$((String)"f3").arrayMax(), "ARRAY_MAX(f3)", "def", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f14").arrayMax(), "ARRAY_MAX(f14)", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f15").arrayMax(), "ARRAY_MAX(f15)", 2, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f15").arrayMax(), "ARRAY_MAX(f15)", 2, (AbstractDataType<?>)DataTypes.INT()).withFunction(CreateEmptyArray.class).testResult((Expression)Expressions.call((String)"CreateEmptyArray", (Object[])new Object[0]).arrayMax(), "ARRAY_MAX(CreateEmptyArray())", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f13").arrayMax(), "ARRAY_MAX(f13)", LocalDate.of(2092, 7, 19), (AbstractDataType<?>)DataTypes.DATE()).testSqlValidationError("ARRAY_MAX(f4)", "SQL validation failed. Invalid function call:\nARRAY_MAX(ARRAY<ROW<`f0` BOOLEAN, `f1` DATE>>").testTableApiValidationError((Expression)Expressions.$((String)"f4").arrayMax(), "Invalid function call:\nARRAY_MAX(ARRAY<ROW<`f0` BOOLEAN, `f1` DATE>>").testSqlValidationError("ARRAY_MAX(f5)", "SQL validation failed. Invalid function call:\nARRAY_MAX(ARRAY<MAP<INT, STRING>>").testTableApiValidationError((Expression)Expressions.$((String)"f5").arrayMax(), "Invalid function call:\nARRAY_MAX(ARRAY<MAP<INT, STRING>>)").testSqlValidationError("ARRAY_MAX(f6)", "SQL validation failed. Invalid function call:\nARRAY_MAX(ARRAY<ARRAY<INT>>)").testTableApiValidationError((Expression)Expressions.$((String)"f6").arrayMax(), "Invalid function call:\nARRAY_MAX(ARRAY<ARRAY<INT>>)").testSqlValidationError("ARRAY_MAX(f7)", "SQL validation failed. Invalid function call:\nARRAY_MAX(ARRAY<ROW<`f0` DATE>>)").testTableApiValidationError((Expression)Expressions.$((String)"f7").arrayMax(), "Invalid function call:\nARRAY_MAX(ARRAY<ROW<`f0` DATE>>)").testSqlValidationError("ARRAY_MAX(f8)", "SQL validation failed. Invalid function call:\nARRAY_MAX(ARRAY<BOOLEAN>)").testTableApiValidationError((Expression)Expressions.$((String)"f8").arrayMax(), "Invalid function call:\nARRAY_MAX(ARRAY<BOOLEAN>)").testSqlValidationError("ARRAY_MAX(f9)", "SQL validation failed. Invalid function call:\nARRAY_MAX(ARRAY<ROW<`f0` BOOLEAN>>)").testTableApiValidationError((Expression)Expressions.$((String)"f9").arrayMax(), "Invalid function call:\nARRAY_MAX(ARRAY<ROW<`f0` BOOLEAN>>)").testSqlValidationError("ARRAY_MAX(f10)", "SQL validation failed. Invalid function call:\nARRAY_MAX(ARRAY<ROW<`f0` INT>>)").testTableApiValidationError((Expression)Expressions.$((String)"f10").arrayMax(), "Invalid function call:\nARRAY_MAX(ARRAY<ROW<`f0` INT>>)").testTableApiValidationError((Expression)Expressions.$((String)"f11").arrayMax(), "Invalid function call:\nARRAY_MAX(INT NOT NULL)").testSqlValidationError("ARRAY_MAX(f11)", "SQL validation failed. Invalid function call:\nARRAY_MAX(INT NOT NULL)").testTableApiValidationError((Expression)Expressions.$((String)"f12").arrayMax(), "Invalid function call:\nARRAY_MAX(ARRAY<ARRAY<INT>>)").testSqlValidationError("ARRAY_MAX(f12)", "SQL validation failed. Invalid function call:\nARRAY_MAX(ARRAY<ARRAY<INT>>)").testSqlValidationError("ARRAY_MAX()", "No match found for function signature ARRAY_MAX()").testSqlValidationError("ARRAY_MAX(ARRAY[1], ARRAY[2])", "No match found for function signature ARRAY_MAX(<INTEGER ARRAY>, <INTEGER ARRAY>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayMinTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_MIN).onFieldsWithData(new Object[]{new Integer[]{1, 2, null}, null, new Double[]{1.2, null, 3.4, 8.0}, new String[]{"a", null, "bc", "d", "def"}, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, new Map[]{CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)"a"), CollectionUtil.entry((Object)2, (Object)"b")}), CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)3, (Object)"c"), CollectionUtil.entry((Object)4, (Object)"d")}), null}, new Integer[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}, null}, new Row[]{Row.of((Object[])new Object[]{LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{LocalDate.of(1990, 10, 14)}), Row.of((Object[])new Object[]{LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{LocalDate.of(1990, 10, 14)}), Row.of((Object[])new Object[]{LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{LocalDate.of(1990, 10, 14)}), null}, new Boolean[]{true, false, true, false, true, null}, new Row[]{Row.of((Object[])new Object[]{true}), Row.of((Object[])new Object[]{false}), Row.of((Object[])new Object[]{true}), Row.of((Object[])new Object[]{false}), Row.of((Object[])new Object[]{true}), Row.of((Object[])new Object[]{false}), null}, new Row[]{Row.of((Object[])new Object[]{1}), Row.of((Object[])new Object[]{2}), Row.of((Object[])new Object[]{8}), Row.of((Object[])new Object[]{4}), Row.of((Object[])new Object[]{5}), Row.of((Object[])new Object[]{8}), null}, 1, new Integer[][]{{1, 2}, {2, 3}, null}, new LocalDate[]{LocalDate.of(2022, 1, 2), LocalDate.of(2023, 4, 21), LocalDate.of(2022, 12, 24), LocalDate.of(2026, 2, 10), LocalDate.of(2012, 5, 16), LocalDate.of(2092, 7, 19)}, null}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.DOUBLE()), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING())), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.BOOLEAN()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN()})), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT()})), DataTypes.INT().notNull(), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.ARRAY((DataType)DataTypes.DATE()), DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull()))}).testResult((Expression)Expressions.$((String)"f0").arrayMin(), "ARRAY_MIN(f0)", 1, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f1").arrayMin(), "ARRAY_MIN(f1)", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f2").arrayMin(), "ARRAY_MIN(f2)", 1.2, (AbstractDataType<?>)DataTypes.DOUBLE()).testResult((Expression)Expressions.$((String)"f3").arrayMin(), "ARRAY_MIN(f3)", "a", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f14").arrayMin(), "ARRAY_MIN(f14)", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f13").arrayMin(), "ARRAY_MIN(f13)", LocalDate.of(2012, 5, 16), (AbstractDataType<?>)DataTypes.DATE()).testSqlValidationError("ARRAY_MIN(f4)", "SQL validation failed. Invalid function call:\nARRAY_MIN(ARRAY<ROW<`f0` BOOLEAN, `f1` DATE>>").testTableApiValidationError((Expression)Expressions.$((String)"f4").arrayMin(), "Invalid function call:\nARRAY_MIN(ARRAY<ROW<`f0` BOOLEAN, `f1` DATE>>").testSqlValidationError("ARRAY_MIN(f5)", "SQL validation failed. Invalid function call:\nARRAY_MIN(ARRAY<MAP<INT, STRING>>").testTableApiValidationError((Expression)Expressions.$((String)"f5").arrayMin(), "Invalid function call:\nARRAY_MIN(ARRAY<MAP<INT, STRING>>)").testSqlValidationError("ARRAY_MIN(f6)", "SQL validation failed. Invalid function call:\nARRAY_MIN(ARRAY<ARRAY<INT>>)").testTableApiValidationError((Expression)Expressions.$((String)"f6").arrayMin(), "Invalid function call:\nARRAY_MIN(ARRAY<ARRAY<INT>>)").testSqlValidationError("ARRAY_MIN(f7)", "SQL validation failed. Invalid function call:\nARRAY_MIN(ARRAY<ROW<`f0` DATE>>)").testTableApiValidationError((Expression)Expressions.$((String)"f7").arrayMin(), "Invalid function call:\nARRAY_MIN(ARRAY<ROW<`f0` DATE>>)").testSqlValidationError("ARRAY_MIN(f8)", "SQL validation failed. Invalid function call:\nARRAY_MIN(ARRAY<BOOLEAN>)").testTableApiValidationError((Expression)Expressions.$((String)"f8").arrayMin(), "Invalid function call:\nARRAY_MIN(ARRAY<BOOLEAN>)").testSqlValidationError("ARRAY_MIN(f9)", "SQL validation failed. Invalid function call:\nARRAY_MIN(ARRAY<ROW<`f0` BOOLEAN>>)").testTableApiValidationError((Expression)Expressions.$((String)"f9").arrayMin(), "Invalid function call:\nARRAY_MIN(ARRAY<ROW<`f0` BOOLEAN>>)").testSqlValidationError("ARRAY_MIN(f10)", "SQL validation failed. Invalid function call:\nARRAY_MIN(ARRAY<ROW<`f0` INT>>)").testTableApiValidationError((Expression)Expressions.$((String)"f10").arrayMin(), "Invalid function call:\nARRAY_MIN(ARRAY<ROW<`f0` INT>>)").testTableApiValidationError((Expression)Expressions.$((String)"f11").arrayMin(), "Invalid function call:\nARRAY_MIN(INT NOT NULL)").testSqlValidationError("ARRAY_MIN(f11)", "SQL validation failed. Invalid function call:\nARRAY_MIN(INT NOT NULL)").testTableApiValidationError((Expression)Expressions.$((String)"f12").arrayMin(), "Invalid function call:\nARRAY_MIN(ARRAY<ARRAY<INT>>)").testSqlValidationError("ARRAY_MIN(f12)", "SQL validation failed. Invalid function call:\nARRAY_MIN(ARRAY<ARRAY<INT>>)").testSqlValidationError("ARRAY_MIN()", "No match found for function signature ARRAY_MIN()").testSqlValidationError("ARRAY_MIN(ARRAY[1], ARRAY[2])", "No match found for function signature ARRAY_MIN(<INTEGER ARRAY>, <INTEGER ARRAY>)").withFunction(CreateEmptyArray.class).testResult((Expression)Expressions.call((String)"CreateEmptyArray", (Object[])new Object[0]).arrayMin(), "ARRAY_MIN(CreateEmptyArray())", (Object)null, (AbstractDataType<?>)DataTypes.INT()));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayJoinTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_JOIN).onFieldsWithData(new String[]{"abv", "bbb", "cb"}, new String[]{"a", "b", null}, new String[]{null, "1", null}, new String[]{null, null, "1", null, null}, null, null, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, new Integer[]{1, 2, 3, null}, new Boolean[]{null, false, true}, new Double[]{1.2, 34.0, 4.0, 4.5}, 1).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull(), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.BOOLEAN()), DataTypes.ARRAY((DataType)DataTypes.DOUBLE()).notNull(), DataTypes.INT().notNull()}).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), null}), "ARRAY_JOIN(f0, null)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), "+", null}), "ARRAY_JOIN(f0, '+', null)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), null, null}), "ARRAY_JOIN(f0, null, null)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), "+"}), "ARRAY_JOIN(f0, '+')", "abv+bbb+cb", DataTypes.STRING().notNull()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), "+", "abc"}), "ARRAY_JOIN(f0, '+', 'abc')", "abv+bbb+cb", DataTypes.STRING().notNull()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), " "}), "ARRAY_JOIN(f0, ' ')", "abv bbb cb", DataTypes.STRING().notNull()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), ""}), "ARRAY_JOIN(f0, '')", "abvbbbcb", DataTypes.STRING().notNull()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), " ", ""}), "ARRAY_JOIN(f0, ' ', '')", "abv bbb cb", DataTypes.STRING().notNull()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), " ", " "}), "ARRAY_JOIN(f0, ' ', ' ')", "abv bbb cb", DataTypes.STRING().notNull()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), "", ""}), "ARRAY_JOIN(f0, '', '')", "abvbbbcb", DataTypes.STRING().notNull()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), "", " "}), "ARRAY_JOIN(f0, '', ' ')", "abvbbbcb", DataTypes.STRING().notNull()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f1"), "+", "abc"}), "ARRAY_JOIN(f1, '+', 'abc')", "a+b+abc", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f1"), "+", ""}), "ARRAY_JOIN(f1, '+', '')", "a+b+", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f1"), "+"}), "ARRAY_JOIN(f1, '+')", "a+b", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f1"), "+", " "}), "ARRAY_JOIN(f1, '+', ' ')", "a+b+ ", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f1"), "", "+"}), "ARRAY_JOIN(f1, '', '+')", "ab+", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f1"), "", ""}), "ARRAY_JOIN(f1, '', '')", "ab", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f1"), " ", ""}), "ARRAY_JOIN(f1, ' ', '')", "a b ", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f1"), " ", " "}), "ARRAY_JOIN(f1, ' ', ' ')", "a b  ", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f2"), "+", "abc"}), "ARRAY_JOIN(f2, '+', 'abc')", "abc+1+abc", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f2"), "+"}), "ARRAY_JOIN(f2, '+')", "1", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f2"), ""}), "ARRAY_JOIN(f2, '')", "1", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f2"), " "}), "ARRAY_JOIN(f2, ' ')", "1", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f2"), "+", ""}), "ARRAY_JOIN(f2, '+', '')", "+1+", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f2"), "+", " "}), "ARRAY_JOIN(f2, '+', ' ')", " +1+ ", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f2"), "", ""}), "ARRAY_JOIN(f2, '', '')", "1", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f2"), "", " "}), "ARRAY_JOIN(f2, '', ' ')", " 1 ", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f2"), " ", " "}), "ARRAY_JOIN(f2, ' ', ' ')", "  1  ", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f2"), " ", ""}), "ARRAY_JOIN(f2, ' ', '')", " 1 ", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f3"), "+", "abc"}), "ARRAY_JOIN(f3, '+', 'abc')", "abc+abc+1+abc+abc", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f3"), "+"}), "ARRAY_JOIN(f3, '+')", "1", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f3"), ""}), "ARRAY_JOIN(f3, '')", "1", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f3"), " "}), "ARRAY_JOIN(f3, ' ')", "1", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f3"), "+", ""}), "ARRAY_JOIN(f3, '+', '')", "++1++", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f3"), "+", " "}), "ARRAY_JOIN(f3, '+', ' ')", " + +1+ + ", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f3"), "", ""}), "ARRAY_JOIN(f3, '', '')", "1", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f3"), "", " "}), "ARRAY_JOIN(f3, '', ' ')", "  1  ", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f3"), " ", " "}), "ARRAY_JOIN(f3, ' ', ' ')", "    1    ", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f3"), " ", ""}), "ARRAY_JOIN(f3, ' ', '')", "  1  ", DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f4"), " ", ""}), "ARRAY_JOIN(f4, ' ', '')", null, DataTypes.STRING().nullable()).testSqlValidationError("ARRAY_JOIN(f0)", "No match found for function signature ARRAY_JOIN(<VARCHAR(2147483647) ARRAY>).\nSupported signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testSqlValidationError("ARRAY_JOIN()", "No match found for function signature ARRAY_JOIN().\nSupported signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testSqlValidationError("ARRAY_JOIN(f5, '+')", "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testTableApiValidationError((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f5"), "+"}), "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testSqlValidationError("ARRAY_JOIN(f6, '+')", "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testTableApiValidationError((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f6"), "+", "abc"}), "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testSqlValidationError("ARRAY_JOIN(f7, '+', 'abc')", "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testTableApiValidationError((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f7"), "+"}), "Invalid function call:\nARRAY_JOIN(ARRAY<INT>, CHAR(1) NOT NULL)").testSqlValidationError("ARRAY_JOIN(f8, '+', 'abc')", "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testTableApiValidationError((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f8"), "+"}), "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testSqlValidationError("ARRAY_JOIN(f9, '+', 'abc')", "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testTableApiValidationError((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f9"), "+"}), "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testSqlValidationError("ARRAY_JOIN(f10, '+', 'abc')", "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testTableApiValidationError((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f10"), "+"}), "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)").testTableApiValidationError((Expression)Expressions.call((String)"ARRAY_JOIN", (Object[])new Object[]{Expressions.$((String)"f0"), "+", "+", "+"}), "Invalid input arguments. Expected signatures are:\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>)\nARRAY_JOIN(ARRAY<STRING>, <CHARACTER_STRING>, <CHARACTER_STRING>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arraySliceTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_SLICE).onFieldsWithData(new Integer[]{null, 1, 2, 3, 4, 5, 6, null}, null, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, new String[]{"a", "b", "c", "d", "e"}, new Integer[]{1, 2, 3, 4, 5}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ARRAY((DataType)DataTypes.INT())}).testResult((Expression)Expressions.$((String)"f4").arraySlice((Object)-123), "ARRAY_SLICE(f4, -123)", new Integer[]{1, 2, 3, 4, 5}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f4").arraySlice((Object)0), "ARRAY_SLICE(f4, 0)", new Integer[]{1, 2, 3, 4, 5}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f4").arraySlice((Object)-3), "ARRAY_SLICE(f4, -3)", new Integer[]{3, 4, 5}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f4").arraySlice((Object)9), "ARRAY_SLICE(f4, 9)", new Integer[0], (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f4").arraySlice((Object)-123, (Object)-231), "ARRAY_SLICE(f4, -123, -231)", new Integer[0], (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f4").arraySlice((Object)-5, (Object)-5), "ARRAY_SLICE(f4, -5, -5)", new Integer[]{1}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f4").arraySlice((Object)-6, (Object)-5), "ARRAY_SLICE(f4, -6, -5)", new Integer[]{1}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f4").arraySlice((Object)5, (Object)6), "ARRAY_SLICE(f4, 5, 6)", new Integer[]{5}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f4").arraySlice((Object)20, (Object)30), "ARRAY_SLICE(f4, 20, 30)", new Integer[0], (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f4").arraySlice((Object)-123, (Object)123), "ARRAY_SLICE(f4, -123, 123)", new Integer[]{1, 2, 3, 4, 5}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f0").arraySlice((Object)0, (Object)8), "ARRAY_SLICE(f0, 0, 8)", new Integer[]{null, 1, 2, 3, 4, 5, 6, null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f0").arraySlice((Object)0, (Object)9), "ARRAY_SLICE(f0, 0, 9)", new Integer[]{null, 1, 2, 3, 4, 5, 6, null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f0").arraySlice((Object)0, (Object)-1), "ARRAY_SLICE(f0, 0, -1)", new Integer[]{null, 1, 2, 3, 4, 5, 6, null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f0").arraySlice((Object)1, (Object)0), "ARRAY_SLICE(f0, 1, 0)", new Integer[]{null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f0").arraySlice((Object)-1, (Object)15), "ARRAY_SLICE(f0, -1, 15)", new Integer[]{null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f0").arraySlice((Object)8, (Object)15), "ARRAY_SLICE(f0, 8, 15)", new Integer[]{null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f0").arraySlice(null, (Object)15), "ARRAY_SLICE(f0, null, 15)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f0").arraySlice((Object)1, null), "ARRAY_SLICE(f0, 1, null)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f0").arraySlice(null, null), "ARRAY_SLICE(f0, null, null)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f1").arraySlice((Object)1, (Object)3), "ARRAY_SLICE(f1, 1, 3)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f2").arraySlice((Object)1, (Object)1), "ARRAY_SLICE(f2, 1, 1)", new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)})}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()}))).testSqlValidationError("ARRAY_SLICE(f3, TRUE, 2.5)", "Invalid input arguments. Expected signatures are:\nARRAY_SLICE(<ARRAY>, <INTEGER>, <INTEGER>)").testTableApiValidationError((Expression)Expressions.$((String)"f3").arraySlice((Object)true, (Object)2.5), "Invalid input arguments. Expected signatures are:\nARRAY_SLICE(<ARRAY>, <INTEGER>, <INTEGER>)").testSqlValidationError("ARRAY_SLICE()", "No match found for function signature ARRAY_SLICE().\nSupported signatures are:\nARRAY_SLICE(<ARRAY>, <INTEGER>, <INTEGER>)\nARRAY_SLICE(<ARRAY>, <INTEGER>)").testSqlValidationError("ARRAY_SLICE(1)", "No match found for function signature ARRAY_SLICE(<NUMERIC>).\nSupported signatures are:\nARRAY_SLICE(<ARRAY>, <INTEGER>, <INTEGER>)\nARRAY_SLICE(<ARRAY>, <INTEGER>)").testSqlValidationError("ARRAY_SLICE(null)", "Illegal use of 'NULL'"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arraySortTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_SORT).onFieldsWithData(new Integer[]{1, 2, 2, null}, null, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, new Double[]{1.2, 3.5, 4.7, 1.3, 1.0, 5.0}, new String[]{"a", "cv", "dc", "rerer", "234", "12"}, new LocalDate[]{LocalDate.of(2022, 1, 2), LocalDate.of(2023, 4, 21), LocalDate.of(2022, 12, 24), LocalDate.of(2026, 2, 10), LocalDate.of(2012, 5, 16), LocalDate.of(2092, 7, 19)}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.DOUBLE()), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ARRAY((DataType)DataTypes.DATE())}).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f0")}), "ARRAY_SORT(f0)", new Integer[]{null, 1, 2, 2}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f0"), false}), "ARRAY_SORT(f0, false)", new Integer[]{2, 2, 1, null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f0"), true}), "ARRAY_SORT(f0, true)", new Integer[]{null, 1, 2, 2}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f0"), null}), "ARRAY_SORT(f0, null)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f0"), true, true}), "ARRAY_SORT(f0, true, true)", new Integer[]{null, 1, 2, 2}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f0"), true, false}), "ARRAY_SORT(f0, true, false)", new Integer[]{1, 2, 2, null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f0"), false, true}), "ARRAY_SORT(f0, false, true)", new Integer[]{null, 2, 2, 1}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f0"), false, false}), "ARRAY_SORT(f0, false, false)", new Integer[]{2, 2, 1, null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f0"), false, null}), "ARRAY_SORT(f0, false, null)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f0"), null, null}), "ARRAY_SORT(f0, false, null)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f1"), true}), "ARRAY_SORT(f1, true)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f1"), false}), "ARRAY_SORT(f1, true)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testTableApiValidationError((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f2"), true}), "Invalid input arguments. Expected signatures are:\nARRAY_SORT(<ARRAY<COMPARABLE>>)\nARRAY_SORT(<ARRAY<COMPARABLE>>, <BOOLEAN>)\nARRAY_SORT(<ARRAY<COMPARABLE>>, <BOOLEAN>, <BOOLEAN>)").testSqlValidationError("ARRAY_SORT(f2, true)", "SQL validation failed. Invalid function call:\nARRAY_SORT(ARRAY<ROW<`f0` BOOLEAN, `f1` DATE>>, BOOLEAN NOT NULL)").testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f3")}), "ARRAY_SORT(f3)", new Double[]{1.0, 1.2, 1.3, 3.5, 4.7, 5.0}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.DOUBLE())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f3"), false}), "ARRAY_SORT(f3, false)", new Double[]{5.0, 4.7, 3.5, 1.3, 1.2, 1.0}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.DOUBLE())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f4")}), "ARRAY_SORT(f4)", new String[]{"12", "234", "a", "cv", "dc", "rerer"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f4"), false}), "ARRAY_SORT(f4, false)", new String[]{"rerer", "dc", "cv", "a", "234", "12"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f5")}), "ARRAY_SORT(f5)", new LocalDate[]{LocalDate.of(2012, 5, 16), LocalDate.of(2022, 1, 2), LocalDate.of(2022, 12, 24), LocalDate.of(2023, 4, 21), LocalDate.of(2026, 2, 10), LocalDate.of(2092, 7, 19)}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.DATE())).testResult((Expression)Expressions.call((String)"ARRAY_SORT", (Object[])new Object[]{Expressions.$((String)"f5"), false}), "ARRAY_SORT(f5, false)", new LocalDate[]{LocalDate.of(2092, 7, 19), LocalDate.of(2026, 2, 10), LocalDate.of(2023, 4, 21), LocalDate.of(2022, 12, 24), LocalDate.of(2022, 1, 2), LocalDate.of(2012, 5, 16)}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.DATE())));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayExceptTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_EXCEPT).onFieldsWithData(new Object[]{new Integer[]{1, 2, 2}, null, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, new Integer[]{null, null, 1}, new Integer[][]{{1, null, 3}, {0}, {1}}, new Map[]{CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)"a"), CollectionUtil.entry((Object)2, (Object)"b")}), CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)3, (Object)"c"), CollectionUtil.entry((Object)4, (Object)"d")}), null}, new Integer[]{1, 2, 3, 2, 4, 2}}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING())), DataTypes.ARRAY((DataType)DataTypes.INT())}).testResult((Expression)Expressions.$((String)"f0").arrayExcept((Object)new Integer[]{1, null, 4}), "ARRAY_EXCEPT(f0, ARRAY[1, NULL, 4])", new Integer[]{2}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f0").arrayExcept((Object)new Integer[]{1}), "ARRAY_EXCEPT(f0, ARRAY[1])", new Integer[]{2}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f0").arrayExcept((Object)new Integer[]{42}), "ARRAY_EXCEPT(f0, ARRAY[42])", new Integer[]{1, 2}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f6").arrayExcept((Object)new Integer[]{2, 2}), "ARRAY_EXCEPT(f6, ARRAY[2, 2])", new Integer[]{1, 3, 4}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f0").arrayExcept(Expressions.lit(null, (DataType)DataTypes.ARRAY((DataType)DataTypes.INT())).cast(DataTypes.ARRAY((DataType)DataTypes.INT()))), "ARRAY_EXCEPT(f0, CAST(NULL AS ARRAY<INT>))", null, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f0").arrayExcept((Object)new Integer[]{null, 2}), "ARRAY_EXCEPT(f0, ARRAY[null, 2])", new Integer[]{1}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f1").arrayExcept((Object)new Integer[]{1, 2, 3}), "ARRAY_EXCEPT(f1, ARRAY[1,2,3])", null, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f3").arrayExcept((Object)new Integer[]{null, 42}), "ARRAY_EXCEPT(f3, ARRAY[null, 42])", new Integer[]{1}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f2").arrayExcept((Object)new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)})}), "ARRAY_EXCEPT(f2, ARRAY[(TRUE, DATE '1990-10-14')])", new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), null}, DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})).nullable()).testResult((Expression)Expressions.$((String)"f4").arrayExcept((Object)new Integer[][]{{0}}), "ARRAY_EXCEPT(f4, ARRAY[ARRAY[0]])", new Integer[][]{{1, null, 3}, {1}}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()))).testResult((Expression)Expressions.$((String)"f5").arrayExcept((Object)new Map[]{CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)3, (Object)"c"), CollectionUtil.entry((Object)4, (Object)"d")})}), "ARRAY_EXCEPT(f5, ARRAY[MAP[3, 'c', 4, 'd']])", new Map[]{CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)"a"), CollectionUtil.entry((Object)2, (Object)"b")}), null}, DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING())).nullable()).testSqlValidationError("ARRAY_EXCEPT(f0, TRUE)", "Invalid input arguments. Expected signatures are:\nARRAY_EXCEPT(<COMMON>, <COMMON>)").testTableApiValidationError((Expression)Expressions.$((String)"f0").arrayExcept((Object)true), "Invalid input arguments. Expected signatures are:\nARRAY_EXCEPT(<COMMON>, <COMMON>)").testSqlValidationError("ARRAY_EXCEPT(f0, ARRAY['hi', 'there'])", "Invalid input arguments. Expected signatures are:\nARRAY_EXCEPT(<COMMON>, <COMMON>)").testTableApiValidationError((Expression)Expressions.$((String)"f0").arrayExcept((Object)new String[]{"hi", "there"}), "Invalid input arguments. Expected signatures are:\nARRAY_EXCEPT(<COMMON>, <COMMON>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> arrayIntersectTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_INTERSECT).onFieldsWithData(new Object[]{new Integer[]{1, 1, 2}, null, new Row[]{Row.of((Object[])new Object[]{true, 1}), Row.of((Object[])new Object[]{true, 2}), null}, new Integer[]{null, null, 1}, new Map[]{CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)"a"), CollectionUtil.entry((Object)2, (Object)"b")}), CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)3, (Object)"c"), CollectionUtil.entry((Object)4, (Object)"d")})}, new Integer[][]{{1, 2, 3}}}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.INT()})), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING())), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))}).testResult((Expression)Expressions.$((String)"f0").arrayIntersect((Object)new Integer[]{1, null, 4}), "ARRAY_INTERSECT(f0, ARRAY[1, NULL, 4])", new Integer[]{1}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f0").arrayIntersect((Object)new Integer[]{3, 4}), "ARRAY_INTERSECT(f0, ARRAY[3, 4])", new Integer[0], (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f1").arrayIntersect((Object)new Integer[]{1, null, 4}), "ARRAY_INTERSECT(f1, ARRAY[1, NULL, 4])", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f2").arrayIntersect((Object)new Row[]{null, Row.of((Object[])new Object[]{true, 2})}), "ARRAY_INTERSECT(f2, ARRAY[NULL, ROW(TRUE, 2)])", new Row[]{Row.of((Object[])new Object[]{true, 2}), null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.INT()}))).testResult((Expression)Expressions.$((String)"f3").arrayIntersect((Object)new Integer[]{null, 42}), "ARRAY_INTERSECT(f3, ARRAY[null, 42])", new Integer[]{null}, DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).testResult((Expression)Expressions.$((String)"f4").arrayIntersect((Object)new Map[]{CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)"a"), CollectionUtil.entry((Object)2, (Object)"b")})}), "ARRAY_INTERSECT(f4, ARRAY[MAP[1, 'a', 2, 'b']])", new Map[]{CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)"a"), CollectionUtil.entry((Object)2, (Object)"b")})}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING()))).testResult((Expression)Expressions.$((String)"f5").arrayIntersect((Object)new Integer[][]{{1, 2, 3}}), "ARRAY_INTERSECT(f5, ARRAY[ARRAY[1, 2, 3]])", new Integer[][]{{1, 2, 3}}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))).testSqlValidationError("ARRAY_INTERSECT(f3, TRUE)", "Invalid input arguments. Expected signatures are:\nARRAY_INTERSECT(<COMMON>, <COMMON>)").testTableApiValidationError((Expression)Expressions.$((String)"f3").arrayIntersect((Object)true), "Invalid input arguments. Expected signatures are:\nARRAY_INTERSECT(<COMMON>, <COMMON>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> splitTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.SPLIT).onFieldsWithData("123,123,23", null, ",123,123", ",123,123,", 123, "12345", ",123,,,123,").andDataTypes(new AbstractDataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.INT().notNull(), DataTypes.STRING().notNull(), DataTypes.STRING().notNull()}).testResult((Expression)Expressions.$((String)"f0").split((Object)","), "SPLIT(f0, ',')", new String[]{"123", "123", "23"}, DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull()).testResult((Expression)Expressions.$((String)"f0").split(null), "SPLIT(f0, NULL)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f0").split((Object)""), "SPLIT(f0, '')", new String[]{"1", "2", "3", ",", "1", "2", "3", ",", "2", "3"}, DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull()).testResult((Expression)Expressions.$((String)"f1").split((Object)","), "SPLIT(f1, ',')", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").split(null), "SPLIT(f1, null)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f2").split((Object)","), "SPLIT(f2, ',')", new String[]{"", "123", "123"}, DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull()).testResult((Expression)Expressions.$((String)"f3").split((Object)","), "SPLIT(f3, ',')", new String[]{"", "123", "123", ""}, DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull()).testResult((Expression)Expressions.$((String)"f5").split((Object)","), "SPLIT(f5, ',')", new String[]{"12345"}, DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull()).testResult((Expression)Expressions.$((String)"f6").split((Object)","), "SPLIT(f6, ',')", new String[]{"", "123", "", "", "123", ""}, DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull()).testTableApiValidationError((Expression)Expressions.$((String)"f4").split((Object)","), "Invalid input arguments. Expected signatures are:\nSPLIT(<CHARACTER_STRING>, <CHARACTER_STRING>)").testSqlValidationError("SPLIT(f4, ',')", "Invalid input arguments. Expected signatures are:\nSPLIT(<CHARACTER_STRING>, <CHARACTER_STRING>)").testSqlValidationError("SPLIT()", "No match found for function signature SPLIT()").testSqlValidationError("SPLIT(f1, '1', '2')", "No match found for function signature SPLIT(<CHARACTER>, <CHARACTER>, <CHARACTER>)"));
    }

    public static class CreateEmptyArray
    extends ScalarFunction {
        @DataTypeHint(value="ARRAY<INT NOT NULL>")
        public int[] eval() {
            return new int[0];
        }
    }
}

