/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInAggregateFunctionTestBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;

class ArrayAggFunctionITCase
extends BuiltInAggregateFunctionTestBase {
    ArrayAggFunctionITCase() {
    }

    @Override
    Stream<BuiltInAggregateFunctionTestBase.TestSpec> getTestCaseSpecs() {
        return Stream.of(BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_AGG).withDescription("ARRAY changelog stream aggregation").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.INT()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"A", 1}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"A", 2}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"B", 2}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"B", 2}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"B", 3}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"C", 3}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"C", null}), Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{"C", null}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"D", null}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"E", 4}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"E", 5}), Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{"E", 5}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{"E", 4}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{"E", 6}))).testResult(source -> "SELECT f0, array_agg(f1) FROM " + source + " GROUP BY f0", BuiltInAggregateFunctionTestBase.TableApiAggSpec.groupBySelect(Collections.singletonList(Expressions.$((String)"f0")), new Expression[]{Expressions.$((String)"f0"), (Expression)Expressions.$((String)"f1").arrayAgg()}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.ARRAY((DataType)DataTypes.INT())}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.ARRAY((DataType)DataTypes.INT())}), Arrays.asList(Row.of((Object[])new Object[]{"A", new Integer[]{1, 2}}), Row.of((Object[])new Object[]{"B", new Integer[]{2, 2, 3}}), Row.of((Object[])new Object[]{"C", new Integer[]{3}}), Row.of((Object[])new Object[]{"D", new Integer[]{null}}), Row.of((Object[])new Object[]{"E", new Integer[]{6}}))).testSqlResult(source -> "SELECT f0, array_agg(DISTINCT f1 IGNORE NULLS) FROM " + source + " GROUP BY f0", DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.ARRAY((DataType)DataTypes.INT())}), Arrays.asList(Row.of((Object[])new Object[]{"A", new Integer[]{1, 2}}), Row.of((Object[])new Object[]{"B", new Integer[]{2, 3}}), Row.of((Object[])new Object[]{"C", new Integer[]{3}}), Row.of((Object[])new Object[]{"D", null}), Row.of((Object[])new Object[]{"E", new Integer[]{6}}))));
    }
}

