/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.factories.utils;

import java.util.LinkedList;
import java.util.List;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.legacy.factories.TableSinkFactory;
import org.apache.flink.table.legacy.factories.TableSourceFactory;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.types.Row;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;

public final class TestCollectionTableFactory$ {
    public static TestCollectionTableFactory$ MODULE$;
    private final String IS_BOUNDED;
    private final LinkedList<Row> SOURCE_DATA;
    private final LinkedList<Row> DIM_DATA;
    private final LinkedList<Row> RESULT;
    private long emitIntervalMS;

    static {
        new TestCollectionTableFactory$();
    }

    public String IS_BOUNDED() {
        return this.IS_BOUNDED;
    }

    public LinkedList<Row> SOURCE_DATA() {
        return this.SOURCE_DATA;
    }

    public LinkedList<Row> DIM_DATA() {
        return this.DIM_DATA;
    }

    public LinkedList<Row> RESULT() {
        return this.RESULT;
    }

    private long emitIntervalMS() {
        return this.emitIntervalMS;
    }

    private void emitIntervalMS_$eq(long x$1) {
        this.emitIntervalMS = x$1;
    }

    public void initData(List<Row> sourceData) {
        this.initData(sourceData, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Nil$.MODULE$), -1L);
    }

    public void initData(List<Row> sourceData, List<Row> dimData, long emitInterval) {
        this.SOURCE_DATA().addAll(sourceData);
        this.DIM_DATA().addAll(dimData);
        this.emitIntervalMS_$eq(emitInterval);
    }

    public List<Row> initData$default$2() {
        return JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Nil$.MODULE$);
    }

    public long initData$default$3() {
        return -1L;
    }

    public void reset() {
        this.RESULT().clear();
        this.SOURCE_DATA().clear();
        this.DIM_DATA().clear();
        this.emitIntervalMS_$eq(-1L);
    }

    public List<Row> getResult() {
        return this.RESULT();
    }

    public TestCollectionTableFactory.CollectionTableSource getCollectionSource(TableSourceFactory.Context context) {
        TableSchema schema = context.getTable().getSchema();
        boolean isBounded = new StringOps(Predef$.MODULE$.augmentString(context.getTable().getOptions().getOrDefault(this.IS_BOUNDED(), "true"))).toBoolean();
        return new TestCollectionTableFactory.CollectionTableSource(this.emitIntervalMS(), TableSchemaUtils.getPhysicalSchema((TableSchema)schema), isBounded);
    }

    public TestCollectionTableFactory.CollectionTableSink getCollectionSink(TableSinkFactory.Context context) {
        TableSchema schema = context.getTable().getSchema();
        return new TestCollectionTableFactory.CollectionTableSink(TableSchemaUtils.getPhysicalSchema((TableSchema)schema));
    }

    private TestCollectionTableFactory$() {
        MODULE$ = this;
        this.IS_BOUNDED = "is-bounded";
        this.SOURCE_DATA = new LinkedList();
        this.DIM_DATA = new LinkedList();
        this.RESULT = new LinkedList();
        this.emitIntervalMS = -1L;
    }
}

