/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.factories;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.ProcedureNotExistException;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.flink.table.procedures.Procedure;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class TestProcedureCatalogFactory
implements CatalogFactory {
    private static final String IDENTIFIER = "test_procedure_catalog";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }

    public Catalog createCatalog(CatalogFactory.Context context) {
        FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper((CatalogFactory)this, (CatalogFactory.Context)context);
        helper.validate();
        return new CatalogWithBuiltInProcedure(context.getName());
    }

    public static class CatalogWithBuiltInProcedure
    extends GenericInMemoryCatalog {
        private static final Map<ObjectPath, Procedure> PROCEDURE_MAP = new HashMap<ObjectPath, Procedure>();

        public CatalogWithBuiltInProcedure(String name) {
            super(name);
        }

        public List<String> listProcedures(String dbName) throws DatabaseNotExistException, CatalogException {
            if (!this.databaseExists(dbName)) {
                throw new DatabaseNotExistException(this.getName(), dbName);
            }
            return PROCEDURE_MAP.keySet().stream().filter(procedurePath -> procedurePath.getDatabaseName().equals(dbName)).map(ObjectPath::getObjectName).collect(Collectors.toList());
        }

        public Procedure getProcedure(ObjectPath procedurePath) throws ProcedureNotExistException, CatalogException {
            if (PROCEDURE_MAP.containsKey(procedurePath)) {
                return PROCEDURE_MAP.get(procedurePath);
            }
            throw new ProcedureNotExistException(this.getName(), procedurePath);
        }

        static {
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.generate_n"), new GenerateSequenceProcedure());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.sum_n"), new SumProcedure());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.get_year"), new GetYearProcedure());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.generate_user"), new GenerateUserProcedure());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.named_args"), new NamedArgumentsProcedure());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.named_args_overload"), new NamedArgumentsProcedureWithOverload());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.named_args_optional"), new NamedArgumentsProcedureWithOptionalArguments());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.get_env_conf"), new EnvironmentConfProcedure());
        }
    }

    public static class UserPojo {
        private final String name;
        private final int age;

        public UserPojo(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserPojo userPojo = (UserPojo)o;
            return this.age == userPojo.age && Objects.equals(this.name, userPojo.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.age);
        }

        public String toString() {
            return "UserPojo{name='" + this.name + "', age=" + this.age + "}";
        }
    }

    @ProcedureHint(output=@DataTypeHint(value="ROW<k STRING, v STRING>"))
    public static class EnvironmentConfProcedure
    implements Procedure {
        public Row[] call(ProcedureContext procedureContext) throws Exception {
            StreamExecutionEnvironment env = procedureContext.getExecutionEnvironment();
            Configuration config = (Configuration)env.getConfiguration();
            ArrayList rows = new ArrayList();
            config.toMap().forEach((k, v) -> rows.add(Row.of((Object[])new Object[]{k, v})));
            return rows.toArray(new Row[0]);
        }
    }

    public static class NamedArgumentsProcedureWithOptionalArguments
    implements Procedure {
        @ProcedureHint(output=@DataTypeHint(value="STRING"), arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="c", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INT"), name="d", isOptional=true)})
        public String[] call(ProcedureContext procedureContext, String arg1, Integer arg2) {
            return new String[]{arg1 + ", " + arg2};
        }
    }

    public static class NamedArgumentsProcedureWithOverload
    implements Procedure {
        @ProcedureHint(input={@DataTypeHint(value="STRING"), @DataTypeHint(value="INT")}, output=@DataTypeHint(value="STRING"), argumentNames={"c", "d"})
        public String[] call(ProcedureContext procedureContext, String arg1, Integer arg2) {
            return new String[]{arg1 + ", " + arg2};
        }

        @ProcedureHint(input={@DataTypeHint(value="STRING"), @DataTypeHint(value="STRING")}, output=@DataTypeHint(value="STRING"), argumentNames={"c", "d"})
        public String[] call(ProcedureContext procedureContext, String arg1, String arg2) {
            return new String[]{arg1 + ", " + arg2};
        }
    }

    public static class NamedArgumentsProcedure
    implements Procedure {
        @ProcedureHint(input={@DataTypeHint(value="STRING"), @DataTypeHint(value="INT")}, output=@DataTypeHint(value="STRING"), argumentNames={"c", "d"})
        public String[] call(ProcedureContext procedureContext, String arg1, Integer arg2) {
            return new String[]{arg1 + ", " + arg2};
        }
    }

    public static class GenerateUserProcedure
    implements Procedure {
        public UserPojo[] call(ProcedureContext procedureContext, String name, Integer age) {
            return new UserPojo[]{new UserPojo(name, age)};
        }
    }

    public static class GetYearProcedure
    implements Procedure {
        public String[] call(ProcedureContext procedureContext, LocalDateTime ... timestamps) {
            String[] results = new String[timestamps.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = String.valueOf(timestamps[i].getYear());
            }
            return results;
        }
    }

    public static class SumProcedure
    implements Procedure {
        @DataTypeHint(value="ROW< sum_value decimal(10, 2), count INT >")
        public Row[] call(ProcedureContext procedureContext, BigDecimal ... inputs) {
            if (inputs.length == 0) {
                return new Row[]{Row.of((Object[])new Object[]{null, 0})};
            }
            int counts = inputs.length;
            BigDecimal result = inputs[0];
            for (int i = 1; i < inputs.length; ++i) {
                result = result.add(inputs[i]);
            }
            return new Row[]{Row.of((Object[])new Object[]{result, counts})};
        }
    }

    public static class GenerateSequenceProcedure
    implements Procedure {
        public long[] call(ProcedureContext procedureContext, int n) throws Exception {
            return this.generate(procedureContext.getExecutionEnvironment(), n);
        }

        public long[] call(ProcedureContext procedureContext, int n, String runTimeMode) throws Exception {
            StreamExecutionEnvironment env = procedureContext.getExecutionEnvironment();
            env.setRuntimeMode(RuntimeExecutionMode.valueOf((String)runTimeMode));
            return this.generate(env, n);
        }

        private long[] generate(StreamExecutionEnvironment env, int n) throws Exception {
            env.setParallelism(1);
            long[] sequenceN = new long[n];
            int i = 0;
            try (CloseableIterator result = env.fromSequence(0L, (long)(n - 1)).executeAndCollect();){
                while (result.hasNext()) {
                    sequenceN[i++] = (Long)result.next();
                }
            }
            return sequenceN;
        }
    }
}

